/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.xml;

import de.enough.polish.xml.XmlDomNode;
import de.enough.polish.xml.XmlPullParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class XmlDomParser {
    public static XmlDomNode parseTree(String document) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(document.getBytes());
        return XmlDomParser.parseTree(byteArrayInputStream);
    }

    public static XmlDomNode parseTree(InputStream in) {
        XmlDomNode root;
        XmlPullParser parser;
        InputStreamReader inputStreamReader = new InputStreamReader(in);
        try {
            parser = new XmlPullParser(inputStreamReader);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not create xml parser." + exception);
        }
        XmlDomNode currentNode = root = new XmlDomNode(null, null, -1);
        try {
            while (parser.next() != 1) {
                String newName = parser.getName();
                int newType = parser.getType();
                if (newType == 2) {
                    XmlDomNode newNode;
                    Hashtable<String, String> attributes = null;
                    int attributeCount = parser.getAttributeCount();
                    if (attributeCount > 0) {
                        attributes = new Hashtable<String, String>();
                        for (int i = 0; i < attributeCount; ++i) {
                            attributes.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                        }
                    }
                    currentNode = newNode = new XmlDomNode(currentNode, newName, attributes, newType);
                    continue;
                }
                if (newType == 3) {
                    currentNode = currentNode.getParent();
                    continue;
                }
                if (newType != 4) continue;
                String text = parser.getText();
                currentNode.setText(text);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not parse tree:" + exception);
        }
        if (root.getChildCount() == 1) {
            return root.getChild(0);
        }
        return root;
    }
}

