/*
 * Decompiled with CFR 0.152.
 */
package sound_util;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class soundObj {
    private Player playerObj;
    private InputStream tempStream;
    private VolumeControl vol_Control;
    private int PlayCount;
    public static final String TONE = "audio/x-tone-seq";
    public static final String WAV = "audio/X-wav";
    public static final String MIDI = "audio/midi";
    public static final String MP3 = "audio/mpeg";

    public soundObj(String fileName, String mediaKind) {
        try {
            this.tempStream = this.getClass().getResourceAsStream(fileName);
            this.tempStream.mark(0);
            this.playerObj = Manager.createPlayer((InputStream)this.tempStream, (String)mediaKind);
            this.playerObj.prefetch();
        }
        catch (IOException ioError) {
            ioError.printStackTrace();
            System.out.println("Loading Media files failed !");
        }
        catch (MediaException mediaError) {
            mediaError.printStackTrace();
            System.out.println("Loading Media files failed !");
        }
        this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
    }

    public void setMediaTime(int time) {
        if (this.playerObj != null) {
            try {
                this.playerObj.setMediaTime((long)time);
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public boolean IsMusicStop() {
        boolean temp = false;
        if (this.playerObj != null && this.playerObj.getState() == 300) {
            temp = true;
        }
        return temp;
    }

    public boolean playSound() {
        try {
            if (this.playerObj != null) {
                if (this.PlayCount < 0) {
                    this.playerObj.setLoopCount(-1);
                }
                if (this.playerObj.getState() != 400) {
                    this.playerObj.start();
                    if (this.PlayCount > 0) {
                        --this.PlayCount;
                    }
                }
            }
        }
        catch (MediaException mediaError) {
            System.out.println("Playing media files failed !");
        }
        return true;
    }

    public boolean stop() {
        if (this.playerObj != null) {
            try {
                this.playerObj.stop();
            }
            catch (MediaException mediaError) {
                System.out.println("Stopping media files failed !");
            }
            return true;
        }
        return false;
    }

    public boolean close() {
        if (this.playerObj != null) {
            if (this.playerObj.getState() == 400) {
                try {
                    this.playerObj.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            if (this.playerObj.getState() != 0) {
                try {
                    this.playerObj.stop();
                    this.playerObj.close();
                }
                catch (MediaException mediaError) {
                    System.out.println("Stopping media files failed !");
                }
            }
        }
        return true;
    }

    public void set_PlayCount(int Count) {
        this.PlayCount = Count;
    }

    public int get_PlayCount() {
        return this.PlayCount;
    }

    public boolean setVolume(int vol) {
        if (this.playerObj != null && vol >= 0 && vol <= 100) {
            if (this.vol_Control != null) {
                this.vol_Control.setLevel(vol);
                return true;
            }
            this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
            this.vol_Control.setLevel(vol);
            return true;
        }
        return false;
    }

    public int getVolume() {
        if (this.playerObj != null) {
            if (this.vol_Control != null) {
                return this.vol_Control.getLevel();
            }
            this.vol_Control = (VolumeControl)this.playerObj.getControl("javax.microedition.media.control.VolumeControl");
            return this.vol_Control.getLevel();
        }
        return 0;
    }
}

