/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.util;

import com.jarbull.jbf.text.JBHexWriter;
import com.jarbull.jbf.text.JBTextWriter;
import com.jarbull.jbf.text.JBWexWriter;
import com.jarbull.jbf.util.JBUtil;
import com.jarbull.jbf.util.ParserUtility;
import java.util.Hashtable;

public class JBGameConfig {
    private String partnerId;
    private String userId;
    private String gameId;
    private String resolution;
    private String jbfVersion;
    private String coreVersion;
    private String gameVersion;
    private Hashtable fontHash = new Hashtable();

    public JBGameConfig(String pId, String uId) {
        this.partnerId = pId;
        this.userId = uId;
        this.parseFile();
    }

    private void parseFile() {
        String configXml = null;
        try {
            configXml = JBUtil.getEncryptedTxtFromFile("/res/config.enc");
        }
        catch (Exception ex) {
            try {
                configXml = JBUtil.getEncryptedTxtFromFile("/config.enc");
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        this.gameId = ParserUtility.getValue(configXml, "game_id");
        this.resolution = ParserUtility.getValue(configXml, "resolution");
        this.jbfVersion = ParserUtility.getValue(configXml, "jbf_version");
        this.coreVersion = ParserUtility.getValue(configXml, "core_version");
        this.gameVersion = ParserUtility.getValue(configXml, "game_version");
        String str = configXml;
        while (str.indexOf("</font>") != -1) {
            String fontStr = str.substring(str.indexOf("<font>"), str.indexOf("</font>") + "</font>".length());
            this.parseFont(fontStr);
            str = str.substring(str.indexOf("</font>") + "</font>".length());
        }
    }

    private void parseFont(String str) {
        String name = ParserUtility.getValue(str, "name");
        String type = ParserUtility.getValue(str, "type");
        String png_file = ParserUtility.getValue(str, "png_file");
        String index_file = ParserUtility.getValue(str, "index_file");
        if (type.equalsIgnoreCase("HEX")) {
            this.fontHash.put(name, new JBHexWriter(png_file, index_file));
        } else {
            this.fontHash.put(name, new JBWexWriter(png_file, index_file));
        }
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGameId() {
        return this.gameId;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getVersion() {
        return this.jbfVersion + "-" + this.coreVersion + "-" + this.gameVersion;
    }

    public String getCoreVersion() {
        return this.coreVersion;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getJbfVersion() {
        return this.jbfVersion;
    }

    public JBTextWriter getJBFont(String fontKey) {
        JBTextWriter jBTextWriter = (JBTextWriter)this.fontHash.get(fontKey);
        if (jBTextWriter == null) {
            jBTextWriter = (JBTextWriter)this.fontHash.elements().nextElement();
        }
        return jBTextWriter;
    }

    public JBTextWriter getJBFont() {
        return (JBTextWriter)this.fontHash.elements().nextElement();
    }
}

