/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsChipColor {
    private final int MS_PER_FRAME;
    private final int TILE_FLIPX;
    private final int TILE_FLIPY;
    private final int TILE_OBJ1;
    private final int TILE_OBJ2;
    private byte[] videoRam;
    private byte[][] videoRamBanks;
    private final int[] colors = new int[]{-1, -5592406, -11184811, -16777216};
    private int[] gbPalette = new int[12];
    private int[] gbcRawPalette = new int[128];
    private int[] gbcPalette = new int[64];
    boolean bgEnabled = true;
    boolean winEnabled = true;
    boolean winEnabledThisFrame = true;
    boolean spritesEnabled = true;
    boolean spritesEnabledThisFrame = true;
    boolean lcdEnabled = true;
    boolean spritePriorityEnabled = true;
    private Graphics g;
    public int timer;
    private boolean skipping = true;
    private int skipCount;
    int lastSkipCount;
    boolean frameDone = false;
    boolean bgWindowDataSelect = true;
    boolean doubledSprites = false;
    boolean hiBgTileMapAddress = false;
    boolean hiWinTileMapAddress = false;
    private int tileOffset;
    private int tileCount;
    private int colorCount;
    private DmgcpuColor cpu;
    boolean savedWindowDataSelect = false;
    private boolean windowStopped;
    private boolean winEnabledThisLine = false;
    private int windowStopLine = 144;
    private int windowStopX;
    private int windowStopY;
    private Image transparentImage;
    private Image[] tileImage;
    private boolean[] tileReadState;
    private int[] tempPix;
    public int left;
    public int top;
    private boolean screenFilled;
    private boolean scale;
    int tileWidth = 8;
    int tileHeight = 8;
    private static int[] weaveLookup = new int[256];

    public GraphicsChipColor(DmgcpuColor d) {
        int i;
        this.MS_PER_FRAME = 17;
        this.TILE_FLIPX = 1;
        this.TILE_FLIPY = 2;
        this.TILE_OBJ1 = 4;
        this.TILE_OBJ2 = 8;
        this.cpu = d;
        this.videoRamBanks = new byte[2][8192];
        this.tileCount = 768;
        this.colorCount = 64;
        this.videoRam = this.videoRamBanks[0];
        this.tileImage = new Image[this.tileCount * this.colorCount];
        this.tileReadState = new boolean[this.tileCount];
        this.cpu.memory[4] = this.videoRam;
        this.tempPix = new int[this.tileWidth * this.tileHeight];
        this.transparentImage = Image.createRGBImage((int[])this.tempPix, (int)this.tileWidth, (int)this.tileHeight, (boolean)true);
        for (i = 0; i < this.gbcRawPalette.length; ++i) {
            this.gbcRawPalette[i] = -1000;
        }
        for (i = 0; i < this.gbcPalette.length >> 1; ++i) {
            this.gbcPalette[i] = -1;
        }
        for (i = this.gbcPalette.length >> 1; i < this.gbcPalette.length; ++i) {
            this.gbcPalette[i] = 0;
        }
    }

    public int unflatten(byte[] flatState, int offset) {
        int i;
        for (i = 0; i < this.videoRamBanks.length; ++i) {
            System.arraycopy(flatState, offset, this.videoRamBanks[i], 0, 8192);
            offset += 8192;
        }
        for (i = 0; i < 12; ++i) {
            this.gbPalette[i] = (i & 3) == 0 ? 0xFFFFFF & GBCanvas.getInt(flatState, offset) : 0xFF000000 | GBCanvas.getInt(flatState, offset);
            offset += 4;
        }
        this.bgEnabled = flatState[offset++] != 0;
        this.winEnabled = flatState[offset++] != 0;
        this.spritesEnabled = flatState[offset++] != 0;
        this.bgWindowDataSelect = flatState[offset++] != 0;
        this.doubledSprites = flatState[offset++] != 0;
        this.hiBgTileMapAddress = flatState[offset++] != 0;
        this.hiWinTileMapAddress = (this.cpu.registers[64] & 0x40) != 0;
        this.lcdEnabled = (this.cpu.registers[64] & 0x80) != 0;
        this.spritePriorityEnabled = flatState[offset++] != 0;
        this.setVRamBank(flatState[offset++] & 0xFF);
        for (i = 0; i < 128; ++i) {
            this.setGBCPalette(i, flatState[offset++] & 0xFF);
        }
        return offset;
    }

    public int flatten(byte[] flatState, int offset) {
        int i;
        for (i = 0; i < this.videoRamBanks.length; ++i) {
            System.arraycopy(this.videoRamBanks[i], 0, flatState, offset, 8192);
            offset += 8192;
        }
        for (int j = 0; j < 12; ++j) {
            GBCanvas.setInt(flatState, offset, this.gbPalette[j]);
            offset += 4;
        }
        flatState[offset++] = (byte)(this.bgEnabled ? 1 : 0);
        flatState[offset++] = (byte)(this.winEnabled ? 1 : 0);
        flatState[offset++] = (byte)(this.spritesEnabled ? 1 : 0);
        flatState[offset++] = (byte)(this.bgWindowDataSelect ? 1 : 0);
        flatState[offset++] = (byte)(this.doubledSprites ? 1 : 0);
        flatState[offset++] = (byte)(this.hiBgTileMapAddress ? 1 : 0);
        flatState[offset++] = (byte)(this.spritePriorityEnabled ? 1 : 0);
        flatState[offset++] = (byte)(this.tileOffset != 0 ? 1 : 0);
        for (i = 0; i < 128; ++i) {
            flatState[offset++] = (byte)this.getGBCPalette(i);
        }
        return offset;
    }

    public final void addressWrite(int addr, byte data) {
        int tileIndex;
        if (addr < 6144 && this.tileReadState[tileIndex = (addr >> 4) + this.tileOffset]) {
            int r = this.tileImage.length - this.tileCount + tileIndex;
            do {
                this.tileImage[r] = null;
            } while ((r -= this.tileCount) >= 0);
            this.tileReadState[tileIndex] = false;
        }
        this.videoRam[addr] = data;
    }

    public final void invalidateAll(int pal) {
        int start = pal * this.tileCount * 4;
        int stop = (pal + 1) * this.tileCount * 4;
        for (int r = start; r < stop; ++r) {
            this.tileImage[r] = null;
        }
    }

    private final void drawSprites(int priorityFlag) {
        if (!this.spritesEnabledThisFrame) {
            return;
        }
        for (int i = 0; i < 40; ++i) {
            int attributes = 0xFF & this.cpu.oam[i * 4 + 3];
            if ((attributes & 0x80) != priorityFlag) continue;
            int spriteX = (0xFF & this.cpu.oam[i * 4 + 1]) - 8;
            int spriteY = (0xFF & this.cpu.oam[i * 4]) - 16;
            int tileNum = 0xFF & this.cpu.oam[i * 4 + 2];
            if (spriteX >= 160 || spriteY >= 144 || spriteY == -16) continue;
            if (this.doubledSprites) {
                tileNum &= 0xFE;
            }
            int spriteAttrib = 0;
            spriteAttrib += 32 + ((attributes & 7) << 2);
            tileNum += 384 * (attributes >> 3 & 1);
            if ((attributes & 0x20) != 0) {
                spriteAttrib |= 1;
            }
            if ((attributes & 0x40) != 0) {
                spriteAttrib |= 2;
            }
            if (this.doubledSprites) {
                if ((spriteAttrib & 2) != 0) {
                    this.draw(tileNum + 1, spriteX, spriteY, spriteAttrib);
                    this.draw(tileNum, spriteX, spriteY + 8, spriteAttrib);
                    continue;
                }
                this.draw(tileNum, spriteX, spriteY, spriteAttrib);
                this.draw(tileNum + 1, spriteX, spriteY + 8, spriteAttrib);
                continue;
            }
            this.draw(tileNum, spriteX, spriteY, spriteAttrib);
        }
    }

    public final void notifyScanline(int line) {
        if (this.skipping) {
            return;
        }
        if (line == 0) {
            this.g.setClip(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
            if (this.spritePriorityEnabled) {
                this.drawSprites(128);
            }
            this.windowStopLine = 144;
            this.winEnabledThisFrame = this.winEnabled;
            this.winEnabledThisLine = this.winEnabled;
            this.screenFilled = false;
            this.windowStopped = false;
        }
        if (this.winEnabledThisLine && !this.winEnabled) {
            this.windowStopLine = line & 0xFF;
            this.winEnabledThisLine = false;
        }
        if (line == (this.cpu.registers[74] & 0xFF) + 1) {
            this.savedWindowDataSelect = this.bgWindowDataSelect;
        }
        if (!this.bgEnabled) {
            return;
        }
        if (this.winEnabledThisLine && !this.windowStopped && (this.cpu.registers[75] & 0xFF) - 7 == 0 && (this.cpu.registers[74] & 0xFF) <= line - 7) {
            int yPixelOfs = this.cpu.registers[66] & 7;
            int screenY = (line & 0xF8) - yPixelOfs;
            if (screenY >= 136) {
                this.screenFilled = true;
            }
        } else if ((this.cpu.registers[66] + line & 7) == 7 || line == 144) {
            int xPixelOfs = this.cpu.registers[67] & 7;
            int yPixelOfs = this.cpu.registers[66] & 7;
            int xTileOfs = (this.cpu.registers[67] & 0xFF) >> 3;
            int yTileOfs = (this.cpu.registers[66] & 0xFF) >> 3;
            int bgStartAddress = this.hiBgTileMapAddress ? 7168 : 6144;
            int screenY = (line & 0xF8) - yPixelOfs;
            int screenRight = 160;
            int tileY = (line >> 3) + yTileOfs;
            int tileX = xTileOfs;
            int memStart = bgStartAddress + ((tileY & 0x1F) << 5);
            for (int screenX = -xPixelOfs; screenX < screenRight; screenX += 8) {
                int tileNum = this.bgWindowDataSelect ? this.videoRamBanks[0][memStart + (tileX & 0x1F)] & 0xFF : 256 + this.videoRamBanks[0][memStart + (tileX & 0x1F)];
                int tileAttrib = 0;
                byte mapAttrib = this.videoRamBanks[1][memStart + (tileX & 0x1F)];
                tileAttrib += (mapAttrib & 7) << 2;
                ++tileX;
                this.draw(tileNum += 384 * (mapAttrib >> 3 & 1), screenX, screenY, tileAttrib += mapAttrib >> 5 & 3);
            }
            if (screenY >= 136) {
                this.screenFilled = true;
            }
        }
        if (line == 143 && !this.screenFilled) {
            this.notifyScanline(144);
        }
    }

    public final void vBlank() {
        this.timer += 17;
        if (this.skipping && this.g != null) {
            ++this.skipCount;
            if (this.skipCount >= MeBoy.maxFrameSkip) {
                this.skipping = false;
                int lag = (int)System.currentTimeMillis() - this.timer;
                if (lag > 17) {
                    this.timer += lag - 17;
                }
            } else {
                this.skipping = this.timer - (int)System.currentTimeMillis() < 0;
            }
            return;
        }
        if (!this.lcdEnabled && this.g != null) {
            this.g.setClip(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
            this.g.setColor(-1);
            this.g.fillRect(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
        }
        this.lastSkipCount = this.skipCount;
        this.frameDone = false;
        this.cpu.screen.repaint();
        while (!this.frameDone && !this.cpu.terminate) {
            Thread.yield();
        }
        int now = (int)System.currentTimeMillis();
        this.skipping = MeBoy.maxFrameSkip == 0 ? false : this.timer - now < 0;
        try {
            while (this.timer > now + 17) {
                Thread.sleep(1L);
                now = (int)System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.skipCount = 0;
    }

    public final void draw(Graphics g) {
        if (this.lcdEnabled) {
            this.g = g;
            if (this.winEnabledThisFrame) {
                int wy;
                int wx;
                int windowStartAddress;
                int n = windowStartAddress = this.hiWinTileMapAddress ? 7168 : 6144;
                if (this.windowStopped) {
                    wx = this.windowStopX;
                    wy = this.windowStopY;
                } else {
                    wx = (this.cpu.registers[75] & 0xFF) - 7;
                    wy = this.cpu.registers[74] & 0xFF;
                }
                int screenY = wy;
                int maxy = 19 - (wy >> 3);
                for (int y = 0; y < maxy && wy + y * 8 < this.windowStopLine; ++y) {
                    int screenX = wx;
                    int maxx = 21 - (wx >> 3);
                    for (int x = 0; x < maxx; ++x) {
                        int tileAddress = windowStartAddress + y * 32 + x;
                        int tileNum = this.savedWindowDataSelect ? this.videoRamBanks[0][tileAddress] & 0xFF : 256 + this.videoRamBanks[0][tileAddress];
                        int tileAttrib = 0;
                        byte mapAttrib = this.videoRamBanks[1][tileAddress];
                        tileAttrib += (mapAttrib & 7) << 2;
                        this.draw(tileNum += 384 * (mapAttrib >> 3 & 1), screenX, screenY, tileAttrib += mapAttrib >> 5 & 3);
                        screenX += 8;
                    }
                    screenY += 8;
                }
            }
            if (!this.spritePriorityEnabled) {
                this.drawSprites(128);
            }
            this.drawSprites(0);
        }
        this.frameDone = true;
        this.spritesEnabledThisFrame = this.spritesEnabled;
    }

    private final Image updateImage(int tileIndex, int attribs) {
        int index = tileIndex + this.tileCount * attribs;
        boolean otherBank = tileIndex >= 384;
        int offset = otherBank ? tileIndex - 384 << 4 : tileIndex << 4;
        int paletteStart = attribs & 0xFC;
        byte[] vram = otherBank ? this.videoRamBanks[1] : this.videoRamBanks[0];
        int[] palette = this.gbcPalette;
        boolean transparent = palette[paletteStart] >= 0;
        int pixix = 0;
        int pixixdx = 1;
        int pixixdy = 0;
        if ((attribs & 2) != 0) {
            pixixdy = -2 * this.tileWidth;
            pixix = this.tileWidth * (this.tileHeight - 1);
        }
        if ((attribs & 1) == 0) {
            pixixdx = -1;
            pixix += this.tileWidth - 1;
            pixixdy += this.tileWidth * 2;
        }
        int y1c = this.tileHeight >> 1;
        int y2c = 0;
        for (int y = 0; y < this.tileHeight; ++y) {
            int num = weaveLookup[vram[offset] & 0xFF] + (weaveLookup[vram[offset + 1] & 0xFF] << 1);
            if (num != 0) {
                transparent = false;
            }
            int x1c = this.tileWidth >> 1;
            int x2c = 0;
            int x = this.tileWidth;
            while (--x >= 0) {
                this.tempPix[pixix] = palette[paletteStart + (num & 3)];
                pixix += pixixdx;
                x2c += 8;
                while (x2c > x1c) {
                    x1c += this.tileWidth;
                    num >>= 2;
                }
            }
            pixix += pixixdy;
            y2c += 8;
            while (y2c > y1c) {
                y1c += this.tileHeight;
                offset += 2;
            }
        }
        this.tileImage[index] = transparent ? this.transparentImage : Image.createRGBImage((int[])this.tempPix, (int)this.tileWidth, (int)this.tileHeight, (boolean)true);
        this.tileReadState[tileIndex] = true;
        return this.tileImage[index];
    }

    private final void draw(int tileIndex, int x, int y, int attribs) {
        int ix = tileIndex + this.tileCount * attribs;
        Image im = this.tileImage[ix];
        if (im == null) {
            im = this.updateImage(tileIndex, attribs);
        }
        if (im == this.transparentImage) {
            return;
        }
        if (this.scale) {
            y = y * this.tileHeight >> 3;
            x = x * this.tileWidth >> 3;
        }
        this.g.drawImage(im, this.left + x, this.top + y, 20);
    }

    public void decodePalette(int startIndex, int data) {
        for (int i = 0; i < 4; ++i) {
            this.gbPalette[startIndex + i] = this.colors[data >> 2 * i & 3];
        }
        int n = startIndex;
        this.gbPalette[n] = this.gbPalette[n] & 0xFFFFFF;
    }

    public final void stopWindowFromLine() {
        this.windowStopped = true;
        this.windowStopLine = this.cpu.registers[68] & 0xFF;
        this.windowStopX = (this.cpu.registers[75] & 0xFF) - 7;
        this.windowStopY = this.cpu.registers[74] & 0xFF;
    }

    public void setScale(int screenWidth, int screenHeight) {
        int oldTW = this.tileWidth;
        int oldTH = this.tileHeight;
        this.tileWidth = screenWidth / 20;
        this.tileHeight = screenHeight / 18;
        if (MeBoy.keepProportions) {
            if (this.tileWidth < this.tileHeight) {
                this.tileHeight = this.tileWidth;
            } else {
                this.tileWidth = this.tileHeight;
            }
        }
        boolean bl = this.scale = this.tileWidth != 8 || this.tileHeight != 8;
        if (this.tileWidth != oldTW || this.tileHeight != oldTH) {
            int r;
            for (r = 0; r < this.tileImage.length; ++r) {
                this.tileImage[r] = null;
            }
            for (r = 0; r < this.tileReadState.length; ++r) {
                this.tileReadState[r] = false;
            }
        }
        this.tempPix = new int[this.tileWidth * this.tileHeight];
    }

    public void setGBCPalette(int index, int data) {
        if (this.gbcRawPalette[index] == data) {
            return;
        }
        this.gbcRawPalette[index] = data;
        if (index >= 64 && (index & 6) == 0) {
            return;
        }
        int value = (this.gbcRawPalette[index | 1] << 8) + this.gbcRawPalette[index & 0xFFFFFFFE];
        this.gbcPalette[index >> 1] = -16777216 + ((value & 0x1F) << 19) + ((value & 0x3E0) << 6) + ((value & 0x7C00) >> 7);
        this.invalidateAll(index >> 3);
    }

    public int getGBCPalette(int index) {
        return this.gbcRawPalette[index];
    }

    public void setVRamBank(int value) {
        this.tileOffset = value * 384;
        this.videoRam = this.videoRamBanks[value];
        this.cpu.memory[4] = this.videoRam;
    }

    static {
        for (int i = 1; i < 256; ++i) {
            for (int d = 0; d < 8; ++d) {
                int n = i;
                weaveLookup[n] = weaveLookup[n] + ((i >> d & 1) << d * 2);
            }
        }
    }
}

