/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwaEX;

import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAImageARGB;
import CWA2DAPI.cwabase2d.CWASprite;
import javax.microedition.lcdui.Image;

public class CWAImageUtil {
    public static byte TEXTURE_MIX = 0;
    public static byte TEXTURE_BLEND = 1;
    public static byte TEXTURE_REPLACE = (byte)2;

    public static CWAImageARGB getImageARGB(Image image, CWAImageARGB cWAImageARGB) {
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int[] nArray = new int[n2 * n3];
        image.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != -1 && nArray[i2] != -16777216) continue;
            nArray[i2] = 0xFFFFFF;
        }
        cWAImageARGB.init(nArray, n2, n3);
        return cWAImageARGB;
    }

    public static CWAImageARGB getFrameImg(CWASprite cWASprite, int n2, int[] nArray, byte by, CWAImageARGB cWAImageARGB) {
        Image image = Image.createImage((int)nArray[2], (int)nArray[3]);
        image.getGraphics().setColor(0);
        image.getGraphics().fillRect(0, 0, nArray[2], nArray[3]);
        cWASprite.drawFrame(image.getGraphics(), n2, -nArray[0], -nArray[1], by, 20);
        cWAImageARGB.x = nArray[0];
        cWAImageARGB.y = nArray[1];
        return CWAImageUtil.getImageARGB(image, cWAImageARGB);
    }

    public static CWAImageARGB reSize(CWAImageARGB cWAImageARGB, int n2, int n3) {
        int[] nArray = new int[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n4 = i3 * cWAImageARGB.w / n2;
                int n5 = i2 * cWAImageARGB.h / n3;
                nArray[i3 + i2 * n2] = cWAImageARGB.argb[n4 + n5 * cWAImageARGB.w];
            }
        }
        cWAImageARGB.init(nArray, n2, n3);
        cWAImageARGB.x = cWAImageARGB.x * n2 / cWAImageARGB.w / 10;
        cWAImageARGB.y = cWAImageARGB.y * n2 / cWAImageARGB.w / 10;
        return cWAImageARGB;
    }

    public static CWAImageARGB scale(CWAImageARGB cWAImageARGB, int n2) {
        int n3 = cWAImageARGB.w * n2 / 10;
        int n4 = cWAImageARGB.h * n2 / 10;
        int[] nArray = new int[n3 * n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n5 = i3 * cWAImageARGB.w / n3;
                int n6 = i2 * cWAImageARGB.h / n4;
                nArray[i3 + i2 * n3] = cWAImageARGB.argb[n5 + n6 * cWAImageARGB.w];
            }
        }
        cWAImageARGB.init(nArray, n3, n4);
        cWAImageARGB.x = cWAImageARGB.x * n2 / 10;
        cWAImageARGB.y = cWAImageARGB.y * n2 / 10;
        return cWAImageARGB;
    }

    public static CWAImageARGB reLightContrast(CWAImageARGB cWAImageARGB, int n2, int n3) {
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n4 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n5 = n4 >> 24;
                int n6 = n4 >> 16 & 0xFF;
                int n7 = n4 >> 8 & 0xFF;
                n4 &= 0xFF;
                n6 = n6 * n2 + n3;
                n7 = n7 * n2 + n3;
                n4 = n4 * n2 + n3;
                if (n6 > 255) {
                    n6 = 255;
                } else if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 > 255) {
                    n7 = 255;
                } else if (n7 < 0) {
                    n7 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                } else if (n4 < 0) {
                    n4 = 0;
                }
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n5 << 24 | n6 << 16 | n7 << 8 | n4;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB negative(CWAImageARGB cWAImageARGB) {
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n2 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n3 = n2 >> 24;
                int n4 = 255 - (n2 >> 16 & 0xFF);
                int n5 = 255 - (n2 >> 8 & 0xFF);
                n2 = 255 - (n2 & 0xFF);
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n3 << 24 | n4 << 16 | n5 << 8 | n2;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB transparent(CWAImageARGB cWAImageARGB, int n2) {
        if (n2 < 0 || n2 > 255) {
            return cWAImageARGB;
        }
        for (int i2 = 0; i2 < cWAImageARGB.length; ++i2) {
            if (cWAImageARGB.argb[i2] == 0xFFFFFF || cWAImageARGB.argb[i2] == 0) continue;
            if (cWAImageARGB.argb[i2] == -16777216) {
                int n3 = i2;
                int cfr_ignored_0 = cWAImageARGB.argb[n3];
                cWAImageARGB.argb[n3] = 0;
                continue;
            }
            cWAImageARGB.argb[i2] = n2 << 24 | cWAImageARGB.argb[i2] & 0xFFFFFF;
        }
        return cWAImageARGB;
    }

    public static Image transparent(Image image, int n2) {
        CWAImageARGB cWAImageARGB = new CWAImageARGB();
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        Image image2 = Image.createImage((int)n3, (int)n4);
        image2.getGraphics().setColor(0);
        image2.getGraphics().fillRect(0, 0, n3, n4);
        image2.getGraphics().drawImage(image, 0, 0, 20);
        cWAImageARGB.init(CWATools.getPixels(image2), n3, n4);
        CWAImageUtil.transparent(cWAImageARGB, n2);
        image = CWATools.drawPixels(cWAImageARGB.argb, cWAImageARGB.w, cWAImageARGB.h, true);
        cWAImageARGB.release();
        return image;
    }

    public static CWAImageARGB changeColor(CWAImageARGB cWAImageARGB, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < cWAImageARGB.argb.length; ++i2) {
            if (cWAImageARGB.argb[i2] == 0xFFFFFF) continue;
            cWAImageARGB.argb[i2] = n2 < 0 || n2 > 255 ? n3 << 16 | n4 << 8 | n5 : n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB texture2D(CWAImageARGB cWAImageARGB, CWAImageARGB cWAImageARGB2, byte by) {
        int n2 = 0;
        int n3 = 0;
        if (by == TEXTURE_MIX) {
            cWAImageARGB = CWAImageUtil.reLightContrast(cWAImageARGB, 5, 5);
        }
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n4 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n5 = cWAImageARGB2.argb[n3 * cWAImageARGB2.w + n2];
                if (n4 >> 24 != 0) {
                    if (by == TEXTURE_MIX) {
                        cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n4 & n5;
                    } else if (by == TEXTURE_BLEND) {
                        cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n4 | n5;
                    } else if (by == TEXTURE_REPLACE) {
                        cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n5;
                    }
                }
                if (n2 < cWAImageARGB2.w - 1) {
                    ++n2;
                    continue;
                }
                n2 = 0;
            }
            n3 = n3 < cWAImageARGB2.h - 1 ? ++n3 : 0;
            n2 = 0;
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB blackWhite(CWAImageARGB cWAImageARGB) {
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n2 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n3 = n2 >> 24;
                int n4 = n2 >> 16 & 0xFF;
                int n5 = n2 >> 8 & 0xFF;
                n2 &= 0xFF;
                n4 = n2 = (int)(0.299 * (double)n4 + 0.587 * (double)n5 + 0.114 * (double)n2);
                n5 = n2;
                if (cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] == -1 || cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] == -16777216) {
                    int n6 = i2 * cWAImageARGB.w + i3;
                    cWAImageARGB.argb[n6] = cWAImageARGB.argb[n6] & 0xFFFFFF;
                    continue;
                }
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n3 << 24 | n4 << 16 | n5 << 8 | n2;
            }
        }
        return cWAImageARGB;
    }

    public static Image blackWhite(Image image) {
        CWAImageARGB cWAImageARGB = new CWAImageARGB();
        cWAImageARGB.init(CWATools.getPixels(image), image.getWidth(), image.getHeight());
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n2 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n3 = n2 >> 24;
                int n4 = n2 >> 16 & 0xFF;
                int n5 = n2 >> 8 & 0xFF;
                n2 &= 0xFF;
                n4 = n2 = (int)(0.299 * (double)n4 + 0.587 * (double)n5 + 0.114 * (double)n2);
                n5 = n2;
                if (cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] == -1 || cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] == -16777216) {
                    int n6 = i2 * cWAImageARGB.w + i3;
                    cWAImageARGB.argb[n6] = cWAImageARGB.argb[n6] & 0xFFFFFF;
                    continue;
                }
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n3 << 24 | n4 << 16 | n5 << 8 | n2;
            }
        }
        image = CWATools.drawPixels(cWAImageARGB.argb, cWAImageARGB.w, cWAImageARGB.h, true);
        cWAImageARGB.release();
        return image;
    }

    public static CWAImageARGB crayon(CWAImageARGB cWAImageARGB) {
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n8 = n7 >> 24;
                int n9 = n7 >> 16 & 0xFF;
                int n10 = n7 >> 8 & 0xFF;
                int n11 = n7 & 0xFF;
                if (i2 + 1 == cWAImageARGB.h) {
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                } else {
                    n7 = cWAImageARGB.argb[(i2 + 1) * cWAImageARGB.w + i3];
                    n6 = n7 >> 16 & 0xFF;
                    n5 = n7 >> 8 & 0xFF;
                    n4 = n7 & 0xFF;
                }
                if (i3 + 1 == cWAImageARGB.w) {
                    n3 = 0;
                    n2 = 0;
                    n7 = 0;
                } else {
                    n7 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3 + 1];
                    n3 = n7 >> 16 & 0xFF;
                    n2 = n7 >> 8 & 0xFF;
                    n7 &= 0xFF;
                }
                n9 = (int)Math.sqrt(2 * (n9 - n6) * (n9 - n6) + (n9 - n3) * (n9 - n3));
                n10 = (int)Math.sqrt(2 * (n10 - n5) * (n10 - n5) + (n10 - n2) * (n10 - n2));
                n11 = (int)Math.sqrt(2 * (n11 - n4) * (n11 - n4) + (n11 - n7) * (n11 - n7));
                n9 = 255 - n9;
                n10 = 255 - n10;
                n11 = 255 - n11;
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n8 << 24 | n9 << 16 | n10 << 8 | n11;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB hoodwink(CWAImageARGB cWAImageARGB) {
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n2 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n3 = n2 >> 24;
                int n4 = n2 >> 16 & 0xFF;
                int n5 = n2 >> 8 & 0xFF;
                n2 &= 0xFF;
                n4 = (int)(0.299 * (double)n4);
                n5 = (int)(0.587 * (double)n5);
                n2 = (int)(0.114 * (double)n2);
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n3 << 24 | n4 << 16 | n5 << 8 | n2;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB neonLight(CWAImageARGB cWAImageARGB) {
        for (int i2 = 0; i2 < cWAImageARGB.h; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.w; ++i3) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3];
                int n8 = n7 >> 24;
                int n9 = n7 >> 16 & 0xFF;
                int n10 = n7 >> 8 & 0xFF;
                int n11 = n7 & 0xFF;
                if (i2 + 1 == cWAImageARGB.h) {
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                } else {
                    n7 = cWAImageARGB.argb[(i2 + 1) * cWAImageARGB.w + i3];
                    n6 = n7 >> 16 & 0xFF;
                    n5 = n7 >> 8 & 0xFF;
                    n4 = n7 & 0xFF;
                }
                if (i3 + 1 == cWAImageARGB.w) {
                    n3 = 0;
                    n2 = 0;
                    n7 = 0;
                } else {
                    n7 = cWAImageARGB.argb[i2 * cWAImageARGB.w + i3 + 1];
                    n3 = n7 >> 16 & 0xFF;
                    n2 = n7 >> 8 & 0xFF;
                    n7 &= 0xFF;
                }
                n9 = (int)Math.sqrt(2 * (n9 - n6) * (n9 - n6) + (n9 - n3) * (n9 - n3));
                n10 = (int)Math.sqrt(2 * (n10 - n5) * (n10 - n5) + (n10 - n2) * (n10 - n2));
                n11 = (int)Math.sqrt(2 * (n11 - n4) * (n11 - n4) + (n11 - n7) * (n11 - n7));
                cWAImageARGB.argb[i2 * cWAImageARGB.w + i3] = n8 << 24 | n9 << 16 | n10 << 8 | n11;
            }
        }
        return cWAImageARGB;
    }

    public static CWAImageARGB rotate(CWAImageARGB cWAImageARGB, int n2, int n3, double d2) {
        if (Math.abs(d2 % 360.0) < 1.0) {
            return cWAImageARGB;
        }
        int n4 = n2 > cWAImageARGB.w / 2 ? n2 : cWAImageARGB.w - n2;
        int n5 = n3 > cWAImageARGB.h / 2 ? n3 : cWAImageARGB.h - n3;
        double d3 = Math.sqrt(n4 * n4 + n5 * n5);
        n4 = (int)(d3 * 2.0 + 1.0);
        int[] nArray = new int[n4 * n4];
        double d4 = d2 * Math.PI / 180.0;
        for (int i2 = 0; i2 < cWAImageARGB.w; ++i2) {
            for (int i3 = 0; i3 < cWAImageARGB.h; ++i3) {
                if (cWAImageARGB.argb[i3 * cWAImageARGB.w + i2] >> 24 == 0) continue;
                double d5 = d3 + (double)(i2 - n2) * Math.cos(d4) + (double)(i3 - n3) * Math.sin(d4);
                double d6 = d3 + (double)(i3 - n3) * Math.cos(d4) - (double)(i2 - n2) * Math.sin(d4);
                nArray[(int)d6 * n4 + (int)d5] = cWAImageARGB.argb[i3 * cWAImageARGB.w + i2];
            }
        }
        cWAImageARGB.init(nArray, n4, n4);
        return cWAImageARGB;
    }
}

