/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public final class mapMaster {
    static String[] mapName = null;
    static int[][] mapValue = null;
    public int mapWidth;
    public int mapHeight;
    public static int mapTileWidth = 16;
    public static int mapTileHeight = 16;
    public int mapMaxX;
    public int mapMaxY;
    public PicObj[] picArr;
    public ResObj[] resArr;
    public BgTileObj[][] bgArr;
    public short[][][] map;

    int getMapValue(int ResID) {
        if (ResID < 0) {
            return 1;
        }
        if (ResID == 0) {
            return 0;
        }
        if (mapName == null) {
            return 0;
        }
        boolean value = false;
        ResObj rObj = this.getResObj(ResID);
        PicObj pObj = this.getPicObj(rObj.picId);
        int id = -1;
        for (int i = 0; i < mapName.length; ++i) {
            if (pObj.path.indexOf(mapName[i]) == -1 && mapName[i].indexOf(pObj.path) == -1) continue;
            id = i;
            break;
        }
        if (id == -1) {
            return 0;
        }
        int[] mapV = mapValue[id];
        if (pObj.img == null) {
            pObj.img = Tool.createImage(pObj.img, pObj.path);
        }
        int width = pObj.img.getWidth();
        int height = pObj.img.getHeight();
        int wCount = width / mapTileWidth;
        int hCount = height / this.mapHeight;
        int cX = rObj.x / mapTileWidth;
        int cY = rObj.y / mapTileHeight;
        int tID = cY * wCount + cX;
        return mapV[tID];
    }

    static void initMapValue(Game game) {
        String str = game.getTextByUTF("/option/mapValue.txt");
        if (str == null || str.equals("")) {
            return;
        }
        int index = 0;
        int end = 0;
        index = str.indexOf("@count", index);
        index = str.indexOf("=", index);
        end = str.indexOf("\r\n", index);
        String countStr = str.substring(index + 1, end);
        int count = Integer.parseInt(countStr);
        mapName = new String[count];
        mapValue = new int[count][];
        for (int i = 0; i < count; ++i) {
            String name;
            index = str.indexOf("@mapName=", end);
            index = str.indexOf("=", index);
            end = str.indexOf("\r\n", index);
            mapMaster.mapName[i] = name = str.substring(index + 1, end);
            index = str.indexOf("@mapTileCount=", index);
            index = str.indexOf("=", index);
            end = str.indexOf("\r\n", index);
            String tileCountStr = str.substring(index + 1, end);
            int tileCount = Integer.parseInt(tileCountStr);
            mapMaster.mapValue[i] = new int[tileCount];
            index = str.indexOf("@detail=", index);
            index = str.indexOf("=", index);
            end = str.indexOf("\r\n", index);
            String temp = str.substring(index + 1, end);
            int s = 0;
            int e = 0;
            for (int k = 0; k < tileCount; ++k) {
                int v;
                e = temp.indexOf(",", s);
                if (e == -1) {
                    e = temp.length();
                }
                String t2 = temp.substring(s, e);
                s = e + 1;
                int a = 0;
                boolean b = false;
                a = t2.indexOf(":", a);
                String vStr = t2.substring(a + 1, t2.length());
                mapMaster.mapValue[i][k] = v = Integer.parseInt(vStr);
            }
        }
    }

    void releaseImg() {
        if (this.picArr != null) {
            for (int i = 0; i < this.picArr.length; ++i) {
                this.picArr[i].img = null;
            }
        }
    }

    void releaseAllData() {
        if (this.picArr != null) {
            for (int i = 0; i < this.picArr.length; ++i) {
                this.picArr[i].img = null;
            }
            this.picArr = null;
        }
        this.resArr = null;
        this.bgArr = null;
        this.map = null;
    }

    PicObj getPicObj(int picID) {
        for (int i = 0; i < this.picArr.length; ++i) {
            if (this.picArr[i].id != picID) continue;
            return this.picArr[i];
        }
        return null;
    }

    ResObj getResObj(int resID) {
        if (this.resArr != null) {
            for (int i = 0; i < this.resArr.length; ++i) {
                if (this.resArr[i].id != resID) continue;
                return this.resArr[i];
            }
        }
        return null;
    }

    public void drawMap(Graphics g, int x, int y, int mapX, int mapY) {
        if (mapX >= this.mapMaxX || mapY >= this.mapMaxY) {
            return;
        }
        for (int i = 0; i < this.map.length - 1; ++i) {
            if (i == 0 && this.map[i][mapX][mapY] == 0) {
                int oldColor = g.getColor();
                g.setColor(0, 0, 0);
                g.fillRect(x, y, mapTileWidth, mapTileHeight);
                g.setColor(oldColor);
            }
            this.drawMapTile(g, x, y, this.map[i][mapX][mapY]);
        }
    }

    public void drawLastMap(Graphics g, int x, int y, int mapX, int mapY) {
        if (mapX >= this.mapMaxX || mapY >= this.mapMaxY) {
            return;
        }
        this.drawMapTile(g, x, y, this.map[this.map.length - 1][mapX][mapY]);
    }

    public void drawMapTile(Graphics g, int x, int y, int resID) {
        if (resID <= 0) {
            return;
        }
        ResObj tempR = this.getResObj(resID);
        PicObj tempP = this.getPicObj(tempR.picId);
        byte t = Tool.getTransformByFlip(tempR.flipH, tempR.flipV);
        if (tempP.img == null) {
            tempP.img = Tool.createImage(tempP.img, tempP.path);
        }
        if (tempP.img == null) {
            return;
        }
        Tool.drawRegion(g, tempP.img, tempR.x, tempR.y, tempR.width, tempR.height, t, x, y, 0);
    }

    public mapMaster(String menuFile) {
        this.readSceneData(menuFile);
    }

    public mapMaster() {
    }

    public void setDataFile(String menuFile) {
        this.readSceneData(menuFile);
    }

    private boolean readSceneData(String filePath) {
        try {
            InputStream in = this.getClass().getResourceAsStream(filePath);
            DataInputStream is = new DataInputStream(in);
            this.mapWidth = is.readInt();
            this.mapHeight = is.readInt();
            mapTileWidth = is.readInt();
            mapTileHeight = is.readInt();
            this.mapMaxX = this.mapWidth / mapTileWidth;
            this.mapMaxY = this.mapHeight / mapTileHeight;
            int picCount = is.readByte();
            this.picArr = new PicObj[picCount];
            for (int i = 0; i < picCount; ++i) {
                short picID = is.readByte();
                String path = is.readUTF();
                PicObj temp = new PicObj();
                temp.id = picID;
                temp.path = path;
                this.picArr[i] = temp;
                temp = null;
            }
            int resCount = is.readInt();
            this.resArr = new ResObj[resCount];
            for (int i = 0; i < this.resArr.length; ++i) {
                short id = is.readShort();
                short picID = is.readShort();
                short x = is.readShort();
                short y = is.readShort();
                byte width = is.readByte();
                byte height = is.readByte();
                byte flipH = is.readByte();
                byte filpV = is.readByte();
                ResObj obj = new ResObj();
                obj.id = id;
                obj.picId = picID;
                obj.x = x;
                obj.y = y;
                obj.width = width;
                obj.height = height;
                obj.flipH = flipH;
                obj.flipV = filpV;
                this.resArr[i] = obj;
                obj = null;
            }
            int mapCount = is.readInt();
            this.map = new short[mapCount][this.mapMaxX][this.mapMaxY];
            for (int i = 0; i < mapCount; ++i) {
                for (int j = 0; j < this.mapMaxX; ++j) {
                    for (int k = 0; k < this.mapMaxY; ++k) {
                        this.map[i][j][k] = is.readShort();
                    }
                }
            }
            is.close();
            Object var3_4 = null;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        System.gc();
        return true;
    }
}

