/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;

public class Motor
implements Constraint {
    private Body a;
    private int b;
    private int c;
    private boolean d;
    private boolean e;
    private int f;
    private static FXVector g = new FXVector();
    private static FXVector h = new FXVector();
    private static FXVector i = new FXVector();
    private FXVector j = new FXVector();
    private FXVector k = new FXVector();
    private FXVector l = new FXVector();
    private FXVector m = new FXVector();
    protected UserData userData = null;

    public Motor(Body body, int n, int n2) {
        this.a = body;
        this.b = n;
        this.d = true;
        this.e = false;
        this.f = n2;
    }

    public Motor(Body body, int n, int n2, int n3) {
        this.a = body;
        this.b = n;
        this.c = n2;
        this.d = false;
        this.e = false;
        this.f = n3;
    }

    public Motor(Motor motor, Body[] bodyArray) {
        this.a = bodyArray != null ? bodyArray[motor.a.id] : motor.a;
        this.b = motor.b;
        this.c = motor.c;
        this.d = motor.d;
        this.e = motor.e;
        this.f = motor.f;
        if (motor.userData != null) {
            this.userData = motor.userData.copy();
        }
    }

    public void setParameter(int n, int n2, boolean bl, boolean bl2) {
        this.b = n;
        this.c = n2;
        this.d = bl;
        this.e = bl2;
        this.m.assignFX(0, 0);
    }

    public Constraint copy(Body[] bodyArray) {
        return new Motor(this, bodyArray);
    }

    private Motor() {
    }

    public void precalculate() {
        if (this.d) {
            this.a.applyTorque(this.m.xFX);
            return;
        }
        g.assignFX(this.b, this.c);
        if (this.e) {
            FXMatrix fXMatrix = new FXMatrix(this.a.getRotationMatrix());
            fXMatrix.invert();
            fXMatrix.mult(g, this.k);
        } else {
            this.k.xFX = Motor.g.xFX;
            this.k.yFX = Motor.g.yFX;
        }
        this.l.xFX = this.k.xFX;
        this.l.yFX = this.k.yFX;
        this.l.normalize();
        this.a.applyMomentum(this.m);
    }

    public void applyMomentum() {
        if (this.d) {
            int n = (int)((long)(this.a.angularVelocity2FX - this.b) * this.a.shape.h >> 24);
            Motor.i.xFX = this.m.xFX;
            this.m.xFX = Math.max(Math.min(this.m.xFX + n, this.f), -this.f);
            this.a.applyTorque(this.m.xFX - Motor.i.xFX);
            return;
        }
        this.j.xFX = this.k.xFX;
        this.j.yFX = this.k.yFX;
        long l = (long)this.l.xFX * (long)this.a.velocityFX.xFX + (long)this.l.yFX * (long)this.a.velocityFX.yFX >> 12;
        this.j.add(this.l, -l);
        this.j.multFX(this.a.shape.f);
        i.assign(this.m);
        this.m.xFX += this.j.xFX;
        this.m.yFX += this.j.yFX;
        this.m.minFX(this.f);
        this.m.maxFX(-this.f);
        h.assignDiff(this.m, i);
        this.a.applyMomentum(h);
    }

    public void postStep() {
    }

    public boolean concernsBody(Body body) {
        return body.equals(this.a);
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Motor && this.a.equals(((Motor)constraint).a) && this.b == ((Motor)constraint).b && this.c == ((Motor)constraint).c && this.d == ((Motor)constraint).d && this.e == ((Motor)constraint).e && this.f == ((Motor)constraint).f;
    }

    public int getImpulseFX() {
        return this.m.lengthFX();
    }

    public Body body() {
        return this.a;
    }

    public boolean isRotation() {
        return this.d;
    }

    public boolean isRelative() {
        return this.e;
    }

    public int getMaxForceFX() {
        return this.f;
    }

    protected int getTargetAFX() {
        return this.b;
    }

    protected int getTargetBFX() {
        return this.c;
    }

    protected void setTargetAFX(int n) {
        this.b = n;
    }

    protected void setTargetBFX(int n) {
        this.c = n;
    }

    protected void setMaxForceFX(int n) {
        this.f = n;
    }

    protected void setRotation(boolean bl) {
        this.d = bl;
    }

    protected void setIsRelative(boolean bl) {
        this.e = bl;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }
}

