/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.DataManager;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.AboutScreen;
import com.ximad.pvn.screens.OptionsScreen;
import com.ximad.pvn.screens.QuitScreen;
import com.ximad.pvn.screens.SelectScenarioScreen;
import javax.microedition.lcdui.Graphics;

public class HomeScreen
extends UiScreen {
    private static HomeScreen instance;
    private CustomButton btSound;

    public HomeScreen() {
        CustomButton btPlay = new CustomButton(Textures.homePlay, 1, 0){

            protected void touchAction() {
                HomeScreen.this.openPlay();
            }
        };
        CustomButton btAbout = new CustomButton(Textures.homeAboutOff, Textures.homeAboutOff, null){

            protected void touchAction() {
                HomeScreen.this.openAbout();
            }
        };
        CustomButton btOptions = new CustomButton(Textures.homeOptionsOff, Textures.homeOptionsOff, null){

            protected void touchAction() {
                HomeScreen.this.openOptions();
            }
        };
        CustomButton btQuit = new CustomButton(Textures.homeQuitOff, Textures.homeQuitOff, null){

            protected void touchAction() {
                HomeScreen.this.openQuit();
            }
        };
        this.btSound = new CustomButton(Textures.homeSoundOff, Textures.homeSoundOff, null){

            protected void touchAction() {
                HomeScreen.this.switchSound();
            }
        };
        this.add(btPlay, 265, 238);
        this.add(btAbout, 5, 270);
        this.add(btOptions, 550, 270);
        this.add(this.btSound, 5, 5);
        this.add(btQuit, 575, 5);
    }

    public void onPaint(Graphics g) {
        Textures.mainMenuBackground.draw(g, 0, 0);
        super.onPaint(g);
    }

    public void onShow() {
        this.onVolumeChange();
        HomeScreen.repaint();
    }

    public void onVolumeChange() {
        if (DataManager.getCurrentEffectsLvl() == 0 && DataManager.getCurrentMusicLvl() == 0) {
            this.btSound.setOffImage(Textures.homeNoSoundOff);
            this.btSound.setOnImage(Textures.homeNoSoundOff);
        } else {
            this.btSound.setOffImage(Textures.homeSoundOff);
            this.btSound.setOnImage(Textures.homeSoundOff);
        }
    }

    private void switchSound() {
        DataManager.changeSoundState();
    }

    private void openPlay() {
        Application.setScreen(SelectScenarioScreen.getInstance());
    }

    private void openOptions() {
        Application.setScreen(OptionsScreen.getInstance());
    }

    private void openAbout() {
        Application.setScreen(AboutScreen.getInstance());
    }

    private void openQuit() {
        Application.setScreen(QuitScreen.getInstance());
    }

    public static HomeScreen getInstance() {
        if (instance == null) {
            instance = new HomeScreen();
        }
        return instance;
    }
}

