/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class game9
extends game {
    int drop = 0;
    int dropFruit;
    int explode;
    int bottomUpInterval;
    int bottomUpCounter;
    int denominator;
    int startHeight;
    int fruit;
    int maxFruitType;
    int x;
    int y;
    int kidDirection;
    int flyingFruit;
    int flyingFruitX;
    int flyingFruitY;
    int nextFruit;
    int sameFruitCounter;
    int[][] sameFruits;
    int CT;
    int CB;
    int CL;
    int CR;
    int CLDD;
    int CLDU;
    int CRDU;
    int CRDD;
    Image[] boyImg;
    Image[] fruitImg;
    Image[] burstImg;
    int qst1Fruit180 = 0;
    int qst2Combo100 = 0;
    int[] qst3AllKindFruits50;
    int totalFruits;
    int qst1StageFruit180 = 0;
    int qst2StageCombo100 = 0;
    int[] qst3StageAllKindFruits50;

    game9() {
        base.width = 9;
        base.height = 9;
        this.sameFruits = new int[3][50];
        this.qst3AllKindFruits50 = new int[11];
        this.qst3StageAllKindFruits50 = new int[11];
        for (base.col = 1; base.col <= 10; ++base.col) {
            this.qst3AllKindFruits50[base.col] = 0;
        }
        base.TheGame = 9;
        this.loadImage();
        this.loadGame(base.TheGame);
        this.setupStage(true);
    }

    public void loadImage() {
        this.boyImg = new Image[7];
        this.burstImg = new Image[4];
        this.fruitImg = new Image[21];
        this.comboImg = new Image[12];
        try {
            for (base.col = 0; base.col < 7; ++base.col) {
                this.boyImg[base.col] = Image.createImage((String)("/img/fruit/boy" + base.col + ".png"));
            }
            for (base.col = 1; base.col < 21; ++base.col) {
                this.fruitImg[base.col] = Image.createImage((String)("/img/fruit/fruit" + base.col + ".png"));
            }
            for (base.col = 0; base.col < 4; ++base.col) {
                this.burstImg[base.col] = Image.createImage((String)("/img/fruit/feff_" + base.col + ".png"));
            }
            for (base.col = 0; base.col < 12; ++base.col) {
                this.comboImg[base.col] = Image.createImage((String)("/img/effect/combo" + base.col + ".png"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setupStage(boolean reset) {
        this.loadStage50ClearImg();
        this.qst1StageFruit180 = 0;
        this.qst2StageCombo100 = 0;
        for (base.col = 1; base.col <= 10; ++base.col) {
            this.qst3StageAllKindFruits50[base.col] = 0;
        }
        base.counter = 0;
        this.drop = 0;
        this.dropFruit = 1;
        this.flyingFruitX = 4;
        this.kidDirection = 1;
        this.bottomUpInterval = (16 - this.gameStage / 4) * 10;
        if (this.bottomUpInterval < 60) {
            this.bottomUpInterval = 60;
        }
        this.bottomUpInterval = this.gameStage <= 5 ? 200 : (this.gameStage <= 12 ? 180 : (this.gameStage <= 19 ? 170 : (this.gameStage <= 26 ? 160 : (this.gameStage <= 33 ? 150 : (this.gameStage <= 40 ? 140 : 130)))));
        this.denominator = this.bottomUpInterval / 10;
        this.bottomUpCounter = 0;
        this.stageScore = 0;
        this.targetScore = (15 + (this.gameStage - 1)) * (4 + (this.gameStage - 1) / 4);
        this.remainTime = this.limitTime = (10 + this.targetScore / 3) * 10;
        this.maxFruitType = 3 + this.gameStage / 5;
        if (this.maxFruitType > 10) {
            this.maxFruitType = 10;
        }
        this.startHeight = this.gameStage <= 5 ? 3 : (this.gameStage <= 15 ? 4 : (this.gameStage <= 30 ? 5 : (this.gameStage <= 40 ? 6 : 7)));
        this.setStartLines(this.startHeight);
        this.flyingFruit = this.genNewFruit();
        this.nextFruit = this.genNewFruit();
    }

    private void setStartLines(int line) {
        for (base.row = 0; base.row < base.height - line; ++base.row) {
            for (base.col = 0; base.col < base.width; ++base.col) {
                this.arena[base.row][base.col] = 0;
            }
        }
        this.arena[base.height - line][0] = this.genNewFruit();
        this.arena[base.height - line][1] = this.genNewFruit();
        this.arena[base.height - line + 1][0] = this.genNewFruit();
        this.arena[base.height - line + 1][1] = this.genNewFruit();
        for (int gi = 2; gi < base.width; ++gi) {
            int loop;
            this.arena[base.height - line][gi] = this.genNewFruit();
            for (loop = 0; loop < 10 && gi - this.check2Left(gi, base.height - line) > 1; ++loop) {
                this.arena[base.height - line][gi] = this.genNewFruit();
            }
            this.arena[base.height - line + 1][gi] = this.genNewFruit();
            for (loop = 0; loop < 10 && gi - this.check2Left(gi, base.height - line + 1) > 1; ++loop) {
                this.arena[base.height - line + 1][gi] = this.genNewFruit();
            }
        }
        for (base.row = base.height - line + 2; base.row < base.height; ++base.row) {
            this.genNewLine(base.row);
        }
    }

    private void genNewLine(int high) {
        int loop;
        this.arena[high][0] = this.genNewFruit();
        this.CT = this.check2Top(0, high);
        this.CRDU = this.check2RightDiagonal(0, high, true);
        for (loop = 0; loop < 10 && (high - this.CT > 1 || this.CRDU > 1); ++loop) {
            this.arena[high][0] = this.genNewFruit();
            this.CT = this.check2Top(0, high);
            this.CRDU = this.check2RightDiagonal(0, high, true);
        }
        this.arena[high][1] = this.genNewFruit();
        this.CT = this.check2Top(1, high);
        this.CRDU = this.check2RightDiagonal(1, high, true);
        for (loop = 0; loop < 10 && (high - this.CT > 1 || this.CRDU - 1 > 1); ++loop) {
            this.arena[high][1] = this.genNewFruit();
            this.CT = this.check2Top(1, high);
            this.CRDU = this.check2RightDiagonal(1, high, true);
        }
        for (base.col = 2; base.col < base.width; ++base.col) {
            this.arena[high][base.col] = this.genNewFruit();
            this.CL = this.check2Left(base.col, high);
            this.CT = this.check2Top(base.col, high);
            this.CLDU = this.check2LeftDiagonal(base.col, high, true);
            this.CRDU = this.check2RightDiagonal(base.col, high, true);
            for (loop = 0; loop < 10 && (high - this.CT > 1 || base.col - this.CL > 1 || base.col - this.CLDU > 1 || this.CRDU - base.col > 1); ++loop) {
                this.arena[high][base.col] = this.genNewFruit();
                this.CL = this.check2Left(base.col, high);
                this.CT = this.check2Top(base.col, high);
                this.CLDU = this.check2LeftDiagonal(base.col, high, true);
                this.CRDU = this.check2RightDiagonal(base.col, high, true);
            }
        }
    }

    private int genNewFruit() {
        this.flyingFruitY = 0;
        return base.Random(1, this.maxFruitType);
    }

    private boolean checkSameFruitAll() {
        int tpl;
        boolean burst = false;
        for (base.row = tpl = this.getTopLine(); base.row < base.height; ++base.row) {
            for (base.col = 0; base.col < base.width; ++base.col) {
                if (this.arena[base.row][base.col] <= 0 || !this.checkSameFruits(base.col, base.row)) continue;
                burst = true;
            }
        }
        return burst;
    }

    private boolean checkSameFruits(int sx, int sy) {
        boolean burst = false;
        this.CL = this.check2Left(sx, sy);
        this.CR = this.check2Right(sx, sy);
        if (sx - this.CL + (this.CR - sx) >= 2) {
            burst = true;
            this.addSameFruits(this.CL, sy, this.CR, sy, 0);
        }
        this.CB = this.check2Bottom(sx, sy);
        if (this.CB - sy > 1) {
            burst = true;
            this.addSameFruits(sx, sy, sx, this.CB, 1);
        }
        this.CLDD = this.check2LeftDiagonal(sx, sy, false);
        this.CRDU = this.check2RightDiagonal(sx, sy, true);
        if (sx - this.CLDD + (this.CRDU - sx) >= 2) {
            burst = true;
            this.addSameFruits(this.CLDD, sy + (sx - this.CLDD), this.CRDU, sy - (this.CRDU - sx), 2);
        }
        this.CLDU = this.check2LeftDiagonal(sx, sy, true);
        this.CRDD = this.check2RightDiagonal(sx, sy, false);
        if (sx - this.CLDU + (this.CRDD - sx) >= 2) {
            burst = true;
            this.addSameFruits(this.CLDU, sy - (sx - this.CLDU), this.CRDD, sy + (this.CRDD - sx), 3);
        }
        return burst;
    }

    private int check2Left(int sx, int sy) {
        int index = 1;
        while (sx - index >= 0 && this.arena[sy][sx - index] == this.arena[sy][sx]) {
            ++index;
        }
        return sx - index + 1;
    }

    private int check2LeftDiagonal(int sx, int sy, boolean up) {
        int index = 1;
        if (up) {
            while (sx - index >= 0 && sy - index >= 0 && this.arena[sy - index][sx - index] == this.arena[sy][sx]) {
                ++index;
            }
        } else {
            while (sx - index >= 0 && sy + index < base.height && this.arena[sy + index][sx - index] == this.arena[sy][sx]) {
                ++index;
            }
        }
        return sx - index + 1;
    }

    private int check2Right(int sx, int sy) {
        int index = 1;
        while (sx + index < base.width && this.arena[sy][sx + index] == this.arena[sy][sx]) {
            ++index;
        }
        return sx + index - 1;
    }

    private int check2RightDiagonal(int sx, int sy, boolean up) {
        int index = 1;
        if (up) {
            while (sx + index < base.width && sy - index >= 0 && this.arena[sy - index][sx + index] == this.arena[sy][sx]) {
                ++index;
            }
        } else {
            while (sx + index < base.width && sy + index < base.height && this.arena[sy + index][sx + index] == this.arena[sy][sx]) {
                ++index;
            }
        }
        return sx + index - 1;
    }

    private int check2Top(int sx, int sy) {
        int index = 1;
        while (sy - index >= 0 && this.arena[sy - index][sx] > 0 && this.arena[sy - index][sx] == this.arena[sy][sx]) {
            ++index;
        }
        return sy - index + 1;
    }

    private int check2Bottom(int sx, int sy) {
        int index = 1;
        while (sy + index < base.height && this.arena[sy + index][sx] == this.arena[sy][sx]) {
            ++index;
        }
        return sy + index - 1;
    }

    private void addSameFruits(int sx, int sy, int ex, int ey, int dir) {
        switch (dir) {
            case 0: {
                for (int idx = sx; idx <= ex; ++idx) {
                    if (!this.noDuplicateSameFruits(idx, sy)) continue;
                    this.sameFruits[0][this.sameFruitCounter] = idx;
                    this.sameFruits[1][this.sameFruitCounter] = sy;
                    this.sameFruits[2][this.sameFruitCounter] = this.arena[sy][idx];
                    ++this.sameFruitCounter;
                }
                break;
            }
            case 1: {
                for (int idx = sy; idx <= ey; ++idx) {
                    if (!this.noDuplicateSameFruits(sx, idx)) continue;
                    this.sameFruits[0][this.sameFruitCounter] = sx;
                    this.sameFruits[1][this.sameFruitCounter] = idx;
                    this.sameFruits[2][this.sameFruitCounter] = this.arena[idx][sx];
                    ++this.sameFruitCounter;
                }
                break;
            }
            case 2: {
                int step = 0;
                for (int idx = sx; idx <= ex; ++idx) {
                    if (this.noDuplicateSameFruits(idx, sy + step)) {
                        this.sameFruits[0][this.sameFruitCounter] = idx;
                        this.sameFruits[1][this.sameFruitCounter] = sy + step;
                        this.sameFruits[2][this.sameFruitCounter] = this.arena[sy + step][idx];
                        ++this.sameFruitCounter;
                    }
                    --step;
                }
                break;
            }
            case 3: {
                int step = 0;
                for (int idx = sx; idx <= ex; ++idx) {
                    if (this.noDuplicateSameFruits(idx, sy + step)) {
                        this.sameFruits[0][this.sameFruitCounter] = idx;
                        this.sameFruits[1][this.sameFruitCounter] = sy + step;
                        this.sameFruits[2][this.sameFruitCounter] = this.arena[sy + step][idx];
                        ++this.sameFruitCounter;
                    }
                    ++step;
                }
                break;
            }
        }
    }

    private boolean noDuplicateSameFruits(int dx, int dy) {
        for (int dup = 0; dup < this.sameFruitCounter; ++dup) {
            if (this.sameFruits[0][dup] != dx || this.sameFruits[1][dup] != dy) continue;
            return false;
        }
        return true;
    }

    private void clearArenaSameFruits() {
        for (int idx = 0; idx < this.sameFruitCounter; ++idx) {
            int x = this.sameFruits[0][idx];
            int y = this.sameFruits[1][idx];
            this.arena[y][x] = 0;
        }
    }

    private boolean existSpace() {
        boolean empty = false;
        for (int sx = 0; sx < base.width; ++sx) {
            if (!this.checkVerticalEmptyBlock(sx)) continue;
            empty = true;
            this.downFill(sx);
        }
        return empty;
    }

    private boolean checkVerticalEmptyBlock(int cx) {
        int sy;
        boolean colNoSpace = true;
        int topRow = 0;
        int bottomRow = 11;
        for (sy = 0; sy < base.height; ++sy) {
            if (this.arena[sy][cx] <= 0) continue;
            topRow = sy;
            break;
        }
        if (sy == base.height) {
            colNoSpace = false;
        }
        if (colNoSpace && (bottomRow = base.height - 1) > topRow) {
            for (sy = topRow + 1; sy <= bottomRow; ++sy) {
                if (this.arena[sy][cx] != 0) continue;
                return true;
            }
        }
        return false;
    }

    private void downFill(int ex) {
        int ey;
        int emptyRow = 0;
        for (ey = base.height - 1; ey > 0; --ey) {
            if (this.arena[ey][ex] != 0) continue;
            emptyRow = ey;
            break;
        }
        for (ey = emptyRow - 1; ey >= 0; --ey) {
            this.arena[ey + 1][ex] = this.arena[ey][ex];
        }
        this.arena[0][ex] = 0;
    }

    private void downFruits() {
        if (this.drop == 1) {
            if (this.flyingFruitY < base.height - 1 && this.arena[this.flyingFruitY + 1][this.flyingFruitX] == 0) {
                ++this.flyingFruitY;
            } else if (this.flyingFruitY == -1) {
                this.playSound("/sound/fail");
                base.playState = 69;
            } else {
                switch (this.dropFruit) {
                    case 1: {
                        this.arena[this.flyingFruitY][this.flyingFruitX] = this.flyingFruit;
                        this.sameFruitCounter = 0;
                        if (this.checkSameFruits(this.flyingFruitX, this.flyingFruitY)) {
                            this.clearArenaSameFruits();
                            this.combo = 1;
                            this.checkFruitsMission1();
                            this.checkFruitsMission3();
                            this.bottomUpCounter -= this.bottomUpInterval / 5;
                            if (this.bottomUpCounter < 0) {
                                this.bottomUpCounter = 0;
                            }
                            this.playSound("/sound/disappear");
                            this.explode = 0;
                            this.drop = 2;
                            break;
                        }
                        this.flyingFruit = this.nextFruit;
                        this.nextFruit = this.genNewFruit();
                        this.drop = 0;
                        break;
                    }
                    case 2: {
                        this.doItemHori(this.flyingFruitX, this.flyingFruitY);
                        break;
                    }
                    case 3: {
                        this.doItemVert(this.flyingFruitX, this.flyingFruitY);
                        break;
                    }
                    case 4: {
                        this.sameBurst(this.flyingFruitX, this.flyingFruitY);
                        break;
                    }
                    case 5: {
                        this.bombBurst(this.flyingFruitX, this.flyingFruitY);
                    }
                }
                this.dropFruit = 1;
            }
        }
    }

    private int getTopLine() {
        for (base.row = 0; base.row < base.height; ++base.row) {
            for (base.col = 0; base.col < base.width; ++base.col) {
                if (this.arena[base.row][base.col] == 0) continue;
                return base.row;
            }
        }
        return base.height;
    }

    private int getTopPosition(int tpx) {
        for (base.row = 0; base.row < base.height; ++base.row) {
            if (this.arena[base.row][tpx] == 0) continue;
            return base.row;
        }
        return base.height;
    }

    private void moveBottomUp() {
        int x;
        for (x = 0; x < base.width; ++x) {
            if (this.arena[0][x] <= 0) continue;
            this.playSound("/sound/fail");
            base.playState = 69;
            return;
        }
        this.playSound("/sound/appear02");
        int top = this.getTopLine();
        for (int y = top - 1; y < base.height - 1; ++y) {
            for (x = 0; x < base.width; ++x) {
                this.arena[y][x] = this.arena[y + 1][x];
            }
        }
        this.genNewLine(base.height - 1);
    }

    void processKeyEvent(int key) {
        switch (base.playState) {
            case 60: {
                this.playHelpKeyProcess(key, base.TheGame);
                break;
            }
            case 61: {
                this.processPreMissionKeyEvent(key);
                break;
            }
            case 62: {
                this.processReadyKeyEvent(key);
                break;
            }
            case 64: {
                if (this.drop != 0) break;
                if (key == -3 || key == 52) {
                    if (this.flyingFruitX > 0) {
                        this.kidDirection = 1;
                        --this.flyingFruitX;
                    } else {
                        this.kidDirection = 2;
                        this.flyingFruitX = base.width - 1;
                    }
                    this.playSound("/sound/cmove");
                }
                if (key == -4 || key == 54) {
                    if (this.flyingFruitX < base.width - 1) {
                        this.kidDirection = 2;
                        ++this.flyingFruitX;
                    } else {
                        this.kidDirection = 1;
                        this.flyingFruitX = 0;
                    }
                    this.playSound("/sound/cmove");
                }
                if (key == -2 || key == 56) {
                    this.playSound("/sound/throw01");
                    this.flyingFruitY = this.getTopPosition(this.flyingFruitX);
                    if (this.flyingFruitY == 0) {
                        this.playSound("/sound/fail");
                        base.playState = 69;
                    } else {
                        switch (this.dropFruit) {
                            case 1: {
                                this.arena[this.flyingFruitY - 1][this.flyingFruitX] = this.flyingFruit;
                                this.sameFruitCounter = 0;
                                if (this.checkSameFruits(this.flyingFruitX, this.flyingFruitY - 1)) {
                                    this.clearArenaSameFruits();
                                    this.bottomUpCounter -= this.bottomUpInterval / 5;
                                    if (this.bottomUpCounter < 0) {
                                        this.bottomUpCounter = 0;
                                    }
                                    this.combo = 1;
                                    this.playSound("/sound/disappear");
                                    this.explode = 0;
                                    this.drop = 2;
                                    break;
                                }
                                this.flyingFruit = this.nextFruit;
                                this.nextFruit = this.genNewFruit();
                                this.drop = 0;
                                break;
                            }
                            case 2: {
                                this.arena[this.flyingFruitY - 1][this.flyingFruitX] = 12;
                                this.doItemHori(this.flyingFruitX, this.flyingFruitY - 1);
                                this.drop = 2;
                                break;
                            }
                            case 3: {
                                this.arena[this.flyingFruitY - 1][this.flyingFruitX] = 13;
                                this.doItemVert(this.flyingFruitX, this.flyingFruitY - 1);
                                this.drop = 2;
                                break;
                            }
                            case 4: {
                                this.arena[this.flyingFruitY - 1][this.flyingFruitX] = 14;
                                this.sameBurst(this.flyingFruitX, this.flyingFruitY - 1);
                                this.drop = 2;
                                break;
                            }
                            case 5: {
                                this.arena[this.flyingFruitY - 1][this.flyingFruitX] = 15;
                                this.bombBurst(this.flyingFruitX, this.flyingFruitY - 1);
                                this.drop = 2;
                            }
                        }
                        this.dropFruit = 1;
                    }
                }
                if (key == -5 || key == 53) {
                    this.flyingFruitY = -1;
                    this.drop = 1;
                    this.playSound("/sound/throw01");
                }
                if (key == -6) {
                    this.playSound("/sound/popup");
                    this.selectSubMenu = 1;
                    base.playState = 80;
                }
                if (key == 42) {
                    if (this.dropFruit == 1) {
                        this.playSound("/sound/popup");
                        base.selectedItem = 1;
                        base.playState = 67;
                    } else {
                        this.playSound("/sound/swrong");
                    }
                }
                if (key != 35) break;
                this.playSound("/sound/popup");
                base.counter = 0;
                this.readQuestExplanation(base.TheGame, 6);
                this.totalFruits = 0;
                for (base.col = 1; base.col <= 10; ++base.col) {
                    if (this.qst3AllKindFruits50[base.col] + this.qst3StageAllKindFruits50[base.col] >= 50) {
                        this.totalFruits += 50;
                        continue;
                    }
                    this.totalFruits += this.qst3AllKindFruits50[base.col] + this.qst3StageAllKindFruits50[base.col];
                }
                base.playState = 65;
                break;
            }
            case 65: {
                this.processMissionKeyEvent(key);
                break;
            }
            case 67: {
                if (!(key != -5 && key != 53 || this.usingItem)) {
                    switch (base.selectedItem) {
                        case 5: {
                            if (!this.usableItems[5] || common.ITEMS[4] <= 0) break;
                            this.dropFruit = 2;
                            break;
                        }
                        case 6: {
                            if (!this.usableItems[6] || common.ITEMS[5] <= 0) break;
                            this.dropFruit = 3;
                            break;
                        }
                        case 7: {
                            if (!this.usableItems[7] || common.ITEMS[6] <= 0) break;
                            this.dropFruit = 4;
                            break;
                        }
                        case 8: {
                            if (!this.usableItems[8] || common.ITEMS[7] <= 0) break;
                            this.dropFruit = 5;
                        }
                    }
                }
                this.itemKeyProcess(key);
                break;
            }
            case 68: {
                this.workCheatKey(key);
                if (base.counter > 10 && (key == -5 || key == 53)) {
                    this.qst1Fruit180 += this.qst1StageFruit180;
                    this.qst2Combo100 += this.qst2StageCombo100;
                    for (base.col = 1; base.col <= 10; ++base.col) {
                        int n = base.col;
                        this.qst3AllKindFruits50[n] = this.qst3AllKindFruits50[n] + this.qst3StageAllKindFruits50[base.col];
                    }
                }
                this.processClearKeyEvent(key);
                break;
            }
            case 71: {
                this.processStage50ClearKeyEvent(key);
                break;
            }
            case 69: {
                this.workCheatKey(key);
                if (key == -5 || key == 53) {
                    if (base.menuDepth == 1) {
                        if (base.yesNo == 1) {
                            if (common.ITEMS[13] < 5) {
                                base.menuDepth = 2;
                            }
                        } else {
                            this.qst1Fruit180 = 0;
                            this.qst2Combo100 = 0;
                            for (base.col = 1; base.col <= 10; ++base.col) {
                                this.qst3AllKindFruits50[base.col] = 0;
                            }
                        }
                    } else {
                        this.qst1Fruit180 = 0;
                        this.qst2Combo100 = 0;
                        for (base.col = 1; base.col <= 10; ++base.col) {
                            this.qst3AllKindFruits50[base.col] = 0;
                        }
                    }
                }
                this.processFailKeyEvent(key);
                break;
            }
            case 70: {
                this.processResultKeyEvent(key);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                this.processSubMenuKeyEvent(key, base.TheGame);
                break;
            }
            case 100: {
                this.processSubMenuKeyEvent_111(key, base.TheGame);
            }
        }
    }

    public void workItem5HRemove() {
        if (this.usableItems[5] && this.itemTimers[5] == 0) {
            this.usingItem = true;
            common.ITEMS[4] = common.ITEMS[4] - 1;
            base.cmn.saveItemData();
            this.itemTimers[5] = 1000;
            base.playState = 64;
        }
    }

    public void workItem6VRemove() {
        if (this.usableItems[6] && this.itemTimers[6] == 0) {
            common.ITEMS[5] = common.ITEMS[5] - 1;
            base.cmn.saveItemData();
            this.itemTimers[6] = 1000;
            base.playState = 64;
        }
    }

    public void workItem7SRemove() {
        if (this.usableItems[7] && this.itemTimers[7] == 0) {
            common.ITEMS[6] = common.ITEMS[6] - 1;
            base.cmn.saveItemData();
            this.itemTimers[7] = 1000;
            base.playState = 64;
        }
    }

    public void workItem8Bomb() {
        if (this.usableItems[8] && this.itemTimers[8] == 0) {
            common.ITEMS[7] = common.ITEMS[7] - 1;
            base.cmn.saveItemData();
            this.itemTimers[8] = 1000;
            base.playState = 64;
        }
    }

    private void doItemHori(int ix, int iy) {
        this.sameFruitCounter = 0;
        for (int idx = 0; idx < base.width; ++idx) {
            if (this.arena[iy][idx] < 1 || this.arena[iy][idx] > 10) continue;
            this.sameFruits[0][this.sameFruitCounter] = idx;
            this.sameFruits[1][this.sameFruitCounter] = iy;
            this.sameFruits[2][this.sameFruitCounter] = this.arena[iy][idx];
            ++this.sameFruitCounter;
        }
        if (this.sameFruitCounter > 0) {
            this.checkFruitsMission1();
            this.checkFruitsMission3();
            this.clearArenaSameFruits();
            this.combo = 1;
            this.explode = 0;
            this.drop = 2;
        } else {
            this.drop = 0;
        }
        this.usingItem = false;
        this.itemTimers[5] = 0;
        this.playSound("/sound/disappear");
    }

    private void doItemVert(int ix, int iy) {
        this.sameFruitCounter = 0;
        for (int idy = 0; idy < base.height; ++idy) {
            if (this.arena[idy][ix] < 1 || this.arena[idy][ix] > 10) continue;
            this.sameFruits[0][this.sameFruitCounter] = ix;
            this.sameFruits[1][this.sameFruitCounter] = idy;
            this.sameFruits[2][this.sameFruitCounter] = this.arena[idy][ix];
            ++this.sameFruitCounter;
        }
        if (this.sameFruitCounter > 0) {
            this.checkFruitsMission1();
            this.checkFruitsMission3();
            this.clearArenaSameFruits();
            this.combo = 1;
            this.explode = 0;
            this.drop = 2;
        } else {
            this.drop = 0;
        }
        this.usingItem = false;
        this.itemTimers[6] = 0;
        this.playSound("/sound/disappear");
    }

    private void sameBurst(int sx, int sy) {
        if (sy < 8) {
            int target = this.arena[sy + 1][sx];
            this.sameFruitCounter = 0;
            for (base.row = 0; base.row < base.height; ++base.row) {
                for (base.col = 0; base.col < base.width; ++base.col) {
                    if (this.arena[base.row][base.col] != target) continue;
                    this.sameFruits[0][this.sameFruitCounter] = base.col;
                    this.sameFruits[1][this.sameFruitCounter] = base.row;
                    this.sameFruits[2][this.sameFruitCounter] = this.arena[base.row][base.col];
                    ++this.sameFruitCounter;
                }
            }
            if (this.sameFruitCounter > 0) {
                this.checkFruitsMission1();
                this.checkFruitsMission3();
                this.clearArenaSameFruits();
                this.combo = 1;
                this.explode = 0;
                this.drop = 2;
            } else {
                this.drop = 0;
            }
            this.usingItem = false;
            this.itemTimers[7] = 0;
            this.playSound("/sound/disappear");
        } else {
            this.playSound("/sound/disappear");
            this.drop = 0;
        }
    }

    private void bombBurst(int bx, int by) {
        int endY;
        int endX;
        int startY;
        int startX = bx - 1;
        if (startX < 0) {
            startX = 0;
        }
        if ((startY = by - 1) < 0) {
            startY = 0;
        }
        if ((endX = bx + 1) >= base.width) {
            endX = base.width - 1;
        }
        if ((endY = by + 1) >= base.height) {
            endY = base.height - 1;
        }
        this.sameFruitCounter = 0;
        for (base.row = startY; base.row <= endY; ++base.row) {
            for (base.col = startX; base.col <= endX; ++base.col) {
                if (this.arena[base.row][base.col] < 1 || this.arena[base.row][base.col] > 10) continue;
                this.sameFruits[0][this.sameFruitCounter] = base.col;
                this.sameFruits[1][this.sameFruitCounter] = base.row;
                this.sameFruits[2][this.sameFruitCounter] = this.arena[base.row][base.col];
                ++this.sameFruitCounter;
            }
        }
        if (this.sameFruitCounter > 0) {
            this.checkFruitsMission1();
            this.checkFruitsMission3();
            this.clearArenaSameFruits();
            this.combo = 1;
            this.explode = 0;
            this.drop = 2;
        } else {
            this.drop = 0;
        }
        this.usingItem = false;
        this.itemTimers[8] = 0;
        this.playSound("/sound/disappear");
    }

    private void checkFruitsMission1() {
        if (!base.cmn.checkMission(base.TheGame, 1)) {
            this.qst1StageFruit180 += this.sameFruitCounter;
            if (this.qst1Fruit180 + this.qst1StageFruit180 >= 180) {
                this.completedMission = 1;
                base.cmn.setMission(base.TheGame, 1);
                common.ITEMS[13] = common.ITEMS[13] + 200;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
    }

    private void checkFruitsMission2() {
        if (!base.cmn.checkMission(base.TheGame, 2) && this.combo >= 2) {
            ++this.qst2StageCombo100;
            if (this.qst2Combo100 + this.qst2StageCombo100 >= 100) {
                this.completedMission = 2;
                base.cmn.setMission(base.TheGame, 2);
                common.ITEMS[13] = common.ITEMS[13] + 300;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
    }

    private void checkFruitsMission3() {
        boolean allKind500 = true;
        if (!base.cmn.checkMission(base.TheGame, 3)) {
            for (int sb = 0; sb < this.sameFruitCounter; ++sb) {
                if (this.sameFruits[2][sb] < 1 || this.sameFruits[2][sb] > 10) continue;
                int n = this.sameFruits[2][sb];
                this.qst3StageAllKindFruits50[n] = this.qst3StageAllKindFruits50[n] + 1;
            }
            for (int akb = 1; akb <= 10; ++akb) {
                if (this.qst3AllKindFruits50[akb] + this.qst3StageAllKindFruits50[akb] >= 50) continue;
                allKind500 = false;
                break;
            }
            if (allKind500) {
                this.completedMission = 3;
                base.cmn.setMission(base.TheGame, 3);
                common.ITEMS[13] = common.ITEMS[13] + 500;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
    }

    public void playGame() {
        ++base.counter;
        if (base.playState == 64) {
            if (this.itemTimers[2] == 0) {
                if (this.drop == 0 && this.bottomUpCounter >= this.bottomUpInterval) {
                    this.moveBottomUp();
                    this.bottomUpCounter = 0;
                } else {
                    ++this.bottomUpCounter;
                }
                --this.remainTime;
                if (this.remainTime <= 0) {
                    this.playSound("/sound/fail");
                    base.playState = 69;
                }
            }
            switch (this.drop) {
                case 1: {
                    this.downFruits();
                    break;
                }
                case 3: {
                    if (this.existSpace()) break;
                    this.sameFruitCounter = 0;
                    if (this.checkSameFruitAll()) {
                        this.clearArenaSameFruits();
                        this.checkFruitsMission1();
                        this.checkFruitsMission3();
                        ++this.combo;
                        this.comboIndex = 4;
                        this.explode = 0;
                        this.drop = 2;
                        this.playSound("/sound/disappear");
                        break;
                    }
                    if (this.combo == 2) {
                        this.bottomUpCounter -= this.bottomUpInterval / 6;
                        if (this.bottomUpCounter < 0) {
                            this.bottomUpCounter = 0;
                        }
                    } else if (this.combo == 3) {
                        this.bottomUpCounter -= this.bottomUpInterval / 3;
                        if (this.bottomUpCounter < 0) {
                            this.bottomUpCounter = 0;
                        }
                    } else if (this.combo >= 4) {
                        this.bottomUpCounter = 0;
                    }
                    if (this.combo >= 2) {
                        this.checkFruitsMission2();
                    }
                    this.flyingFruit = this.nextFruit;
                    this.nextFruit = this.genNewFruit();
                    this.drop = 0;
                }
            }
        }
    }

    public void drawGame() {
        this.drawBg();
        this.drawGameUITime(this.stageScore, this.targetScore);
        this.drawDownUI();
        switch (base.playState) {
            case 60: {
                this.drawGameHelp(base.TheGame);
                break;
            }
            case 61: {
                this.drawPreMission(base.TheGame);
                break;
            }
            case 62: {
                this.drawPlaying();
                this.processReady();
                break;
            }
            case 64: {
                this.drawPlaying();
                this.drawUsingItem();
                break;
            }
            case 67: {
                this.drawPlaying();
                this.drawItemWindow();
                break;
            }
            case 65: {
                this.drawMission(base.TheGame, 180, this.qst1Fruit180, 100, this.qst2Combo100, 500, this.totalFruits);
                break;
            }
            case 66: {
                this.drawPlaying();
                this.drawMissionComplete();
                break;
            }
            case 68: {
                this.drawPlaying();
                this.drawClear();
                break;
            }
            case 71: {
                this.drawPlaying();
                this.drawStage50Clear();
                break;
            }
            case 69: {
                this.drawPlaying();
                this.drawFail();
                break;
            }
            case 70: {
                this.drawResult(base.TheGame, this.totalScore);
                break;
            }
            case 80: 
            case 84: {
                this.drawSubMenu(base.TheGame, this.selectSubMenu);
                break;
            }
            case 100: {
                this.drawSub_111();
                break;
            }
            case 81: {
                this.drawGameRetry(base.TheGame);
                break;
            }
            case 82: {
                this.drawGameOption(base.TheGame);
                break;
            }
            case 83: {
                this.drawGameHelp(base.TheGame);
            }
        }
    }

    private void drawPlaying() {
        for (base.col = 0; base.col < 5; ++base.col) {
            base.offScreen.drawImage(this.boyImg[0], 23 + base.col * 39, 71, 0);
        }
        for (base.row = 0; base.row < base.height; ++base.row) {
            for (base.col = 0; base.col < base.width; ++base.col) {
                this.fruit = this.arena[base.row][base.col];
                if (this.fruit >= 1 && this.fruit <= 10) {
                    base.offScreen.drawImage(this.fruitImg[this.fruit], 26 + base.col * 21, base.gLcdHeight - 29 - (base.height - base.row) * 21, 0);
                    continue;
                }
                if (this.fruit < 12) continue;
                switch (this.fruit) {
                    case 12: {
                        base.offScreen.drawImage(this.itemImg[4], 26 + base.col * 21, base.gLcdHeight - 29 - (base.height - base.row) * 21, 0);
                        break;
                    }
                    case 13: {
                        base.offScreen.drawImage(this.itemImg[5], 26 + base.col * 21, base.gLcdHeight - 29 - (base.height - base.row) * 21, 0);
                        break;
                    }
                    case 14: {
                        base.offScreen.drawImage(this.itemImg[6], 26 + base.col * 21, base.gLcdHeight - 29 - (base.height - base.row) * 21, 0);
                        break;
                    }
                    case 15: {
                        base.offScreen.drawImage(this.itemImg[7], 26 + base.col * 21, base.gLcdHeight - 29 - (base.height - base.row) * 21, 0);
                    }
                }
                this.arena[base.row][base.col] = 0;
            }
        }
        if (this.kidDirection == 1) {
            if (base.playState == 64 && base.counter % 6 < 3) {
                if (this.drop == 0) {
                    switch (this.dropFruit) {
                        case 1: {
                            base.offScreen.drawImage(this.fruitImg[this.flyingFruit], 26 + this.flyingFruitX * 21, 48, 0);
                            break;
                        }
                        case 2: {
                            base.offScreen.drawImage(this.itemImg[4], 26 + this.flyingFruitX * 21, 48, 0);
                            break;
                        }
                        case 3: {
                            base.offScreen.drawImage(this.itemImg[5], 26 + this.flyingFruitX * 21, 48, 0);
                            break;
                        }
                        case 4: {
                            base.offScreen.drawImage(this.itemImg[6], 26 + this.flyingFruitX * 21, 48, 0);
                            break;
                        }
                        case 5: {
                            base.offScreen.drawImage(this.itemImg[7], 26 + this.flyingFruitX * 21, 48, 0);
                        }
                    }
                }
                base.offScreen.drawImage(this.boyImg[2], 26 + this.flyingFruitX * 21 + 16, 45, 0);
                base.offScreen.drawImage(this.fruitImg[10 + this.nextFruit], 26 + this.flyingFruitX * 21 + 35, 49, 0);
            } else {
                if (this.drop == 0) {
                    switch (this.dropFruit) {
                        case 1: {
                            base.offScreen.drawImage(this.fruitImg[this.flyingFruit], 26 + this.flyingFruitX * 21, 47, 0);
                            break;
                        }
                        case 2: {
                            base.offScreen.drawImage(this.itemImg[4], 26 + this.flyingFruitX * 21, 47, 0);
                            break;
                        }
                        case 3: {
                            base.offScreen.drawImage(this.itemImg[5], 26 + this.flyingFruitX * 21, 47, 0);
                            break;
                        }
                        case 4: {
                            base.offScreen.drawImage(this.itemImg[6], 26 + this.flyingFruitX * 21, 47, 0);
                            break;
                        }
                        case 5: {
                            base.offScreen.drawImage(this.itemImg[7], 26 + this.flyingFruitX * 21, 47, 0);
                        }
                    }
                }
                base.offScreen.drawImage(this.boyImg[1], 26 + this.flyingFruitX * 21 + 16, 44, 0);
                base.offScreen.drawImage(this.fruitImg[10 + this.nextFruit], 26 + this.flyingFruitX * 21 + 35, 48, 0);
            }
        } else if (base.playState == 64 && base.counter % 6 < 3) {
            if (this.drop == 0) {
                switch (this.dropFruit) {
                    case 1: {
                        base.offScreen.drawImage(this.fruitImg[this.flyingFruit], 26 + this.flyingFruitX * 21, 48, 0);
                        break;
                    }
                    case 2: {
                        base.offScreen.drawImage(this.itemImg[4], 26 + this.flyingFruitX * 21, 48, 0);
                        break;
                    }
                    case 3: {
                        base.offScreen.drawImage(this.itemImg[5], 26 + this.flyingFruitX * 21, 48, 0);
                        break;
                    }
                    case 4: {
                        base.offScreen.drawImage(this.itemImg[6], 26 + this.flyingFruitX * 21, 48, 0);
                        break;
                    }
                    case 5: {
                        base.offScreen.drawImage(this.itemImg[7], 26 + this.flyingFruitX * 21, 48, 0);
                    }
                }
            }
            base.offScreen.drawImage(this.boyImg[4], 26 + this.flyingFruitX * 21 - 29, 45, 0);
            base.offScreen.drawImage(this.fruitImg[10 + this.nextFruit], 26 + this.flyingFruitX * 21 - 25, 49, 0);
        } else {
            if (this.drop == 0) {
                switch (this.dropFruit) {
                    case 1: {
                        base.offScreen.drawImage(this.fruitImg[this.flyingFruit], 26 + this.flyingFruitX * 21, 47, 0);
                        break;
                    }
                    case 2: {
                        base.offScreen.drawImage(this.itemImg[4], 26 + this.flyingFruitX * 21, 47, 0);
                        break;
                    }
                    case 3: {
                        base.offScreen.drawImage(this.itemImg[5], 26 + this.flyingFruitX * 21, 47, 0);
                        break;
                    }
                    case 4: {
                        base.offScreen.drawImage(this.itemImg[6], 26 + this.flyingFruitX * 21, 47, 0);
                        break;
                    }
                    case 5: {
                        base.offScreen.drawImage(this.itemImg[7], 26 + this.flyingFruitX * 21, 47, 0);
                    }
                }
            }
            base.offScreen.drawImage(this.boyImg[3], 26 + this.flyingFruitX * 21 - 29, 44, 0);
            base.offScreen.drawImage(this.fruitImg[10 + this.nextFruit], 26 + this.flyingFruitX * 21 - 25, 48, 0);
        }
        if (this.drop == 1) {
            if (this.flyingFruitY == -1) {
                switch (this.dropFruit) {
                    case 1: {
                        base.offScreen.drawImage(this.fruitImg[this.flyingFruit], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height + 1) * 21 - 20, 0);
                        break;
                    }
                    case 2: {
                        base.offScreen.drawImage(this.itemImg[4], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height + 1) * 21 - 20, 0);
                        break;
                    }
                    case 3: {
                        base.offScreen.drawImage(this.itemImg[5], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height + 1) * 21 - 20, 0);
                        break;
                    }
                    case 4: {
                        base.offScreen.drawImage(this.itemImg[6], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height + 1) * 21 - 20, 0);
                        break;
                    }
                    case 5: {
                        base.offScreen.drawImage(this.itemImg[7], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height + 1) * 21 - 20, 0);
                    }
                }
            } else {
                switch (this.dropFruit) {
                    case 1: {
                        base.offScreen.drawImage(this.fruitImg[this.flyingFruit], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height - this.flyingFruitY) * 21, 0);
                        break;
                    }
                    case 2: {
                        base.offScreen.drawImage(this.itemImg[4], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height - this.flyingFruitY) * 21, 0);
                        break;
                    }
                    case 3: {
                        base.offScreen.drawImage(this.itemImg[5], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height - this.flyingFruitY) * 21, 0);
                        break;
                    }
                    case 4: {
                        base.offScreen.drawImage(this.itemImg[6], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height - this.flyingFruitY) * 21, 0);
                        break;
                    }
                    case 5: {
                        base.offScreen.drawImage(this.itemImg[7], 26 + this.flyingFruitX * 21, base.gLcdHeight - 28 - (base.height - this.flyingFruitY) * 21, 0);
                    }
                }
            }
        }
        this.drawBurst();
        this.drawGuage();
    }

    private void drawGuage() {
        int bound = this.bottomUpCounter / this.denominator;
        if (bound >= 1) {
            base.offScreen.drawImage(this.boyImg[6], 76, base.gLcdHeight - 18, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 76, base.gLcdHeight - 18, 0);
        }
        if (bound >= 2) {
            base.offScreen.drawImage(this.boyImg[6], 85, base.gLcdHeight - 20, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 85, base.gLcdHeight - 20, 0);
        }
        if (bound >= 3) {
            base.offScreen.drawImage(this.boyImg[6], 94, base.gLcdHeight - 19, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 94, base.gLcdHeight - 19, 0);
        }
        if (bound >= 4) {
            base.offScreen.drawImage(this.boyImg[6], 103, base.gLcdHeight - 21, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 103, base.gLcdHeight - 21, 0);
        }
        if (bound >= 5) {
            base.offScreen.drawImage(this.boyImg[6], 112, base.gLcdHeight - 21, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 112, base.gLcdHeight - 21, 0);
        }
        if (bound >= 6) {
            base.offScreen.drawImage(this.boyImg[6], 121, base.gLcdHeight - 20, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 121, base.gLcdHeight - 20, 0);
        }
        if (bound >= 7) {
            base.offScreen.drawImage(this.boyImg[6], 130, base.gLcdHeight - 21, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 130, base.gLcdHeight - 21, 0);
        }
        if (bound >= 8) {
            base.offScreen.drawImage(this.boyImg[6], 139, base.gLcdHeight - 19, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 139, base.gLcdHeight - 19, 0);
        }
        if (bound >= 9) {
            base.offScreen.drawImage(this.boyImg[6], 148, base.gLcdHeight - 18, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 148, base.gLcdHeight - 18, 0);
        }
        if (bound >= 10) {
            base.offScreen.drawImage(this.boyImg[6], 157, base.gLcdHeight - 18, 0);
        } else {
            base.offScreen.drawImage(this.boyImg[5], 157, base.gLcdHeight - 18, 0);
        }
    }

    private void drawBurst() {
        if (base.playState == 64 && this.drop == 2) {
            switch (this.explode) {
                case 0: {
                    for (int sx = 0; sx < this.sameFruitCounter; ++sx) {
                        int x = this.sameFruits[0][sx];
                        int y = this.sameFruits[1][sx];
                        if (this.sameFruits[2][sx] < 1 || this.sameFruits[2][sx] > 10) continue;
                        base.offScreen.drawImage(this.fruitImg[this.sameFruits[2][sx]], 26 + x * 21, base.gLcdHeight - 29 - (base.height - y) * 21 - 2, 0);
                    }
                    ++this.explode;
                    break;
                }
                case 1: {
                    for (int sx = 0; sx < this.sameFruitCounter; ++sx) {
                        int x = this.sameFruits[0][sx];
                        int y = this.sameFruits[1][sx];
                        if (this.sameFruits[2][sx] < 1 || this.sameFruits[2][sx] > 10) continue;
                        base.offScreen.drawImage(this.fruitImg[this.sameFruits[2][sx]], 26 + x * 21, base.gLcdHeight - 29 - (base.height - y) * 21, 0);
                    }
                    ++this.explode;
                    break;
                }
                case 2: {
                    for (int sx = 0; sx < this.sameFruitCounter; ++sx) {
                        int x = this.sameFruits[0][sx];
                        int y = this.sameFruits[1][sx];
                        if (this.sameFruits[2][sx] < 1 || this.sameFruits[2][sx] > 10) continue;
                        base.offScreen.drawImage(this.burstImg[0], 26 + x * 21 + 7, base.gLcdHeight - 29 - (base.height - y) * 21 + 7, 0);
                    }
                    ++this.explode;
                    break;
                }
                case 3: {
                    for (int sx = 0; sx < this.sameFruitCounter; ++sx) {
                        int x = this.sameFruits[0][sx];
                        int y = this.sameFruits[1][sx];
                        if (this.sameFruits[2][sx] < 1 || this.sameFruits[2][sx] > 10) continue;
                        base.offScreen.drawImage(this.burstImg[1], 26 + x * 21 - 3, base.gLcdHeight - 29 - (base.height - y) * 21 + 3, 0);
                    }
                    ++this.explode;
                    break;
                }
                case 4: {
                    for (int sx = 0; sx < this.sameFruitCounter; ++sx) {
                        int x = this.sameFruits[0][sx];
                        int y = this.sameFruits[1][sx];
                        if (this.sameFruits[2][sx] < 1 || this.sameFruits[2][sx] > 10) continue;
                        base.offScreen.drawImage(this.burstImg[2], 26 + x * 21 - 1, base.gLcdHeight - 29 - (base.height - y) * 21 + 3, 0);
                    }
                    ++this.explode;
                    break;
                }
                case 5: {
                    for (int sx = 0; sx < this.sameFruitCounter; ++sx) {
                        int x = this.sameFruits[0][sx];
                        int y = this.sameFruits[1][sx];
                        if (this.sameFruits[2][sx] < 1 || this.sameFruits[2][sx] > 10) continue;
                        base.offScreen.drawImage(this.burstImg[3], 26 + x * 21, base.gLcdHeight - 29 - (base.height - y) * 21 + 15, 0);
                    }
                    this.explode = 0;
                    this.stageScore += this.sameFruitCounter * (4 + (this.gameStage - 1) / 4);
                    if (this.stageScore >= this.targetScore) {
                        this.drop = 0;
                        this.playSound("/sound/success");
                        base.counter = 0;
                        base.playState = 68;
                        break;
                    }
                    this.drop = 3;
                }
            }
            this.drawCombo();
        }
    }
}

