/*
 * Decompiled with CFR 0.152.
 */
package SAF_GUI;

import SAF_Core.C;
import SAF_Core.Txt;
import javax.microedition.lcdui.Graphics;

public class Edit {
    public static final String N = "";
    public static final int EDIT_MODE_ALPHANUMERIC = 0;
    public static final int EDIT_MODE_ALPHA = 1;
    public static final int EDIT_MODE_NUMERIC = 2;
    public static final char BLINKING_CHAR = '_';
    private static final int KEY_TIME_MS = 500;
    private static final int BLINK_TIME_MS = 500;
    private static final String[] CHARS = new String[]{".1", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9", " 0", "*@", "#_-"};
    private static int[] keys;
    private char[] text;
    private int textLen;
    private int timeMS;
    private int maxChars;
    private int lastKey;
    private Txt txt;
    private int lifeTimeeMS;
    private boolean isTextAccepted;
    private int editMode;
    private int positionX;
    private int positionY;
    private int anchorPoint;

    public Edit(char[] cArray, Txt txt, int n) {
        this.txt = txt;
        this.maxChars = n;
        this.text = new char[this.maxChars + 1];
        while (n >= 0) {
            this.text[n] = '\u0000';
            --n;
        }
        if (cArray != null) {
            n = cArray.length - 1;
            while (this.maxChars >= 0) {
                this.text[n] = cArray[n];
                --this.maxChars;
            }
            this.textLen = cArray.length;
        } else {
            this.textLen = 0;
        }
        this.text[this.textLen] = 95;
        this.isTextAccepted = false;
        this.editMode = 0;
        Edit.initKeyTable();
    }

    public Edit(char[] cArray, Txt txt, int n, int n2) {
        this.txt = txt;
        this.maxChars = n;
        this.text = new char[this.maxChars + 1];
        while (n >= 0) {
            this.text[n] = '\u0000';
            --n;
        }
        if (cArray != null) {
            n = cArray.length - 1;
            while (this.maxChars >= 0) {
                this.text[n] = cArray[n];
                --this.maxChars;
            }
            this.textLen = cArray.length;
        } else {
            this.textLen = 0;
        }
        this.text[this.textLen] = 95;
        this.isTextAccepted = false;
        this.editMode = n2;
        Edit.initKeyTable();
    }

    public boolean update(int n) {
        this.lifeTimeeMS += n;
        this.timeMS -= n;
        if (this.timeMS < 0) {
            this.timeMS ^= this.timeMS;
        }
        if (!C.isKeyChanged()) {
            return false;
        }
        if (C.getAction() == 128 || C.getAction() == 256) {
            if (!this.deleteLastChar()) {
                this.isTextAccepted = false;
                return true;
            }
        } else {
            if (C.getAction() == 64) {
                C.keyClear();
                this.isTextAccepted = true;
                return true;
            }
            if (C.getAction() == 8 && C.getLastKeyPressed() != C.getKey(11)) {
                this.timeMS ^= this.timeMS;
                C.keyClear();
            } else {
                if (C.getLastKeyPressed() == 0) {
                    return false;
                }
                int n2 = Edit.getKeyIndex(C.getLastKeyPressed());
                if (n2 >= 0) {
                    if (this.timeMS > 0) {
                        this.nextSequenceChar(n2);
                    } else {
                        this.newChar(n2);
                    }
                }
                C.keyClear();
            }
        }
        return false;
    }

    public void paint(Graphics graphics) {
        int n = this.txt.getTextWidth(this.text, this.textLen);
        int n2 = this.textLen;
        if ((this.lifeTimeeMS / 500 & 1) == 0) {
            ++n2;
        }
        this.txt.drawText(graphics, this.text, n2, this.positionX - (n >> 1), this.positionY, 6);
    }

    public String getText() {
        String string = N;
        for (int i = 0; i < this.textLen; ++i) {
            string = string + this.text[i];
        }
        return string;
    }

    public void setPositionX(int n) {
        this.positionX = n;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public void setPositionY(int n) {
        this.positionY = n;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public void setAnchorPoint(int n) {
        this.anchorPoint = n;
    }

    public int getAnchorPoint() {
        return this.anchorPoint;
    }

    public boolean isTextAccepted() {
        return this.isTextAccepted;
    }

    public static void initKeyTable() {
        if (keys != null) {
            return;
        }
        keys = new int[12];
        Edit.keys[0] = C.getKey(6);
        Edit.keys[1] = C.getKey(7);
        Edit.keys[2] = C.getKey(8);
        Edit.keys[3] = C.getKey(9);
        Edit.keys[4] = C.getKey(10);
        Edit.keys[5] = C.getKey(11);
        Edit.keys[6] = C.getKey(12);
        Edit.keys[7] = C.getKey(13);
        Edit.keys[8] = C.getKey(14);
        Edit.keys[9] = C.getKey(15);
        Edit.keys[10] = C.getKey(19);
        Edit.keys[11] = C.getKey(18);
    }

    private boolean deleteLastChar() {
        if (this.textLen > 0) {
            --this.textLen;
            this.text[this.textLen] = 95;
            return true;
        }
        return false;
    }

    private void newChar(int n) {
        if (this.textLen < this.maxChars) {
            char c = '\u0000';
            switch (this.editMode) {
                case 0: {
                    c = CHARS[n].charAt(0);
                    this.timeMS = 500;
                    break;
                }
                case 1: {
                    c = Edit.getNextAlphaCharFromSequence(n, CHARS[n].charAt(0));
                    this.timeMS = 500;
                    break;
                }
                case 2: {
                    c = Edit.getNextNumericCharFromSequence(n, CHARS[n].charAt(0));
                    this.timeMS ^= this.timeMS;
                }
            }
            if (c != '\u0000') {
                this.text[this.textLen] = c;
                ++this.textLen;
                this.text[this.textLen] = 95;
            }
            this.lastKey = n;
        }
    }

    private void nextSequenceChar(int n) {
        if (n != this.lastKey) {
            this.newChar(n);
        } else {
            char c = '\u0000';
            switch (this.editMode) {
                case 0: {
                    c = Edit.getNextCharFromSequence(n, this.text[this.textLen - 1]);
                    this.timeMS = 500;
                    break;
                }
                case 1: {
                    c = Edit.getNextAlphaCharFromSequence(n, this.text[this.textLen - 1]);
                    this.timeMS = 500;
                    break;
                }
                case 2: {
                    c = Edit.getNextNumericCharFromSequence(n, this.text[this.textLen - 1]);
                    this.timeMS ^= this.timeMS;
                }
            }
            if (c != '\u0000') {
                this.text[this.textLen - 1] = c;
            }
            this.lastKey = n;
        }
    }

    public static char getNextCharFromSequence(int n, char c) {
        int n2 = CHARS[n].indexOf(c);
        if (++n2 >= CHARS[n].length()) {
            n2 = 0;
        }
        return CHARS[n].charAt(n2);
    }

    public static char getNextAlphaCharFromSequence(int n, char c) {
        char c2 = c;
        while (c2 != (c = Edit.getNextCharFromSequence(n, c)) && (c < 'A' || c > 'Z')) {
        }
        return c;
    }

    public static char getNextNumericCharFromSequence(int n, char c) {
        char c2 = c;
        do {
            if ((c = Edit.getNextCharFromSequence(n, c)) < '0' || c > '9') continue;
            return c;
        } while (c2 != c);
        return '\u0000';
    }

    public static char getFirstCharFromSequence(int n) {
        return CHARS[n].charAt(0);
    }

    public static int getKeyIndex(int n) {
        for (int i = 0; i < keys.length; ++i) {
            if (n != keys[i]) continue;
            return i;
        }
        return -1;
    }
}

