/*
 * Decompiled with CFR 0.152.
 */
package SAF_GUI;

import SAF_Application.Application;
import SAF_Core.C;
import SAF_GUI.Menu;
import SAF_GUI.MenuItem;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MenuPage {
    public static final String N = "";
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_MULTILINE = 2;
    public static final int CONTROL_SINGLE_STEP = 0;
    public static final int CONTROL_CONTINOUS_DIRECTIONS = 1;
    public static final int CONTROL_CONTINOUS_DELAYED_DIRECTIONS = 2;
    public static final int CONTROL_KEY_DELAY_TIME_MS = 400;
    private Menu menuSystem;
    public int itemSelectedIndex;
    private Vector items;
    private MenuItem pageCommands;
    private int softLeft = -1;
    private int softRight = -1;
    private int type = 0;
    private int controlType = 0;
    private int itemScrollOffset = 0;
    private static boolean keyIsReleased = true;
    private static int keyPressTimeMs = 0;

    public MenuPage(Menu menu) {
        this.menuSystem = menu;
        this.items = new Vector();
        this.pageCommands = new MenuItem();
    }

    public static void keyRelease() {
        keyIsReleased = true;
    }

    public static void keyPress() {
        keyIsReleased = false;
    }

    public static boolean keyWasReleased() {
        return keyIsReleased;
    }

    public static void keyResetPressTime() {
        keyPressTimeMs = 0;
    }

    public static void KeyAddPressTimeMs(int n) {
        keyPressTimeMs += n;
    }

    public static int keyGetPressTime() {
        return keyPressTimeMs;
    }

    public void addCommand(int n, int[] nArray) {
        this.pageCommands.addCommand(n, nArray);
    }

    public void removeCommand(int n, int n2) {
        this.pageCommands.removeCommand(n, n2);
    }

    public int[] getCommand(int n, int n2) {
        return this.pageCommands.getCommand(n, n2);
    }

    public int getCommandsCount(int n) {
        int n2 = this.pageCommands.getCommandsCount(n);
        if (this.itemSelectedIndex > -1 && this.items.size() > 0) {
            n2 += ((MenuItem)this.items.elementAt(this.itemSelectedIndex)).getCommandsCount(n);
        }
        return n2;
    }

    public int getCommandsCountItemOnly(int n) {
        int n2 = 0;
        if (this.itemSelectedIndex > -1 && this.items.size() > 0) {
            n2 += ((MenuItem)this.items.elementAt(this.itemSelectedIndex)).getCommandsCount(n);
        }
        return n2;
    }

    public int getCommandscountPageOnly(int n) {
        return this.pageCommands.getCommandsCount(n);
    }

    public Vector getCommands(int n) {
        Vector vector = this.items.size() > 0 && this.itemSelectedIndex >= 0 ? ((MenuItem)this.items.elementAt(this.itemSelectedIndex)).getCommands(n) : new Vector();
        for (int i = 0; i < this.pageCommands.getCommandsCount(n); ++i) {
            vector.addElement(this.pageCommands.getCommand(n, i));
        }
        return vector;
    }

    public Vector getCommandsPageOnly(int n) {
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < this.pageCommands.getCommandsCount(n); ++i) {
            vector.addElement(this.pageCommands.getCommand(n, i));
        }
        return vector;
    }

    public Vector getCommandsItemOnly(int n) {
        Vector vector = this.items.size() > 0 ? ((MenuItem)this.items.elementAt(this.itemSelectedIndex)).getCommands(n) : new Vector();
        return vector;
    }

    public void setMenuSystem(Menu menu) {
        this.menuSystem = menu;
    }

    public Menu getMenuSystem() {
        return this.menuSystem;
    }

    public void setPageCommands(MenuItem menuItem) {
        this.pageCommands = menuItem;
    }

    public MenuItem getPageCommands() {
        return this.pageCommands;
    }

    public int addItem(MenuItem menuItem) {
        this.items.addElement(menuItem);
        if (this.itemSelectedIndex == -1) {
            this.itemSelectedIndex = 0;
        }
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        if (n < this.items.size()) {
            return (MenuItem)this.items.elementAt(n);
        }
        return null;
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public int removeItem(int n) {
        if (n < this.items.size()) {
            this.items.removeElementAt(n);
        }
        return this.items.size();
    }

    public void clearItems() {
        this.items.removeAllElements();
        this.itemSelectedIndex = -1;
    }

    public int removeItem(MenuItem menuItem) {
        this.items.removeElement(menuItem);
        return this.items.size();
    }

    public boolean nextItem() {
        if (this.itemSelectedIndex < 0 || this.items.size() == 0) {
            return false;
        }
        int n = this.itemSelectedIndex;
        do {
            if (++n >= this.items.size()) {
                n ^= n;
            }
            if (n != this.itemSelectedIndex) continue;
            return false;
        } while (!((MenuItem)this.items.elementAt(n)).isAvailable(this.menuSystem));
        this.itemSelectedIndex = n;
        return true;
    }

    public MenuItem getNextItem() {
        if (this.itemSelectedIndex < 0 || this.items.size() == 0) {
            return null;
        }
        int n = this.itemSelectedIndex;
        do {
            if (++n >= this.items.size()) {
                n ^= n;
            }
            if (n != this.itemSelectedIndex) continue;
            return (MenuItem)this.items.elementAt(this.itemSelectedIndex);
        } while (!((MenuItem)this.items.elementAt(n)).isAvailable(this.menuSystem));
        return (MenuItem)this.items.elementAt(n);
    }

    public boolean prevItem() {
        if (this.itemSelectedIndex < 0 || this.items.size() == 0) {
            return false;
        }
        int n = this.itemSelectedIndex;
        do {
            if (--n < 0) {
                n = this.items.size() - 1;
            }
            if (n != this.itemSelectedIndex) continue;
            return false;
        } while (!((MenuItem)this.items.elementAt(n)).isAvailable(this.menuSystem));
        this.itemSelectedIndex = n;
        return true;
    }

    public MenuItem getPrevItem() {
        if (this.itemSelectedIndex < 0 || this.items.size() == 0) {
            return null;
        }
        int n = this.itemSelectedIndex;
        do {
            if (--n < 0) {
                n = this.items.size() - 1;
            }
            if (n != this.itemSelectedIndex) continue;
            return (MenuItem)this.items.elementAt(this.itemSelectedIndex);
        } while (!((MenuItem)this.items.elementAt(n)).isAvailable(this.menuSystem));
        return (MenuItem)this.items.elementAt(n);
    }

    public boolean lastItem() {
        if (this.itemSelectedIndex < 0 || this.items.size() == 0) {
            return false;
        }
        int n = 0;
        do {
            if (--n < 0) {
                n = this.items.size() - 1;
            }
            if (n != this.itemSelectedIndex) continue;
            return false;
        } while (!((MenuItem)this.items.elementAt(n)).isAvailable(this.menuSystem));
        this.itemSelectedIndex = n;
        return true;
    }

    public void selectionTest() {
        this.itemScrollOffset ^= this.itemScrollOffset;
        if (this.itemSelectedIndex < 0) {
            this.itemSelectedIndex ^= this.itemSelectedIndex;
        }
        if (this.itemSelectedIndex >= this.items.size()) {
            this.itemSelectedIndex = -1;
            return;
        }
        if (!((MenuItem)this.items.elementAt(this.itemSelectedIndex)).isAvailable(this.menuSystem) && !this.nextItem()) {
            this.itemSelectedIndex = -1;
        }
    }

    public void selectItem(int n) {
        this.itemSelectedIndex = n;
    }

    public int getSelectedItemIndex() {
        return this.itemSelectedIndex;
    }

    public int getSoftLeft() {
        return this.softLeft;
    }

    public void setSoftLeft(int n) {
        this.softLeft = n;
    }

    public int getSoftRight() {
        return this.softRight;
    }

    public void setSoftRight(int n) {
        this.softRight = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setControlType(int n) {
        this.controlType = n;
    }

    public int getControlType() {
        return this.controlType;
    }

    public void paint(Graphics graphics) {
        if (this.type == 1) {
            if (this.menuSystem.getCurrentLayoutBox() != null) {
                this.menuSystem.getCurrentLayoutBox().drawLogo(graphics);
                this.menuSystem.getCurrentLayoutBox().calculateSize(this.menuSystem.textBox.getTextHeight(), 1);
                this.menuSystem.getCurrentLayoutBox().drawBackground(graphics);
                this.menuSystem.getCurrentLayoutBox().drawBorder(graphics);
                this.menuSystem.textBox.setFontPalette(this.menuSystem.getCurrentLayoutBox().getFontPaletteId());
                this.menuSystem.textBox.setPositionY(this.menuSystem.getCurrentLayoutBox().getCurrentPositionY() + this.menuSystem.getCurrentLayoutBox().getInnerMarginTop());
                this.menuSystem.textBox.setHeight(this.menuSystem.getCurrentLayoutBox().getCurrentHeight() - this.menuSystem.getCurrentLayoutBox().getInnerMarginTop() - this.menuSystem.getCurrentLayoutBox().getInnerMarginBottom());
            }
            this.menuSystem.textBox.paint(graphics);
            return;
        }
        int n = this.menuSystem.getCurrentLayoutBox().getItemHeight();
        int n2 = this.menuSystem.getCurrentLayoutBox().getPositionX();
        int n3 = this.getVisibleItemsCount();
        this.menuSystem.getCurrentLayoutBox().calculateSize(n3, 0);
        this.menuSystem.getCurrentLayoutBox().drawBackground(graphics);
        this.menuSystem.getCurrentLayoutBox().drawBorder(graphics);
        n2 = (this.menuSystem.getCurrentLayoutBox().getTextAdjust() & 1) != 0 ? (n2 += this.menuSystem.getCurrentLayoutBox().getInnerMarginleft() + (this.menuSystem.getCurrentLayoutBox().getCurrentWidth() - this.menuSystem.getCurrentLayoutBox().getInnerMarginleft() - this.menuSystem.getCurrentLayoutBox().getInnerMarginRight() >> 1)) : ((this.menuSystem.getCurrentLayoutBox().getTextAdjust() & 8) != 0 ? (n2 += this.menuSystem.getCurrentLayoutBox().getCurrentWidth() - this.menuSystem.getCurrentLayoutBox().getInnerMarginRight()) : (n2 += this.menuSystem.getCurrentLayoutBox().getInnerMarginleft()));
        int n4 = this.menuSystem.getCurrentLayoutBox().getCurrentPositionY() + this.menuSystem.getCurrentLayoutBox().getInnerMarginTop();
        this.menuSystem.getCurrentLayoutBox().drawLogo(graphics);
        int n5 = 0;
        while (n5 * n < this.menuSystem.getCurrentLayoutBox().getCurrentHeight() - this.menuSystem.getCurrentLayoutBox().getInnerMarginTop() - this.menuSystem.getCurrentLayoutBox().getInnerMarginBottom()) {
            ++n5;
        }
        if (n5 > n3) {
            n5 = n3;
        }
        if ((this.menuSystem.getCurrentLayoutBox().getTextAdjust() & 2) != 0) {
            n4 += (this.menuSystem.getCurrentLayoutBox().getCurrentHeight() - this.menuSystem.getCurrentLayoutBox().getInnerMarginTop() - this.menuSystem.getCurrentLayoutBox().getInnerMarginBottom() >> 1) - (n * n5 >> 1);
        } else if ((this.menuSystem.getCurrentLayoutBox().getTextAdjust() & 0x20) != 0) {
            n4 += this.menuSystem.getCurrentLayoutBox().getCurrentHeight() - this.menuSystem.getCurrentLayoutBox().getInnerMarginTop() - this.menuSystem.getCurrentLayoutBox().getInnerMarginBottom() - n * n5;
        }
        int n6 = (this.menuSystem.getCurrentLayoutBox().getItemHeight() >> 1) + 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.menuSystem.getCurrentLayoutBox().getTextAdjust();
        n10 &= 0xFFFFFFCF;
        n10 |= 2;
        while (this.getVisibleItemsCount(this.itemSelectedIndex) >= n5 + n8) {
            ++n8;
        }
        for (int i = n8; i < this.items.size(); ++i) {
            int n11 = ((MenuItem)this.items.elementAt(i)).getTextId();
            n9 = ((MenuItem)this.items.elementAt((int)i)).isTextDynamic ? this.menuSystem.text.getTextWidth(this.menuSystem.getTextFromTable(n11)) : this.menuSystem.text.getTextWidth(n11);
            int n12 = (this.menuSystem.getCurrentLayoutBox().getTextAdjust() & 1) != 0 ? (this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() > 0 && n9 > this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() ? n2 - (this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() >> 1) : n2 - (n9 >> 1)) : ((this.menuSystem.getCurrentLayoutBox().getTextAdjust() & 8) != 0 ? (this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() > 0 && n9 > this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() ? n2 - this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() : n2 - n9) : n2);
            if (((MenuItem)this.items.elementAt((int)i)).isConditional) {
                if (((MenuItem)this.items.elementAt((int)i)).isConditionalEnabled) {
                    this.menuSystem.getCurrentLayoutBox().drawMenuSelector(graphics, n12, n4 + (n >> 1), n9, i == this.itemSelectedIndex);
                    this.paintItem(graphics, n2, n4 + n6, (MenuItem)this.items.elementAt(i), this.menuSystem.getCondition(((MenuItem)this.items.elementAt(i)).getConditionId()), n10, i == this.itemSelectedIndex, n9);
                } else if (this.menuSystem.getCondition(((MenuItem)this.items.elementAt(i)).getConditionId())) {
                    this.menuSystem.getCurrentLayoutBox().drawMenuSelector(graphics, n12, n4 + (n >> 1), n9, i == this.itemSelectedIndex);
                    this.paintItem(graphics, n2, n4 + n6, (MenuItem)this.items.elementAt(i), true, n10, i == this.itemSelectedIndex, n9);
                } else {
                    n4 -= n;
                    --n7;
                }
            } else {
                this.menuSystem.getCurrentLayoutBox().drawMenuSelector(graphics, n12, n4 + (n >> 1), n9, i == this.itemSelectedIndex);
                this.paintItem(graphics, n2, n4 + n6, (MenuItem)this.items.elementAt(i), true, n10, i == this.itemSelectedIndex, n9);
            }
            n4 += n;
            if (++n7 == n5) break;
        }
        if (n7 < n3) {
            // empty if block
        }
    }

    private void paintItem(Graphics graphics, int n, int n2, MenuItem menuItem, boolean bl, int n3, boolean bl2, int n4) {
        int n5;
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        if (this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() > 0 && n4 > this.menuSystem.getCurrentLayoutBox().getItemMaxWidth()) {
            if ((n3 & 8) != 0) {
                n += n4 - this.menuSystem.getCurrentLayoutBox().getItemMaxWidth();
            }
            n5 = n;
            if ((n3 & 8) != 0) {
                n5 = n - n4;
            } else if ((n3 & 1) != 0) {
                n5 = n;
            }
            graphics.setClip(n5, 0, this.menuSystem.getCurrentLayoutBox().getItemMaxWidth(), C.getScreenHeight());
            if (bl2) {
                int n10 = 0;
                if (Application.getSingleton().getFrameTime() >= 100) {
                    n10 = 4;
                } else if (Application.getSingleton().getFrameTime() > 0) {
                    n10 = 4 * Application.getSingleton().getFrameTime() / 100;
                    if (n10 < 1) {
                        n10 = 1;
                    }
                } else {
                    n10 = 1;
                }
                this.itemScrollOffset -= n10;
                if (0 - this.itemScrollOffset > n4) {
                    this.itemScrollOffset = this.menuSystem.getCurrentLayoutBox().getItemMaxWidth();
                }
                n += this.itemScrollOffset;
            }
        }
        if (bl2) {
            this.menuSystem.getCurrentLayoutBox().getText().getFont().gfx.setPalettesSetCurrent(this.menuSystem.getCurrentLayoutBox().getFontHighlightedPaletteId());
        } else {
            this.menuSystem.getCurrentLayoutBox().getText().getFont().gfx.setPalettesSetCurrent(this.menuSystem.getCurrentLayoutBox().getFontPaletteId());
        }
        if (menuItem.isTextDynamic) {
            this.menuSystem.text.drawText(graphics, this.menuSystem.getTextFromTable(menuItem.getTextId()), n, n2, n3);
        } else {
            this.menuSystem.text.drawText(graphics, menuItem.getTextId(), n, n2, n3);
        }
        if (!bl) {
            graphics.setColor(0);
            n5 = this.menuSystem.text.getFont().getFontHeight();
            if (menuItem.isTextDynamic) {
                graphics.drawRect(n, n2, this.menuSystem.text.getTextWidth(this.menuSystem.getTextFromTable(menuItem.getTextId())), n5);
            } else {
                graphics.drawRect(n, n2, this.menuSystem.text.getTextWidth(menuItem.getTextId()), n5);
            }
        }
        if (this.menuSystem.getCurrentLayoutBox().getItemMaxWidth() > 0 && n4 > this.menuSystem.getCurrentLayoutBox().getItemMaxWidth()) {
            graphics.setClip(n6, n7, n8, n9);
        }
    }

    public int getVisibleItemsCount() {
        int n = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.getItem(i).isAvailable(this.menuSystem)) continue;
            ++n;
        }
        return n;
    }

    public int getVisibleItemsCount(int n) {
        int n2 = 0;
        for (int i = 0; i < n && i < this.items.size(); ++i) {
            if (!this.getItem(i).isAvailable(this.menuSystem)) continue;
            ++n2;
        }
        return n2;
    }
}

