/*
 * Decompiled with CFR 0.152.
 */
package Game;

import SAF_Core.Anim;
import SAF_Core.Gfx;
import SAF_Engine.Core;
import SAF_Engine.LayerCollision;
import SAF_Engine.LayerTemplates;
import SAF_Engine.LayerTile;
import SAF_Engine.LayerTrigger;
import SAF_Engine.Trigger;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Map {
    public static final String N = "";
    byte fileTemplatesId;
    byte fileMapId;
    byte fileBackgroundId;
    byte fileForegroundId;
    byte filePlaceablesId;
    static final int TILES_SECTOR_WIDTH = 8;
    static final int TILES_SECTOR_WIDTH_C = 7;
    static final int TILES_SECTOR_WIDTH_S = 3;
    static final int TILES_SECTOR_HEIGHT = 8;
    static final int TILES_SECTOR_HEIGHT_C = 7;
    static final int TILES_SECTOR_HEIGHT_S = 3;
    static final int COLL_SECTOR_WIDTH = 16;
    static final int COLL_SECTOR_WIDTH_C = 15;
    static final int COLL_SECTOR_WIDTH_S = 4;
    static final int COLL_SECTOR_HEIGHT = 16;
    static final int COLL_SECTOR_HEIGHT_C = 15;
    static final int COLL_SECTOR_HEIGHT_S = 4;
    static final int TS = 10;
    static final int TSH = 9;
    static final int TV = 1024;
    static final int TVH = 512;
    static final int TC = 1023;
    static final int TF = 2147482624;
    static final int CS = 9;
    static final int CV = 512;
    static final int CVH = 256;
    static final int CC = 511;
    static final int CF = 2147483136;
    static final int POS_2_SECTOR_S = 13;
    private static Gfx backgroundGfx;
    private static Gfx foregroundGfx;
    static Anim placeablesAnim;
    private Core map;
    static int tilesBackgroundOnScreenX;
    static int tilesBackgroundOnScreenY;
    static int tilesPlaceablesOnScreenX;
    static int tilesPlaceablesOnScreenY;
    static int tileWidth;
    static int tileHeight;
    static int collWidth;
    static int collHeight;
    static byte[][] templatesPosX;
    static byte[][] templatesPosY;
    static int cellsOnMapTotalX;
    static int cellsOnMapTotalY;
    static int collisionCellsOnMapTotalX;
    static int collisionCellsOnMapTotalY;
    static int widthTotalF;
    static int heightTotalF;
    static int sectorsX;
    static int sectorsY;
    static int sectorsXLastId;
    static int sectorsYLastId;
    static int pixux;
    static int pixuy;
    static LayerTile layerBackground;
    static LayerTile layerForeground;
    static LayerTile layerPlaceables;
    static LayerCollision layerCollisionWalk;
    static LayerCollision layerCollisionShoot;
    static LayerTrigger layerTriggersSpawn;
    static LayerTrigger layerTriggersNpcCtrl;
    static LayerTrigger layerTriggersHotSpots;
    private boolean[] backgroundUsedTiles;
    private boolean[] foregroundUsedTiles;
    private boolean[] placeablesUsedTiles;
    private static int auxX;
    private static int auxY;
    private static int auxTile;
    private static int auxPosY;
    private static int auxPosX;
    private static int auxPosX2;
    private static int auxPosY2;
    private static int auxScreenPosX;
    private static int auxScreenPosY;
    private static int auxCamOffsetX;
    private static int auxCamOffsetY;
    private static int[][] shadows;
    private static final int SHADOWS_NUMBER = 3;
    private static final String FILE_SHADOWS = "sh.bin";

    public void load(String string, String string2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.map = new Core();
        this.map.loadLevel(string + ".slf");
        this.map.loadLevel(string2 + ".slf");
        LayerTemplates layerTemplates = (LayerTemplates)this.map.getLayer(0);
        layerTriggersSpawn = (LayerTrigger)this.map.getLayer(1);
        layerTriggersNpcCtrl = (LayerTrigger)this.map.getLayer(2);
        layerTriggersHotSpots = (LayerTrigger)this.map.getLayer(3);
        layerBackground = (LayerTile)this.map.getLayer(4);
        layerForeground = (LayerTile)this.map.getLayer(5);
        layerPlaceables = (LayerTile)this.map.getLayer(6);
        layerCollisionWalk = (LayerCollision)this.map.getLayer(7);
        layerCollisionShoot = (LayerCollision)this.map.getLayer(8);
        this.backgroundUsedTiles = new boolean[256];
        this.foregroundUsedTiles = new boolean[256];
        this.placeablesUsedTiles = new boolean[256];
        short s = 0;
        for (n6 = 0; n6 < layerBackground.getLayerSizeX(); n6 = (int)((short)(n6 + 1))) {
            for (n5 = 0; n5 < layerBackground.getLayerSizeY(); n5 = (int)((short)(n5 + 1))) {
                for (n4 = 0; n4 < layerBackground.getSectorSizeX(); n4 = (int)((short)(n4 + 1))) {
                    for (n3 = 0; n3 < layerBackground.getSectorSizeY(); n3 = (int)((short)(n3 + 1))) {
                        if (Map.layerBackground.tiles[n6][n5] == null) continue;
                        s = Map.layerBackground.tiles[n6][n5][n4 & 7][n3 & 7];
                        s = s < 0 ? (short)(s + 255) : (short)(s - 1);
                        this.backgroundUsedTiles[s] = true;
                    }
                }
            }
        }
        for (n6 = 0; n6 < layerForeground.getLayerSizeX(); n6 = (int)((short)(n6 + 1))) {
            for (n5 = 0; n5 < layerForeground.getLayerSizeY(); n5 = (int)((short)(n5 + 1))) {
                for (n4 = 0; n4 < layerForeground.getSectorSizeX(); n4 = (int)((short)(n4 + 1))) {
                    for (n3 = 0; n3 < layerForeground.getSectorSizeY(); n3 = (int)((short)(n3 + 1))) {
                        if (Map.layerForeground.tiles[n6][n5] == null) continue;
                        s = Map.layerForeground.tiles[n6][n5][n4 & 7][n3 & 7];
                        if (s != 0) {
                            s = s < 0 ? (short)(s + 255) : (short)(s - 1);
                        }
                        this.foregroundUsedTiles[s] = true;
                    }
                }
            }
        }
        for (n6 = 0; n6 < layerPlaceables.getLayerSizeX(); n6 = (int)((short)(n6 + 1))) {
            for (n5 = 0; n5 < layerPlaceables.getLayerSizeY(); n5 = (int)((short)(n5 + 1))) {
                for (n4 = 0; n4 < layerPlaceables.getSectorSizeX(); n4 = (int)((short)(n4 + 1))) {
                    for (n3 = 0; n3 < layerPlaceables.getSectorSizeY(); n3 = (int)((short)(n3 + 1))) {
                        if (Map.layerPlaceables.tiles[n6][n5] == null) continue;
                        s = Map.layerPlaceables.tiles[n6][n5][n4 & 7][n3 & 7];
                        if (s != 0) {
                            s = s < 0 ? (short)(s + 255) : (short)(s - 1);
                        }
                        this.placeablesUsedTiles[s] = true;
                    }
                }
            }
        }
        templatesPosX = new byte[layerTemplates.getSectorSizeX()][layerTemplates.getSectorSizeY()];
        templatesPosY = new byte[layerTemplates.getSectorSizeX()][layerTemplates.getSectorSizeY()];
        for (int i = 0; i < layerTemplates.getSectorSizeY(); ++i) {
            for (int j = 0; j < layerTemplates.getSectorSizeX(); ++j) {
                Map.templatesPosX[j][i] = this.getTemplatePosX(layerTemplates.templates[0][0][j][i]);
                Map.templatesPosY[j][i] = this.getTemplatePosY(layerTemplates.templates[0][0][j][i]);
            }
        }
        collWidth = 24;
        collHeight = 24;
        tileWidth = 24;
        tileHeight = 24;
        pixux = 1024 / tileWidth;
        pixuy = 1024 / tileHeight;
        tilesBackgroundOnScreenX = n / tileWidth + 1;
        if (n % tileWidth > 0) {
            ++tilesBackgroundOnScreenX;
        }
        tilesBackgroundOnScreenY = n2 / tileHeight + 1;
        if (n2 % tileHeight > 0) {
            ++tilesBackgroundOnScreenY;
        }
        tilesPlaceablesOnScreenX = tilesBackgroundOnScreenX + 4 + 4;
        tilesPlaceablesOnScreenY = tilesBackgroundOnScreenY + 4;
        sectorsX = layerTemplates.getSectorSizeX();
        sectorsXLastId = sectorsX - 1;
        sectorsY = layerTemplates.getSectorSizeY();
        sectorsYLastId = sectorsY - 1;
        cellsOnMapTotalX = layerBackground.getSectorSizeX() * sectorsX;
        cellsOnMapTotalY = layerBackground.getSectorSizeY() * sectorsY;
        widthTotalF = cellsOnMapTotalX << 10;
        heightTotalF = cellsOnMapTotalY << 10;
        collisionCellsOnMapTotalX = layerCollisionWalk.getSectorSizeX() * sectorsX;
        collisionCellsOnMapTotalY = layerCollisionWalk.getSectorSizeY() * sectorsY;
        layerTemplates.dispose();
        this.map.removeLayer(0);
        layerTemplates = null;
    }

    private void loadShadows(MIDlet mIDlet) {
        shadows = new int[3][tileHeight * tileWidth];
        try {
            DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(FILE_SHADOWS));
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < tileHeight * tileWidth; ++j) {
                    Map.shadows[i][j] = dataInputStream.readInt();
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte getTemplatePosX(byte by) {
        by = (byte)(by - 1);
        return (byte)(by % layerBackground.getLayerSizeX());
    }

    private byte getTemplatePosY(byte by) {
        by = (byte)(by - 1);
        return (byte)(by / layerBackground.getLayerSizeX());
    }

    public void setBackgroundGfx(Gfx gfx) {
        backgroundGfx = gfx;
    }

    public void setForegroundGfx(Gfx gfx) {
        foregroundGfx = gfx;
    }

    public void setPlaceablesAnimation(Anim anim) {
        placeablesAnim = anim;
    }

    public boolean[] getBackgroundUsageInfo() {
        return this.backgroundUsedTiles;
    }

    public boolean[] getForegroundUsageInfo() {
        return this.foregroundUsedTiles;
    }

    public boolean[] getPlaceablesUsageInfo() {
        return this.placeablesUsedTiles;
    }

    public int getCameraMaxPosX() {
        return cellsOnMapTotalX - tilesBackgroundOnScreenX;
    }

    public int getCameraMaxPosY() {
        return heightTotalF;
    }

    public Trigger getTriggerNpcCtrl(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        auxPosX = n >> 10;
        auxPosY = n2 >> 10;
        if (auxPosX >= cellsOnMapTotalX || auxPosY >= cellsOnMapTotalY) {
            return null;
        }
        auxX = auxPosX >> 3;
        auxY = auxPosY >> 3;
        if (Map.layerTriggersNpcCtrl.triggers[auxX][auxY] != null) {
            int n3 = Map.layerTriggersNpcCtrl.triggers[auxX][auxY].length;
            --n3;
            while (n3 >= 0) {
                Trigger trigger = Map.layerTriggersNpcCtrl.triggers[auxX][auxY][n3];
                if (trigger.posX == (auxPosX & 7) && trigger.posY == (auxPosY & 7)) {
                    return trigger;
                }
                --n3;
            }
        }
        return null;
    }

    public boolean isColWalkL(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return true;
        }
        auxPosX = n >> 9;
        auxPosY = n2 >> 9;
        if (auxPosX >= collisionCellsOnMapTotalX || auxPosY >= collisionCellsOnMapTotalY) {
            return true;
        }
        auxX = templatesPosX[auxPosX >> 4][auxPosY >> 4];
        auxY = templatesPosY[auxPosX >> 4][auxPosY >> 4];
        if (Map.layerCollisionWalk.coll[auxX][auxY] != null) {
            return Map.layerCollisionWalk.coll[auxX][auxY][auxPosX & 0xF][auxPosY & 0xF];
        }
        return false;
    }

    public boolean isColWalk(int n, int n2) {
        auxPosX = n >> 9;
        auxPosY = n2 >> 9;
        auxX = templatesPosX[auxPosX >> 4][auxPosY >> 4];
        auxY = templatesPosY[auxPosX >> 4][auxPosY >> 4];
        if (Map.layerCollisionWalk.coll[auxX][auxY] != null) {
            return Map.layerCollisionWalk.coll[auxX][auxY][auxPosX & 0xF][auxPosY & 0xF];
        }
        return false;
    }

    public boolean isColShoot(int n, int n2) {
        auxPosX = n >> 10;
        auxPosY = n2 >> 10;
        auxX = templatesPosX[auxPosX >> 3][auxPosY >> 3];
        auxY = templatesPosY[auxPosX >> 3][auxPosY >> 3];
        if (Map.layerCollisionShoot.coll[auxX][auxY] != null) {
            return Map.layerCollisionShoot.coll[auxX][auxY][auxPosX & 7][auxPosY & 7];
        }
        return false;
    }

    public boolean isShootPossible(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        auxPosX = n >> 9;
        auxPosX2 = n3 >> 9;
        auxPosY = n2 >> 9;
        auxPosY2 = n4 >> 9;
        auxX = auxPosX;
        auxY = auxPosY;
        if (auxPosX < auxPosX2) {
            n8 = 1;
            n7 = auxPosX2 - auxPosX;
        } else {
            n8 = -1;
            n7 = auxPosX - auxPosX2;
        }
        if (auxPosY < auxPosY2) {
            n6 = 1;
            n5 = auxPosY2 - auxPosY;
        } else {
            n6 = -1;
            n5 = auxPosY - auxPosY2;
        }
        auxPosX = templatesPosX[auxX >> 4][auxY >> 4];
        auxPosY = templatesPosY[auxX >> 4][auxY >> 4];
        if (Map.layerCollisionShoot.coll[auxPosX][auxPosY] != null && Map.layerCollisionShoot.coll[auxPosX][auxPosY][auxX >> 1 & 7][auxY >> 1 & 7]) {
            return false;
        }
        if (n7 > n5) {
            int n9 = n5 - n7 << 1;
            int n10 = n5 << 1;
            int n11 = n10 - n7;
            while (auxX != auxPosX2) {
                if (n11 >= 0) {
                    auxX += n8;
                    auxY += n6;
                    n11 += n9;
                } else {
                    n11 += n10;
                    auxX += n8;
                }
                if (Map.layerCollisionShoot.coll[auxPosX = templatesPosX[auxX >> 4][auxY >> 4]][auxPosY = templatesPosY[auxX >> 4][auxY >> 4]] == null || !Map.layerCollisionShoot.coll[auxPosX][auxPosY][auxX >> 1 & 7][auxY >> 1 & 7]) continue;
                return false;
            }
        } else {
            int n12 = n7 - n5 << 1;
            int n13 = n7 << 1;
            int n14 = n13 - n5;
            while (auxY != auxPosY2) {
                if (n14 >= 0) {
                    auxX += n8;
                    auxY += n6;
                    n14 += n12;
                } else {
                    n14 += n13;
                    auxY += n6;
                }
                if (Map.layerCollisionShoot.coll[auxPosX = templatesPosX[auxX >> 4][auxY >> 4]][auxPosY = templatesPosY[auxX >> 4][auxY >> 4]] == null || !Map.layerCollisionShoot.coll[auxPosX][auxPosY][auxX >> 1 & 7][auxY >> 1 & 7]) continue;
                return false;
            }
        }
        return true;
    }

    public void paintCollision(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5 = (tilesBackgroundOnScreenX << 1) - 1;
        int n6 = (tilesBackgroundOnScreenY << 1) - 1;
        auxCamOffsetX = -((n & 0x1FF) * collWidth) >> 9;
        auxCamOffsetY = -((n2 & 0x1FF) * collHeight) >> 9;
        auxPosY = n2 >> 9;
        auxScreenPosY = auxCamOffsetY;
        graphics.setColor(4198527);
        for (n4 = 0; n4 < n6; ++n4) {
            auxPosX = n >> 9;
            auxScreenPosX = auxCamOffsetX;
            for (n3 = 0; n3 < n5; ++n3) {
                auxX = templatesPosX[auxPosX >> 4][auxPosY >> 4];
                auxY = templatesPosY[auxPosX >> 4][auxPosY >> 4];
                if (Map.layerCollisionWalk.coll[auxX][auxY] != null && Map.layerCollisionWalk.coll[auxX][auxY][auxPosX & 0xF][auxPosY & 0xF]) {
                    graphics.fillRect(auxScreenPosX, auxScreenPosY, collWidth, collHeight);
                }
                auxScreenPosX += collWidth;
                ++auxPosX;
            }
            auxScreenPosY += collHeight;
            if (++auxPosY >= collisionCellsOnMapTotalY) break;
        }
        n5 = tilesBackgroundOnScreenX;
        n6 = tilesBackgroundOnScreenY;
        auxCamOffsetX = -((n & 0x3FF) * tileWidth) >> 10;
        auxCamOffsetY = -((n2 & 0x3FF) * tileHeight) >> 10;
        auxPosY = n2 >> 10;
        auxScreenPosY = auxCamOffsetY;
        graphics.setColor(0xFF9000);
        for (n4 = 0; n4 < n6; ++n4) {
            auxPosX = n >> 10;
            auxScreenPosX = auxCamOffsetX;
            for (n3 = 0; n3 < n5; ++n3) {
                auxX = templatesPosX[auxPosX >> 3][auxPosY >> 3];
                auxY = templatesPosY[auxPosX >> 3][auxPosY >> 3];
                if (Map.layerCollisionShoot.coll[auxX][auxY] != null && Map.layerCollisionShoot.coll[auxX][auxY][auxPosX & 7][auxPosY & 7]) {
                    graphics.drawRect(auxScreenPosX, auxScreenPosY, tileWidth - 1, tileHeight - 1);
                }
                auxScreenPosX += tileWidth;
                ++auxPosX;
            }
            auxScreenPosY += tileHeight;
            if (++auxPosY >= cellsOnMapTotalY) break;
        }
    }

    private void paintBackgroundLayer(Graphics graphics, int n, int n2) {
        auxCamOffsetX = -((n & 0x3FF) * tileWidth + 512) >> 10;
        auxCamOffsetY = -((n2 & 0x3FF) * tileHeight + 512) >> 10;
        auxPosY = n2 >> 10;
        auxScreenPosY = auxCamOffsetY;
        for (int i = 0; i < tilesBackgroundOnScreenY; ++i) {
            auxPosX = n >> 10;
            auxScreenPosX = auxCamOffsetX;
            for (int j = 0; j < tilesBackgroundOnScreenX; ++j) {
                auxX = templatesPosX[auxPosX >> 3][auxPosY >> 3];
                auxY = templatesPosY[auxPosX >> 3][auxPosY >> 3];
                auxTile = Map.layerBackground.tiles[auxX][auxY][auxPosX & 7][auxPosY & 7];
                auxTile = auxTile < 0 ? (auxTile += 255) : --auxTile;
                backgroundGfx.drawImage(graphics, auxTile, auxScreenPosX, auxScreenPosY);
                auxScreenPosX += tileWidth;
                ++auxPosX;
            }
            auxScreenPosY += tileHeight;
            if (++auxPosY != cellsOnMapTotalY) continue;
            return;
        }
    }

    public void paintBackgroundForegroundLayers(Graphics graphics, int n, int n2) {
        if (this.fileForegroundId < 0) {
            this.paintBackgroundLayer(graphics, n, n2);
            return;
        }
        auxCamOffsetX = -((n & 0x3FF) * tileWidth + 512) >> 10;
        auxCamOffsetY = -((n2 & 0x3FF) * tileHeight + 512) >> 10;
        auxPosY = n2 >> 10;
        auxScreenPosY = auxCamOffsetY;
        for (int i = 0; i < tilesBackgroundOnScreenY; ++i) {
            auxPosX = n >> 10;
            auxScreenPosX = auxCamOffsetX;
            for (int j = 0; j < tilesBackgroundOnScreenX; ++j) {
                auxX = templatesPosX[auxPosX >> 3][auxPosY >> 3];
                auxY = templatesPosY[auxPosX >> 3][auxPosY >> 3];
                auxTile = Map.layerBackground.tiles[auxX][auxY][auxPosX & 7][auxPosY & 7];
                auxTile = auxTile < 0 ? (auxTile += 255) : --auxTile;
                backgroundGfx.drawImage(graphics, auxTile, auxScreenPosX, auxScreenPosY);
                if (Map.layerForeground.tiles[auxX][auxY] != null && (auxTile = Map.layerForeground.tiles[auxX][auxY][auxPosX & 7][auxPosY & 7]) != 0) {
                    auxTile = auxTile < 0 ? (auxTile += 255) : --auxTile;
                    foregroundGfx.drawImage(graphics, auxTile, auxScreenPosX, auxScreenPosY);
                }
                auxScreenPosX += tileWidth;
                ++auxPosX;
            }
            auxScreenPosY += tileHeight;
            if (++auxPosY != cellsOnMapTotalY) continue;
            return;
        }
    }

    public void dispose() {
        backgroundGfx = null;
        foregroundGfx = null;
        placeablesAnim = null;
        templatesPosX = null;
        templatesPosY = null;
        layerBackground = null;
        layerForeground = null;
        layerPlaceables = null;
        layerCollisionWalk = null;
        layerCollisionShoot = null;
        layerTriggersSpawn = null;
        layerTriggersNpcCtrl = null;
        layerTriggersHotSpots = null;
        this.backgroundUsedTiles = null;
        this.foregroundUsedTiles = null;
        this.placeablesUsedTiles = null;
        this.map = null;
    }
}

