/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Vect;

public class Polygon {
    Vect[] vertices;
    private static final int SUPPORT_POINTS_THRESHOLD = 4;
    private static int intervalMin;
    private static int intervalMax;
    private static int aux;
    public static Vect mtd;
    public static Vect collisionAxis;
    public static int contactPointsNumber;
    public static Vect[] contactPointsA;
    public static Vect[] contactPointsB;
    private static Vect[] supportPoints;
    private static int supportPointsANumber;
    private static Vect[] supportPointsA;
    private static int supportPointsBNumber;
    private static Vect[] supportPointsB;

    Polygon(int n) {
        this.init(n);
    }

    Polygon(Polygon polygon) {
        this.init(polygon.verticesCount());
        for (int i = 0; i < this.verticesCount(); ++i) {
            this.vertices[i].x = polygon.vertices[i].x;
            this.vertices[i].y = polygon.vertices[i].y;
        }
    }

    private void init(int n) {
        this.vertices = new Vect[n];
        --n;
        while (n >= 0) {
            this.vertices[n] = new Vect();
            --n;
        }
    }

    int verticesCount() {
        return this.vertices.length;
    }

    public static boolean isCollide(Polygon polygon, Polygon polygon2, int n, int n2) {
        Vect vect;
        Vect vect2;
        Vect vect3;
        Vect[] vectArray = new Vect[polygon.verticesCount() + polygon2.verticesCount()];
        int n3 = 0;
        int n4 = polygon.verticesCount() - 1;
        int n5 = 0;
        while (n5 < polygon.verticesCount()) {
            vect3 = polygon.vertices[n4];
            vect2 = polygon.vertices[n5];
            vect = new Vect();
            vect.x = vect2.x - vect3.x;
            vect.y = vect2.y - vect3.y;
            vectArray[n3] = new Vect(-vect.y, vect.x);
            if (!Polygon.intervalIntersect(polygon, polygon2, vectArray[n3])) {
                return false;
            }
            ++n3;
            n4 = n5++;
        }
        n4 = polygon2.verticesCount() - 1;
        n5 = 0;
        while (n5 < polygon2.verticesCount()) {
            vect3 = polygon2.vertices[n4];
            vect2 = polygon2.vertices[n5];
            vect = new Vect();
            vect.x = vect2.x - vect3.x;
            vect.y = vect2.y - vect3.y;
            vectArray[n3] = new Vect(-vect.y, vect.x);
            if (!Polygon.intervalIntersect(polygon2, polygon, vectArray[n3])) {
                return false;
            }
            ++n3;
            n4 = n5++;
        }
        Vect vect4 = new Vect(n, n2);
        mtd = Polygon.findMtd(vectArray);
        if (vect4.dotProduct(mtd) < 0) {
            Polygon.mtd.x = -Polygon.mtd.x;
            Polygon.mtd.y = -Polygon.mtd.y;
        }
        Polygon.findContactPoints(polygon, polygon2, mtd);
        return true;
    }

    private static void getInterval(Polygon polygon, Vect vect) {
        intervalMin = intervalMax = polygon.vertices[0].dotProduct(vect);
        for (int i = 1; i < polygon.verticesCount(); ++i) {
            int n = polygon.vertices[i].dotProduct(vect);
            if (n < intervalMin) {
                intervalMin = n;
                continue;
            }
            if (n <= intervalMax) continue;
            intervalMax = n;
        }
    }

    private static boolean intervalIntersect(Polygon polygon, Polygon polygon2, Vect vect) {
        Polygon.getInterval(polygon, vect);
        int n = intervalMin;
        int n2 = intervalMax;
        Polygon.getInterval(polygon2, vect);
        int n3 = intervalMin;
        int n4 = intervalMax;
        if (n > n4 || n3 > n2) {
            return false;
        }
        int n5 = n2 - n3;
        int n6 = n4 - n;
        int n7 = n5 < n6 ? n5 : n6;
        int n8 = vect.dotProduct(vect);
        long l = vect.x * n7 / n8;
        long l2 = vect.y * n7 / n8;
        vect.x = (int)l;
        vect.y = (int)l2;
        return true;
    }

    private static Vect findMtd(Vect[] vectArray) {
        Vect vect = vectArray[0];
        int n = vectArray[0].dotProduct(vectArray[0]);
        for (int i = 1; i < vectArray.length; ++i) {
            int n2 = vectArray[i].dotProduct(vectArray[i]);
            if (n2 >= n) continue;
            n = n2;
            vect = vectArray[i];
        }
        return vect;
    }

    private static int FindSupportPoints(Vect vect, Polygon polygon) {
        int n;
        int[] nArray = new int[polygon.verticesCount()];
        int n2 = nArray[0] = polygon.vertices[0].dotProduct(vect);
        for (n = 1; n < polygon.verticesCount(); ++n) {
            nArray[n] = polygon.vertices[n].dotProduct(vect);
            if (nArray[n] >= n2) continue;
            n2 = nArray[n];
        }
        n = 0;
        for (int i = 0; i < polygon.verticesCount(); ++i) {
            if (nArray[i] > n2 + 4) continue;
            supportPoints[n].set(polygon.vertices[i]);
            if (++n != 2) continue;
            return n;
        }
        return n;
    }

    private static void findContactPoints(Polygon polygon, Polygon polygon2, Vect vect) {
        supportPointsANumber = Polygon.FindSupportPoints(vect, polygon);
        supportPointsA[0].set(supportPoints[0]);
        supportPointsA[1].set(supportPoints[1]);
        Vect vect2 = new Vect(-vect.x, -vect.y);
        supportPointsBNumber = Polygon.FindSupportPoints(vect2, polygon2);
        supportPointsB[0].set(supportPoints[0]);
        supportPointsB[1].set(supportPoints[1]);
        Polygon.convertSupportToContactPoints(vect);
    }

    private static void convertSupportToContactPoints(Vect vect) {
        Vect vect2;
        int n;
        int n2;
        contactPointsNumber = 0;
        if (supportPointsANumber == 0 || supportPointsBNumber == 0) {
            return;
        }
        if (supportPointsANumber == 1 && supportPointsBNumber == 1) {
            contactPointsA[contactPointsNumber].set(supportPointsA[0]);
            contactPointsB[contactPointsNumber].set(supportPointsB[0]);
            ++contactPointsNumber;
            return;
        }
        Vect vect3 = new Vect(-vect.y, vect.x);
        int n3 = n2 = supportPointsA[0].dotProduct(vect3);
        int n4 = n = supportPointsB[0].dotProduct(vect3);
        if (supportPointsANumber == 2 && (n3 = supportPointsA[1].dotProduct(vect3)) < n2) {
            aux = n2;
            n2 = n3;
            n3 = aux;
            aux = Polygon.supportPointsA[0].x;
            Polygon.supportPointsA[0].x = Polygon.supportPointsA[1].x;
            Polygon.supportPointsA[1].x = aux;
            aux = Polygon.supportPointsA[0].y;
            Polygon.supportPointsA[0].y = Polygon.supportPointsA[1].y;
            Polygon.supportPointsA[1].y = aux;
        }
        if (supportPointsBNumber == 2 && (n4 = supportPointsB[1].dotProduct(vect3)) < n) {
            aux = n;
            n = n4;
            n4 = aux;
            aux = Polygon.supportPointsB[0].x;
            Polygon.supportPointsB[0].x = Polygon.supportPointsB[1].x;
            Polygon.supportPointsB[1].x = aux;
            aux = Polygon.supportPointsB[0].y;
            Polygon.supportPointsB[0].y = Polygon.supportPointsB[1].y;
            Polygon.supportPointsB[1].y = aux;
        }
        if (n2 > n4 || n > n3) {
            return;
        }
        if (n2 > n) {
            vect2 = Polygon.projectPointOnSegment(supportPointsA[0], supportPointsB[0], supportPointsB[1]);
            if (vect2 != null) {
                contactPointsA[contactPointsNumber].set(supportPointsA[0]);
                contactPointsB[contactPointsNumber].set(vect2);
                ++contactPointsNumber;
            }
        } else {
            vect2 = Polygon.projectPointOnSegment(supportPointsB[0], supportPointsA[0], supportPointsA[1]);
            if (vect2 != null) {
                contactPointsA[contactPointsNumber].set(vect2);
                contactPointsB[contactPointsNumber].set(supportPointsB[0]);
                ++contactPointsNumber;
            }
        }
        if (n3 != n2 && n4 != n) {
            if (n3 < n4) {
                vect2 = Polygon.projectPointOnSegment(supportPointsA[1], supportPointsB[0], supportPointsB[1]);
                if (vect2 != null) {
                    contactPointsA[contactPointsNumber].set(supportPointsA[1]);
                    contactPointsB[contactPointsNumber].set(vect2);
                    ++contactPointsNumber;
                }
            } else {
                vect2 = Polygon.projectPointOnSegment(supportPointsB[1], supportPointsA[0], supportPointsA[1]);
                if (vect2 != null) {
                    contactPointsA[contactPointsNumber].set(vect2);
                    contactPointsB[contactPointsNumber].set(supportPointsB[1]);
                    ++contactPointsNumber;
                }
            }
        }
    }

    private static Vect projectPointOnSegment(Vect vect, Vect vect2, Vect vect3) {
        Vect vect4 = new Vect();
        Vect vect5 = new Vect(vect.x, vect.y);
        vect5.sub(vect2);
        Vect vect6 = new Vect(vect3.x, vect3.y);
        vect6.sub(vect2);
        long l = (vect5.dotProduct(vect6) << 10) / vect6.dotProduct(vect6);
        int n = (int)l;
        if (n < 0) {
            n = 0;
        } else if (n > 1024) {
            n = 1024;
        }
        vect4.set(vect2);
        vect4.x += n * vect6.x >> 10;
        vect4.y += n * vect6.y >> 10;
        return vect4;
    }

    static {
        mtd = new Vect();
        collisionAxis = new Vect();
        contactPointsA = new Vect[]{new Vect(), new Vect()};
        contactPointsB = new Vect[]{new Vect(), new Vect()};
        supportPoints = new Vect[]{new Vect(), new Vect()};
        supportPointsA = new Vect[]{new Vect(), new Vect()};
        supportPointsB = new Vect[]{new Vect(), new Vect()};
    }
}

