/*
 * Decompiled with CFR 0.152.
 */
package SAF_Core;

import SAF_Core.Anim;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Txt {
    public static final String N = "";
    public static final String EXT = ".sts";
    private char[][] texts;
    private char[][] langNames;
    private char[] fontChars;
    short[] fontTable = null;
    private Anim fontCurrent;
    public static final int FONT_TABLE_MAX_SIZE = 200;

    char[] readString(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        return string.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Txt(MIDlet mIDlet, String string) {
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        try {
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            this.fontChars = this.readString(dataInputStream);
            this.langNames = new char[dataInputStream.readByte()][];
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readShort();
            for (int i = 0; i < this.langNames.length; ++i) {
                this.langNames[i] = this.readString(dataInputStream);
                int n = dataInputStream.readInt();
                dataInputStream.skipBytes(n);
            }
            this.fontTableInit();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
                dataInputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLanguage(MIDlet mIDlet, String string, int n) {
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        try {
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            this.fontChars = this.readString(dataInputStream);
            dataInputStream.readByte();
            dataInputStream.readChar();
            dataInputStream.readChar();
            dataInputStream.readChar();
            int n2 = dataInputStream.readShort();
            this.texts = null;
            this.texts = new char[n2][];
            for (int i = 0; i <= n; ++i) {
                dataInputStream.readUTF();
                int n3 = dataInputStream.readInt();
                if (n > i) {
                    dataInputStream.skipBytes(n3);
                    continue;
                }
                for (int j = 0; j < n2; ++j) {
                    String string2 = Txt.replaceAll(dataInputStream.readUTF(), "\\n", "\n");
                    this.texts[j] = string2.toCharArray();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
                dataInputStream = null;
            }
        }
        this.fontTableInit();
    }

    private void fontTableInit() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.fontChars.length; ++n) {
            if (n2 >= this.fontChars[n]) continue;
            n2 = this.fontChars[n];
        }
        if (++n2 > 200) {
            n2 = 200;
        }
        this.fontTable = null;
        this.fontTable = new short[n2];
        try {
            n = 0;
            while (true) {
                this.fontTable[n] = -1;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            for (int i = 0; i < this.fontChars.length; ++i) {
                char c = this.fontChars[i];
                if (c >= this.fontTable.length) continue;
                this.fontTable[c] = (short)i;
            }
            return;
        }
    }

    public int getLanguageCount() {
        return this.langNames.length;
    }

    public char[] getLanguageName(int n) {
        return this.langNames[n];
    }

    public String getTextAsString(int n) {
        return new String(this.texts[n]);
    }

    public char[] getText(int n) {
        return this.texts[n];
    }

    public void setText(char[] cArray, int n) {
        this.texts[n] = cArray;
    }

    public char getChar(int n) {
        if (this.fontChars != null) {
            return this.fontChars[n];
        }
        return 'a';
    }

    public int getCharId(char c) {
        if (this.fontTable != null && c < this.fontTable.length && this.fontTable[c] >= 0) {
            return this.fontTable[c];
        }
        try {
            int n = 0;
            while (true) {
                if (this.fontChars[n] == c) {
                    return n;
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n = this.getCharId('?');
            if (n > -1) {
                return n;
            }
            return 0;
        }
    }

    public int getCharWidth(char c) {
        if (c == ' ') {
            return this.fontCurrent.getFontSpaceWidth();
        }
        if (c == '\n' || this.getCharId(c) < 0) {
            return 0;
        }
        return this.fontCurrent.getFrameWidth(this.getCharId(c), 0);
    }

    public int getCharWidthWithFontSpacing(char c) {
        if (c == ' ') {
            return this.fontCurrent.getFontSpaceWidth() + this.fontCurrent.getFontSpacing();
        }
        if (c == '\n' || this.getCharId(c) < 0) {
            return this.fontCurrent.getFontSpacing();
        }
        return this.fontCurrent.getFrameWidth(this.getCharId(c), 0) + this.fontCurrent.getFontSpacing();
    }

    public int getTextWidth(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            n += this.getCharWidthWithFontSpacing(cArray[i]);
        }
        return n;
    }

    public int getTextWidth(char[] cArray, int n) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getCharWidthWithFontSpacing(cArray[i]);
        }
        return n2;
    }

    public int getTextWidth(int n) {
        return this.getTextWidth(this.getText(n));
    }

    public void setFont(Anim anim) {
        this.fontCurrent = anim;
    }

    public Anim getFont() {
        return this.fontCurrent;
    }

    public String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + string3 + string.substring(n + string2.length(), string.length());
    }

    public static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) < 0) {
                stringBuffer.append(string.substring(n, string.length()));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
    }

    public char[][] splitText(char[] cArray, char c, int n) {
        Vector vector = this.splitTextToVect(cArray, c, n - 5);
        char[][] cArrayArray = new char[vector.size()][];
        for (int i = 0; i < cArrayArray.length; ++i) {
            cArrayArray[i] = ((String)vector.elementAt(i)).toCharArray();
        }
        return cArrayArray;
    }

    Vector splitTextToVect(char[] cArray, char c, int n) {
        Vector<String> vector = new Vector<String>();
        String string = new String(cArray);
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        String string2 = null;
        while (n3 < n2) {
            int n5;
            int n6 = string.indexOf(c, n3);
            if (n6 < 0) {
                n6 = string.length();
            }
            if ((n5 = string.indexOf(10, n3)) < 0) {
                n5 = string.length();
            }
            int n7 = Math.min(n6, n5);
            String string3 = string.substring(n3, n7);
            int n8 = this.getTextWidth(string3.toCharArray());
            if (string2 == null) {
                string2 = string3;
                n4 = n8;
                if (n4 > n) {
                    string2 = this.splitWord(vector, string3, n);
                    n4 = this.getTextWidth(string2.toCharArray());
                }
            } else if (n4 + this.fontCurrent.getFontSpacing() + this.fontCurrent.getFontSpaceWidth() + this.fontCurrent.getFontSpacing() + n8 <= n) {
                string2 = string2 + c + string3;
                n4 += this.fontCurrent.getFontSpacing() + this.fontCurrent.getFontSpaceWidth() + this.fontCurrent.getFontSpacing() + n8;
            } else {
                vector.addElement(string2);
                string2 = null;
                string2 = new String(string3);
                n4 = n8;
                if (n4 > n) {
                    string2 = this.splitWord(vector, string3, n);
                    n4 = this.getTextWidth(string2.toCharArray());
                }
            }
            if (n7 == n5) {
                vector.addElement(string2);
                string2 = null;
                n4 = 0;
            }
            n3 = n7 + 1;
        }
        if (n4 > 0) {
            vector.addElement(string2);
            string2 = null;
        }
        return vector;
    }

    private String splitWord(Vector vector, String string, int n) {
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = this.getCharWidthWithFontSpacing(cArray[i]);
            if ((n4 += n5) <= n) continue;
            vector.addElement(new String(cArray, n3, i - n3));
            n3 = i;
            n4 = n5;
        }
        return new String(cArray, n3, n2 - n3);
    }

    public int drawText(Graphics graphics, int n, int n2, int n3, int n4) {
        return this.drawText(graphics, this.getText(n), n2, n3, n4);
    }

    public void drawChar(Graphics graphics, char c, int n, int n2, int n3) {
        if (c == ' ' || c == '\n') {
            return;
        }
        if ((n3 & 8) > 0) {
            n -= this.getCharWidth(c);
        } else if ((n3 & 1) > 0) {
            n -= this.getCharWidth(c) >> 1;
        }
        if ((n3 & 0x20) > 0) {
            n2 -= this.fontCurrent.getFontHeight();
        } else if ((n3 & 2) > 0) {
            n2 -= this.fontCurrent.getFontHeight() >> 1;
        }
        int n4 = this.getCharId(c);
        if (n4 >= 0) {
            this.fontCurrent.drawFrame(graphics, n4, 0, n, n2, 0);
        }
    }

    public void drawCharId(Graphics graphics, int n, int n2, int n3, int n4) {
        if ((n4 & 8) > 0) {
            n2 -= this.fontCurrent.getFrameWidth(n, 0);
        } else if ((n4 & 1) > 0) {
            n2 -= this.fontCurrent.getFrameWidth(n, 0) >> 1;
        }
        if ((n4 & 0x20) > 0) {
            n3 -= this.fontCurrent.getFontHeight();
        } else if ((n4 & 2) > 0) {
            n3 -= this.fontCurrent.getFontHeight() >> 1;
        }
        if (n >= 0) {
            this.fontCurrent.drawFrame(graphics, n, 0, n2, n3, 0);
        }
    }

    public int drawText(Graphics graphics, char[] cArray, int n, int n2, int n3) {
        if ((n3 & 8) > 0) {
            n -= this.getTextWidth(cArray);
        } else if ((n3 & 1) > 0) {
            n -= this.getTextWidth(cArray) >> 1;
        }
        if ((n3 & 0x20) > 0) {
            n2 -= this.fontCurrent.getFontHeight();
        } else if ((n3 & 2) > 0) {
            n2 -= this.fontCurrent.getFontHeight() >> 1;
        }
        int n4 = n;
        int n5 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\n') continue;
            if (c == ' ') {
                n += this.fontCurrent.getFontSpaceWidth() + this.fontCurrent.getFontSpacing();
                continue;
            }
            n5 = this.getCharId(c);
            if (n5 < 0) continue;
            this.fontCurrent.drawFrame(graphics, n5, 0, n, n2, 0);
            n += this.fontCurrent.getFrameWidth(n5, 0) + this.fontCurrent.getFontSpacing();
        }
        return n - n4;
    }

    public int drawText(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        if ((n4 & 8) > 0) {
            n2 -= this.getTextWidth(cArray, n);
        } else if ((n4 & 1) > 0) {
            n2 -= this.getTextWidth(cArray, n) >> 1;
        }
        if ((n4 & 0x20) > 0) {
            n3 -= this.fontCurrent.getFontHeight();
        } else if ((n4 & 2) > 0) {
            n3 -= this.fontCurrent.getFontHeight() >> 1;
        }
        int n5 = n2;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\n') continue;
            if (c == ' ') {
                n2 += this.fontCurrent.getFontSpaceWidth() + this.fontCurrent.getFontSpacing();
                continue;
            }
            n6 = this.getCharId(c);
            if (n6 < 0) continue;
            this.fontCurrent.drawFrame(graphics, n6, 0, n2, n3, 0);
            n2 += this.fontCurrent.getFrameWidth(n6, 0) + this.fontCurrent.getFontSpacing();
        }
        return n2 - n5;
    }

    public int drawText(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        return this.drawText(graphics, this.getText(n), n2, n3, n5);
    }

    public void drawTextInRegion(Graphics graphics, char[][] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        int n11 = n > n9 ? n : n9;
        int n12 = n2 > n10 ? n2 : n10;
        int n13 = n2 + n4 < n10 + n8 ? n2 + n4 - n12 : n10 + n8 - n12;
        graphics.setClip(n11, n12, n + n3 < n9 + n7 ? n + n3 - n11 : n9 + n7 - n11, n2 + n4 < n10 + n8 ? n2 + n4 - n12 : n10 + n8 - n12);
        if ((n6 & 1) == 1) {
            n += n3 >> 1;
            n6 = 1;
        } else if ((n6 & 8) == 8) {
            n += n3;
            n6 = 8;
        } else {
            n6 = 4;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (n2 + n5 + this.fontCurrent.getFontHeight() > n12) {
                this.drawText(graphics, cArray[i], n, n2 + n5, n6);
            }
            if (n2 + (n5 += this.fontCurrent.getFontHeight()) > n12 + n13) break;
        }
        graphics.setClip(n9, n10, n7, n8);
    }

    public void drawTextInRegion(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = cArray.length;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        boolean bl = false;
        int n12 = graphics.getClipWidth();
        int n13 = graphics.getClipHeight();
        int n14 = graphics.getClipX();
        int n15 = graphics.getClipY();
        int n16 = n > n14 ? n : n14;
        int n17 = n2 > n15 ? n2 : n15;
        graphics.setClip(n16, n17, n + n3 < n14 + n12 ? n + n3 - n16 : n14 + n12 - n16, n2 + n4 < n15 + n13 ? n2 + n4 - n17 : n15 + n13 - n17);
        while (n5 < n4) {
            char c;
            n11 ^= n11;
            int n18 = -1;
            int n19 = n9;
            while (n11 < n3 || n18 == -1) {
                if (n19 == n7) {
                    n18 = n11;
                    n10 = n19 - 1;
                    bl = true;
                    break;
                }
                c = cArray[n19];
                if (c == '\n') {
                    n10 = n19 - 1;
                    n18 = n11;
                    break;
                }
                if (c == ' ') {
                    n10 = n19 - 1;
                    n18 = n11;
                }
                n11 += this.getCharWidth(c);
                n11 += this.fontCurrent.getFontSpacing();
                ++n19;
            }
            n8 = (n6 & 8) != 0 ? n3 - n18 : ((n6 & 1) != 0 ? (n3 >> 1) - (n18 >> 1) : (n8 ^= n8));
            if (n5 + this.fontCurrent.getFontHeight() > 0) {
                for (int i = n9; i <= n10; ++i) {
                    c = cArray[i];
                    if (c != ' ') {
                        this.fontCurrent.drawFrame(graphics, this.fontTable[c], 0, n + n8, n2 + n5, 0);
                    }
                    n8 += this.getCharWidth(c) + this.fontCurrent.getFontSpacing();
                }
            }
            if (bl) break;
            n9 = n10 + 2;
            n5 += this.fontCurrent.getFontHeight();
        }
        graphics.setClip(n14, n15, n12, n13);
    }

    public void drawTextInRegion(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawTextInRegion(graphics, this.getText(n), n2, n3, n4, n5, n6, n7);
    }

    static Vector splitSystemTextToVect(String string, char c, int n) {
        Font font = Font.getDefaultFont();
        Vector<String> vector = new Vector<String>();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        String string2 = new String();
        while (n3 < n2) {
            int n5;
            int n6 = string.indexOf(c, n3);
            if (n6 < 0) {
                n6 = string.length();
            }
            if ((n5 = string.indexOf(10, n3)) < 0) {
                n5 = string.length();
            }
            int n7 = Math.min(n6, n5);
            String string3 = string.substring(n3, n7);
            if (n4 == 0) {
                string2 = string3;
                n4 = font.stringWidth(string3);
            } else if (font.stringWidth(string2 + c + string3) <= n) {
                string2 = string2 + c + string3;
                n4 = font.stringWidth(string2 + c + string3);
            } else {
                vector.addElement(string2);
                string2 = null;
                string2 = new String(string3);
                n4 = font.stringWidth(string3);
            }
            if (n7 == n5) {
                vector.addElement(string2);
                string2 = null;
                n4 = 0;
            }
            n3 = n7 + 1;
        }
        if (n4 > 0) {
            vector.addElement(string2);
            string2 = null;
        }
        return vector;
    }

    public static String[] splitSystemText(String string, char c, int n) {
        Vector vector = Txt.splitSystemTextToVect(string, c, n);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void drawSystemTextInRegion(Graphics graphics, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        int n11 = n > n9 ? n : n9;
        int n12 = n2 > n10 ? n2 : n10;
        int n13 = n2 + n4 < n10 + n8 ? n2 + n4 - n12 : n10 + n8 - n12;
        graphics.setClip(n11, n12, n + n3 < n9 + n7 ? n + n3 - n11 : n9 + n7 - n11, n2 + n4 < n10 + n8 ? n2 + n4 - n12 : n10 + n8 - n12);
        if ((n6 & 2) == 2 && Txt.getSystemTextHeigth(stringArray) < n4) {
            n2 += (n4 - Txt.getSystemTextHeigth(stringArray)) / 2;
        }
        if ((n6 & 1) == 1) {
            n += n3 >> 1;
            n6 = 17;
        } else if ((n6 & 8) == 8) {
            n += n3;
            n6 = 24;
        } else {
            n6 = 20;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (n2 + n5 + Font.getDefaultFont().getHeight() > n12) {
                graphics.drawString(stringArray[i], n, n2 + n5, n6);
            }
            if (n2 + (n5 += Font.getDefaultFont().getHeight()) > n12 + n13) break;
        }
        graphics.setClip(n9, n10, n7, n8);
    }

    public static int getSystemTextHeigth(String[] stringArray) {
        return stringArray.length * Font.getDefaultFont().getHeight();
    }

    public int getFontCharsLength() {
        if (this.fontChars != null) {
            return this.fontChars.length;
        }
        return -1;
    }
}

