/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects.misslie;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Missile;

public class DoubleLaserMissile
extends Missile {
    public Sprite laser = new Sprite(laserImg, 10, 10);
    public static Image laserImg;
    private int XSPEED = 8;
    private int YSPEED = 8;

    static {
        try {
            laserImg = Image.createImage((String)"/images/LaserFire.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DoubleLaserMissile(int x, int y, boolean good, int dir, GameMediator gm, int pos) {
        super(x, y, good, dir, gm, pos);
    }

    public void draw(Graphics g) {
        int x = this.x - this.gm.mapPosX;
        int y = this.y - this.gm.mapPosY;
        switch (this.dir) {
            case 0: {
                g.setColor(242, 78, 92);
                g.drawRoundRect(x, y - 2, 10, 3, 2, 2);
                g.setColor(0xFFFFFF);
                g.fillRect(x + 1, y - 2, 8, 2);
                break;
            }
            case 1: {
                this.laser.setFrameSequence(new int[]{3});
                this.laser.setPosition(x, y - 3);
                this.laser.paint(g);
                break;
            }
            case 2: {
                g.setColor(242, 78, 92);
                g.drawRoundRect(x, y - 2, 3, 10, 2, 2);
                g.setColor(0xFFFFFF);
                g.fillRect(x + 1, y - 2, 2, 8);
                break;
            }
            case 3: {
                this.laser.setFrameSequence(new int[]{2});
                this.laser.setPosition(x, y - 3);
                this.laser.paint(g);
                break;
            }
            case 4: {
                g.setColor(242, 78, 92);
                g.drawRoundRect(x, y - 2, 10, 3, 2, 2);
                g.setColor(0xFFFFFF);
                g.fillRect(x + 1, y - 2, 8, 2);
                break;
            }
            case 5: {
                this.laser.setFrameSequence(new int[]{3});
                this.laser.setPosition(x, y - 3);
                this.laser.paint(g);
                break;
            }
            case 6: {
                g.setColor(242, 78, 92);
                g.drawRoundRect(x, y - 3, 3, 10, 2, 2);
                g.setColor(0xFFFFFF);
                g.fillRect(x + 1, y - 2, 2, 8);
                break;
            }
            case 7: {
                this.laser.setFrameSequence(new int[]{2});
                this.laser.setPosition(x, y - 3);
                this.laser.paint(g);
            }
        }
        this.move();
    }

    public void move() {
        switch (this.dir) {
            case 0: {
                if (this.pos == 1) {
                    this.y -= 3;
                }
                if (this.pos == 2) {
                    this.y += 7;
                }
                this.pos = 0;
                this.x -= this.XSPEED;
                break;
            }
            case 1: {
                if (this.pos == 1) {
                    this.x += 2;
                    this.y -= 3;
                }
                if (this.pos == 2) {
                    this.x -= 2;
                    this.y += 3;
                }
                this.pos = 0;
                this.x -= this.XSPEED - 1;
                this.y -= this.YSPEED - 1;
                break;
            }
            case 2: {
                if (this.pos == 1) {
                    this.x -= 5;
                }
                if (this.pos == 2) {
                    this.x += 5;
                }
                this.pos = 0;
                this.y -= this.YSPEED;
                break;
            }
            case 3: {
                if (this.pos == 1) {
                    this.x -= 2;
                    this.y -= 3;
                }
                if (this.pos == 2) {
                    this.x += 2;
                    this.y += 3;
                }
                this.pos = 0;
                this.y -= this.YSPEED - 1;
                this.x += this.XSPEED - 1;
                break;
            }
            case 4: {
                if (this.pos == 1) {
                    this.y -= 3;
                }
                if (this.pos == 2) {
                    this.y += 7;
                }
                this.pos = 0;
                this.x += this.XSPEED;
                break;
            }
            case 5: {
                if (this.pos == 1) {
                    this.x -= 2;
                    this.y += 3;
                }
                if (this.pos == 2) {
                    this.x += 2;
                    this.y -= 3;
                }
                this.pos = 0;
                this.x += this.XSPEED - 1;
                this.y += this.YSPEED - 1;
                break;
            }
            case 6: {
                if (this.pos == 1) {
                    this.x -= 5;
                }
                if (this.pos == 2) {
                    this.x += 5;
                }
                this.pos = 0;
                this.y += this.YSPEED;
                break;
            }
            case 7: {
                if (this.pos == 1) {
                    this.x -= 2;
                    this.y -= 3;
                }
                if (this.pos == 2) {
                    this.x += 2;
                    this.y += 3;
                }
                this.pos = 0;
                this.x -= this.XSPEED - 1;
                this.y += this.YSPEED - 1;
            }
        }
        this.rect.x = this.x;
        this.rect.y = this.y;
        this.checkBounds();
    }
}

