/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects.tanks;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.misslie.DoubleLaserMissile;
import org.kyxh.tank.util.Direction;

public class GhostTank
extends Tank {
    int XSPEED = 3;
    int YSPEED = 3;
    public Sprite laserTank;
    public static Image laserTankImg;

    static {
        try {
            laserTankImg = Image.createImage((String)"/images/tank/LaserTank.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GhostTank(int x, int y, boolean good, int dir, GameMediator gm) {
        super(x, y, good, dir, gm);
        if (good) {
            GameMediator.myTankSpeed = this.XSPEED;
        }
        this.laserTank = new Sprite(laserTankImg, 20, 20);
    }

    public void draw(Graphics g) {
        int x = this.x - this.gm.mapPosX;
        int y = this.y - this.gm.mapPosY;
        if (!this.live && !this.good) {
            this.gm.gameObjects.remove(this);
            return;
        }
        if (!this.live) {
            return;
        }
        this.move();
        this.laserTank.setFrameSequence(new int[]{this.ptdir});
        this.laserTank.setPosition(x, y);
        if (x < 280 && x > -40 && y < 340 && y > -40) {
            this.laserTank.paint(g);
        }
        this.drawOnMap(g);
    }

    protected void move() {
        this.oldX = this.x;
        this.oldY = this.y;
        if (!this.good) {
            if (this.step == 0) {
                int rn;
                this.step = Tank.r.nextInt(30) + 8;
                this.dir = rn = Tank.r.nextInt(8);
            }
            --this.step;
            if (Tank.r.nextInt(40) > 37) {
                this.fire(this.ptdir);
            }
        }
        switch (this.dir) {
            case 0: {
                this.x -= this.XSPEED + 1;
                break;
            }
            case 1: {
                this.x -= this.XSPEED;
                this.y -= this.YSPEED;
                break;
            }
            case 2: {
                this.y -= this.YSPEED + 1;
                break;
            }
            case 3: {
                this.y -= this.YSPEED;
                this.x += this.XSPEED;
                break;
            }
            case 4: {
                this.x += this.XSPEED + 1;
                break;
            }
            case 5: {
                this.x += this.XSPEED;
                this.y += this.YSPEED;
                break;
            }
            case 6: {
                this.y += this.YSPEED + 1;
                break;
            }
            case 7: {
                this.x -= this.XSPEED;
                this.y += this.YSPEED;
            }
        }
        if (this.dir != Direction.STOP) {
            this.ptdir = this.dir;
        }
        this.rect.x = this.x;
        this.rect.y = this.y;
        this.checkBounds();
    }

    public void fire(int dir) {
        int x = this.x + Tank.WIDTH / 2;
        int y = this.y + Tank.HEIGHT / 2;
        this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, dir, this.gm, 1));
        this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, dir, this.gm, 2));
    }
}

