/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects.tanks;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.misslie.DoubleLaserMissile;

public class LaserTank
extends Tank {
    public Sprite laserTank;
    public static int WIDTH = 20;
    public static int HEIGHT = 20;
    int XSPEED = 5;
    int YSPEED = 5;
    public static Image laserTankImg;
    public int step = 0;

    static {
        try {
            laserTankImg = Image.createImage((String)"/images/tank/LaserTank1.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LaserTank(int x, int y, boolean good, int dir, GameMediator gm) {
        super(x, y, good, dir, gm);
        if (good) {
            GameMediator.myTankSpeed = this.XSPEED;
        }
        this.laserTank = new Sprite(laserTankImg, 20, 20);
    }

    public void draw(Graphics g) {
        int x = this.x - this.gm.mapPosX;
        int y = this.y - this.gm.mapPosY;
        if (this.step < 25) {
            ++this.step;
        }
        if (!this.live && !this.good) {
            this.gm.gameObjects.remove(this);
            return;
        }
        if (this.good && this.live) {
            g.setColor(0x808080);
            g.fillRect(x - 5, y - 15, WIDTH + 10, 8);
            g.setColor(0);
            g.fillRect(x - 4, y - 14, WIDTH + 8, 6);
            if (this.hp < 31) {
                g.setColor(0xFF0000);
            } else if (this.hp < 65) {
                g.setColor(0xFFFF00);
            } else {
                g.setColor(32768);
            }
        } else {
            return;
        }
        g.fillRect(x - 4, y - 14, (WIDTH + 7) * this.hp / 100, 6);
        this.move();
        this.laserTank.setFrameSequence(new int[]{this.ptdir});
        this.laserTank.setPosition(x, y);
        if (x < 280 && x > -40 && y < 340 && y > -40) {
            this.laserTank.paint(g);
        }
        this.drawOnMap(g);
    }

    public void fire(int dir) {
        int x = this.x + WIDTH / 2;
        int y = this.y + HEIGHT / 2;
        if (this.live && this.step > 10) {
            this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, dir, this.gm, 1));
            this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, dir, this.gm, 2));
            this.step = 0;
        }
    }
}

