/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects.tanks;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import org.kyxh.tank.TankClient;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.misslie.LittleMissile;

public class LittleTank
extends Tank {
    public static Sprite sp;
    public static Image im;
    private int step = 0;

    static {
        try {
            im = Image.createImage((String)"/images/tank/littletank.png");
            sp = new Sprite(im, 20, 20);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LittleTank(int x, int y, boolean good, int dir, GameMediator gm) {
        super(x, y, good, dir, gm);
        if (good) {
            GameMediator.myTankSpeed = Tank.XSPEED;
        }
    }

    public LittleTank(int x, int y, boolean good, int dir, GameMediator gm, int id, String name) {
        super(x, y, good, dir, gm);
        GameMediator.myTankSpeed = Tank.XSPEED;
        sp = new Sprite(im, 20, 20);
        this.id = id;
        this.name = name;
    }

    public void draw(Graphics g) {
        int x = this.x - this.gm.mapPosX;
        int y = this.y - this.gm.mapPosY;
        if (this.step < 25) {
            ++this.step;
        }
        if (!this.live && !this.good) {
            this.gm.gameObjects.remove(this);
            return;
        }
        if (this.good && this.live) {
            g.setColor(0x808080);
            g.fillRect(x - 5, y - 15, Tank.WIDTH + 10, 8);
            g.setColor(0);
            g.fillRect(x - 4, y - 14, Tank.WIDTH + 8, 6);
            if (this.hp < 31) {
                g.setColor(0xFF0000);
            } else if (this.hp < 65) {
                g.setColor(0xFFFF00);
            } else {
                g.setColor(32768);
            }
            g.fillRect(x - 4, y - 14, (Tank.WIDTH + 7) * this.hp / 100, 6);
        }
        if (!this.live) {
            return;
        }
        this.move();
        sp.setFrameSequence(new int[]{this.ptdir});
        sp.setPosition(x, y);
        if (x < 280 && x > -40 && y < 340 && y > -40) {
            sp.paint(g);
        }
        this.drawOnMap(g);
    }

    public void fire(int dir) {
        if (this.step > 10 && this.good) {
            if (!this.live) {
                return;
            }
            int x = this.x + Tank.WIDTH / 2;
            int y = this.y + Tank.HEIGHT / 2;
            this.gm.gameObjects.add(new LittleMissile(x, y, this.good, dir, this.gm, 0, this.id));
            this.step = 0;
        } else if (!this.good) {
            if (!this.live) {
                return;
            }
            if (!TankClient.gameClient) {
                int x = this.x + Tank.WIDTH / 2;
                int y = this.y + Tank.HEIGHT / 2;
                this.gm.gameObjects.add(new LittleMissile(x, y, this.good, dir, this.gm, 0));
            } else if (this.step > 10) {
                int x = this.x + Tank.WIDTH / 2;
                int y = this.y + Tank.HEIGHT / 2;
                this.gm.gameObjects.add(new LittleMissile(x, y, this.good, dir, this.gm, 0, this.id));
                this.step = 0;
            }
        }
    }
}

