/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class BufferedImage {
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    protected int offx;
    protected int offy;
    protected int Offx;
    protected int Offy;
    protected Image buf;
    protected Graphics bg;

    public BufferedImage(int w, int h) {
        this.w = w;
        this.h = h;
        this.buf = Image.createImage((int)w, (int)h);
        this.bg = this.buf.getGraphics();
        this.bufferImpl(0, 0, w, h);
    }

    public final void paint(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int tempx = this.offx % this.w;
        int tempy = this.offy % this.h;
        g.clipRect(this.x, this.y, this.w - tempx, this.h - tempy);
        g.drawImage(this.buf, this.x - tempx, this.y - tempy, 0);
        g.setClip(clipX, clipY, clipW, clipH);
        if (tempx > 0) {
            g.clipRect(this.x - tempx + this.w, this.y, tempx, this.h - tempy);
            g.drawImage(this.buf, this.x - tempx + this.w, this.y - tempy, 0);
            g.setClip(clipX, clipY, clipW, clipH);
        }
        if (tempy > 0) {
            g.clipRect(this.x, this.y - tempy + this.h, this.w - tempx, tempy);
            g.drawImage(this.buf, this.x - tempx, this.y - tempy + this.h, 0);
            g.setClip(clipX, clipY, clipW, clipH);
        }
        if (tempx > 0 && tempy > 0) {
            g.clipRect(this.x - tempx + this.w, this.y - tempy + this.h, tempx, tempy);
            g.drawImage(this.buf, this.x - tempx + this.w, this.y - tempy + this.h, 0);
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }

    public final void scroll(int dx, int dy) {
        this.Offx += dx;
        this.Offy += dy;
    }

    public final void scrollTo(int x, int y) {
        this.Offx = x;
        this.Offy = y;
    }

    public final void buffer(boolean force) {
        if (!force && this.Offx == this.offx && this.Offy == this.offy) {
            return;
        }
        if (force || Math.abs(this.Offx - this.offx) >= this.w || Math.abs(this.Offy - this.offy) >= this.h) {
            this.bufferImpl(0, 0, this.w, this.h);
        } else {
            int minX = Math.min(this.Offx % this.w, this.offx % this.w);
            int maxX = Math.max(this.Offx % this.w, this.offx % this.w);
            int minY = Math.min(this.Offy % this.h, this.offy % this.h);
            int maxY = Math.max(this.Offy % this.h, this.offy % this.h);
            if (this.Offx / this.w == this.offx / this.w && this.Offy / this.h == this.offy / this.h) {
                this.bufferImpl(minX, 0, maxX - minX, minY);
                this.bufferImpl(0, minY, this.w, maxY - minY);
                this.bufferImpl(minX, maxY, maxX - minX, this.h - maxY);
            } else if (this.Offx / this.w == this.offx / this.w) {
                this.bufferImpl(0, 0, this.w, minY);
                this.bufferImpl(minX, minY, maxX - minX, maxY - minY);
                this.bufferImpl(0, maxY, this.w, this.h - maxY);
            } else if (this.Offy / this.h == this.offy / this.h) {
                this.bufferImpl(0, 0, minX, this.h);
                this.bufferImpl(minX, minY, maxX - minX, maxY - minY);
                this.bufferImpl(maxX, 0, this.w - maxX, this.h);
            } else {
                this.bufferImpl(0, 0, this.w, minY);
                this.bufferImpl(0, minY, minX, maxY - minY);
                this.bufferImpl(maxX, minY, this.w - maxX, maxY - minY);
                this.bufferImpl(0, maxY, this.w, this.h - maxY);
            }
        }
    }

    private final void bufferImpl(int clipX, int clipY, int clipW, int clipH) {
        if (clipW <= 0 || clipH <= 0) {
            return;
        }
        int tempx = this.Offx % this.w;
        int tempy = this.Offy % this.h;
        this.bg.translate(-this.bg.getTranslateX(), -this.bg.getTranslateY());
        this.bg.translate(-(this.Offx - tempx), -(this.Offy - tempy));
        this.bg.setClip(this.Offx, this.Offy, this.w - tempx, this.h - tempy);
        this.drawBuffer(this.bg);
        if (tempx > 0) {
            this.bg.translate(-this.bg.getTranslateX(), -this.bg.getTranslateY());
            this.bg.translate(-(this.Offx - tempx + this.w), -(this.Offy - tempy));
            this.bg.setClip(this.Offx - tempx + this.w, this.Offy, tempx, this.h - tempy);
            this.drawBuffer(this.bg);
        }
        if (tempy > 0) {
            this.bg.translate(-this.bg.getTranslateX(), -this.bg.getTranslateY());
            this.bg.translate(-(this.Offx - tempx), -(this.Offy - tempy + this.h));
            this.bg.setClip(this.Offx, this.Offy - tempy + this.h, this.w - tempx, tempy);
            this.drawBuffer(this.bg);
        }
        if (tempx > 0 && tempy > 0) {
            this.bg.translate(-this.bg.getTranslateX(), -this.bg.getTranslateY());
            this.bg.translate(-(this.Offx - tempx + this.w), -(this.Offy - tempy + this.h));
            this.bg.setClip(this.Offx - tempx + this.w, this.Offy - tempy + this.h, tempx, tempy);
            this.drawBuffer(this.bg);
        }
        this.offx = this.Offx;
        this.offy = this.Offy;
    }

    protected abstract void drawBuffer(Graphics var1);
}

