/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.util;

import org.kyxh.tank.gameobjects.Tank;

public class List {
    private Object[] elementData = new Object[10];
    private int[] ids = new int[10];
    private int sizeasd = 0;
    boolean flag = false;
    int count = 0;

    public boolean add(Object o) {
        this.ensureCapacity(this.sizeasd + 1);
        this.elementData[this.sizeasd++] = o;
        return true;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.sizeasd);
        }
    }

    public Object get(int index) {
        if (this.RangeCheck(index)) {
            return this.elementData[index];
        }
        return null;
    }

    private boolean RangeCheck(int index) {
        return index < this.sizeasd && index >= 0;
    }

    public Object remove(int index) {
        this.RangeCheck(index);
        Object oldValue = this.elementData[index];
        int numMoved = this.sizeasd - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.sizeasd] = null;
        return oldValue;
    }

    public Object remove(Object obj) {
        int i = 0;
        while (i < this.sizeasd) {
            if (obj == this.elementData[i]) {
                return this.remove(i);
            }
            ++i;
        }
        return null;
    }

    public void clear() {
        int i = 0;
        while (i < this.sizeasd) {
            this.elementData[i] = null;
            ++i;
        }
        this.sizeasd = 0;
    }

    public void copy(List l) {
        System.arraycopy(l.elementData, 0, this.elementData, 0, l.sizeasd);
        this.sizeasd = l.sizeasd;
    }

    public void modifyptdir(int id, int ptDir) {
        int i = 0;
        while (i < this.sizeasd) {
            if (this.get(i) instanceof Tank) {
                Tank srcTank = (Tank)this.get(i);
                if (srcTank.id == id) {
                    srcTank.ptdir = ptDir;
                }
            }
            ++i;
        }
    }

    public void modifydir(int id, int dir) {
        int i = 0;
        while (i < this.sizeasd) {
            if (this.get(i) instanceof Tank) {
                Tank srcTank = (Tank)this.get(i);
                if (srcTank.id == id) {
                    srcTank.dir = dir;
                }
            }
            ++i;
        }
    }

    public void fire(int id) {
        int i = 0;
        while (i < this.sizeasd) {
            if (this.get(i) instanceof Tank) {
                Tank srcTank = (Tank)this.get(i);
                if (srcTank.id == id) {
                    srcTank.fire(srcTank.ptdir);
                }
            }
            ++i;
        }
    }

    public void replace(List gameObjects) {
        this.flag = false;
        while (!this.flag) {
            this.count = 0;
            while (this.count < this.sizeasd) {
                if (this.get(this.count) != null && this.get(this.count) instanceof Tank) {
                    this.remove(this.count);
                    break;
                }
                ++this.count;
            }
            if (this.count != this.sizeasd) continue;
            this.flag = true;
        }
        if (gameObjects.sizeasd > 0) {
            int j = 0;
            while (j < gameObjects.sizeasd) {
                if (gameObjects.get(j) instanceof Tank) {
                    Tank destTank = (Tank)gameObjects.get(j);
                    this.add(destTank);
                }
                ++j;
            }
        }
    }

    public int getSize() {
        return this.sizeasd;
    }

    public void koFire(int id) {
        int i = 0;
        while (i < this.sizeasd) {
            if (this.get(i) instanceof Tank) {
                Tank srcTank = (Tank)this.get(i);
                if (srcTank.id == id) {
                    srcTank.koFire();
                }
            }
            ++i;
        }
    }

    public void reborn(int id) {
        int i = 0;
        while (i < this.sizeasd) {
            if (this.get(i) instanceof Tank) {
                Tank srcTank = (Tank)this.get(i);
                if (srcTank.id == id) {
                    srcTank.superFirex(true);
                }
            }
            ++i;
        }
    }
}

