/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.stdlib;

import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaPrototype;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTableImpl;
import se.krka.kahlua.vm.LuaThread;

public class CoroutineLib
implements JavaFunction {
    private static final int CREATE = 0;
    private static final int RESUME = 1;
    private static final int YIELD = 2;
    private static final int STATUS = 3;
    private static final int RUNNING = 4;
    private static final int NUM_FUNCTIONS = 5;
    private static final String[] names;
    private static final Class LUA_THREAD_CLASS;
    private int index;
    private static CoroutineLib[] functions;

    public String toString() {
        return "coroutine." + names[this.index];
    }

    public CoroutineLib(int index) {
        this.index = index;
    }

    public static void register(LuaState state) {
        LuaTableImpl coroutine = new LuaTableImpl();
        state.getEnvironment().rawset("coroutine", (Object)coroutine);
        for (int i2 = 0; i2 < 5; ++i2) {
            coroutine.rawset(names[i2], (Object)functions[i2]);
        }
        coroutine.rawset("__index", (Object)coroutine);
        state.setUserdataMetatable(LUA_THREAD_CLASS, coroutine);
    }

    public int call(LuaCallFrame callFrame, int nArguments) {
        switch (this.index) {
            case 0: {
                return this.create(callFrame, nArguments);
            }
            case 2: {
                return CoroutineLib.yield(callFrame, nArguments);
            }
            case 1: {
                return this.resume(callFrame, nArguments);
            }
            case 3: {
                return this.status(callFrame, nArguments);
            }
            case 4: {
                return this.running(callFrame, nArguments);
            }
        }
        return 0;
    }

    private int running(LuaCallFrame callFrame, int nArguments) {
        LuaThread t2 = callFrame.thread;
        if (t2.parent == null) {
            t2 = null;
        }
        callFrame.push(t2);
        return 1;
    }

    private int status(LuaCallFrame callFrame, int nArguments) {
        LuaThread t2 = this.getCoroutine(callFrame, nArguments);
        String status = this.getStatus(t2, callFrame.thread);
        callFrame.push(status);
        return 1;
    }

    private String getStatus(LuaThread t2, LuaThread caller) {
        String status = null;
        status = t2.parent == null ? (t2.isDead() ? "dead" : "suspended") : (caller == t2 ? "running" : "normal");
        return status;
    }

    private int resume(LuaCallFrame callFrame, int nArguments) {
        LuaThread parent;
        LuaThread t2 = this.getCoroutine(callFrame, nArguments);
        String status = this.getStatus(t2, callFrame.thread);
        if (status != "suspended") {
            BaseLib.fail("Can not resume thread that is in status: " + status);
        }
        t2.parent = parent = callFrame.thread;
        LuaCallFrame nextCallFrame = t2.currentCallFrame();
        if (nextCallFrame.nArguments == -1) {
            nextCallFrame.setTop(0);
        }
        for (int i2 = 1; i2 < nArguments; ++i2) {
            nextCallFrame.push(callFrame.get(i2));
        }
        if (nextCallFrame.nArguments == -1) {
            nextCallFrame.nArguments = nArguments - 1;
            nextCallFrame.init();
        }
        callFrame.thread.state.currentThread = t2;
        return 0;
    }

    public static int yield(LuaCallFrame callFrame, int nArguments) {
        LuaThread t2 = callFrame.thread;
        LuaThread parent = t2.parent;
        BaseLib.luaAssert(parent != null, "Can not yield outside of a coroutine");
        LuaCallFrame realCallFrame = t2.callFrameStack[t2.callFrameTop - 2];
        CoroutineLib.yieldHelper(realCallFrame, callFrame, nArguments);
        return 0;
    }

    public static void yieldHelper(LuaCallFrame callFrame, LuaCallFrame argsCallFrame, int nArguments) {
        BaseLib.luaAssert(callFrame.insideCoroutine, "Can not yield outside of a coroutine");
        LuaThread t2 = callFrame.thread;
        LuaThread parent = t2.parent;
        t2.parent = null;
        LuaCallFrame nextCallFrame = parent.currentCallFrame();
        nextCallFrame.push(LuaPrototype.bTRUE);
        for (int i2 = 0; i2 < nArguments; ++i2) {
            Object value = argsCallFrame.get(i2);
            nextCallFrame.push(value);
        }
        t2.state.currentThread = parent;
    }

    private int create(LuaCallFrame callFrame, int nArguments) {
        LuaClosure c2 = this.getFunction(callFrame, nArguments);
        LuaThread newThread = new LuaThread(callFrame.thread.state, callFrame.thread.environment);
        newThread.pushNewCallFrame(c2, 0, 0, -1, true, true);
        callFrame.push(newThread);
        return 1;
    }

    private LuaClosure getFunction(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "not enough arguments");
        Object o2 = callFrame.get(0);
        BaseLib.luaAssert(o2 instanceof LuaClosure, "argument 1 must be a lua function");
        LuaClosure c2 = (LuaClosure)o2;
        return c2;
    }

    private LuaThread getCoroutine(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "not enough arguments");
        Object o2 = callFrame.get(0);
        BaseLib.luaAssert(o2 instanceof LuaThread, "argument 1 must be a coroutine");
        LuaThread t2 = (LuaThread)o2;
        return t2;
    }

    static {
        LUA_THREAD_CLASS = new LuaThread(null, null).getClass();
        names = new String[5];
        CoroutineLib.names[0] = "create";
        CoroutineLib.names[1] = "resume";
        CoroutineLib.names[2] = "yield";
        CoroutineLib.names[3] = "status";
        CoroutineLib.names[4] = "running";
        functions = new CoroutineLib[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            CoroutineLib.functions[i2] = new CoroutineLib(i2);
        }
    }
}

