/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import javax.microedition.lcdui.Graphics;
import tjge.Animation;
import tjge.Assistant;
import tjge.BaiZhanTang;
import tjge.Boss;
import tjge.BridgeBoard;
import tjge.EnemyMind;
import tjge.EnemyThing;
import tjge.EnemyThrow;
import tjge.Flagon;
import tjge.Function;
import tjge.GameScreen;
import tjge.Hen;
import tjge.MainFriend;
import tjge.Scene;
import tjge.TiledBackground;

public class Actor {
    public static final int ACTOR_BAIZHANTANG = 0;
    public static final int ACTOR_GUOFURONG = 2;
    public static final int ACTOR_LIDAZUI = 3;
    public static final int ACTOR_MOXIAOBEI = 4;
    public static final int ACTOR_PIG = 5;
    public static final int ACTOR_THIEF = 6;
    public static final int ACTOR_THIEF_SCUTE = 7;
    public static final int ACTOR_DOG = 8;
    public static final int ACTOR_HEN = 9;
    public static final int ACTOR_BLACKHUMAN = 10;
    public static final int ACTOR_BURNHUMAN = 11;
    public static final int ACTOR_HUMANCAKE = 12;
    public static final int ACTOR_DOG_CAKE = 13;
    public static final int ACTOR_PIG_CAKE = 14;
    public static final int ACTOR_PROP = 15;
    public static final int ACTOR_BOMB = 16;
    public static final int ACTOR_COIN = 17;
    public static final int ACTOR_BAG_FOOD = 18;
    public static final int ACTOR_BONE = 20;
    public static final int ACTOR_EGG = 21;
    public static final int ACTOR_DUST = 23;
    public static final int ACTOR_STUB = 24;
    public static final int ACTOR_SPRAY = 25;
    public static final int ACTOR_BRIDGE_BOARD = 27;
    public static final int ACTOR_FLAGON = 29;
    public static final int ACTOR_FLASH_VIEW = 30;
    public static final int ACTOR_BIG_GUN = 31;
    public static final int ACTOR_XIN_BU_TOU = 32;
    public static final int ACTOR_LV_XIU_CAI = 34;
    public static final int ACTOR_TONG_XIANG_YU = 35;
    public static final int ACTOR_BOSS = 36;
    public static final int ACTOR_BURN_HEN = 39;
    public static final int ACTOR_BURN_PIG = 40;
    public static final int ACTOR_BURN_DOG = 41;
    public static final int ACTOR_SPRINT = 42;
    public static final int ACTOR_FLOWER = 43;
    public static final int ACTOR_BUTTOM = 44;
    public static final int[] ACTOR_PRIORITY = new int[]{20, 40, 21, 21, 21, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 25, 25, 25, 25, 25, 25, 25, 19, 25, 15, 23, 17, 15, 22, 26, 30, 16, 16, 16, 16, 16, 16, 22, 22, 10, 17, 17, 17, 30, 30};
    public static final int C_HURT_NO_ATTACK = -1;
    public static final int C_HURT_BAI_NORMAL = 0;
    public static final int C_HURT_BAI_TICK_OUT = 1;
    public static final int C_HURT_BAI_BREAK_OUT_1 = 2;
    public static final int C_HURT_BAI_BREAK_OUT_2 = 3;
    public static final int C_HURT_BAI_BREAK_OUT_3 = 4;
    public static final int C_HURT_BAI_SUN_FLOWER = 5;
    public static final int C_HURT_GUO_MOUNTAIN = 6;
    public static final int C_HURT_LI_TOP_DOWN = 7;
    public static final int C_HURT_MO_PIG = 8;
    public static final int C_HURT_ENEMY_BUMP = 9;
    public static final int C_HURT_ENEMY_THROW = 10;
    public static final int C_HURT_ENEMY_NORMAL = 11;
    public static final int C_HURT_EXPLOSION = 12;
    public static final int C_HURT_BOSS_THROW = 13;
    public static final int C_HURT_CANNON = 14;
    public static final int C_HURT_PIG_RUN = 15;
    public static final int C_HURT_BLACKMAN_KICK = 16;
    public static final int C_HURT_FLAGON = 17;
    public static final int C_HURT_EGG = 18;
    public static final int C_COLLIDE_BAIZHANTANG = 19;
    public static final int[] C_HURT_HP = new int[]{3, 3, 2, 2, 2, 4, 40, 40, 3, 1, 1, 1, 6, 6, 6, 2, 3, 3, 3, 0};
    public static final int C_FLIP_MASK = -268435456;
    public static final int C_ON_MASK = 0xFF0000;
    public static final int C_ACT_MASK = 65535;
    public static final byte C_FIXED_PARAM_SIZE = 7;
    public static final byte C_PARAM_TYPE_OFFSET = 0;
    public static final byte C_PARAM_XPOS_OFFSET = 1;
    public static final byte C_PARAM_YPOS_OFFSET = 3;
    public static final byte C_PARAM_ACT_OFFSET = 5;
    public static final byte C_PARAM_SKIN_OFFSET = 6;
    public static final byte C_PARAM_0 = 7;
    public static final byte C_PARAM_1 = 8;
    public static final byte C_PARAM_2 = 9;
    public static final byte C_PARAM_3 = 10;
    public static final byte C_PARAM_4 = 11;
    public static final int C_AIM_DISPLAY = 0;
    public static final int C_AIM_MAIN = 1;
    public static final int C_AIM_ENEMY = 2;
    public static final int C_AIM_THINGS = 4;
    public static final int C_AIM_PLATFROM = 8;
    public static final int C_BOX_COLLISON = 0;
    public static final int C_BOX_ATTACK = 1;
    public static final int C_FRACTION_BITS = 10;
    public static final int C_GRAVITY = 3072;
    public static final int C_FINAL_VY = 15360;
    public static final int C_FINAL_VX = 15360;
    private static final int C_SEQUENCE_INTERVAL = 1000000;
    private static int _sequence = 0;
    public boolean _active;
    public boolean _visible;
    public boolean _onWater;
    public boolean _onGround;
    public boolean _onPreGround;
    protected int _type;
    protected int _flicker;
    protected int _actionNum;
    protected int _curAction;
    protected int _action;
    protected int _flipFlag;
    protected boolean _isFlip;
    private boolean _actionEnd;
    protected boolean _loopAction;
    protected int _curFrame;
    protected short _actFrmNum;
    protected int _l;
    protected int _r;
    protected int _t;
    protected int _b;
    protected int _al;
    protected int _ar;
    protected int _at;
    protected int _ab;
    public int _id;
    public int _x;
    public int _y;
    public int _dx;
    public int _dy;
    public int _vx;
    public int _vy;
    public int _ax;
    public int _ay;
    public int _fx;
    public int _fy;
    protected int _gravity;
    public int _palNo;
    protected int _toff;
    protected int _boff;
    private int _ownSequence;
    private int _opponentSequence;
    public int _relation;
    public int _ownKind;
    protected int _priority;
    protected int _state;
    protected boolean _onPasspoint;
    protected int _curPasspointFlip;
    protected int _curPasspointPathId;
    protected boolean _onPasspath;
    protected boolean _curPasspathFlip;
    protected int _curPasspathTxpos;
    protected int _curPasspathTypos;
    protected Animation _anim;
    protected GameScreen _gs;
    protected Scene _scene;
    protected TiledBackground _bk;
    protected static final int C_MAX_ACT_RANGE_NUM = 10;
    protected int _preAction;
    public boolean _deviceReady = false;

    public Actor(int n, Animation animation) {
        this._type = n;
        this._anim = animation;
        this._actionNum = animation.getActionNum();
        this._active = false;
        this._priority = ACTOR_PRIORITY[this._type];
        this.fetchOwnSequence();
    }

    public static final Actor createActor(int n, Animation animation) {
        switch (n) {
            case 0: {
                return new BaiZhanTang(n, animation);
            }
            case 2: 
            case 3: 
            case 4: {
                return new MainFriend(n, animation);
            }
            case 27: {
                return new BridgeBoard(n, animation);
            }
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 30: 
            case 42: {
                return new Assistant(n, animation);
            }
            case 29: {
                return new Flagon(n, animation);
            }
            case 5: 
            case 6: 
            case 7: {
                return new EnemyMind(n, animation);
            }
            case 36: {
                return new Boss(n, animation);
            }
            case 9: {
                return new Hen(n, animation);
            }
            case 8: 
            case 10: 
            case 31: {
                return new EnemyThrow(n, animation);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 43: {
                return new EnemyThing(n, animation);
            }
        }
        return new Actor(n, animation);
    }

    protected boolean init(byte[] byArray) {
        this._x = Function.readInt(byArray, 1, 2) << 10;
        this._y = Function.readInt(byArray, 3, 2) << 10;
        this._palNo = byArray[6];
        int n = byArray[5] & 0x3F;
        if ((byArray[5] & 0x80) != 0) {
            n |= Integer.MIN_VALUE;
        }
        if ((byArray[5] & 0x40) != 0) {
            n |= 0x40000000;
        }
        this.changeAction(n);
        this._dy = 0;
        this._dx = 0;
        this._vy = 0;
        this._vx = 0;
        this._ay = 0;
        this._ax = 0;
        this._boff = 2;
        this._toff = 2;
        this._fx = 15360;
        this._fy = 15360;
        this._flicker = 0;
        this._onGround = true;
        this._onPreGround = true;
        this._loopAction = true;
        this._onWater = false;
        this._onPasspath = false;
        this._gravity = 3072;
        this._deviceReady = false;
        return true;
    }

    protected final void init() {
        this._x = 0;
        this._y = 0;
        this._palNo = 0;
        this._dy = 0;
        this._dx = 0;
        this._vy = 0;
        this._vx = 0;
        this._ay = 0;
        this._ax = 0;
        this._boff = 2;
        this._toff = 2;
        this._fx = 15360;
        this._fy = 15360;
        this._flicker = 0;
        this._onGround = true;
        this._loopAction = true;
        this._onWater = false;
        this._onPasspath = false;
        this._gravity = 3072;
        this.changeAction(0);
    }

    protected final void init(int n, int n2, int n3, int n4) {
        this.init();
        this._state = n;
        this._x = n3;
        this._y = n4;
        this.changeAction(n2);
    }

    protected final void init(int n, int n2, int n3, int n4, int n5, int n6) {
        this.init(n, n2, n3, n4);
        this._vx = n5;
        this._vy = n6;
    }

    public final Actor activate(Scene scene, int n) {
        this._id = n;
        this._active = true;
        this._scene = scene;
        this._gs = scene.getScreen();
        this._bk = scene.getBackground();
        return this;
    }

    public void disActive() {
        this._scene.disActiveInst(this._id);
    }

    public final void disLife() {
        if (!this._active) {
            return;
        }
        this._scene.disLifeInst(this._id);
    }

    public final void changeAction(int n) {
        this._preAction = this._curAction;
        this._curAction = n;
        if ((n &= 0xFFFF) < 0 || n > this._anim.getActionNum()) {
            return;
        }
        if ((this._curAction & Integer.MIN_VALUE) == 0) {
            this._l = this._anim._l[n];
            this._r = this._anim._r[n];
        } else {
            this._l = -this._anim._r[n];
            this._r = -this._anim._l[n];
        }
        if ((this._curAction & 0x40000000) == 0) {
            this._t = this._anim._t[n];
            this._b = this._anim._b[n];
        } else {
            this._t = -this._anim._b[n];
            this._b = -this._anim._t[n];
        }
        this._actFrmNum = this._anim.getActFrmNum(n);
        this._curFrame = 0;
        this._actionEnd = false;
        this._action = n;
        this._flipFlag = this._curAction & 0xF0000000;
        this._isFlip = (this._curAction & 0xF0000000) != 0;
        this.ownSequenceAdd();
    }

    public final void nextFrame() {
        ++this._curFrame;
        if (this._curFrame >= this._actFrmNum) {
            this._curFrame = this._loopAction ? 0 : --this._curFrame;
            this._actionEnd = true;
        }
    }

    public final boolean isActionEnd() {
        return this._actionEnd;
    }

    public void step() {
        this.nextFrame();
        this._dx = this._vx;
        this._dy = this._vy;
        this._vx += this._ax;
        if (this._ax > 0 && this._vx > this._fx) {
            this._vx = this._fx;
        }
        if (this._ax < 0 && this._vx < -this._fx) {
            this._vx = -this._fx;
        }
        this._vy += this._ay;
        if (this._ay > 0 && this._vy > this._fy) {
            this._vy = this._fy;
        }
        if (this._ay < 0 && this._vy < -this._fy) {
            this._vy = -this._fy;
        }
        this._x += this._dx;
        this._y += this._dy;
    }

    public void ai() {
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this._flicker == 0 || --this._flicker > 0 && (this._flicker & 1) != 0) {
            short s2;
            short s3;
            short s4;
            short s5;
            int n3 = (this._x >> 10) - n;
            int n4 = (this._y >> 10) - n2 + TiledBackground.C_MAP_OFF_Y;
            int n5 = this._curAction & Integer.MIN_VALUE;
            int n6 = this._curAction & 0x40000000;
            if (n5 != 0) {
                s5 = -this._anim._vr;
                s4 = -this._anim._vl;
            } else {
                s5 = this._anim._vl;
                s4 = this._anim._vr;
            }
            if (n3 + s4 < 0 || n3 + s5 > 240) {
                this._visible = false;
                return;
            }
            if (n6 != 0) {
                s3 = -this._anim._vb;
                s2 = -this._anim._vt;
            } else {
                s3 = this._anim._vt;
                s2 = this._anim._vb;
            }
            if (n4 + s2 < TiledBackground.C_MAP_OFF_Y || n4 + s3 > 320) {
                this._visible = false;
                return;
            }
            this._visible = true;
            this._anim.draw(graphics, n3, n4, this._curAction, this._curFrame, this._palNo);
        }
    }

    public final boolean collide(int n, int n2, int n3, int n4) {
        if (this._l == this._r || this._t == this._b || n == n3 || n2 == n4) {
            return false;
        }
        int n5 = (this._x >> 10) + this._l;
        int n6 = (this._x >> 10) + this._r;
        int n7 = (this._y >> 10) + this._t;
        int n8 = (this._y >> 10) + this._b;
        return n6 >= n && n5 <= n3 && n8 >= n2 && n7 <= n4;
    }

    protected final boolean collideAction(Actor actor, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n & 0xFFFF;
        if ((n & Integer.MIN_VALUE) == 0) {
            n5 = this._anim._l[n6];
            n4 = this._anim._r[n6];
        } else {
            n5 = -this._anim._r[n6];
            n4 = -this._anim._l[n6];
        }
        if ((n & 0x40000000) == 0) {
            n3 = this._anim._t[n6];
            n2 = this._anim._b[n6];
        } else {
            n3 = -this._anim._b[n6];
            n2 = -this._anim._t[n6];
        }
        if (n5 == n4 || n3 == n2) {
            return false;
        }
        return actor.collide(n5 += this._x >> 10, n3 += this._y >> 10, n4 += this._x >> 10, n2 += this._y >> 10);
    }

    protected final boolean collide(Actor actor) {
        return this.collideAction(actor, this._curAction);
    }

    protected boolean isPlatform() {
        return this._type == 27 || this._type == 9;
    }

    protected boolean isBoard() {
        return this._type == 27;
    }

    protected final boolean checkRelation(int n) {
        return (this._ownKind & n) != 0;
    }

    protected final void setRelation(int n) {
        this._relation = n;
    }

    protected final boolean isDynamicActor() {
        return this._id >= Scene._staticActorNum;
    }

    public int getXDirLocation(int n) {
        if (this._isFlip) {
            return this._x - n * 2 / 3;
        }
        return this._x - n / 5;
    }

    public int getYDirLocation(int n) {
        return this._y - n * 3 / 4;
    }

    public boolean process(Actor actor) {
        return false;
    }

    public boolean notify(Actor actor) {
        return false;
    }

    public int getHurtMode() {
        return 0;
    }

    protected int getBodyLeft() {
        return this._l;
    }

    protected int getBodyRight() {
        return this._r;
    }

    protected void traverUnable(Actor actor) {
    }

    public final int getHurtHp(int n) {
        if (n < 0) {
            return 0;
        }
        return C_HURT_HP[n];
    }

    protected boolean issolid(int n) {
        return n == 1;
    }

    protected boolean isupsolid(int n) {
        return n == 1;
    }

    protected boolean checkSolid(int n, int n2) {
        if (n2 == 0) {
            return this.issolid(n);
        }
        return this.isupsolid(n);
    }

    protected void submergence() {
    }

    protected int getOnPasspathXpos() {
        return this._x;
    }

    protected int getOnPasspathYpos() {
        return this._y;
    }

    protected void setOnPasspathYpos(int n) {
        this._y = n << 10;
    }

    public final boolean isCollidePasspoint() {
        return this._onPasspoint;
    }

    protected final void collidePasspath(int n, int n2, int n3, boolean bl) {
        this._onPasspath = true;
        this._curPasspathFlip = bl;
        this._curPasspathTxpos = n2 << 10;
        this._curPasspathTypos = n3 << 10;
        this.setOnPasspathYpos(n);
    }

    protected void collidePasspoint(int n, int n2, int n3, int n4, int n5) {
        this._onPasspoint = true;
        this._curPasspointPathId = n3;
        this._curPasspointFlip = n4;
    }

    protected boolean triggerFeedback() {
        int[] nArray = new int[]{0};
        boolean bl = false;
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n = 0;
        while (n < nArray[0]) {
            Actor actor = actorArray[n];
            if (actor._active && actor != this && (this._relation & actor._ownKind) != 0 && this.collide(actor)) {
                bl = true;
                if (actor.notify(this) && !this.process(actor)) break;
            }
            ++n;
        }
        return bl;
    }

    public Actor triggerFeedback(int n) {
        int[] nArray = new int[]{0};
        int n2 = -1;
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n3 = 0;
        while (n3 < nArray[0]) {
            Actor actor = actorArray[n3];
            if (actor._active && actor._type != this._type && (this._relation & actor._ownKind) != 0 && (this._vx >= 0 || actor._x <= this._x) && (this._vx <= 0 || actor._x >= this._x) && this.collide(actor)) {
                if (n2 == -1) {
                    n2 = n3;
                }
                if (actor.notify(this) && !this.process(actor)) break;
            }
            ++n3;
        }
        if (n2 >= 0) {
            return actorArray[n2];
        }
        return null;
    }

    protected final void checkTraversing() {
        int[] nArray = new int[]{0};
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n = 0;
        while (n < nArray[0]) {
            Actor actor = actorArray[n];
            if (actor._active && actor != this && this.collide(actor)) {
                this.traverUnable(this);
            }
            ++n;
        }
    }

    private final void fetchOwnSequence() {
        this._ownSequence = _sequence;
        _sequence += 1000000;
    }

    private final void ownSequenceAdd() {
        ++this._ownSequence;
    }

    private final int getOwnSequence() {
        return this._ownSequence;
    }

    protected final boolean checkSequence(Actor actor) {
        int n = actor.getOwnSequence();
        if (n != this._opponentSequence) {
            this._opponentSequence = n;
            return true;
        }
        return false;
    }

    public int getRelation() {
        return this._relation;
    }

    protected final void setSkin(int n) {
        int n2 = this._anim.getSkinNum();
        this._palNo = n < n2 ? n : n2 - 1;
    }

    protected final boolean gotoTargetPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.abs(n3 - n);
        int n8 = Math.abs(n4 - n2);
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n6 < 0) {
            n6 = -n6;
        }
        if (n7 > n8) {
            if (n7 < n5) {
                return true;
            }
            this._vx = n3 > n ? n5 : -n5;
            this._vy = n6 * n8 / n7;
            if (n4 < n2) {
                this._vy = -this._vy;
            }
        } else {
            if (n8 < n6) {
                return true;
            }
            this._vy = n4 > n2 ? n6 : -n6;
            this._vx = n5 * n7 / n8;
            if (n3 < n) {
                this._vx = -this._vx;
            }
        }
        return false;
    }

    protected boolean checkLeftWall() {
        if (this._dx > 0) {
            return false;
        }
        int n = this.getBodyLeft();
        int n2 = this._bk._phytw;
        int n3 = this._bk._phyth;
        int n4 = ((this._x >> 10) + n) / n2 * n2;
        int n5 = ((this._x + this._dx >> 10) + n) / n2 * n2;
        int n6 = ((this._y + this._dy >> 10) + this._t + this._toff) / n3 * n3;
        int n7 = ((this._y + this._dy >> 10) + this._b - this._boff) / n3 * n3;
        int[] nArray = new int[]{1, 0};
        boolean bl = false;
        int n8 = n6;
        while (n8 <= n7) {
            if (this.checkLineSolid(n4, n8, n5, n8, -n2, 0, nArray)) {
                bl = true;
                break;
            }
            n8 += n3;
        }
        if (bl) {
            n6 = ((this._y >> 10) + this._t + this._toff) / n3 * n3;
            n7 = ((this._y >> 10) + this._b - this._boff) / n3 * n3;
            int n9 = n6;
            while (n9 <= n7) {
                if (this.checkLineSolid(n4, n9, n5, n9, -n2, 0, nArray)) {
                    this._vx = 0;
                    this._dx = (nArray[0] + n2 << 10) - (this._x + (n << 10));
                    return true;
                }
                n9 += n3;
            }
        }
        return false;
    }

    protected boolean checkRightWall() {
        if (this._dx < 0) {
            return false;
        }
        int n = this.getBodyRight();
        int n2 = this._bk._phytw;
        int n3 = this._bk._phyth;
        int n4 = ((this._x >> 10) + n) / n2 * n2;
        int n5 = ((this._x + this._dx >> 10) + n) / n2 * n2;
        int n6 = ((this._y + this._dy >> 10) + this._t + this._toff) / n3 * n3;
        int n7 = ((this._y + this._dy >> 10) + this._b - this._boff) / n3 * n3;
        int[] nArray = new int[]{1, 0};
        boolean bl = false;
        int n8 = n6;
        while (n8 <= n7) {
            if (this.checkLineSolid(n4, n8, n5, n8, n2, 0, nArray)) {
                bl = true;
                break;
            }
            n8 += n3;
        }
        if (bl) {
            n6 = ((this._y >> 10) + this._t + this._toff) / n3 * n3;
            n7 = ((this._y >> 10) + this._b - this._boff) / n3 * n3;
            int n9 = n6;
            while (n9 <= n7) {
                if (this.checkLineSolid(n4, n9, n5, n9, n2, 0, nArray)) {
                    this._vx = 0;
                    this._dx = (nArray[0] - 1 << 10) - (this._x + (n << 10));
                    return true;
                }
                n9 += n3;
            }
        }
        return false;
    }

    protected boolean checkGround() {
        this._onWater = false;
        if (this._dy < 0) {
            this._onPreGround = this._onGround;
            this._onGround = false;
            this._ay = this._gravity;
            return false;
        }
        int n = this.getBodyLeft();
        int n2 = this.getBodyRight();
        int n3 = this._bk._phytw;
        int n4 = this._bk._phyth;
        int n5 = ((this._x + this._dx >> 10) + n + 2) / n3 * n3;
        int n6 = ((this._x + this._dx >> 10) + n2 - 2) / n3 * n3;
        int n7 = ((this._y >> 10) + this._b) / n4 * n4;
        int n8 = ((this._y + this._dy >> 10) + this._b) / n4 * n4;
        this._onPreGround = this._onGround;
        int[] nArray = new int[]{0, 0};
        int n9 = n5;
        while (n9 <= n6) {
            if (this.checkLineSolid(n9, n7, n9, n8, 0, n4, nArray)) {
                if (nArray[1] == 5) {
                    this._onWater = true;
                    this.submergence();
                    break;
                }
                if (n7 != nArray[0] || !this.checkLineSolid(n9, n7 - n4 * 2, n9, n8, 0, n4, nArray) || nArray[0] >= n7) {
                    this._ay = 0;
                    this._vy = 0;
                    this._dy = (nArray[0] + 1 << 10) - (this._y + (this._b << 10));
                    this._onGround = true;
                    return true;
                }
            }
            n9 += n3;
        }
        this._ay = this._gravity;
        this._onGround = false;
        return false;
    }

    protected boolean checkCeiling() {
        if (this._dy > 0) {
            return false;
        }
        int n = this._bk._phytw;
        int n2 = this._bk._phyth;
        int n3 = ((this._x + this._dx >> 10) + this._l + 2) / n * n;
        int n4 = ((this._x + this._dx >> 10) + this._r - 2) / n * n;
        int n5 = ((this._y >> 10) + this._t) / n2 * n2;
        int n6 = ((this._y + this._dy >> 10) + this._t) / n2 * n2;
        int[] nArray = new int[]{1, 0};
        int n7 = n3;
        while (n7 <= n4) {
            if (this.checkLineSolid(n7, n5, n7, n6, 0, -n2, nArray)) {
                this._vy = 0;
                this._ay = 3072;
                this._dy = (nArray[0] + n2 + 1 << 10) - (this._y + (this._t << 10));
                return true;
            }
            n7 += n;
        }
        this._ay = this._gravity;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean checkLineSolid(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int[] var7_7) {
        block9: {
            block8: {
                if (var5_5 == 0) break block8;
                if (var5_5 >= 0) ** GOTO lbl18
                while (var1_1 >= var3_3) {
                    var8_8 = this._bk.getPhyBlock(var1_1, var2_2);
                    if (this.checkSolid(var8_8, var7_7[0])) {
                        var7_7[0] = var1_1;
                        var7_7[1] = var8_8;
                        return true;
                    }
                    var1_1 += var5_5;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    var8_9 = this._bk.getPhyBlock(var1_1, var2_2);
                    if (this.checkSolid(var8_9, var7_7[0])) {
                        var7_7[0] = var1_1;
                        var7_7[1] = var8_9;
                        return true;
                    }
                    var1_1 += var5_5;
lbl18:
                    // 2 sources

                    ** while (var1_1 <= var3_3)
                }
lbl19:
                // 1 sources

                break block9;
            }
            if (var6_6 >= 0) ** GOTO lbl37
            while (var2_2 >= var4_4) {
                var8_10 = this._bk.getPhyBlock(var1_1, var2_2);
                if (this.checkSolid(var8_10, var7_7[0])) {
                    var7_7[0] = var2_2;
                    var7_7[1] = var8_10;
                    return true;
                }
                var2_2 += var6_6;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                var8_11 = this._bk.getPhyBlock(var1_1, var2_2);
                if (this.checkSolid(var8_11, var7_7[0])) {
                    var7_7[0] = var2_2;
                    var7_7[1] = var8_11;
                    return true;
                }
                var2_2 += var6_6;
lbl37:
                // 2 sources

                ** while (var2_2 <= var4_4)
            }
        }
        return false;
    }

    protected final boolean checkPointSolid(int n, int n2) {
        int n3 = this._bk.getPhyBlock(n, n2);
        return n3 == 1;
    }

    public final Actor flashView(int n, int n2, int n3) {
        Assistant assistant = (Assistant)this._scene.fetchActorFromPool(30, -1);
        if (assistant != null) {
            assistant.init(0, n3, n, n2, this);
            assistant._loopAction = false;
            if (n3 == 0) {
                Function.playSound(7, 1);
            }
        }
        return assistant;
    }

    public void notifyID(Actor actor) {
    }

    protected void startScriptActorMove(int n, int n2) {
    }

    protected boolean endScriptActorMove(int n, int n2) {
        return true;
    }

    protected void startScriptActorBehavior(int n, int n2, int n3) {
        this._vx = n2 << 10;
        this._vy = n3 << 10;
        if (n < 0) {
            n = -n;
            n |= Integer.MIN_VALUE;
        }
        this.changeAction(n);
    }

    protected boolean endScriptActorBehavior(int n, int n2, int n3) {
        return true;
    }

    protected void startScriptCallFunction(int n, int n2, int n3) {
    }

    protected boolean endScriptCallFunction(int n, int n2, int n3) {
        return true;
    }

    protected void stop() {
    }

    protected void boardSpring(int n) {
    }

    public void paintInfo(Graphics graphics) {
    }

    public static boolean isEnemyType(int n) {
        return n == 5 || n == 6 || n == 7 || n == 8 || n == 10;
    }

    public boolean canCheckPasspath() {
        return false;
    }
}

