/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import tjge.Actor;
import tjge.Animation;
import tjge.EnemyThing;
import tjge.Function;
import tjge.Human;
import tjge.MainActor;

public class EnemyThrow
extends Human {
    private int _alarmDistanceX;
    private int _alarmDistanceY;
    private boolean _isAlarming;
    private int _BulletFrame = 20;
    private static final int C_ACT_DOG_WAIT = 0;
    private static final int C_ACT_DOG_CRY = 1;
    private static final int C_ACT_DOG_ATTACK = 2;
    private static final int C_ACT_DOG_HURT = 3;
    private static final int C_ACT_DOG_FALL = 4;
    private static final int C_ACT_DOG_DIE = 5;
    private static final int C_ACT_DOG_HURT_BLACK = 6;
    private int _dogTimeTick = 0;
    private boolean _canBone = false;
    private static final int C_FIRE_OFF_X = 15360;
    private static final int C_FIRE_OFF_Y = 35840;
    private static final int C_ACT_BIG_GUN_WAIT = 0;
    private static final int C_ACT_BIG_GUN_FIRE = 1;
    private boolean _canFire = false;
    private int _fireValue = 0;
    private int _fireType = 2;
    private static final int C_RANDOM_X = 6000;
    private static final int C_RANDOM_Y = 12288;
    public MainActor _boss = null;
    private boolean _controlBigGun = false;
    private static final int C_ACT_BLACK_HUMAN_WALK = 0;
    private static final int C_ACT_BLACK_HUMAN_ROLL = 1;
    private static final int C_ACT_BLACK_HUMAN_FALL = 2;
    private boolean _isStop;
    private boolean _isFly;
    public int _bigGunType;
    private int _fireAngle = 0;
    public boolean _isBossDog;
    public static final int C_BORN_X = 0;
    public static final int C_BORN_Y = 20;

    public EnemyThrow(int n, Animation animation) {
        super(n, animation);
        this._ownKind = 2;
    }

    protected boolean init(byte[] byArray) {
        this._BulletFrame = 20;
        super.init(byArray);
        if (this._type == 8) {
            this._hp = 12;
            this._alarmDistanceX = 122880;
            this._alarmDistanceY = 122880;
            this._isBossDog = byArray[7] != 0;
        } else if (this._type == 31) {
            this._alarmDistanceX = 512000;
            this._alarmDistanceY = 512000;
            this._ownKind = 0;
            this._canFire = false;
            this._controlBigGun = false;
            this._bigGunType = byArray[7];
            if (byArray.length - 1 >= 8) {
                this._fireAngle = byArray[8];
            }
        } else {
            this._BulletFrame = 12;
            this._hp = 6;
            this._alarmDistanceX = 122880;
            this._alarmDistanceY = 256000;
            this._relation = 1;
        }
        return true;
    }

    public void step() {
        if (this._type == 31) {
            this.checkTraversing();
        } else if (this._type == 8) {
            if (this._hp > 0) {
                this.checkCollideMainActor();
            }
            if (this.stepDog()) {
                return;
            }
        } else if (this._type == 10) {
            if (this.isDynamicActor() && this._action == 2) {
                this._gravity = 0;
            }
            if (this._hp > 0) {
                this.checkCollideMainActor();
            }
        }
        super.step();
    }

    private boolean stepDog() {
        if (this._isStop) {
            if (this._dogTimeTick++ < 50) {
                return true;
            }
            this._dogTimeTick = 0;
            this._isStop = false;
        } else if (this._dogTimeTick++ > 10) {
            this._canBone = true;
            this._dogTimeTick = 0;
        }
        return false;
    }

    public void ai() {
        if (this._type == 31) {
            this.aiBigGun();
        } else if (this._type == 8) {
            this.aiDog();
        } else if (this._type == 10) {
            if (!this.isDynamicActor()) {
                this.aiBlackHuman();
            } else if (this._action == 1) {
                if (this._isTurnMode) {
                    int n;
                    int n2;
                    if (this._onGround && this._action == 0 && (n2 = this._x >> 10) > (n = this._scene.getWidth() + 5)) {
                        this._scene.gameLoseLife();
                    }
                } else {
                    this.triggerFeedback();
                }
                if (this._x < 0 || this._x >> 10 > this._bk.getMapWidth() || this._y >> 10 > this._bk.getMapHeight()) {
                    this.disLife();
                    return;
                }
            } else if (this._action == 2 && !this._visible) {
                this.disLife();
            }
        }
    }

    private void aiBlackHuman() {
        Actor actor = this._scene.getFocusActor();
        this._isAlarming = Math.abs(actor._x - this._x) < this._alarmDistanceX && Math.abs(actor._y - this._y) < this._alarmDistanceY;
        if (this._action == 0) {
            if (this._isAlarming) {
                if (actor._type == 4) {
                    this._vx = -6144;
                    this._vy = -3096;
                    this._gravity = 3096;
                } else {
                    this._ay = this._gravity = 1000;
                    this._vy = this.getVY(actor._x, actor._y);
                    this._vx = this.getVX(actor._x, actor._y);
                }
                this.changeAction(1);
            }
        } else if (this._action == 1) {
            if (this.collide(actor)) {
                actor.notify(this);
            }
            if (actor._type != 4) {
                if (this._vy > 3072) {
                    this._vx = 0;
                    this._gravity = 3072;
                    this.changeAction(2);
                }
            } else if (this._onGround) {
                this._vy = -5120;
            }
        } else if (this._action == 2 && this._onGround) {
            if (this._hp < 0) {
                this.disLife();
            } else {
                this.changeAction(Integer.MIN_VALUE);
            }
        }
    }

    private void aiDog() {
        Actor actor = this._scene.getFocusActor();
        boolean bl = true;
        if (actor._x > this._x) {
            bl = false;
        }
        this._isAlarming = Math.abs(actor._x - this._x) < this._alarmDistanceX && Math.abs(actor._y - this._y) < this._alarmDistanceY;
        switch (this._action) {
            case 0: {
                if (this._isAlarming) {
                    this._dogTimeTick = 0;
                    if (bl) {
                        this.changeAction(-2147483646);
                    } else {
                        this.changeAction(2);
                    }
                }
                if (this._dogTimeTick++ < 30) break;
                this._dogTimeTick = 0;
                this.changeAction(1 | this._flipFlag);
                break;
            }
            case 1: {
                if (!this.isActionEnd() || this._dogTimeTick++ % 2 != 1) break;
                this._dogTimeTick = 0;
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 2: {
                if (!this._isAlarming) {
                    this._dogTimeTick = 0;
                    this.changeAction(0 | this._flipFlag);
                }
                if (!bl && this._isFlip) {
                    this.changeAction(2);
                }
                if (bl && !this._isFlip) {
                    this.changeAction(-2147483646);
                }
                if (!this._canBone) break;
                this._canBone = false;
                EnemyThing enemyThing = (EnemyThing)this._scene.fetchActorFromPool(20, -1);
                if (this._scene.getMainActor()._type == 9) {
                    this._BulletFrame = 5;
                }
                int n = this.getVX(actor._x, actor._y);
                int n2 = this.getVY(actor._x, actor._y);
                if (actor._type != 0) {
                    n = -8192;
                    n2 = -14336;
                }
                if (enemyThing == null) break;
                enemyThing.init(n, n2, this._x, this._y, this);
                break;
            }
            case 3: {
                if (this._dogTimeTick++ < 10) break;
                this._dogTimeTick = 0;
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 4: {
                boolean bl2 = true;
                if (!this._isFly) {
                    bl2 = false;
                }
                if (this._dogTimeTick++ >= 8 || this._position != 0) {
                    this._dogTimeTick = 0;
                    bl2 = false;
                }
                if (bl2) break;
                this._vx = 0;
                this.changeAction(5 | this._flipFlag);
                break;
            }
            case 5: {
                if (this._dogTimeTick++ < 25 && this._gs._curLevel != 6) break;
                this._dogTimeTick = 0;
                if (this._hp > 0) {
                    this.changeAction(0 | this._flipFlag);
                    break;
                }
                this.disLife();
                break;
            }
            case 6: {
                if (!this.isActionEnd()) break;
                if (this._hp <= 0) {
                    this.disLife();
                    break;
                }
                this.changeAction(5 | this._flipFlag);
            }
        }
    }

    private void aiBigGun() {
        Actor actor = this._scene.getFocusActor();
        if (this._action == 0) {
            if (this._controlBigGun) {
                this.changeAction(1 | this._flipFlag);
            } else if (this._canFire) {
                this.changeAction(1 | this._flipFlag);
            }
        } else if (this._action == 1) {
            if (this._curFrame == 3) {
                Function.playSound(2, 1);
                EnemyThing enemyThing = (EnemyThing)this._scene.fetchActorFromPool(16, -1);
                int n = this.getVX(actor._x, actor._y);
                int n2 = this.getVY(actor._x, actor._y);
                switch (this._bigGunType) {
                    case 0: {
                        if (this._fireType == 2) {
                            n = -7000;
                            n -= Function.Random(6000);
                            n2 = -12288;
                            n2 -= Function.Random(6000);
                        } else if (this._fireType == 0) {
                            n = -4096;
                            n2 = -10240;
                        } else if (this._fireType == 1) {
                            n = -7168;
                            n2 = -11264;
                        }
                        if (this._isFlip) {
                            enemyThing.init(n, n2, this._x - 15360, this._y - 35840, this);
                        } else {
                            enemyThing.init(n, n2, this._x + 15360, this._y - 35840, this);
                        }
                        this._scene.setFocusActor(enemyThing);
                        this._gs.unlockCamera();
                        break;
                    }
                    case 1: {
                        if (this._fireAngle == 0) {
                            n = -1024;
                            n2 = -4096;
                        } else if (this._fireAngle == 1) {
                            n = -1024;
                            n2 = -5120;
                        } else {
                            n = -1024;
                            n2 = -6144;
                        }
                        if (this._isFlip) {
                            enemyThing.init(n, n2, this._x - 15360, this._y - 35840, this);
                            break;
                        }
                        enemyThing.init(n, n2, this._x + 15360, this._y - 35840, this);
                        break;
                    }
                    case 2: {
                        n2 = -this._fireValue << 10;
                        n = 8192;
                        if (this._isFlip) {
                            enemyThing.init(n, n2, this._x - 15360, this._y - 35840, this);
                        } else {
                            enemyThing.init(n, n2, this._x + 15360, this._y - 35840, this);
                        }
                        this._scene.setFocusActor(enemyThing);
                        this._gs.unlockCamera();
                        break;
                    }
                    case 3: {
                        if (this._isFlip) {
                            enemyThing.init(n, n2, this._x - 15360, this._y - 35840, this);
                            break;
                        }
                        enemyThing.init(n, n2, this._x + 15360, this._y - 35840, this);
                        break;
                    }
                    case 4: {
                        n2 = -6144;
                        n = -this._fireValue - 3;
                        n *= 400;
                        if (this._isFlip) {
                            enemyThing.init(n, n2, this._x - 15360, this._y - 35840, this);
                            break;
                        }
                        enemyThing.init(n, n2, this._x + 15360, this._y - 35840, this);
                    }
                }
                this._canFire = false;
                this._controlBigGun = false;
            }
            if (this.isActionEnd()) {
                this.changeAction(0 | this._flipFlag);
            }
        }
        if (this._bigGunType == 1 && this.collide(actor)) {
            actor.notify(this);
        }
    }

    public boolean notify(Actor actor) {
        if (actor._type == 20 && this._type == 8) {
            return false;
        }
        if (!this.checkRelation(actor.getRelation()) || !this.checkSequence(actor)) {
            return false;
        }
        int n = this._hp;
        if (this._type == 8) {
            if (actor._type == 20) {
                return false;
            }
            this.dogCollide(actor);
        } else if (this._type == 10) {
            if (actor._type == 21) {
                return false;
            }
            this.collideBlackHuman(actor);
        }
        if (this._hp <= 0 && n > 0 && !this.isDynamicActor()) {
            ++MainActor._enemyNum;
        }
        return true;
    }

    private boolean collideBlackHuman(Actor actor) {
        int n = actor.getHurtMode();
        if (n == -1) {
            return false;
        }
        int n2 = Actor.C_HURT_HP[n];
        switch (n) {
            case 18: {
                this._hp -= n2;
                this.flashView(this._x, this._y, 2);
                if (this._action != 1) break;
                this._vy = 0;
                this._vx = 0;
                this._gravity = 3072;
                this.changeAction(2);
                break;
            }
            case 0: 
            case 7: 
            case 8: 
            case 12: {
                this.flashView(this._x, this._y, 2);
                this.changeAction(2);
                this._hp = 0;
                this._vx = 12288;
                this._vy = -18432;
                this._gravity = 200;
            }
        }
        return true;
    }

    private void dogCollide(Actor actor) {
        int n = actor.getHurtMode();
        int n2 = this.getHurtHp(n);
        int n3 = 11;
        boolean bl = true;
        if (actor._x > this._x) {
            bl = false;
        }
        switch (n) {
            case -1: {
                return;
            }
            case 10: 
            case 11: {
                if (this._isAlarming) {
                    return;
                }
                n2 = 0;
                break;
            }
            case 7: {
                if (this._action == 5 && this._vy < -3096) {
                    return;
                }
                this.disLife();
                this.changeCake(this._type);
                break;
            }
            case 8: {
                this.flashView(this._x, this._y, 2);
                this.changeAction(-2147483644);
                this._gravity = 1000;
                this._vx = 12288;
                this._vy = -18432;
                this._hp = 0;
                return;
            }
            case 1: 
            case 6: {
                n3 = 20;
                break;
            }
            case 9: {
                n2 = 1;
                n3 = 21;
                break;
            }
            case 5: {
                n3 = 30;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n3 = 40;
            }
        }
        this._hp -= n2;
        if (n3 / 10 == 1) {
            this._vx = 0;
            if (this._isStop) {
                this._isStop = false;
                this._dogTimeTick = 0;
            }
            if (this._hp <= 0) {
                this.changeAction(5 | this._flipFlag);
                return;
            }
            if (bl) {
                this.changeAction(-2147483645);
            } else {
                this.changeAction(3);
            }
        }
        if (n3 / 10 == 2) {
            if (this._isStop) {
                this._isStop = false;
                this._dogTimeTick = 0;
            }
            if (this._action == 5 || this._action == 5) {
                return;
            }
            this._isFly = n3 % 10 != 1;
            this._dogTimeTick = 0;
            if (bl) {
                this._vx = 6144;
                this.changeAction(-2147483644);
            } else {
                this._vx = -6144;
                this.changeAction(4);
            }
            return;
        }
        if (n3 / 10 == 3) {
            this._vx = 0;
            this._dogTimeTick = 0;
            this._isStop = true;
            return;
        }
        if (n3 / 10 == 4) {
            if (this._isStop) {
                this._isStop = false;
                this._dogTimeTick = 0;
            }
            if (this._action == 5) {
                return;
            }
            this._vx = 0;
            this._vy = 0;
            this.changeAction(6 | this._flipFlag);
        }
    }

    private void changeCake(int n) {
        if (n == 8) {
            EnemyThing enemyThing = (EnemyThing)this._scene.fetchActorFromPool(13, -1);
            enemyThing._x = this._x;
            enemyThing._y = this._y;
        }
    }

    private int getVY(int n, int n2) {
        if (this._y - n2 > 40960) {
            return (n2 - this._y - this._BulletFrame * (this._BulletFrame - 1) * 2000 / 2) / (this._BulletFrame + 5);
        }
        return (n2 - this._y - this._BulletFrame * (this._BulletFrame - 1) * 2000 / 2) / this._BulletFrame;
    }

    private int getVX(int n, int n2) {
        return (n - this._x) / (this._BulletFrame + 10);
    }

    public int getHurtMode() {
        if (this._type == 10) {
            return 9;
        }
        if (this._type == 8 && this._action == 4) {
            return 9;
        }
        return -1;
    }

    public void fire(int n, int n2, MainActor mainActor) {
        this._canFire = true;
        this._fireType = n;
        this._fireValue = n2;
        this._boss = mainActor;
        if (this._boss != null && this._boss._type == 0) {
            this._controlBigGun = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean issolid(int n) {
        if (this._type == 10) {
            if (this._isTurnMode) {
                if (n == 1) return true;
                if (n != 2) return false;
                return true;
            }
            if (n != 1) return false;
            return true;
        }
        if (this._type == 31) {
            return true;
        }
        if (n == 1) return true;
        if (n != 2) return false;
        return true;
    }

    protected void stop() {
        this._vx = 0;
        this.changeAction(0 | this._flipFlag);
    }

    public boolean process(Actor actor) {
        if (this._type == 10 && this.isDynamicActor()) {
            this.changeAction(2);
            this._vx = this._vx > 0 ? 8192 : -8192;
            this._vy = -18432;
        }
        return false;
    }

    public void initTeamEnemy() {
        this.init();
        this._x = 0;
        this._y = 20;
        this._vx = 5000;
        this._isTurnMode = true;
        this._ownKind = 2;
        this._relation = 3;
        this.changeAction(1);
    }

    public void onGround() {
        if (this._isTurnMode && !this._onPreGround) {
            this._vx = 1500;
            this.changeAction(0);
        }
    }
}

