/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import javax.microedition.lcdui.Graphics;
import tjge.Actor;
import tjge.Animation;
import tjge.Assistant;
import tjge.BridgeBoard;
import tjge.EnemyThing;
import tjge.EnemyThrow;
import tjge.Function;
import tjge.GameScreen;
import tjge.MainActor;
import tjge.Scene;
import tjge.SptSet;
import tjge.TiledBackground;

public final class BaiZhanTang
extends MainActor {
    public static final int C_ACT_WAIT = 0;
    public static final int C_ACT_WALK = 1;
    public static final int C_ACT_ATTACK_1 = 2;
    public static final int C_ACT_ATTACK_2 = 3;
    public static final int C_ACT_ATTACK_3 = 4;
    private static final int C_ACT_JUMP_1 = 6;
    private static final int C_ACT_JUMP_2 = 7;
    private static final int C_ACT_JUMP_3 = 8;
    private static final int C_ACT_POWER = 9;
    private static final int C_ACT_POINT_1 = 10;
    private static final int C_ACT_POINT_2 = 11;
    private static final int C_ACT_JINK_OUT = 12;
    private static final int C_ACT_JINK_IN = 13;
    public static final int C_ACT_SMAIL = 14;
    private static final int C_ACT_SLIDE = 15;
    private static final int C_ACT_HURT = 16;
    private static final int C_ACT_FALL = 17;
    public static final int C_ACT_LIE = 18;
    private static final int C_ACT_HELP = 19;
    public static final int C_ACT_AIR_ATTACK = 20;
    public static final int C_ACT_WAIT2 = 21;
    private static final int C_ACT_HELP_WANZHUKUANGBENG = 22;
    public static final int C_ACT_JUMP_TURN = 23;
    private static final int C_ACT_WAIT_SLIDINGWAY = 24;
    private static final int C_ACT_RUN_SLIDINGWAY = 25;
    private static final int C_ACT_JUMP_SLIDINGWAY = 26;
    private static final int C_ACT_JUMPTOP_SLIDINGWAY = 27;
    private static final int C_ACT_ONGROUND_SLIDINGWAY = 28;
    private static final int C_ACT_HURT_SLIDINGWAY = 30;
    private static final int C_ACT_TRAMPLE_SLIDINGWAY = 32;
    private static final int C_ACT_SLIDE_SLIDINGWAY = 33;
    private static final int C_ACT_JUMP_SPRINGPOLE = 34;
    private static final int C_ACT_JUMPTOP_SPRINGPOLE = 35;
    private static final int C_ACT_HURT_SPRINGPOLE = 36;
    private static final int C_WALK_VX = 8192;
    private static final int C_JUMP_VX = 4096;
    private static final int C_JUMP_VY = -10240;
    private static final int C_SPRINGJUMP_VX = 3072;
    private static final int C_SPRINGJUMP_VY = -10240;
    private static final int C_JUMP_SLIDINGWAY_VX = 10240;
    private static final int C_JUMP_SLIDINGWAY_VY = -12288;
    private static final int C_JINK_VX = 10240;
    private static final int C_FALL_VX = 4096;
    private static final int C_FALL_VY = -8192;
    private static final int C_SLIDE_VX = 12288;
    private static final int C_SLIDE_VY = 12288;
    private static final int C_JUMP_TURN_VY = 6144;
    private static final int C_WALK_SLIDINGWAY_VX = 12288;
    private static final int C_BACK_SLIDINGWAY_VX = 12288;
    private static final int C_BACK_SLIDINGWAY_VY = 8192;
    private static final int C_SPRINGPOLE_VX = 1400;
    private static final int C_BOARD_JUMP_VX = 1800;
    private static final int C_SPRINGPOLE_VY = 10240;
    private static final int C_SPRINGPOLE_BIG_VX = 4096;
    private static final int C_SPRINGPOLE_BIG_VY = 18432;
    private static final int C_SPRINGPOLE_AX = 250;
    private static final int C_MIN_FIRE_POWER = 0;
    private static final int C_MAX_FIRE_POWER = 18;
    private static final int C_MAX_JINK_CNT = 8;
    private static final int C_JUMPUP_PROP = 0;
    private static final int C_JUMPDOWN_PROP = 1;
    public boolean _onSlidingway;
    public boolean _onSpringPole;
    private int _jumpPropState;
    private int _propState = 0;
    private int _propJumpState = 0;
    private boolean _autoJump = false;
    private static final int C_PROP_STATE_NORMAL = 0;
    private static final int C_PROP_STATE_ON_SPRING = 1;
    private static final int C_PROP_STATE_ON_SLIDING = 2;
    private static final int C_PROP_SPRING_JUMP_NORMAL = 0;
    private static final int C_PROP_SPRING_JUMP_LEFT = 1;
    private static final int C_PROP_SPRING_JUMP_RIGHT = 2;
    private static final int C_PROP_SPRING_JUMP_LEFT_UP = 3;
    private static final int C_PROP_SPRING_JUMP_RIGHT_UP = 4;
    public static final int C_CAPTOR_TIME = 50;
    public static final int C_CLOCK_TIME = 60;
    public static final int C_CAPTOR_RESET_RANGE = 40;
    public static final int C_SHOWBUTTOM_TIME = 10;
    private int _preVY;
    public boolean _onFire;
    private boolean _onTimer;
    private int _totalTime;
    private long _curTime;
    private int _nextOnFireTime;
    private EnemyThrow _bigFire;
    private int _firePower;
    private int _nextAttackAct;
    private int _nextAttackKey;
    private int _jumpVx;
    private int _jinkCnt;
    private int _submergenceCnt;
    private boolean _isPointAllowHit;
    private boolean _isAllowJumpAttack;
    private boolean _isAllowJumpOnThings;
    private boolean _isAllowJumpAgain;
    private boolean _canPoint = true;
    private boolean _canEnterDoor;
    private int _enterDoorX;
    private int _enterDoorY;
    private int _enterDoorFlip;
    private int _timeTick;
    private int _passTime;
    private int _hurtMode;
    private boolean _onBoard;
    public boolean _questionState;
    private boolean _levelPassed;
    private boolean _slidingCollideRightWall;
    private boolean _slidingCollideLeftWall;
    private int _friendType;
    private int _curCaptor;
    private int _captorTicks;
    boolean _tipCallFriend;
    boolean _saveTipCallFriend;
    public static final int C_LI_RESUME_BOARD = 0;
    public static final int C_GOU_FLAGON_STATIC = 1;
    public static final int C_GOU_FLAGON_MOVE = 2;
    public static final int C_GOU_BOARD_BOMB = 3;
    public static final int C_MO_PIG = 4;
    public static final int C_BAI_STOP = 5;
    MainActor _friend = null;
    private static final int[] SPRING_JUMP_VX = new int[]{3072, 3072, 9216, 9216, 12288};
    private static final int[] SPRING_JUMP_VY = new int[]{-10240, -10240, -18432, -22528, -25600, -30720};
    public static final int C_W_OFF = 10;
    public static final int C_HP_OFF = 128;
    public static final int C_HP_X_OFF = 23;
    public static final int C_HP_Y_OFF = 10;
    private static final int C_COLLIDE_PASSPOINT_JUMPUP = 0;
    private static final int C_COLLIDE_PASSPOINT_JUMPDOWN = 1;
    private static final int C_COLLIDE_PASSPOINT_LINKTO = 2;
    private static final int C_COLLIDE_PASSPOINT_WALKTO = 3;
    private static final int C_SCRIPT_USE_POINT = 0;
    private static final int C_SCRIPT_CALL_GUOFURONG = 1;
    private static final int C_SCRIPT_CALL_LIDAZUI = 2;
    private static final int C_SCRIPT_PASS_LEVEL = 3;
    private static final int C_SCRIPT_CALL_MOXIAOBEI = 4;
    private static final int C_SCRIPT_USE_FIRE = 5;
    private static final int C_SCRIPT_REGISTERACTOR = 6;
    private static final int C_SCRIPT_USE_FIRE2 = 7;
    private static final int C_SCRIPT_ANSWER = 8;

    public BaiZhanTang(int n, Animation animation) {
        super(n, animation);
        this._ownKind = 1;
        this._relation = 10;
    }

    protected boolean init(byte[] byArray) {
        this._nextOnFireTime = 0;
        this._captorTicks = 0;
        this._hp = this.C_TOTAL_HP = 10;
        this._canPoint = byArray[7] > 0;
        this._onBoard = byArray[7] == 21;
        boolean bl = this._questionState = byArray[7] == 26;
        if (this._onBoard) {
            this._propState = 2;
            this._onSlidingway = true;
            this._passTime = 0;
            EnemyThing.initExplosionData();
        } else {
            EnemyThing.disposeData();
            this._propState = 0;
            this._onSlidingway = false;
        }
        this._isAllowJumpOnThings = false;
        this._onSpringPole = false;
        this._canEnterDoor = false;
        this._onFire = false;
        this._submergenceCnt = 0;
        super.init(byArray);
        this._boff = 10;
        this._hurtMode = -1;
        this._timeTick = 0;
        this._slidingCollideRightWall = false;
        this._slidingCollideLeftWall = false;
        this._levelPassed = false;
        return true;
    }

    public void step() {
        if (Scene._pause) {
            this.nextFrame();
        } else {
            super.step();
        }
        if (this._gs.isLockCamera() && !this._onTimer) {
            if (Scene._state == 0 && this._action != 12 && this._action != 13 && this._action != 11) {
                int n = this._x + (this._l << 10);
                int n2 = this._x + (this._r << 10);
                int n3 = this._gs._camx;
                int n4 = this._gs._camw;
                if (n < n3) {
                    this._x = n3 - (this._l << 10);
                } else if (n2 > n3 + n4) {
                    this._x = n3 + n4 - (this._r << 10);
                }
            }
        }
    }

    public void ai() {
        this.actHandler();
        this.keyHandler();
        if (this._captorTicks > 0) {
            --this._captorTicks;
            if (this._captorTicks == 0) {
                this._scene.setCaptor(this._curCaptor, false);
            }
        }
        this._canEnterDoor = false;
        this._saveTipCallFriend = this._tipCallFriend;
        this._tipCallFriend = false;
    }

    public void actHandler() {
        if (this._propState == 2) {
            this.triggerFeedback();
            if (this._slidingCollideLeftWall) {
                this._vx = 12288;
                this._vy = -8192;
                this._jumpVx = this._vx;
                this.changeAction(0x1A | this._flipFlag);
                this._slidingCollideLeftWall = false;
                return;
            }
            if (this._slidingCollideRightWall) {
                this._vx = -12288;
                this._vy = -8192;
                this._jumpVx = this._vx;
                this.changeAction(0x1A | this._flipFlag);
                this._slidingCollideRightWall = false;
                return;
            }
        } else if (this._propState == 1 && this._vy > 0) {
            this.triggerFeedback();
        }
        if (this._onPreGround && this._onGround && this._hp <= 0) {
            this._vx = 0;
            this._vy = 0;
            this.changeAction(0x12 | this._flipFlag);
        }
        switch (this._action) {
            case 2: 
            case 3: 
            case 4: {
                this.attackHandler();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.jumpHandler();
                break;
            }
            case 9: {
                if (!this.isActionEnd()) break;
                this.changeAction(0xA | this._flipFlag);
                break;
            }
            case 10: {
                if (!this.isActionEnd()) break;
                this.jinkout();
                this._scene.unPauseScreen();
                break;
            }
            case 11: {
                if (this._onFire && this.isActionEnd()) {
                    this.changeAction(0 | this._flipFlag);
                    return;
                }
                ++this._jinkCnt;
                if (this._jinkCnt > 8) {
                    this.jinkin();
                    break;
                }
                this.triggerFeedback();
                break;
            }
            case 12: {
                ++this._jinkCnt;
                if (this._isPointAllowHit) {
                    this.changeAction(0xB | this._flipFlag);
                    break;
                }
                if (this._jinkCnt > 8) {
                    this.jinkin();
                    break;
                }
                this.triggerFeedback();
                break;
            }
            case 13: {
                if (--this._jinkCnt > 0) break;
                this._vx = 0;
                this.towait(this._flipFlag);
                this._gs.resetKeyBuff();
                break;
            }
            case 14: {
                if (!this.isActionEnd()) break;
                this._scene.gamePassLevel();
                break;
            }
            case 16: {
                this._vx = 0;
                if (!this.isActionEnd()) break;
                if (this._onWater) {
                    if (++this._submergenceCnt <= 3) break;
                    this._scene.gameLoseLife();
                    break;
                }
                if (this._onGround) {
                    if (this._hurtMode == 8) {
                        this.changeAction(0x12 | this._flipFlag);
                        this._hurtMode = -1;
                        break;
                    }
                    if (this._hp <= 0) {
                        this._vx = 4096;
                        this._vy = -8192;
                        if (this._isFlip) {
                            this._vx = -this._vx;
                        }
                        this.changeAction(0x11 | this._flipFlag);
                        Function.playSound(6, 1);
                        break;
                    }
                    this.towait(this._flipFlag);
                    break;
                }
                this._vx = 4096;
                this._vy = 0;
                if (this._isFlip) {
                    this._vx = -this._vx;
                }
                this.changeAction(0x11 | this._flipFlag);
                break;
            }
            case 17: {
                if (!this.isActionEnd() || !this._onGround) break;
                this._vx = 0;
                if (this._hp <= 0) {
                    this.changeAction(0x12 | this._flipFlag);
                    break;
                }
                this.towait(this._flipFlag);
                break;
            }
            case 18: {
                this._vx = 0;
                if (this._timeTick++ <= 20) break;
                this._timeTick = 0;
                if (this._hp > 0) {
                    this.towait(this._flipFlag);
                    break;
                }
                this._scene.gameLoseLife();
                break;
            }
            case 19: 
            case 22: {
                if (!this.isActionEnd()) break;
                this.towait(this._flipFlag);
                break;
            }
            case 20: {
                if (this.isActionEnd()) {
                    if (this._vy > 5120) {
                        this.changeAction(8 | this._flipFlag);
                        break;
                    }
                    if (this._vy < 0) break;
                    this.changeAction(7 | this._flipFlag);
                    break;
                }
                if (this._curFrame <= 0) break;
                this.triggerFeedback();
                break;
            }
            case 23: {
                if (!this._onGround || !this.isActionEnd() || this._jumpPropState != 1) break;
                this.towait(this._flipFlag);
                break;
            }
            case 26: {
                if (this._vy >= 0) {
                    this.changeAction(0x1B | this._flipFlag);
                }
            }
            case 27: {
                this._vx = this._jumpVx;
                break;
            }
            case 30: {
                if (!this.isActionEnd()) break;
                this.changeAction(0x18 | this._flipFlag);
                break;
            }
            case 34: {
                if (this._onGround && this.isActionEnd()) {
                    this.jumpupSpringPole();
                }
                if (!this._autoJump) break;
                this._vx = this._jumpVx;
                break;
            }
            case 35: {
                if (this._autoJump) {
                    this._vx = this._jumpVx;
                    return;
                }
                if (this._onPreGround) {
                    switch (this._propJumpState) {
                        case 3: {
                            this._vx = -4096;
                            this._vy = -18432;
                            break;
                        }
                        case 4: {
                            this._vx = 4096;
                            this._vy = -18432;
                            break;
                        }
                        case 1: {
                            this._vx = -1400;
                            this._vy = -10240;
                            break;
                        }
                        case 2: {
                            this._vx = 1400;
                            this._vy = -10240;
                            break;
                        }
                        case 0: {
                            this._vx = 0;
                            this._vy = -10240;
                        }
                    }
                }
                if (!this._onGround) break;
                this.changeAction(0x22 | this._flipFlag);
                Function.playSound(4, 1);
                break;
            }
            case 36: {
                if (!this.isActionEnd()) break;
                this.changeAction(0x23 | this._flipFlag);
            }
        }
    }

    public void keyHandler() {
        if (!this.canPressKey()) {
            return;
        }
        int n = this._gs.getCurKey();
        if (this._onFire) {
            if (this._onTimer || this._gs.isStableCamera()) {
                this.onKeyFire(n);
            }
            return;
        }
        switch (n) {
            case 16: {
                if (this._action == 33) break;
                if (this._tipCallFriend) {
                    switch (this._friendType) {
                        case 2: {
                            this.callFriendHelpMe(1);
                            break;
                        }
                        case 4: {
                            MainActor mainActor = (MainActor)this._scene.fetchActorFromPool(MainActor.C_MAIN_ID[3], -1);
                            if (mainActor == null) break;
                            mainActor.agreeAndHelp();
                            break;
                        }
                        case 3: {
                            this.callFriendHelpMe(2);
                            break;
                        }
                        case 0: {
                            this.usePoint();
                        }
                    }
                    this._captorTicks = 50;
                    this._scene.setCaptor(this._curCaptor, true);
                    break;
                }
                this.attackToEnemy();
                break;
            }
            case 4: {
                if (this._onPasspath) {
                    if (this._isFlip) {
                        this.jumping(-8192, this._propState == 2 ? -9192 : -12288, this._flipFlag);
                    } else {
                        this.jumping(8192, this._propState == 2 ? -9192 : -12288, this._flipFlag);
                    }
                    this._onPasspath = false;
                    break;
                }
                if (this._onSlidingway || this._onBoard) {
                    if (!this._onGround) break;
                    this.jumping(this._vx, -10240, this._flipFlag);
                    break;
                }
                if (this._onSpringPole) break;
                if (this._canEnterDoor) {
                    this._scene.switchToEnterDoor();
                    break;
                }
                this.jumpToUp();
                break;
            }
            case 32: {
                if (this._action == 33) break;
                if (this._onSlidingway || this._onBoard) {
                    if (!this._onGround) break;
                    if (this._onBoard) {
                        this.jumping(-10240, -12288, Integer.MIN_VALUE);
                        break;
                    }
                    this.jumping(-10240, -12288, this._flipFlag);
                    break;
                }
                if (this._onSpringPole) {
                    this._propJumpState = 3;
                    break;
                }
                this.jumpToLeft();
                break;
            }
            case 128: {
                if (this._action == 33) break;
                if (this._onSlidingway || this._onBoard) {
                    if (!this._onGround) break;
                    if (this._onBoard) {
                        this.jumping(10240, -12288, 0);
                        break;
                    }
                    this.jumping(10240, -12288, this._flipFlag);
                    break;
                }
                if (this._onSpringPole) {
                    this._propJumpState = 4;
                    break;
                }
                this.jumpToRight();
                break;
            }
            case 1: {
                if (this._action == 33) break;
                if (this._onBoard && this._onGround) {
                    this.changeAction(-2147483621);
                    this._vx = -12288;
                    return;
                }
                if (this._propState == 1) {
                    this._propJumpState = 1;
                    break;
                }
                if (this._platform != null) {
                    this._propJumpState = 2;
                }
                this.walkingToLeft();
                break;
            }
            case 2: {
                if (this._action == 33) break;
                if (this._onBoard && this._onGround) {
                    this.changeAction(27);
                    this._vx = 12288;
                    return;
                }
                if (this._propState == 1) {
                    this._propJumpState = 2;
                    break;
                }
                if (this._platform != null) {
                    this._propJumpState = 2;
                }
                this.walkingToRight();
                break;
            }
            default: {
                this.idle();
            }
        }
    }

    private void onKeyFire(int n) {
        if (--this._nextOnFireTime > 0) {
            return;
        }
        if (n == 16) {
            ++this._firePower;
            if (this._firePower > 18) {
                this.changeAction(2 | this._flipFlag);
                this._bigFire.fire(2, this._firePower, this);
                this._firePower = 0;
                this._nextOnFireTime = 20;
            }
        } else if (this._firePower > 0) {
            this.changeAction(2 | this._flipFlag);
            this._bigFire.fire(2, this._firePower, this);
            this._firePower = 0;
            this._nextOnFireTime = 20;
        }
    }

    private void attackToEnemy() {
        if (this._onSlidingway || this._onSpringPole) {
            return;
        }
        if (this._onGround) {
            this._canPoint = false;
            if (this._canPoint) {
                if (this._gs._keyInterval++ > 4) {
                    this.usePoint();
                }
            } else {
                switch (this._action) {
                    case 2: {
                        this._nextAttackKey = 3;
                        this._gs.resetCurKey();
                        break;
                    }
                    case 3: {
                        this._nextAttackKey = 4;
                        this._gs.resetCurKey();
                        break;
                    }
                    case 4: {
                        this._nextAttackKey = 0;
                        this._nextAttackAct = 0;
                        break;
                    }
                    case 0: {
                        this.shakingDishcloth();
                        break;
                    }
                    default: {
                        this._nextAttackKey = 0;
                        this._nextAttackAct = 0;
                        this.towait(this._flipFlag);
                        break;
                    }
                }
            }
        } else if (this._isAllowJumpAttack) {
            this.changeAction(0x14 | this._flipFlag);
            this._isAllowJumpAttack = false;
        }
    }

    private void jumpToUp() {
        boolean bl = false;
        if (this.iswait()) {
            bl = true;
            this._isAllowJumpAttack = true;
            this._isAllowJumpAgain = false;
        } else if (this._isAllowJumpAgain && (bl = this._isAllowJumpOnThings)) {
            this._isAllowJumpAgain = false;
        }
        if (bl) {
            this.jumping(0, this._isAllowJumpOnThings ? -13653 : -10240, this._flipFlag);
        }
    }

    private void jumpToLeft() {
        boolean bl = false;
        if (this._isFlip) {
            if (this.iswait()) {
                bl = true;
                this._isAllowJumpAttack = true;
                this._isAllowJumpAgain = false;
            } else if (this._isAllowJumpAgain && (bl = this._isAllowJumpOnThings)) {
                this._isAllowJumpAgain = false;
            }
        } else if (this._onGround) {
            this.towait(Integer.MIN_VALUE);
        }
        if (bl) {
            this.jumping(-4096, this._isAllowJumpOnThings ? -13653 : -10240, Integer.MIN_VALUE);
        }
    }

    private void jumpToRight() {
        boolean bl = false;
        if (!this._isFlip) {
            if (this.iswait()) {
                bl = true;
                this._isAllowJumpAttack = true;
                this._isAllowJumpAgain = false;
            } else if (this._isAllowJumpAgain && (bl = this._isAllowJumpOnThings)) {
                this._isAllowJumpAgain = false;
            }
        } else if (this._onGround) {
            this.towait(0);
        }
        if (bl) {
            this.jumping(4096, this._isAllowJumpOnThings ? -13653 : -10240, 0);
        }
    }

    public void jumping(int n, int n2, int n3) {
        if (this._platform != null) {
            int n4 = this._platform.getVX();
            int n5 = this._platform.getVY();
            if (this._platform.getFashion() == 0) {
                if (n5 < 0) {
                    n2 += n5 / 2;
                }
            } else {
                n += n4 * 2 / 3;
                n2 += n5 * 2 / 3;
            }
        }
        this._vx = n;
        this._vy = n2;
        this._ay = 0;
        this._jumpVx = n;
        if (this._onSlidingway) {
            this.changeAction(0x1A | n3);
        } else if (this._onSpringPole) {
            this.changeAction(0x23 | n3);
        } else {
            this.changeAction(6 | n3);
        }
    }

    private void walkingToLeft() {
        if (!this._onSlidingway) {
            if (this._onSpringPole) {
                if (this._onGround) {
                    this.jumpDirSpringPole(Integer.MIN_VALUE);
                }
            } else if (this.iswait()) {
                if (this._isFlip) {
                    if (this._action != 1) {
                        this.changeAction(-2147483647);
                        this._vx = -8192;
                    }
                } else {
                    this.towait(Integer.MIN_VALUE);
                }
            }
        }
    }

    private void walkingToRight() {
        if (!this._onSlidingway) {
            if (this._onSpringPole) {
                if (this._onGround) {
                    this.jumpDirSpringPole(0);
                }
            } else if (this.iswait()) {
                if (!this._isFlip) {
                    if (this._action != 1) {
                        this.changeAction(1);
                        this._vx = 8192;
                    }
                } else {
                    this.towait(0);
                }
            }
        }
    }

    private void usePoint() {
        if (this._onGround) {
            this.changeAction(9 | this._flipFlag);
            Actor actor = this.flashView(this._x, this._y - 20480, 4);
            this._scene.pauseScreen();
            this._scene.pushActorIdPause(this._id);
            this._scene.pushActorIdPause(actor._id);
            this._vx = 0;
            this._ax = 0;
            this._isPointAllowHit = false;
            this._gs._keyInterval = 0;
            this._gs.resetCurKey();
        }
    }

    private boolean callFriendHelpMe(int n) {
        if (!this._onGround) {
            return false;
        }
        this._friend = (MainActor)this._scene.fetchActorFromPool(MainActor.C_MAIN_ID[n], -1);
        if (this._friend != null && this._friend.agreeAndHelp()) {
            if (n == 1 || n == 2) {
                this.changeAction(0x13 | this._flipFlag);
            } else if (n == 3) {
                this.changeAction(0x16 | this._flipFlag);
            }
            return true;
        }
        return false;
    }

    private void jinkout() {
        this._jinkCnt = 0;
        this._vx = 10240;
        this.changeAction(0xC | this._flipFlag);
        if (this._isFlip) {
            this._vx = -this._vx;
        }
    }

    private void jinkin() {
        this._vx = 10240;
        this.changeAction(0xD | this._flipFlag);
        if (!this._isFlip) {
            this._vx = -this._vx;
        }
    }

    protected void idle() {
        if (this._onBoard && this._onGround) {
            this._vx = 0;
            return;
        }
        if (this._propState == 1) {
            if (!this._onGround) {
                if (this._preVY <= 0 && this._vy >= 0) {
                    this._propJumpState = 0;
                }
                if (this._action == 35) {
                    this._ax = 0;
                }
            }
            this._preVY = this._vy;
        }
        if (this._action == 1) {
            this.towait(this._flipFlag);
        } else if (this._gs._keyInterval > 0 && !this.isAttack()) {
            this.shakingDishcloth();
        }
    }

    private boolean shakingDishcloth() {
        this.changeAction(2 | this._flipFlag);
        this._gs._keyInterval = 0;
        this._gs.resetCurKey();
        return true;
    }

    private void attackHandler() {
        if (this.isActionEnd()) {
            if (this._action == 4) {
                this.attackEnd();
            } else if (this._nextAttackKey > 0) {
                if (this._nextAttackKey == this._nextAttackAct) {
                    if (this._action == this._nextAttackAct) {
                        this.attackEnd();
                    }
                    this.changeAction(this._nextAttackAct | this._flipFlag);
                } else {
                    this.attackEnd();
                }
            } else {
                this.attackEnd();
            }
        } else {
            switch (this._action) {
                case 2: {
                    if (this._curFrame <= 0) break;
                    this.triggerToEnemy();
                    break;
                }
                case 3: {
                    this.triggerToEnemy();
                    break;
                }
                case 4: {
                    if (this._curFrame <= 1) break;
                    this.triggerToEnemy();
                }
            }
        }
    }

    private void attackEnd() {
        this._nextAttackAct = 0;
        this._nextAttackKey = 0;
        if (this._onGround) {
            this.towait(this._flipFlag);
        }
    }

    private void jumpHandler() {
        this._isAllowJumpOnThings = false;
        if (this._action == 6) {
            if (this._vy >= 0) {
                this.changeAction(7 | this._flipFlag);
            }
            this._vx = this._jumpVx;
        } else if (this._action == 7) {
            if (this._vy > 5120) {
                this.changeAction(8 | this._flipFlag);
            }
            this._vx = this._jumpVx;
        }
    }

    private void towait(int n) {
        this._vx = 0;
        this._ax = 0;
        this.changeAction(0 | n);
    }

    private boolean iswait() {
        return this._onGround && (this._action == 0 || this._action == 21);
    }

    public boolean isJump() {
        return this._action == 6 || this._action == 7 || this._action == 8;
    }

    public boolean isAttack() {
        return this._action == 2 || this._action == 3 || this._action == 4 || this._action == 20;
    }

    private void hurt(Actor actor) {
        int n = actor.getHurtMode();
        int n2 = this.getHurtHp(n);
        if (this._propState == 1) {
            this.changeAction(0x24 | this._flipFlag);
        } else if (this._propState == 2) {
            this.changeAction(0x1E | this._flipFlag);
        } else {
            this.changeAction(0x10 | this._flipFlag);
        }
        this.flashView(this._x, this._y - 25600, 1);
        this._hp -= n2;
        if (n == 8) {
            this._hurtMode = n;
        }
        Function.playSound(5, 1);
    }

    public void springJump(int n, int n2, int n3) {
        if (this._onGround) {
            this._autoJump = true;
            if (n3 > 0) {
                this.jumping(-SPRING_JUMP_VX[n], SPRING_JUMP_VY[n2], Integer.MIN_VALUE);
            } else {
                this.jumping(SPRING_JUMP_VX[n], SPRING_JUMP_VY[n2], 0);
            }
        }
    }

    public void notifyCanEnterDoor(int n, int n2, int n3) {
        if (this._onGround) {
            this._canEnterDoor = true;
            this._enterDoorX = n * this._bk._phytw * 2 << 10;
            this._enterDoorY = n2 * this._bk._phyth * 2 << 10;
            this._enterDoorFlip = n3;
        }
    }

    public void enterDoor() {
        this._x = this._enterDoorX;
        this._y = this._enterDoorY;
        this.changeAction(0 | (this._enterDoorFlip == 1 ? Integer.MIN_VALUE : 0));
        this._bk.init();
        this._gs.initCamera();
    }

    private boolean enableHurt() {
        return !this.isAttack() && this._hp > 0 && this._action != 16 && this._action != 18 && this._action != 12 && this._action != 13 && this._action != 9 && this._action != 10 && this._action != 11;
    }

    private boolean unableCollide() {
        return this._action != 1 && this._action != 6 && this._action != 7 && this._action != 8;
    }

    public void collideEnemy(Actor actor, int n, int n2, int n3, int n4) {
        if (this.unableCollide()) {
            return;
        }
        int n5 = n2 * 2 / 3;
        if (n5 < 0) {
            n5 = -n5;
        }
        if (actor._y - this._y >> 10 > n5) {
            return;
        }
        int n6 = actor._x + (n << 10);
        int n7 = actor._x + (n3 << 10);
        this._x = this._x < actor._x ? n6 - (this._r + 1 << 10) : n7 - (this._l - 1 << 10);
        this._dx = 0;
        this._vx = 0;
    }

    public void jumpupTurn(int n, int n2) {
        this.changeAction(0x17 | this._flipFlag);
        this._vy = -6144;
        int n3 = this._x >> 10;
        int n4 = Math.abs(n3 - (n >>= 10));
        if (n4 / 5 > 0) {
            this._vx = n > n3 ? n4 / 5 << 10 : -(n4 / 5) << 10;
        }
        this._jumpPropState = 0;
    }

    public void jumpupSlidingway(int n) {
        this._onSlidingway = true;
        this._propState = 2;
        this.changeAction(0x18 | n);
        this._vx = n == 0 ? 12288 : -12288;
    }

    public void jumpDownSlidingway() {
        this._onSlidingway = false;
        this._onSpringPole = false;
        this._propState = 0;
        this._jumpPropState = 1;
        this.changeAction(0x17 | this._flipFlag);
    }

    public boolean isJumpTurnOnSlidingway(Assistant assistant) {
        return this.collide(assistant) && this._action == 23 && this._jumpPropState == 0 && this._vy > 0;
    }

    public void jumpupSpringPole() {
        switch (this._propJumpState) {
            case 3: {
                this.changeAction(-2147483613);
                this._vx = -4096;
                this._vy = -18432;
                break;
            }
            case 4: {
                this.changeAction(35);
                this._vx = 4096;
                this._vy = -18432;
                break;
            }
            case 1: {
                this.changeAction(-2147483613);
                this._vx = -1400;
                this._vy = -10240;
                break;
            }
            case 2: {
                this.changeAction(35);
                this._vx = 1400;
                this._vy = -10240;
                break;
            }
            case 0: {
                this.changeAction(0x23 | this._flipFlag);
                this._vx = 0;
                this._vy = -10240;
            }
        }
        if (this._autoJump) {
            this._jumpVx = this._vx;
        }
    }

    public void setOnJumpSpringPole() {
        this._propJumpState = 0;
        this._onSpringPole = true;
        this._propState = 1;
        this.changeAction(0x22 | this._flipFlag);
        Function.playSound(4, 1);
    }

    public void jumpDirSpringPole(int n) {
        this._onSpringPole = true;
        this.changeAction(0x23 | n);
        this._vx = n == 0 ? 1400 : -1400;
        this._vy = 10240;
    }

    public boolean isJumpTurnOnSpringPole() {
        return this._onGround && this._action == 23 && this._jumpPropState == 0;
    }

    protected boolean canPressKey() {
        boolean bl = super.canPressKey();
        if (bl) {
            switch (this._action) {
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 32: 
                case 36: {
                    bl = false;
                    break;
                }
                case 33: {
                    if (!this._onPasspath) break;
                    return true;
                }
            }
        }
        if (bl) {
            bl = !this.isCollidePasspoint();
        }
        return bl;
    }

    protected void collideLeftWall() {
        if (this._onGround && this._propState == 2 && !this._autoJump) {
            this._slidingCollideLeftWall = true;
        }
        if (this._action == 12) {
            this.jinkin();
        }
    }

    protected void collideRightWall() {
        if (this._onGround && this._propState == 2 && !this._autoJump) {
            this._slidingCollideRightWall = true;
        }
        if (this._action == 12) {
            this.jinkin();
        }
    }

    protected void onLand() {
        if (this._onBoard) {
            if (!this._onPreGround) {
                this.changeAction(0x19 | this._flipFlag);
            }
            return;
        }
        this._autoJump = false;
        switch (this._propState) {
            case 0: {
                if (this._action == 16 || this._action == 17 || this._action == 18 || this._action == 13 || this._action == 23) {
                    return;
                }
                if (this._onPreGround) break;
                this.towait(this._flipFlag);
                break;
            }
            case 2: {
                this.slidingwayOnLand();
            }
        }
    }

    protected void onGround() {
        if (this._platform != null) {
            this._platform.releasePlatForm();
            this._platform = null;
        }
    }

    protected void slidingwayOnLand() {
        if (!this._onPreGround) {
            this.changeAction(0x19 | this._flipFlag);
            this._vx = this._isFlip ? -12288 : 12288;
        }
    }

    protected void onFall() {
        if (!this._visible && this._y >> 10 > this._bk.getMapHeight()) {
            if (this._scene.getFocusActor()._type != this._type) {
                return;
            }
            this._scene.gameLoseLife();
            return;
        }
        if (this._dy < 0) {
            return;
        }
        if (this._onSlidingway) {
            this.slidingwayOnFall();
        } else if (!this._onSpringPole) {
            switch (this._action) {
                case 2: {
                    if (this.isActionEnd()) {
                        this._vx = 0;
                        this._vy = 3072;
                        this._jumpVx = 0;
                        this.changeAction(6 | this._flipFlag);
                    }
                    return;
                }
                case 16: 
                case 17: {
                    if (this._onWater) {
                        this.produceSpray();
                    }
                    return;
                }
                case 12: {
                    this.jinkin();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 23: {
                    return;
                }
            }
            if (this._onPreGround) {
                this._vx = 0;
                this._vy = 3072;
                this._jumpVx = 0;
                this.changeAction(6 | this._flipFlag);
            }
        }
    }

    protected void slidingwayOnFall() {
        if (this._onPreGround) {
            this._vx = 0;
            this._vy = 3072;
            this.changeAction(0x1C | this._flipFlag);
        }
    }

    public void paintInfo(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        if (this._gs._curLevel < 8) {
            Scene._panel.draw(graphics, 0, 0, 0);
            MainActor.paintFace(graphics, 30, 48, 30);
            if (this._hp > 0) {
                int n = 67;
                int n2 = 12;
                int n3 = this._hp * 128 / this.C_TOTAL_HP;
                int n4 = 3;
                Function.drawEffectLightBar(graphics, n, n2, n3, n4, MainActor.HpColors);
            }
            SptSet sptSet = SptSet.getSptSet(10);
            sptSet.draw(graphics, 115, 25, 2);
            sptSet.draw(graphics, 133, 30, 6);
            Function.drawNumber(graphics, 163, 28, MainActor._moneyNum, true, false);
        } else if (this._gs._curLevel == 9) {
            int n = 1;
            int n5 = 1;
            Scene._panel.draw(graphics, 23 + n, 10 + n5, 44);
            if (this._hp > 0) {
                int n6 = this._hp * (Scene._panel.getSptWidth(44) - 7) / this.C_TOTAL_HP;
                int n7 = 3;
                Function.drawEffectLightBar(graphics, 23 + (n += 3), 10 + (n5 += 3), n6, n7, MainActor.HpColors);
            }
        }
        if (Scene._state == 0) {
            if (this._onTimer) {
                long l = System.currentTimeMillis();
                if ((l - this._curTime) / 1000L > 0L) {
                    --this._totalTime;
                    this._curTime = l;
                }
                if (this._totalTime < 0) {
                    this._totalTime = 0;
                    if (this._onGround && !this._levelPassed) {
                        this._levelPassed = true;
                        this._scene.gamePassLevel();
                    }
                }
                Scene._panel.draw(graphics, 28, 26 - (this._gs._curLevel - 8) * 12, 29);
                Function.drawNumber(graphics, 73, 30 - (this._gs._curLevel - 8) * 12, this._totalTime, false, false);
            } else if (this._onBoard && EnemyThing._rankCnt >= 16 && this._passTime++ > 50) {
                if (EnemyThing._rankCnt >= 16) {
                    if (this._timeTick++ < 50) {
                        return;
                    }
                    this._timeTick = 0;
                }
                this._scene.submitScript(1);
            }
        }
        if (this._onFire) {
            if (this._gs._curLevel == 6) {
                this._gs.drawTimeLine(graphics, 48, 52, this._firePower - 0, 18, false);
            } else {
                this._gs.drawTimeLine(graphics, 24, 11, this._firePower - 0, 18, false);
            }
        }
    }

    public boolean process(Actor actor) {
        if (this._propState == 2) {
            if (this._action == 32 || this._action == 24 || this._action == 28 || this._action == 25 || this._action == 24) {
                this._hp -= 2;
            }
            if (this._hp <= 0) {
                this.jumpDownSlidingway();
                return false;
            }
            if (this._action != 26 && this._action != 27 && this._action != 30) {
                this.changeAction(0x1E | this._flipFlag);
                return true;
            }
        }
        switch (this._action) {
            case 2: {
                this._nextAttackAct = 3;
                this._x = this._isFlip ? (this._x -= 4096) : (this._x += 4096);
                Function.playSound(2, 1);
                break;
            }
            case 3: {
                this._nextAttackAct = 4;
                this._x = this._isFlip ? (this._x -= 4096) : (this._x += 4096);
                Function.playSound(2, 1);
                break;
            }
            case 4: {
                this._nextAttackAct = 0;
                Function.playSound(2, 1);
                break;
            }
            case 12: {
                this._isPointAllowHit = true;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this._isAllowJumpOnThings = true;
            }
        }
        return false;
    }

    public boolean notify(Actor actor) {
        if (actor._type == 29) {
            this.hurt(actor);
        }
        if (!this.enableHurt()) {
            return false;
        }
        if (!this.checkRelation(actor.getRelation()) || !this.checkSequence(actor)) {
            return false;
        }
        switch (actor._type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 29: {
                this.hurt(actor);
                return true;
            }
        }
        return false;
    }

    protected void submergence() {
        this._vy = 4096;
        this._ay = 0;
        this._hp = 0;
        if (this._action != 16) {
            this.changeAction(0x10 | this._flipFlag);
        }
    }

    protected int getOnPasspathXpos() {
        int n = this._onSlidingway ? 0 : 8;
        if (this._isFlip) {
            return this._x + (-n << 10);
        }
        return this._x + (n << 10);
    }

    protected int getOnPasspathYpos() {
        int n = this._onSlidingway ? 0 : -47;
        return this._y + (n << 10);
    }

    protected void setOnPasspathYpos(int n) {
        int n2 = this._onSlidingway ? 0 : -47;
        this._y = (n -= n2) << 10;
    }

    protected void collidePasspoint(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        super.collidePasspoint(n, n2, n3, n4, n5);
        boolean bl2 = bl = n4 > 0;
        if (n5 == 1) {
            if (this._onPasspath) {
                this._onPasspath = false;
            } else {
                this._onPasspoint = false;
            }
        } else if (n5 != 2 && (n5 == 3 || n5 == 0) && this._onGround) {
            if (this._onSlidingway) {
                int n6 = this._x >> 10;
                if (Math.abs(n - n6) > 10) {
                    if (bl && n6 > n) {
                        this.walkingToLeft();
                        return;
                    }
                    if (n6 < n) {
                        this.walkingToRight();
                        return;
                    }
                }
                this._isFlip = bl;
                if (bl) {
                    this.jumping(-2730, -10240, Integer.MIN_VALUE);
                } else {
                    this.jumping(2730, -10240, 0);
                }
            } else {
                this._isFlip = bl;
                if (bl) {
                    this.walkingToLeft();
                } else {
                    this.walkingToRight();
                }
            }
        }
    }

    protected void onPasspath() {
        int n;
        int n2 = this.getOnPasspathXpos();
        if (!this.gotoTargetPoint(n2, n = this.getOnPasspathYpos(), this._curPasspathTxpos, this._curPasspathTypos, 12288, 12288)) {
            if (this._onSlidingway) {
                if (this._action != 33 || this._isFlip != this._curPasspathFlip) {
                    this.changeAction(0x21 | (this._curPasspathFlip ? Integer.MIN_VALUE : 0));
                }
            } else if (this._action != 15 || this._isFlip != this._curPasspathFlip) {
                this.changeAction(0xF | (this._curPasspathFlip ? Integer.MIN_VALUE : 0));
            }
        }
    }

    protected void traverUnable(Actor actor) {
        if (this._x < actor._x) {
            int n = actor._x + (actor._l << 10);
            this._x = n - (this._l - 2 << 10);
        } else {
            int n = actor._x + (actor._r << 10);
            this._x = n + (this._r + 2 << 10);
        }
        this._vx = 0;
    }

    public int getHurtMode() {
        if (this._propState == 1) {
            return 7;
        }
        switch (this._action) {
            case 2: 
            case 3: {
                return 0;
            }
            case 4: 
            case 20: {
                return 1;
            }
            case 11: {
                return 5;
            }
            case 12: {
                return 19;
            }
        }
        if (this._propState == 2) {
            return 6;
        }
        return -1;
    }

    public int getXDirLocation(int n) {
        switch (this._action) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return this._gs._camx;
            }
        }
        return super.getXDirLocation(n);
    }

    public int getYDirLocation(int n) {
        if (this._action == 10 || this._action == 11 || this._action == 12 || this._action == 13) {
            return this._gs._camy;
        }
        if (this._onTimer) {
            return this._y - n / 3;
        }
        return super.getYDirLocation(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean issolid(int n) {
        if (this._onBoard) {
            if (n != 1) return false;
            return true;
        }
        if (n == 1) return true;
        if (n == 2) return true;
        if (n == 10) return true;
        if (n != 5) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isupsolid(int n) {
        if (n == 1) return true;
        if (n != 10) return false;
        return true;
    }

    protected void startScriptActorMove(int n, int n2) {
        int n3 = this._x >> 10;
        int n4 = this._y >> 10;
        if (n3 < n) {
            this.changeAction(0);
        } else if (n3 > n) {
            this.changeAction(Integer.MIN_VALUE);
        }
        if (n3 < n) {
            this.walkingToRight();
        } else if (n3 > n) {
            this.walkingToLeft();
        }
    }

    protected boolean endScriptActorMove(int n, int n2) {
        if (GameScreen._safeTimeTick++ > 600) {
            GameScreen._safeTimeTick = 0;
            return true;
        }
        int n3 = this._x >> 10;
        int n4 = Math.abs(n3 - n);
        if (n4 < 8) {
            this._x = n << 10;
            this.idle();
            return true;
        }
        return false;
    }

    protected void startScriptCallFunction(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                this._friendType = 0;
                this.usePoint();
                this._canPoint = true;
                break;
            }
            case 1: {
                this._friendType = 2;
                this.callFriendHelpMe(1);
                break;
            }
            case 2: {
                this._friendType = 3;
                this.callFriendHelpMe(2);
                break;
            }
            case 4: {
                this._friendType = 4;
                MainActor mainActor = (MainActor)this._scene.fetchActorFromPool(MainActor.C_MAIN_ID[3], -1);
                if (mainActor == null) break;
                mainActor.agreeAndHelp();
                break;
            }
            case 3: {
                this._scene.gamePassLevel();
                break;
            }
            case 5: {
                this._onFire = true;
                this._firePower = 0;
                this._bigFire = (EnemyThrow)this._scene.getActiveActor(n2);
                this._scene.registerActor(this, 0);
                break;
            }
            case 7: {
                this._onFire = true;
                this._firePower = 0;
                this._bigFire = (EnemyThrow)this._scene.getActiveActor(n2);
                this._onTimer = true;
                this._totalTime = n3;
                this._curTime = System.currentTimeMillis();
                break;
            }
            case 8: {
                this._scene.gamePassLevel();
                break;
            }
            case 6: {
                this._scene.registerActor(this, 0);
            }
        }
    }

    protected boolean endScriptCallFunction(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return this.iswait();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected void stop() {
        this.towait(this._flipFlag);
        this._gs.resetKeyBuff();
    }

    protected boolean checkPlatform() {
        if (super.checkPlatform()) {
            if (this._vy > 5120 && this._platform.isBoard() && this._platform.getFashion() == 0) {
                BridgeBoard._bridgeMoveState = 1;
                BridgeBoard._jumpDownId = this._platform.getID() - BridgeBoard._firstBridgeID;
                BridgeBoard._jumpDownSpeed = 10240;
                BridgeBoard.setBoardSpring(3);
                BridgeBoard.springHuman(this._id);
            }
            return true;
        }
        if (this._platform != null) {
            this._platform.releasePlatForm();
        }
        return false;
    }

    protected void boardSpring(int n) {
        this.jumping(3, 3, 3);
        if (this._propJumpState == 1) {
            this.jumping(-1800, -14336, Integer.MIN_VALUE);
        } else if (this._propJumpState == 2) {
            this.jumping(1800, -14336, 0);
        } else {
            this.jumping(0, -14336, this._flipFlag);
        }
    }

    public void tipCallFriend(int n, int n2) {
        if (this._onSlidingway || this._onSpringPole) {
            return;
        }
        this._curCaptor = n2;
        this._tipCallFriend = true;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this._friendType = 2;
                break;
            }
            case 4: {
                this._friendType = 4;
                break;
            }
            case 5: {
                this._friendType = 0;
                break;
            }
            case 0: {
                this._friendType = 3;
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        super.draw(graphics, n, n2);
        int n3 = (this._x >> 10) - n + 6;
        int n4 = (this._y >> 10) - n2 - 60 + TiledBackground.C_MAP_OFF_Y;
        if (this._saveTipCallFriend) {
            this._gs.drawButtom(graphics, n3, n4, 5);
        }
        if (this._action == 9) {
            Scene._character.draw(graphics, (240 - Scene._character.getSptWidth(0)) / 2, 80, 0);
        } else if (this._action == 19) {
            Scene._character.draw(graphics, (240 - Scene._character.getSptWidth(2)) / 2, 80, this._friendType == 2 ? 2 : 3);
        } else if (this._action == 22) {
            Scene._character.draw(graphics, (240 - Scene._character.getSptWidth(2)) / 2, 80, 1);
        }
    }

    public boolean canJumpOnProp() {
        return this._action == 0 || this._action == 21 || this._action == 1 || this._action == 23;
    }

    protected int getBodyLeft() {
        if (this.isAttack()) {
            return this._isFlip ? -this._anim._r[0] : this._anim._l[0];
        }
        return this._l;
    }

    protected int getBodyRight() {
        if (this.isAttack()) {
            return this._isFlip ? -this._anim._l[0] : this._anim._r[0];
        }
        return this._r;
    }

    public boolean canCheckPasspath() {
        return this._propState != 1;
    }
}

