/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import tjge.Actor;
import tjge.Animation;
import tjge.EnemyThing;
import tjge.EnemyThrow;
import tjge.MainActor;

public class Boss
extends MainActor {
    private static final int C_SCRIPT_BOSS_FIRE = 0;
    private static final int C_SCRIPT_BOSS_JUMPOT = 1;
    private static final int C_SCRIPT_BOSS_FIRE2 = 2;
    private static final int C_SCRIPT_BOSS_REGISTER = 3;
    private static final int C_ACT_BOSS_WAIT = 0;
    private static final int C_ACT_BOSS_FIRE = 2;
    private static final int C_ACT_BOSS_SQUAT = 3;
    private static final int C_ACT_BOSS_DEFIANT = 4;
    private static final int C_ACT_BOSS_DIE = 5;
    public static final int C_BOSS_FIRST_FIRE = 0;
    public static final int C_BOSS_SECOND_FIRE = 1;
    public static final int C_BOSS_NORMAL_FIRE = 2;
    private int _bossTimeTick = 0;
    private int _BigGunID;
    private int _BigGunID2;
    private int _loadId;
    private int _timeTick;
    private int _fireType;
    private boolean _hitTheTarget;
    private boolean _isBombExplosion;

    public Boss(int n, Animation animation) {
        super(n, animation);
        this._ownKind = 2;
    }

    protected boolean init(byte[] byArray) {
        boolean bl = super.init(byArray);
        this._hitTheTarget = false;
        if (byArray.length - 1 >= 7) {
            this._BigGunID = byArray[7];
        }
        if (byArray.length - 1 >= 8) {
            this._BigGunID2 = byArray[8];
            this._timeTick = 30;
        } else {
            this._BigGunID2 = 0;
        }
        this._fireType = 2;
        this._hp = 20;
        return bl;
    }

    public void ai() {
        if (this._BigGunID < 0) {
            return;
        }
        switch (this._action) {
            case 0: {
                if (this._hitTheTarget) {
                    this.changeAction(4 | this._flipFlag);
                    break;
                }
                Actor actor = this._scene.getFocusActor();
                if (actor._id == this._id && this._timeTick++ > 20) {
                    this._timeTick = 0;
                    this._loadId = this._BigGunID;
                    this.changeAction(2 | this._flipFlag);
                    break;
                }
                if (this._BigGunID2 == 0 || EnemyThing._rankCnt >= 16 || this._timeTick++ <= 40) break;
                this._timeTick = 0;
                if (this._loadId == this._BigGunID) {
                    this._loadId = this._BigGunID2;
                    this.changeAction(-2147483646);
                    break;
                }
                this._loadId = this._BigGunID;
                this.changeAction(-2147483646);
                break;
            }
            case 2: {
                if (this._curFrame == 4 && this._x > 0) {
                    this._isBombExplosion = false;
                    EnemyThrow enemyThrow = (EnemyThrow)this._scene.getActiveActor(this._loadId);
                    if (enemyThrow != null) {
                        enemyThrow.fire(this._fireType, 0, this);
                    }
                }
                if (!this.isActionEnd()) break;
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 3: {
                if (!this._isBombExplosion || ++this._bossTimeTick <= 3) break;
                this._bossTimeTick = 0;
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 4: {
                if (!this.isActionEnd()) break;
                this._hitTheTarget = false;
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 5: {
                if (this._hp > 0) {
                    if (this._timeTick++ <= 10) break;
                    this.changeAction(0 | this._flipFlag);
                    this._timeTick = 0;
                    break;
                }
                this._scene.submitScript(3);
            }
        }
    }

    public boolean notify(Actor actor) {
        if (actor._type == 16) {
            this._hp -= actor.getHurtHp(12);
            this.changeAction(5 | this._flipFlag);
        }
        return false;
    }

    protected void startScriptCallFunction(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                this._loadId = this._BigGunID;
                this.changeAction(-2147483646);
                this._fireType = 0;
                break;
            }
            case 2: {
                this._loadId = this._BigGunID;
                this.changeAction(2 | this._flipFlag);
                this._fireType = 1;
                break;
            }
            case 1: {
                this.changeAction(n3);
                this._vx = 8192;
                this._vy = -8192;
                break;
            }
            case 3: {
                this._scene.registerActor(this, 1);
                this.changeAction(Integer.MIN_VALUE);
            }
        }
    }

    protected boolean endScriptCallFunction(int n, int n2, int n3) {
        switch (n) {
            case 0: 
            case 2: {
                if (this._type != 36 || !this.isActionEnd()) break;
                this.changeAction(0 | this._flipFlag);
                this._fireType = 2;
                return true;
            }
            case 1: {
                this.changeAction(n3);
                this._vx = 10240;
                this._vy = -1024;
                Actor actor = this._scene.getActiveActor(n2);
                actor._x = this._x - 10240;
                actor._y = this._y + 5120;
                return !this._visible;
            }
            case 3: {
                this._timeTick = 0;
                return true;
            }
        }
        return false;
    }

    public void stop() {
        this.changeAction(0);
    }

    protected boolean checkGround() {
        return true;
    }
}

