/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import tjge.Actor;
import tjge.Animation;
import tjge.EnemyThing;
import tjge.Human;
import tjge.MainActor;
import tjge.Platform;

public class BridgeBoard
extends Actor
implements Platform {
    public static final int C_SPRINT = 0;
    public static final int C_FALL = 1;
    public static final int C_TRIGGER = 2;
    public static final int C_AUTO = 3;
    public static final int C_BOMB = 4;
    private static final int C_BRIDGE_OFF_VALUE = 2046;
    private static final int BRIDGE_MOVE_DISTANCE = 4092;
    private static final int C_LEFT = 1;
    private static final int C_RIGHT = 2;
    private static final int C_DOWN = 4;
    private static final int C_RESUME = 1;
    public static boolean _bridgeArrayinited = false;
    private static final int C_BRIDGE_BOARD_TIMING = 2;
    public static BridgeBoard[] _bridgeBoardArray;
    private static final int C_ARRAY_MAX_NUM = 30;
    public static int[] _standHumanId;
    private static final int C_BRIDGE_STAND_HUMAN_MAX_NUM = 5;
    public static int _bridgeArrayNum;
    public static boolean _bridgeArrayCalled;
    public static int _standHumanNum;
    public static int _jumpDownId;
    public static int _jumpDownSpeed;
    public static final int C_JUMP_DOWN_GATE = 5120;
    public static int _bridgeMoveState;
    public static boolean _isMoveEnd;
    public static int _firstBridgeID;
    static int _boardArrayState;
    private int _initx;
    private int _inity;
    private EnemyThing _bridgeBomb = null;
    public int _boradState = 0;
    public int _bridgeTargetPosition;
    private int _bridgeTargetPositionX;
    public int _bridgeMoveDownMaxValue;
    public boolean _hedBeenStanded = false;
    public int _prePositionY = 0;
    private static byte _bridgeTimeTick;
    public int _fashion;
    public Actor _standActor = null;
    private int _moveFashion;
    boolean _isNotified = false;
    private int _timeTick;
    private int _distance;
    public boolean _isDrop;
    private boolean _preVisible;
    private int _bridgeMoveSpeed;
    private boolean _isTriggered;
    public static final int C_MOVE_SPEED = 3072;
    public static final int C_WAIT_TIME = 20;
    public static final int C_BACK_SPEED = 6000;
    public static final int C_STAY_TIME = 60;
    private boolean _triggerBoardMove = false;

    public BridgeBoard(int n, Animation animation) {
        super(n, animation);
    }

    protected boolean init(byte[] byArray) {
        boolean bl = super.init(byArray);
        this._fashion = byArray[7];
        this._moveFashion = byArray[8];
        this._distance = byArray[9];
        this._distance <<= 13;
        this._isDrop = false;
        this._isNotified = false;
        this._timeTick = 0;
        this._bridgeTargetPosition = this._y;
        this._bridgeTargetPositionX = this._x;
        this._boradState = 0;
        this._hedBeenStanded = false;
        this._prePositionY = 0;
        this._standActor = null;
        this._initx = this._x;
        this._inity = this._y;
        if (this._fashion == 0) {
            BridgeBoard.bridgeArrayReset();
        }
        this._deviceReady = this._moveFashion == 1;
        this._triggerBoardMove = false;
        return bl;
    }

    static void bridgeArrayReset() {
        _bridgeArrayinited = false;
        _bridgeArrayNum = 0;
        _bridgeArrayCalled = false;
        _jumpDownId = -1;
        _jumpDownSpeed = 0;
        _bridgeMoveState = 0;
        _boardArrayState = 0;
    }

    private void initBridgeBoard() {
        _firstBridgeID = this._id;
        Actor actor = null;
        int n = 0;
        while (n < 30) {
            actor = this._scene.getActiveActor(_firstBridgeID - 1);
            if (actor == null || !actor.isBoard()) break;
            --_firstBridgeID;
            ++n;
        }
        _bridgeArrayNum = 0;
        int n2 = _firstBridgeID;
        while (n2 < _firstBridgeID + 30) {
            actor = this._scene.getActiveActor(n2);
            if (actor == null || !actor.isBoard()) break;
            BridgeBoard._bridgeBoardArray[BridgeBoard._bridgeArrayNum++] = (BridgeBoard)actor;
            ++n2;
        }
        int n3 = 0;
        while (n3 < _bridgeArrayNum) {
            int n4 = n3 + 1;
            int n5 = _bridgeArrayNum - n3;
            if (n4 > n5) {
                n4 = n5;
            }
            if (n4 > 4) {
                n4 = 4;
            }
            BridgeBoard._bridgeBoardArray[n3]._bridgeMoveDownMaxValue = n4 * 4092;
            ++n3;
        }
        _bridgeArrayinited = true;
    }

    public void step() {
        this._prePositionY = this._y;
        if (this._fashion == 0) {
            if (this._bridgeTargetPosition > this._y) {
                if (this._bridgeTargetPosition - this._y <= this._bridgeMoveSpeed) {
                    this._dy = this._bridgeTargetPosition - this._y;
                    this._vy = 0;
                } else {
                    this._dy = this._vy = this._bridgeMoveSpeed;
                }
            } else if (this._y - this._bridgeTargetPosition <= this._bridgeMoveSpeed) {
                this._dy = this._bridgeTargetPosition - this._y;
                this._vy = 0;
            } else {
                this._dy = this._vy = -this._bridgeMoveSpeed;
            }
        } else if (this._fashion == 4 || this._fashion == 2 || this._fashion == 3 || this._fashion == 1) {
            this._dx = this._vx;
            this._dy = this._vy;
        }
        this._x += this._dx;
        this._y += this._dy;
    }

    public void ai() {
        try {
            switch (this._fashion) {
                case 0: {
                    if (_bridgeArrayinited) break;
                    this.initBridgeBoard();
                    break;
                }
                case 1: {
                    this.stableBoard();
                    break;
                }
                case 2: {
                    if (this._moveFashion == 1) {
                        this.aiResumeBoard();
                        break;
                    }
                    this.aiTriggerBoard();
                    break;
                }
                case 3: {
                    this.aiAutoBoard();
                    break;
                }
                case 4: {
                    this.aiBombBridge();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("" + exception);
        }
    }

    private void aiResumeBoard() {
        if (this._isTriggered) {
            if (this._y > this._inity + this._distance) {
                this._vy = 0;
                ++this._timeTick;
            }
            if (this._timeTick > 20) {
                Actor actor = this._scene.getMainActor();
                if (actor._type == 0 && this.collide(actor)) {
                    actor._y -= 8200;
                    actor._onGround = false;
                }
                this._timeTick = 0;
                this._vy = -6000;
            }
            if (this._y < this._inity) {
                this._deviceReady = true;
                this._timeTick = 0;
                this._vy = 0;
                this._isTriggered = false;
                this._y = this._inity;
            }
        }
    }

    private void aiAutoBoard() {
        if (this._moveFashion == 4) {
            this.downMoveBoard();
        } else if (this._moveFashion == 1) {
            this.leftMoveBorad();
        } else if (this._moveFashion == 2) {
            this.rightMoveBoard();
        }
    }

    private void aiBombBridge() {
        if (this._bridgeBomb != null && this._bridgeBomb._active) {
            this._bridgeBomb._x = this._x;
            this._bridgeBomb._y = this._y;
        } else if (!this._preVisible && this._visible) {
            this._bridgeBomb = (EnemyThing)this._scene.fetchActorFromPool(16, -1);
            this._bridgeBomb.setBombKind(5);
        }
        this._preVisible = this._visible;
        this.aiAutoBoard();
    }

    private void aiTriggerBoard() {
        if (!this._triggerBoardMove) {
            MainActor mainActor = (MainActor)this._scene.getFocusActor();
            if (this.onFloor(mainActor) && mainActor._x + 4096 > this._x) {
                this._bridgeTargetPositionX = this._distance + this._initx;
                this._vx = 3096;
                this._triggerBoardMove = true;
            }
        } else if (this._moveFashion == 2 && this._bridgeTargetPositionX - this._x < 3096) {
            this._x = this._bridgeTargetPositionX;
            this._vx = 0;
        }
    }

    public void setBridgeMoveSpeed(int n) {
        this._bridgeMoveSpeed = Math.abs(this._bridgeTargetPosition - this._y) * 2 / 3;
    }

    public void setBridgeTargetPosition(int n) {
        this._bridgeTargetPosition = this._inity + n;
    }

    private void stableBoard() {
        Actor actor = this._scene.getFocusActor();
        if (this._isDrop) {
            if (++this._timeTick > 2) {
                if (!this._isNotified) {
                    boolean bl = false;
                    boolean bl2 = false;
                    Actor actor2 = this._scene.getActiveActor(this._id + 1);
                    if (actor2 != null) {
                        actor2.notifyID(this);
                        bl2 = true;
                    }
                    if ((actor2 = this._scene.getActiveActor(this._id - 1)) != null) {
                        actor2.notifyID(this);
                        bl = true;
                    }
                    if (bl && bl2) {
                        this._isNotified = true;
                    }
                }
                this._vy = 5120;
                if (this.checkGround()) {
                    this.disLife();
                }
            }
        } else if (this.onFloor(actor)) {
            this._isDrop = true;
        }
    }

    private void downMoveBoard() {
        if (this._vy == 0) {
            this._vy = 3072;
        }
        if (this._y < this._inity) {
            this._vy = 3072;
        }
        if (this._y > this._inity + this._distance) {
            this._vy = -3072;
        }
    }

    private void leftMoveBorad() {
        if (this._vx == 0) {
            this._vx = -3072;
        }
        if (this._x > this._initx) {
            this._vx = -3072;
        }
        if (this._x < this._initx - this._distance) {
            if (this._fashion == 4) {
                this._deviceReady = this._bridgeBomb != null && this._bridgeBomb._active;
                if (this._timeTick++ > 60) {
                    this._deviceReady = false;
                    this._timeTick = 0;
                    this._x += 1024;
                    this._vx = 3072;
                    return;
                }
                this._vx = 0;
                return;
            }
            this._vx = 3072;
        }
    }

    private void rightMoveBoard() {
        if (this._vx == 0) {
            this._vx = 3072;
        }
        if (this._x < this._initx) {
            if (this._fashion == 4) {
                this._deviceReady = this._bridgeBomb != null && this._bridgeBomb._active;
                if (this._timeTick++ > 60) {
                    this._deviceReady = false;
                    this._timeTick = 0;
                    this._x += 1024;
                    this._vx = 3072;
                    return;
                }
                this._vx = 0;
                return;
            }
            this._vx = 3072;
        }
        if (this._x > this._initx + this._distance) {
            this._vx = -3072;
        }
    }

    public void getParameter(int[] nArray) {
        nArray[7] = 0;
        nArray[5] = 0;
        nArray[2] = nArray[2] + this._vx;
        nArray[1] = this.getFloor();
        nArray[3] = this._fashion == 0 ? (this._bridgeTargetPosition > this._y ? (this._bridgeTargetPosition - this._y <= this._bridgeMoveSpeed ? this._bridgeTargetPosition - this._y : this._bridgeMoveSpeed) : (this._y - this._bridgeTargetPosition <= this._bridgeMoveSpeed ? this._bridgeTargetPosition - this._y : -this._bridgeMoveSpeed)) : this._vy;
    }

    protected final int getFloor() {
        return this._y + 2048;
    }

    public static void aiBridgeArray() {
        _isMoveEnd = true;
        int n = 0;
        while (n < _bridgeArrayNum) {
            if (BridgeBoard._bridgeBoardArray[n]._vy != 0) {
                _isMoveEnd = false;
                break;
            }
            ++n;
        }
        switch (_bridgeMoveState) {
            case 0: {
                BridgeBoard.setNormalBoard(_isMoveEnd);
                break;
            }
            case 1: {
                if (!_isMoveEnd) break;
                _bridgeMoveState = 2;
                BridgeBoard.setBoardSpring(-2);
                break;
            }
            case 2: {
                if (!_isMoveEnd) break;
                _bridgeMoveState = 3;
                BridgeBoard.setBoardSpring(1);
                break;
            }
            case 3: {
                if (!_isMoveEnd) break;
                _bridgeMoveState = 0;
                BridgeBoard.setNormalBoard(_isMoveEnd);
            }
        }
    }

    static void springHuman(int n) {
        int n2 = 0;
        while (n2 < _bridgeArrayNum) {
            if (BridgeBoard._bridgeBoardArray[n2]._standActor != null && BridgeBoard._bridgeBoardArray[n2]._hedBeenStanded && n != BridgeBoard._bridgeBoardArray[n2]._standActor._id) {
                BridgeBoard._bridgeBoardArray[n2]._standActor.boardSpring(_jumpDownSpeed);
            }
            ++n2;
        }
    }

    static void setBoardSpring(int n) {
        int n2 = BridgeBoard._bridgeBoardArray[BridgeBoard._jumpDownId]._bridgeMoveDownMaxValue + _jumpDownSpeed * n / 3;
        BridgeBoard.setFrontBoard(_jumpDownId, n2, 2046);
        BridgeBoard.setBackBoard(_jumpDownId, n2, 2046);
    }

    static void setNormalBoard(boolean bl) {
        _standHumanNum = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < _bridgeArrayNum) {
            if (BridgeBoard._bridgeBoardArray[n2]._hedBeenStanded) {
                ++_standHumanNum;
                BridgeBoard._standHumanId[n++] = n2;
            }
            ++n2;
        }
        if (_standHumanNum == 0 && _bridgeMoveState == 0) {
            byte by = _bridgeTimeTick;
            _bridgeTimeTick = (byte)(by + 1);
            if (by < 15) {
                int n3 = 0;
                if (bl) {
                    int n4 = 0;
                    while (n4 < _bridgeArrayNum) {
                        n3 = BridgeBoard._bridgeBoardArray[n4]._y - BridgeBoard._bridgeBoardArray[n4]._inity;
                        _bridgeBoardArray[n4].setBridgeTargetPosition(-n3);
                        BridgeBoard._bridgeBoardArray[n4]._bridgeMoveSpeed = Math.abs(BridgeBoard._bridgeBoardArray[n4]._bridgeTargetPosition - BridgeBoard._bridgeBoardArray[n4]._y) / 5;
                        ++n4;
                    }
                }
            } else {
                _bridgeTimeTick = 0;
                int n5 = 0;
                while (n5 < _bridgeArrayNum) {
                    BridgeBoard._bridgeBoardArray[n5]._bridgeTargetPosition = BridgeBoard._bridgeBoardArray[n5]._inity;
                    BridgeBoard._bridgeBoardArray[n5]._bridgeMoveSpeed = Math.abs(BridgeBoard._bridgeBoardArray[n5]._bridgeTargetPosition - BridgeBoard._bridgeBoardArray[n5]._y) / 3;
                    ++n5;
                }
            }
        } else if (_standHumanNum % 2 == 1) {
            int n6 = BridgeBoard._bridgeBoardArray[BridgeBoard._standHumanId[BridgeBoard._standHumanNum / 2]]._bridgeMoveDownMaxValue;
            BridgeBoard.setFrontBoard(_standHumanId[_standHumanNum / 2], n6, 2046);
            BridgeBoard.setBackBoard(_standHumanId[_standHumanNum / 2], n6, 2046);
        } else {
            int n7 = BridgeBoard._bridgeBoardArray[BridgeBoard._standHumanId[BridgeBoard._standHumanNum / 2 - 1]]._bridgeMoveDownMaxValue;
            BridgeBoard.setFrontBoard(_standHumanId[_standHumanNum / 2 - 1], n7, 2046);
            n7 = BridgeBoard._bridgeBoardArray[BridgeBoard._standHumanId[BridgeBoard._standHumanNum / 2]]._bridgeMoveDownMaxValue;
            BridgeBoard.setBackBoard(_standHumanId[_standHumanNum / 2], n7, 2046);
            if (_standHumanId[_standHumanNum / 2 - 1] != _standHumanId[_standHumanNum / 2]) {
                BridgeBoard.setMiddleBoard(_standHumanId[_standHumanNum / 2 - 1], _standHumanId[_standHumanNum / 2]);
            }
        }
    }

    static void setFrontBoard(int n, int n2, int n3) {
        int n4 = n2 / (n + 1);
        int n5 = 0;
        if (n > 4) {
            n5 = n3 / (n + 1);
        }
        if (n4 < 0) {
            n5 = -n5;
        }
        int n6 = n;
        while (n6 >= 0) {
            _bridgeBoardArray[n6].setBridgeTargetPosition(n4 * (n6 + 1) + n6 * n5);
            _bridgeBoardArray[n6].setBridgeMoveSpeed(3);
            --n6;
        }
    }

    static void setMiddleBoard(int n, int n2) {
        int n3 = BridgeBoard._bridgeBoardArray[n]._bridgeTargetPosition - BridgeBoard._bridgeBoardArray[n2]._bridgeTargetPosition;
        int n4 = Math.abs(n3) / (n2 - n);
        int n5 = Math.min(BridgeBoard._bridgeBoardArray[n]._bridgeTargetPosition - BridgeBoard._bridgeBoardArray[n]._inity, BridgeBoard._bridgeBoardArray[n2]._bridgeTargetPosition - BridgeBoard._bridgeBoardArray[n2]._inity);
        int n6 = 1;
        if (n3 < 0) {
            int n7 = n + 1;
            while (n7 < n2) {
                _bridgeBoardArray[n7].setBridgeTargetPosition(n5 + n6++ * n4);
                _bridgeBoardArray[n7].setBridgeMoveSpeed(3);
                ++n7;
            }
        } else {
            int n8 = n2 - 1;
            while (n8 > n) {
                _bridgeBoardArray[n8].setBridgeTargetPosition(n5 + n6++ * n4);
                _bridgeBoardArray[n8].setBridgeMoveSpeed(3);
                --n8;
            }
        }
    }

    static void setBackBoard(int n, int n2, int n3) {
        int n4 = n2 / (_bridgeArrayNum - n);
        int n5 = 0;
        if (_bridgeArrayNum - n > 5) {
            n5 = n3 / (_bridgeArrayNum - n);
        }
        if (n4 < 0) {
            n5 = -n5;
        }
        int n6 = n;
        while (n6 < _bridgeArrayNum) {
            _bridgeBoardArray[n6].setBridgeTargetPosition(n4 * (_bridgeArrayNum - n6) + (_bridgeArrayNum - n6 - 1) * n5);
            _bridgeBoardArray[n6].setBridgeMoveSpeed(3);
            ++n6;
        }
    }

    public void notifyID(Actor actor) {
        if (actor._type == 27) {
            this._isDrop = true;
        }
    }

    public void openTheDoor() {
        if (this._moveFashion == 1) {
            this._vy = 3072;
            this._isTriggered = true;
            this._deviceReady = false;
        }
    }

    public void notifyFloatPlatform(Actor actor) {
        this._hedBeenStanded = true;
        this._standActor = actor;
    }

    public boolean onFloor(Actor actor) {
        int n;
        if (this._isDrop && this._vy > 0) {
            return false;
        }
        Human human = (Human)actor;
        int n2 = this._l;
        int n3 = this._r;
        int n4 = this._t;
        int n5 = this._b;
        n2 += this._x >> 10;
        n3 += this._x >> 10;
        n4 += this._y >> 10;
        n5 += this._y >> 10;
        if (human._platform != null && human._platform.getID() == this._id && this._id < human._id) {
            n = this._y - this._prePositionY;
            if (n < 0) {
                n5 -= n >> 10;
            } else {
                n4 -= n >> 10;
            }
        }
        n = actor._x + actor._dx >> 10;
        int n6 = (actor._y + actor._dy >> 10) + actor._b;
        return n >= n2 && n <= n3 && n6 >= n4 && n6 <= n5;
    }

    public boolean isBoard() {
        return true;
    }

    public void releasePlatForm() {
        this._hedBeenStanded = false;
        this._standActor = null;
    }

    public boolean isDrop() {
        return this._isDrop;
    }

    public int getFashion() {
        return this._fashion;
    }

    public int getVX() {
        return this._vx;
    }

    public int getVY() {
        return this._vy;
    }

    public int getID() {
        return this._id;
    }

    static {
        _bridgeArrayNum = 0;
        _bridgeArrayCalled = false;
        _standHumanNum = 0;
        _jumpDownId = -1;
        _jumpDownSpeed = 0;
        _bridgeMoveState = 0;
        _isMoveEnd = true;
        _firstBridgeID = 0;
        _boardArrayState = 0;
        _bridgeBoardArray = new BridgeBoard[30];
        _standHumanId = new int[5];
    }
}

