/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import tjge.Actor;
import tjge.Animation;
import tjge.EnemyThrow;
import tjge.Function;
import tjge.MainActor;

public class EnemyThing
extends Actor {
    public static final int C_BOSS_THROW = 0;
    public static final int C_ENEMY_THROW = 1;
    public static final int C_BAI_THROW_TO_BOSS = 2;
    public static final int C_BONUS_BOMB = 3;
    public static final int C_BAI_THROW_TO_ENEMY = 4;
    public static final int C_BRIDGE_BOMB = 5;
    public static int _rankCnt;
    private boolean _onLand;
    private boolean _isEggBroken;
    private boolean _bombTrigger;
    private boolean _isBossBomb;
    private int _timeTick;
    private int _bombKind;
    private Actor _thrower;
    private static byte[][] _rank;

    public EnemyThing(int n, Animation animation) {
        super(n, animation);
        this._ownKind = 4;
        this._relation = 3;
    }

    protected void init(int n, int n2, int n3, int n4, Actor actor) {
        this._timeTick = 0;
        this._relation = 3;
        switch (this._type) {
            case 20: {
                EnemyThrow enemyThrow = (EnemyThrow)actor;
                this._visible = true;
                this._x = n3;
                this._y = n4;
                this._onLand = false;
                this._thrower = actor;
                if (enemyThrow._isBossDog) {
                    this._vx = n;
                    this._vy = n2;
                    this._ay = this._gravity = 2000;
                    break;
                }
                this._vx = n;
                this._vy = n2;
                this._ay = this._gravity = 2000;
                break;
            }
            case 16: {
                this._isBossBomb = true;
                EnemyThrow enemyThrow = (EnemyThrow)actor;
                this._visible = true;
                this._x = n3;
                this._y = n4;
                this._onLand = false;
                this._thrower = actor;
                switch (enemyThrow._bigGunType) {
                    case 0: {
                        this._bombKind = 0;
                        this._vx = n;
                        this._vy = n2;
                        this._ay = this._gravity = 4000;
                        break;
                    }
                    case 1: {
                        this._isBossBomb = false;
                        this._bombKind = 1;
                        this._vx = n;
                        this._vy = n2;
                        this._ay = this._gravity = 1024;
                        break;
                    }
                    case 2: {
                        this._bombKind = 2;
                        this._vx = n;
                        this._vy = n2;
                        this._ay = this._gravity = 3096;
                        break;
                    }
                    case 3: {
                        this._bombKind = 3;
                        this._vx = -3072;
                        this._vy = -10240;
                        this._ay = this._gravity = 500;
                        break;
                    }
                    case 4: {
                        this._vx = n;
                        this._vx += 1000;
                        this._vy = n2;
                        this._bombKind = 4;
                    }
                }
                this._vx *= 2;
                this._vy *= 2;
                break;
            }
            case 21: {
                this._x = n3;
                this._y = n4;
                this._onLand = false;
                this._gravity = 6000;
                this._thrower = actor;
                this._isEggBroken = false;
            }
        }
    }

    public void step() {
        this.nextFrame();
        this._dx = this._vx;
        this._dy = this._vy;
        this._vx += this._ax;
        if (this._ax > 0 && this._vx > this._fx) {
            this._vx = this._fx;
        }
        if (this._ax < 0 && this._vx < -this._fx) {
            this._vx = -this._fx;
        }
        this._vy += this._ay;
        if (this._ay > 0 && this._vy > this._fy) {
            this._vy = this._fy;
        }
        if (this._ay < 0 && this._vy < -this._fy) {
            this._vy = -this._fy;
        }
        switch (this._type) {
            case 43: {
                if (!this.isActionEnd()) break;
                this.disLife();
                break;
            }
            case 16: {
                if (!this.isDynamicActor()) {
                    if (this.stepBomb()) {
                        this.disLife();
                        this.flashView(this._x, this._y, 0);
                    }
                    return;
                }
                if (this._bombKind != 5) break;
                return;
            }
            case 20: {
                this.triggerFeedback();
                break;
            }
            case 21: {
                this._vy = this._ay = this._gravity;
                if (!this._isEggBroken) break;
                this._vy = 0;
                this._dy = 0;
                return;
            }
            case 12: {
                if (this._timeTick++ <= 60) break;
                this._timeTick = 0;
                this.disLife();
                break;
            }
            case 14: {
                if (this._timeTick++ <= 60) break;
                this._timeTick = 0;
                this.disLife();
                break;
            }
            case 13: {
                if (this._timeTick++ <= 60) break;
                this._timeTick = 0;
                this.disLife();
                break;
            }
            case 11: {
                if (this._timeTick++ > 5) {
                    this.disLife();
                }
                return;
            }
        }
        if (this.checkLeftWall()) {
            this.collideLeftWall();
        } else if (this.checkRightWall()) {
            this.collideRightWall();
        }
        if (this.checkGround()) {
            this.onLand();
        } else {
            this._onLand = false;
        }
        this._x += this._dx;
        this._y += this._dy;
    }

    private boolean stepBomb() {
        Actor actor = this._scene.getFocusActor();
        if (this.collide(actor)) {
            MainActor mainActor = (MainActor)actor;
            if (mainActor._type == 0) {
                int n = actor._x - 15360;
                int n2 = actor._x + 15360;
                if (this._x > n && this._x < n2) {
                    mainActor.notify(this);
                    return true;
                }
                return false;
            }
            mainActor.notify(this);
            return true;
        }
        return false;
    }

    public void ai() {
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        int n3 = this._scene.getWidth();
        int n4 = this._scene.getHeight();
        switch (this._type) {
            case 20: {
                if (this.checkPointSolid(n, n2) || this._vx == 0 && this._vy == 0) {
                    this.disLife();
                }
                if (n >= 0 && n <= n3 && n2 <= n4) break;
                this.disLife();
                break;
            }
            case 16: {
                if (this.isDynamicActor()) {
                    EnemyThrow enemyThrow = (EnemyThrow)this._thrower;
                    if (n < 0 || n > n3 || n2 > n4) {
                        this.disBombLife(enemyThrow);
                    }
                    switch (this._bombKind) {
                        case 0: {
                            Actor actor = this.triggerFeedback(0);
                            if (this._timeTick++ > 20) {
                                this._timeTick = 0;
                                this._scene.setFocusActor(this._scene.getMainActor());
                                this.disLife();
                            }
                            if (actor != null && actor._type == 29) {
                                this.flashView(this._x, this._y, 0);
                                return;
                            }
                            Actor actor2 = this._scene.getMainActor();
                            if (!this.collide(actor2)) break;
                            actor2.notify(this);
                            enemyThrow._boss.hitTheTarget();
                            enemyThrow._boss.bombExplosion();
                            this.disBombLife(enemyThrow);
                            break;
                        }
                        case 1: {
                            Actor actor = this._scene.getMainActor();
                            if (!this.collide(actor)) break;
                            actor.notify(this);
                            this.disBombLife(enemyThrow);
                            break;
                        }
                        case 2: {
                            if (!this.triggerFeedback()) break;
                            this.disBombLife(enemyThrow);
                            break;
                        }
                        case 3: {
                            if (this._y + 10240 < this._gs._camy) {
                                this.explosion();
                                this.disBombLife(enemyThrow);
                            }
                            return;
                        }
                        case 4: {
                            if (!this.triggerFeedback()) break;
                            this.disBombLife(enemyThrow);
                            break;
                        }
                        case 5: {
                            if (!this.stepBomb()) break;
                            this.disLife();
                            this.flashView(this._x, this._y, 0);
                        }
                    }
                }
                if (!this._bombTrigger || ++this._timeTick <= 2) break;
                this._timeTick = 0;
                this._bombTrigger = false;
                this.disLife();
                this.flashView(this._x, this._y, 0);
                break;
            }
            case 21: {
                this.aiEgg(n, n2, n3, n4);
            }
        }
    }

    public static void initExplosionData() {
        try {
            _rankCnt = 0;
            if (_rank != null) {
                return;
            }
            _rank = new byte[16][40];
            int n = 48;
            int n2 = 0;
            while (n2 < _rank.length) {
                byte[] byArray = Function.readDataFile("/res/explosion.bin", n2);
                int n3 = 0;
                int n4 = 0;
                while (n3 < _rank[n2].length) {
                    EnemyThing._rank[n2][n3] = (byte)(byArray[n4] - n);
                    ++n3;
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disposeData() {
        if (_rank == null) {
            return;
        }
        int n = 0;
        while (n < _rank.length) {
            EnemyThing._rank[n] = null;
            ++n;
        }
        _rank = null;
    }

    private void explosion() {
        int n;
        if ((n = _rankCnt++) >= _rank.length) {
            return;
        }
        byte[] byArray = _rank[n];
        int n2 = 35840;
        int n3 = 26624;
        int n4 = this._gs._camx + 20480;
        int n5 = this._gs._camy;
        int n6 = 0;
        while (n6 < byArray.length) {
            Actor actor;
            int n7 = n4 + n6 % 5 * n2;
            int n8 = n5 - n3 * 8 + n6 / 5 * n3;
            byte by = byArray[n6];
            if (by == 1) {
                actor = (EnemyThing)this._scene.fetchActorFromPool(16, -1);
                if (actor != null) {
                    actor._bombKind = 1;
                    actor._x = n7;
                    actor._y = n8;
                    actor._vy = 6144;
                    actor._vx = 0;
                    actor._ay = 0;
                    actor._gravity = 0;
                    actor._fy = 6144;
                }
            } else if (by == 2 && (actor = this._scene.fetchActorFromPool(17, -1)) != null) {
                actor._x = n7;
                actor._y = n8;
                actor._vy = 6144;
                actor._vx = 0;
                actor._ay = 0;
                actor._gravity = 0;
                actor._fy = 6144;
            }
            ++n6;
        }
    }

    private void aiEgg(int n, int n2, int n3, int n4) {
        if (n < 0 || n > n3 || n2 > n4) {
            this.disLife();
        }
        if (this._action == 0) {
            boolean bl = false;
            Actor actor = this.triggerFeedback(0);
            if (actor != null) {
                if (actor == this._thrower) {
                    return;
                }
                bl = true;
            }
            if (this._onLand || bl) {
                this._isEggBroken = true;
                this.changeAction(1);
            }
        } else if (this._action == 1) {
            if (this.isActionEnd()) {
                this.changeAction(2);
            }
        } else if (this.isActionEnd()) {
            this.disLife();
        }
    }

    private void onLand() {
        this._vx = 0;
        this._vy = 0;
        this._onLand = true;
        if (this._type == 16) {
            this.dealBome();
        }
    }

    private void dealBome() {
        this.flashView(this._x, this._y, 0);
        if (this._isBossBomb) {
            EnemyThrow enemyThrow = (EnemyThrow)this._thrower;
            enemyThrow._boss.bombExplosion();
        }
        if (this._bombKind == 2) {
            this._scene.setBossFocus();
        }
        if (this._bombKind == 0) {
            this._scene.setFocusActor(this._scene.getMainActor());
        }
        this.disLife();
    }

    private void collideRightWall() {
        if (this._type == 16) {
            this.dealBome();
        }
    }

    private void collideLeftWall() {
        if (this._type == 16) {
            this.dealBome();
        }
    }

    public boolean notify(Actor actor) {
        if (!this.checkRelation(actor.getRelation()) || !this.checkSequence(actor)) {
            return false;
        }
        if (actor._type == 2 && this._type == 16) {
            this._bombTrigger = true;
            if (actor._isFlip) {
                this._vx = -12288;
                this._vy = -2046;
            } else {
                this._vy = -2046;
                this._vx = 12288;
            }
        }
        return false;
    }

    public Actor getThrower() {
        return this._thrower;
    }

    private void disBombLife(EnemyThrow enemyThrow) {
        switch (this._bombKind) {
            case 0: {
                enemyThrow._boss.bombExplosion();
                this._scene.setFocusActor(this._scene.getMainActor());
                this.disLife();
                break;
            }
            case 1: {
                this.disLife();
                break;
            }
            case 2: {
                enemyThrow._boss.bombExplosion();
                this._scene.setBossFocus();
                this.disLife();
                break;
            }
            case 3: {
                this.disLife();
                enemyThrow._boss.bombExplosion();
                return;
            }
            case 4: {
                this.disLife();
            }
        }
        this.flashView(this._x, this._y, 0);
    }

    public int getHurtMode() {
        if (this._type == 21) {
            return 18;
        }
        if (this._type == 20) {
            return 11;
        }
        if (this._type == 16) {
            return 12;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean issolid(int n) {
        switch (this._type) {
            case 12: {
                if (n == 1) return true;
                if (n != 2) return false;
                return true;
            }
        }
        if (n != 1) return false;
        return true;
    }

    public int getXDirLocation(int n) {
        return this._x - n / 2;
    }

    public int getYDirLocation(int n) {
        return this._y - n * 2 / 3;
    }

    public void setBombKind(int n) {
        this._bombKind = n;
    }
}

