/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tjge.Function;

public class TiledBackground {
    public static int C_MAP_OFF_Y;
    static boolean _isFull;
    public int _cw;
    public int _ch;
    public int _mapx;
    public int _mapy;
    private int _patternW;
    private int _patternH;
    private int _patternMapW;
    private int _patternMapH;
    private byte[] _patternMapData;
    private byte[][] _axPhys;
    public int _phytw;
    public int _phyth;
    private int _bkw;
    private int _bkh;
    private int _bktw;
    private int _bkth;
    private static Image _bkTileSet;
    private int _bkTileCntInX;
    private byte[] _bkTile;
    private Image _bkImage;
    int _xoff;
    int _yoff;
    int _scrw;
    int _scrh;
    public static final int C_PHY_EMPTY = 0;
    public static final int C_PHY_SOLID = 1;
    public static final int C_PHY_UPSLD = 2;
    public static final int C_PHY_WATHER = 5;
    public static final int C_PHY_DEATH = 9;
    public static final int C_PHY_BORDER = 10;
    private int _prevMapX0;
    private int _prevMapY0;
    private int _prevMapX1;
    private int _prevMapY1;
    private static Image _backImg;
    private static Graphics _gb;
    public static final byte C_EMPTY_LINE = 0;
    public static final byte C_NORMAL_LINE = 1;
    public static final byte C_RLE_LINE = 2;

    public TiledBackground(int n, int n2) {
        this._cw = n;
        this._ch = n2;
        this._scrw = n;
        this._scrh = n2;
    }

    public void setBuffHeight(int n, int n2) {
        C_MAP_OFF_Y = n2;
        this._ch = n - C_MAP_OFF_Y;
        _isFull = C_MAP_OFF_Y == 0;
    }

    public void setPositionInMap(int n, int n2) {
        this._mapx = n;
        this._mapy = n2;
    }

    public void init() {
        this._prevMapX0 = -1;
        this._prevMapY0 = -1;
    }

    public int getMapWidth() {
        return this._bktw * this._patternW * this._patternMapW;
    }

    public int getMapHeight() {
        return this._bkth * this._patternH * this._patternMapH;
    }

    public void drawToGraphics(Graphics graphics) {
        this.fastDraw(graphics, this._mapx, this._mapy, this._cw, this._ch);
    }

    private int getPatternId(int n, int n2) {
        int n3 = this._patternMapData[n2 / (this._patternH * this._bkth) * this._patternMapW + n / (this._patternW * this._bktw)];
        if (n3 < -1) {
            n3 += 256;
        }
        return n3;
    }

    public int getPhyBlock(int n, int n2) {
        if (n2 < 0) {
            return 10;
        }
        if (n2 >= this.getMapHeight()) {
            return 0;
        }
        if (n < 0 || n >= this.getMapWidth()) {
            return 10;
        }
        int n3 = this.getPatternId(n, n2);
        if (n3 == -1) {
            return 0;
        }
        n = (n3 % (this._bkw / this._patternW) * this._patternW + n / this._bktw % this._patternW) * this._bktw / this._phytw;
        if (this._axPhys[n2 = (n3 / (this._bkw / this._patternW) * this._patternH + n2 / this._bkth % this._patternH) * this._bkth / this._phyth][0] == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 2;
        do {
            n4 += this._axPhys[n2][n5 + 1];
            if (this._axPhys[n2][n5 + 1] < 0) {
                n4 += 256;
            }
            n5 += 2;
        } while (n4 < n + 1);
        return this._axPhys[n2][n5 -= 2];
    }

    protected int getForeTile(int n, int n2) throws Exception {
        int n3 = -1;
        int n4 = this.getPatternId(n, n2);
        if (n4 != -1) {
            n = n4 % (this._bkw / this._patternW) * this._patternW + n / this._bktw % this._patternW;
            n2 = n4 / (this._bkw / this._patternW) * this._patternH + n2 / this._bkth % this._patternH;
            n4 = n2 * this._bkw + n;
            n3 = this._bkTile[n4];
            if (this._bkTile[n4] < -1) {
                n3 += 256;
            }
        }
        return n3;
    }

    private void setFastMode(int n, int n2) {
        if (_backImg == null) {
            int n3 = n % this._bktw == 0 ? n + this._bktw : n - n % this._bktw + 2 * this._bktw;
            int n4 = n2 % this._bkth == 0 ? n2 + this._bkth : n2 - n2 % this._bkth + 2 * this._bkth;
            _backImg = Image.createImage((int)n3, (int)n4);
            _gb = _backImg.getGraphics();
        }
        this.init();
    }

    private int getBuffHeight() {
        int n = this._ch;
        int n2 = n % this._bkth == 0 ? this._ch + this._bkth : n - n % this._bkth + 2 * this._bkth;
        return n2;
    }

    protected void mappedDraw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = n2 % n6;
        int n9 = this._bkImage.getWidth();
        int n10 = this._bkImage.getHeight();
        int n11 = n2;
        while (n11 <= n4) {
            int n12 = n % n5;
            int n13 = n;
            while (n13 <= n3) {
                block7: {
                    int n14 = n13 % n9;
                    int n15 = n11 % n10;
                    graphics.setClip(n12, n8, this._bktw, this._bkth);
                    graphics.drawImage(this._bkImage, n12 - n14, n8 - n15, 4 | 0x10);
                    try {
                        n7 = this.getForeTile(n13, n11);
                    }
                    catch (Exception exception) {
                        break block7;
                    }
                    if (n7 != -1) {
                        graphics.setClip(n12, n8, this._bktw, this._bkth);
                        graphics.drawImage(_bkTileSet, n12 - n7 % this._bkTileCntInX * this._bktw, n8 - n7 / this._bkTileCntInX * this._bkth, 4 | 0x10);
                    }
                    if ((n12 += this._bktw) >= n5) {
                        n12 = 0;
                    }
                }
                n13 += this._bktw;
            }
            if ((n8 += this._bkth) >= n6) {
                n8 = 0;
            }
            n11 += this._bkth;
        }
    }

    protected void copyFromBackImage(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(n5, n6 += C_MAP_OFF_Y, n3, n4);
        graphics.drawImage(_backImg, n5 - n, n6 - n2, 4 | 0x10);
    }

    protected void fastDraw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = _backImg.getWidth();
        int n8 = this.getBuffHeight();
        _gb.setColor(0xFFFFFF);
        int n9 = n - n % this._bktw;
        int n10 = n2 - n2 % this._bkth;
        int n11 = n + n7 - this._bktw - (n + n7 - this._bktw) % this._bktw;
        int n12 = n2 + n8 - this._bkth - (n2 + n8 - this._bkth) % this._bkth;
        if (this._prevMapX0 < 0) {
            this.mappedDraw(_gb, n9, n10, n11, n12, n7, n8);
            this._prevMapX0 = n9;
            this._prevMapY0 = n10;
            this._prevMapX1 = n11;
            this._prevMapY1 = n12;
        }
        if (this._prevMapX0 != n9) {
            if (this._prevMapX0 < n9) {
                n6 = this._prevMapX1 + this._bktw;
                n5 = n11;
            } else {
                n6 = n9;
                n5 = this._prevMapX0 - this._bktw;
            }
            this.mappedDraw(_gb, n6, n10, n5, n12, n7, n8);
            this._prevMapX0 = n9;
            this._prevMapX1 = n11;
        }
        if (this._prevMapY0 != n10) {
            if (this._prevMapY0 < n10) {
                n6 = this._prevMapY1 + this._bkth;
                n5 = n12;
            } else {
                n6 = n10;
                n5 = this._prevMapY0 - this._bkth;
            }
            this.mappedDraw(_gb, n9, n6, n11, n5, n7, n8);
            this._prevMapY0 = n10;
            this._prevMapY1 = n12;
        }
        int n13 = n % n7;
        int n14 = n2 % n8;
        int n15 = (n + n3) % n7;
        int n16 = (n2 + n4) % n8;
        if (n15 > n13) {
            if (n16 > n14) {
                this.copyFromBackImage(graphics, n13, n14, n3, n4, 0, 0);
            } else {
                this.copyFromBackImage(graphics, n13, n14, n3, n4 - n16, 0, 0);
                this.copyFromBackImage(graphics, n13, 0, n3, n16, 0, n4 - n16);
            }
        } else if (n16 > n14) {
            this.copyFromBackImage(graphics, n13, n14, n3 - n15, n4, 0, 0);
            this.copyFromBackImage(graphics, 0, n14, n15, n4, n3 - n15, 0);
        } else {
            this.copyFromBackImage(graphics, n13, n14, n3 - n15, n4 - n16, 0, 0);
            this.copyFromBackImage(graphics, n13, 0, n3 - n15, n16, 0, n4 - n16);
            this.copyFromBackImage(graphics, 0, n14, n15, n4 - n16, n3 - n15, 0);
            this.copyFromBackImage(graphics, 0, 0, n15, n16, n3 - n15, n4 - n16);
        }
        graphics.setClip(0, 0, n3, n4);
    }

    public void dispose() {
        int n = 0;
        while (n < this._axPhys.length) {
            this._axPhys[n] = null;
            ++n;
        }
        this._axPhys = null;
        this._bkTile = null;
        _bkTileSet = null;
        this._bkImage = null;
        this._patternMapData = null;
        System.gc();
    }

    public void load(int n, int n2, int n3) {
        try {
            InputStream inputStream = Function.openDataFile("/res/m.bin", n);
            if (Function.readByte(inputStream) != 1) {
                return;
            }
            byte by = Function.readByte(inputStream);
            this._patternW = Function.readByte(inputStream);
            this._patternH = Function.readByte(inputStream);
            this._patternMapW = Function.readShort(inputStream);
            this._patternMapH = Function.readShort(inputStream);
            this._patternMapData = new byte[this._patternMapW * this._patternMapH];
            inputStream.read(this._patternMapData);
            inputStream.close();
            inputStream = Function.openDataFile("/res/p.bin", by);
            if (Function.readByte(inputStream) != 0) {
                return;
            }
            by = Function.readByte(inputStream);
            this._bkw = Function.readShort(inputStream);
            this._bkh = Function.readShort(inputStream);
            this._bktw = Function.readByte(inputStream);
            this._bkth = Function.readByte(inputStream);
            this._bkTile = new byte[this._bkw * this._bkh];
            inputStream.read(this._bkTile);
            _bkTileSet = Function.loadPng("/res/fpng.bin", by);
            this._bkTileCntInX = _bkTileSet.getWidth() / this._bktw;
            this._phytw = Function.readByte(inputStream);
            this._phyth = Function.readByte(inputStream);
            int n4 = this._bktw * this._bkw / this._phytw;
            int n5 = this._bkth * this._bkh / this._phyth;
            this._axPhys = new byte[n5][];
            int n6 = 0;
            while (n6 < n5) {
                byte by2 = Function.readByte(inputStream);
                if (by2 == 0) {
                    this._axPhys[n6] = new byte[1];
                    this._axPhys[n6][0] = 0;
                } else if (by2 == 1) {
                    this._axPhys[n6] = new byte[1 + n4];
                    inputStream.read(this._axPhys[n6], 1, n4);
                    this._axPhys[n6][0] = 1;
                } else {
                    int n7 = Function.readByte(inputStream);
                    if (n7 < 0) {
                        n7 += 256;
                    }
                    this._axPhys[n6] = new byte[2 + 2 * n7];
                    inputStream.read(this._axPhys[n6], 2, 2 * n7);
                    this._axPhys[n6][0] = 2;
                }
                ++n6;
            }
            this._bkImage = Function.loadPng("/res/bpng.bin", by);
            this.setFastMode(this._scrw, this._scrh);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

