/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public class BlueTooth
implements DiscoveryListener {
    private TankCanvas tc;
    private LocalDevice localDevice;
    private DiscoveryAgent discoveryAgent;
    private RemoteDevice[] remoteDevice;
    private ServiceRecord serviceRecord;
    private L2CAPConnectionNotifier l2capConnectionNotifier;
    private L2CAPConnection l2capConnection;
    private ByteArrayInputStream bais;
    private ByteArrayOutputStream baos;
    private DataInputStream dis;
    private DataOutputStream dos;
    protected Vector vector = new Vector();

    public BlueTooth(TankCanvas tankCanvas) {
        this.tc = tankCanvas;
    }

    public void addElement(int n) {
        try {
            this.dos.writeInt(n);
        }
        catch (Exception exception) {
            System.out.println("write int data failed");
        }
    }

    public void addElement(boolean bl) {
        try {
            this.dos.writeBoolean(bl);
        }
        catch (Exception exception) {
            System.out.println("write boolean data failed");
        }
    }

    public int getIntElement() {
        int n = 0;
        try {
            n = this.dis.readInt();
        }
        catch (Exception exception) {
            System.out.println("read int data failed");
        }
        return n;
    }

    public void startSend() {
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
    }

    public void overSend() {
        try {
            this.dos.flush();
            byte[] byArray = this.baos.toByteArray();
            this.l2capConnection.send(byArray);
        }
        catch (Exception exception) {
            this.tc.returnToMainMenu();
            System.out.println("send data failed");
        }
    }

    public void startReceive() {
        try {
            byte[] byArray = new byte[40];
            this.l2capConnection.receive(byArray);
            this.bais = new ByteArrayInputStream(byArray);
            this.dis = new DataInputStream(this.bais);
        }
        catch (Exception exception) {
            this.tc.returnToMainMenu();
            System.out.println("receive data failed");
        }
    }

    public void closeServer() {
        try {
            this.l2capConnectionNotifier.close();
        }
        catch (Exception exception) {
            System.out.println("close server failed");
        }
    }

    public void closeConnect() {
        try {
            this.l2capConnection.close();
        }
        catch (Exception exception) {
            System.out.println("close connect failed");
        }
    }

    public boolean searchClient() {
        boolean bl = true;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.setDiscoverable(10390323);
            this.l2capConnectionNotifier = (L2CAPConnectionNotifier)Connector.open((String)"btl2cap://localhost:11111111111111111111111111111111");
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("search client init failed");
        }
        try {
            this.l2capConnection = this.l2capConnectionNotifier.acceptAndOpen();
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("connect client failed");
        }
        return bl;
    }

    public void cancelSearchClient() {
        try {
            this.l2capConnectionNotifier.close();
        }
        catch (Exception exception) {
            System.out.println("close l2cap connection notifier failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchServer() {
        this.vector.removeAllElements();
        boolean bl = true;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = this.localDevice.getDiscoveryAgent();
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            BlueTooth blueTooth = this;
            synchronized (blueTooth) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    System.out.println("search server wait failed");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("connect server failed");
        }
        if (this.vector.size() < 1) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchServerService(int n) {
        try {
            UUID[] uUIDArray = new UUID[]{new UUID("11111111111111111111111111111111", false)};
            RemoteDevice remoteDevice = (RemoteDevice)this.vector.elementAt(n);
            this.discoveryAgent.searchServices(null, uUIDArray, remoteDevice, (DiscoveryListener)this);
            Object object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.serviceRecord.getConnectionURL(0, false);
            this.l2capConnection = (L2CAPConnection)Connector.open((String)object);
        }
        catch (Exception exception) {
            System.out.println("connect server service failed");
        }
    }

    public void cancelSearchServer() {
        this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        this.vector.addElement(remoteDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int n) {
        BlueTooth blueTooth = this;
        synchronized (blueTooth) {
            try {
                this.notifyAll();
            }
            catch (Exception exception) {
                System.out.println("notify failed");
            }
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        this.serviceRecord = serviceRecordArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int n, int n2) {
        BlueTooth blueTooth = this;
        synchronized (blueTooth) {
            try {
                this.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getBlueToothName(int n) {
        String string = "";
        RemoteDevice remoteDevice = (RemoteDevice)this.vector.elementAt(n);
        try {
            string = remoteDevice.getFriendlyName(false);
        }
        catch (Exception exception) {
            System.out.println("get friendly name failed");
        }
        return string;
    }
}

