/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EnemyTank
extends Tank {
    private static Image enemyTankImage;
    private int iFireRandom;
    private int iTurnRandom;
    private int iStyle;
    private boolean bBombed;
    private boolean bIsRed;
    private static int iMaxTurnRandom;
    private static int iMaxNum;
    private static int iKilledNum;
    private static int iScreenNum;
    protected static int iCollidesChoice;
    protected static int iDegree;
    protected static int iMaxScreenNum;
    protected static int iAppearingNumber;

    public EnemyTank(int n, int n2) {
        super(n, n2);
    }

    public static int getMaxNum() {
        return iMaxNum;
    }

    public static int getKilledNum() {
        return iKilledNum;
    }

    public static int getScreenNum() {
        return iScreenNum;
    }

    public static void passSetParameter(int n, int n2, int n3) {
        iDegree = n;
        iMaxScreenNum = n2;
        iCollidesChoice = n3;
    }

    public void levelInit() {
        super.levelInit();
    }

    public static void levelStaticInit(int n) {
        if (iDegree == 1) {
            iMaxNum = 20;
        } else {
            iMaxNum = n + 18 + iDegree;
            if (iMaxNum > 40) {
                iMaxNum = 40;
            }
        }
        iScreenNum = 0;
        iKilledNum = 0;
        iAppearingNumber = -1;
    }

    public void action(int n) {
        if (!this.bPause && this.ifAction(n)) {
            int n2 = this.iDirection;
            int n3 = 0;
            switch (iPlayerChoice) {
                case 1: {
                    int n4 = rand.nextInt(this.iTurnRandom);
                    if (n4 < 1) {
                        n2 = rand.nextInt(4) + 1;
                    }
                    n3 = rand.nextInt(this.iFireRandom);
                    if (iPlayerNum <= 1) break;
                    EnemyTank.tc.blueTooth.startSend();
                    EnemyTank.tc.blueTooth.addElement(n2);
                    EnemyTank.tc.blueTooth.addElement(n3);
                    EnemyTank.tc.blueTooth.overSend();
                    break;
                }
                case 2: {
                    EnemyTank.tc.blueTooth.startReceive();
                    n2 = EnemyTank.tc.blueTooth.getIntElement();
                    n3 = EnemyTank.tc.blueTooth.getIntElement();
                }
            }
            this.moveOrTurn(n2);
            if (n3 < 1) {
                this.fire(1);
            }
        }
    }

    public void moveOrTurn(int n) {
        if (this.iDirection == n) {
            if (this.x % 8 == 0 && this.y % 8 == 0) {
                this.move(n, 2);
                if (this.ifHaveBarrier(this)) {
                    this.move(n, -2);
                    this.iTurnRandom = 1;
                } else {
                    this.move(n, -1);
                }
            } else {
                this.move(n, 1);
            }
        } else {
            this.turn(n);
            this.iTurnRandom = iMaxTurnRandom;
        }
    }

    public void sceneUpdate() {
        super.sceneUpdate(this);
        switch (this.iState) {
            case 0: {
                --this.iTime;
                if (this.iTime > 0) break;
                this.toAppear();
                this.lifeInit();
                if (!tc.ifAvoidCollides(this)) break;
                this.bAvoidCollides = true;
                break;
            }
            case 1: {
                if (!bItemAppeared || iCollidesChoice != 2 || !this.ifCollidesItem()) break;
                this.collidesItem();
                break;
            }
            case 2: {
                --this.iTime;
                if (this.iTime > 0) break;
                this.toWait();
                break;
            }
            case 3: {
                if (this.iTime > 0 && iAppearingNumber < 0) {
                    --this.iTime;
                }
                if (this.iTime > 0 || iAppearingNumber >= 0 || iKilledNum + iScreenNum >= iMaxNum) break;
                this.toAppearing();
                int n = (iKilledNum + iScreenNum + 1) % 3 * 96;
                this.setPosition(n, 0);
                iAppearingNumber = 0;
                ++iScreenNum;
            }
        }
    }

    public void collidesItem() {
        if (iItemStyle == 5) {
            EnemyTank.changeFlagAroundState(2);
        } else {
            tc.enemyCollidesItem(iItemStyle);
        }
    }

    public void setBomb() {
        if (this.iState == 1) {
            this.bBombed = true;
            this.oneEnemyExplode();
        }
    }

    public void lifeInit() {
        iAppearingNumber = -1;
        if (iPlayerChoice == 1) {
            this.iStyle = (iKilledNum + iScreenNum) % 5 == 4 ? rand.nextInt(4) * 3 + 1 : rand.nextInt(4) * 3;
            if (iPlayerNum > 1) {
                EnemyTank.tc.blueTooth.startSend();
                EnemyTank.tc.blueTooth.addElement(this.iStyle);
                EnemyTank.tc.blueTooth.overSend();
            }
        } else {
            EnemyTank.tc.blueTooth.startReceive();
            this.iStyle = EnemyTank.tc.blueTooth.getIntElement();
        }
        if (this.iStyle % 3 == 1) {
            this.bIsRed = true;
            bItemAppeared = false;
        } else {
            this.bIsRed = false;
        }
        switch (iDegree) {
            case 1: {
                if (this.iStyle / 3 == 3) {
                    this.iBloodNum = 4;
                    break;
                }
                this.iBloodNum = 1;
                break;
            }
            case 2: {
                this.iBloodNum = 1;
                break;
            }
            case 3: {
                this.iBloodNum = 2;
                break;
            }
            case 4: {
                this.iBloodNum = 3;
                break;
            }
            case 5: {
                this.iBloodNum = 4;
            }
        }
        this.iDirection = 2;
        int n = 0;
        int n2 = 0;
        switch (iDegree) {
            case 1: {
                n = 8;
                n2 = 6;
                break;
            }
            case 2: {
                n = 15;
                n2 = 10;
                break;
            }
            case 3: {
                n = 10;
                n2 = 6;
                break;
            }
            case 4: {
                n = 6;
                n2 = 4;
                break;
            }
            case 5: {
                n = 4;
                n2 = 2;
            }
        }
        if (this.iStyle % 9 < 6) {
            this.iBulletSpeed = 1;
            this.iFireRandom = n;
        } else {
            this.iBulletSpeed = 2;
            this.iFireRandom = n2;
        }
        this.iSpeed = this.iStyle / 3 == 1 ? 2 : 1;
        this.iBulletNum = 1;
        this.iTurnRandom = 50;
        this.bDestroyRock = false;
        this.bBombed = false;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        switch (this.iState) {
            case 1: {
                graphics.setClip(this.x, this.y, 16, 16);
                if (this.bIsRed) {
                    graphics.drawRegion(enemyTankImage, 64, this.iStyle / 3 * 16, 16, 16, EnemyTank.getTransform(this.iDirection), this.x, this.y, 0);
                } else {
                    graphics.drawRegion(enemyTankImage, (this.iBloodNum - 1) * 16, this.iStyle / 3 * 16, 16, 16, EnemyTank.getTransform(this.iDirection), this.x, this.y, 0);
                }
                graphics.setClip(-layerX, -layerY, screenWidth, screenHeight);
                break;
            }
            case 3: {
                if (this.bBombed || this.iTime <= 0) break;
                graphics.setColor(255, 255, 255);
                graphics.drawString("" + (this.iStyle / 3 + 1) * 100, this.x, this.y, 0);
            }
        }
    }

    public static void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.drawRegion(enemyTankImage, n, n2, 16, 16, EnemyTank.getTransform(n5), n3, n4, 0);
    }

    public boolean ifCollidesBullet(Bullet bullet) {
        if (super.ifCollidesBullet(bullet)) {
            int n = bullet.getDamageLevel();
            int n2 = (n - 1) * 3 + 1;
            this.attacked(n2, bullet);
            if (this.bIsRed) {
                bItemAppeared = true;
                this.itemInit();
                if (this.iStyle % 3 != 2) {
                    this.bIsRed = false;
                }
            }
            return true;
        }
        return false;
    }

    public void collidesLife() {
        if (this.iState == 1) {
            this.iBloodNum = 4;
            this.iStyle = !this.bIsRed ? (this.iStyle += 2) : (this.iStyle -= this.iStyle % 3);
            this.bIsRed = !this.bIsRed;
        }
    }

    public void collidesStar() {
        this.bDestroyRock = true;
    }

    public void attacked(int n, Bullet bullet) {
        this.iBloodNum -= n;
        if (this.iBloodNum < 1) {
            tc.killOneEnemy(bullet.getSide(), this.iStyle);
            this.oneEnemyExplode();
        }
    }

    public static boolean ifPassLevel() {
        return iKilledNum == iMaxNum;
    }

    public void oneEnemyExplode() {
        this.toExplode();
        ++iKilledNum;
        --iScreenNum;
    }

    static {
        iMaxTurnRandom = 50;
        try {
            enemyTankImage = Image.createImage((String)"/enemytank.png");
        }
        catch (Exception exception) {
            System.out.println("enemytank image load failed");
        }
    }
}

