/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SelfTank
extends Tank {
    private static Image selfTankImage;
    private int[] killEnemyNum = new int[4];
    private int[] iItemNum = new int[5];
    private int iScore;
    private int iLife;
    private int iEnergyValue;
    private int iItemUsedState;
    private static int iMaxEnergyValue;
    private boolean bProtect;

    public SelfTank(int n, int n2) {
        super(n, n2);
        this.numInit();
    }

    public int getLife() {
        return this.iLife;
    }

    public void setLife(int n) {
        this.iLife = n;
    }

    public void addLife() {
        ++this.iLife;
    }

    public int getScore() {
        return this.iScore;
    }

    public int getLevel() {
        return this.iBloodNum + this.iBulletNum + this.iBulletSpeed - 3;
    }

    public void setLevel(int n) {
        switch (n) {
            case 1: {
                this.iBulletSpeed = 2;
                break;
            }
            case 2: {
                this.iBulletSpeed = 2;
                this.iBulletNum = 2;
                break;
            }
            case 3: {
                this.iBulletSpeed = 2;
                this.iBulletNum = 2;
                this.iBloodNum = 2;
            }
        }
    }

    public int getItemNum(int n) {
        return this.iItemNum[n];
    }

    public int getKillEnemyNum(int n) {
        return this.killEnemyNum[n];
    }

    public int getTotalKillNum() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += this.killEnemyNum[i];
        }
        return n;
    }

    public int getEnergyValue() {
        return this.iEnergyValue;
    }

    public void setEnergyValue(int n) {
        this.iEnergyValue = n;
    }

    public static int getMaxEnergyValue() {
        return iMaxEnergyValue;
    }

    public void boughtItem(int n, int[] nArray) {
        this.iScore -= n;
        this.iLife += nArray[0];
        for (int i = 0; i < 5; ++i) {
            int n2 = i;
            this.iItemNum[n2] = this.iItemNum[n2] + nArray[i + 1];
        }
    }

    public static void canvasInit() {
        try {
            selfTankImage = Image.createImage((String)"/selftank.png");
        }
        catch (Exception exception) {
            System.out.println("selftank image load failed");
        }
    }

    public void gameInit(int n, int n2, int n3, int[] nArray) {
        this.iSpeed = 2;
        this.iLife = n;
        this.iScore = n3;
        this.setLevel(n2);
        this.bDestroyRock = this.iBloodNum == 2;
        for (int i = 0; i < 5; ++i) {
            this.iItemNum[i] = nArray[i];
        }
    }

    public void levelInit() {
        super.levelInit();
        for (int i = 0; i < 4; ++i) {
            this.killEnemyNum[i] = 0;
        }
    }

    public void toAppearInit() {
        this.iDirection = 1;
        this.setProtect(100);
    }

    public void lifeInit() {
        this.numInit();
        this.bDestroyRock = false;
        this.bPause = false;
    }

    public void numInit() {
        this.iBulletNum = 1;
        this.iBloodNum = 1;
        this.iBulletSpeed = 1;
    }

    public void setProtect(int n) {
        this.bProtect = true;
        this.iTime = n;
    }

    public void setBomb() {
        if (this.iState == 1) {
            this.toExplode();
        }
    }

    public void action(int n, int n2, int n3, int n4, int n5, int n6) {
        super.action(n, n2, n3, n4);
        this.iEnergyValue = n5;
        if (this.iItemUsedState == 0) {
            if (n6 > 0) {
                this.iItemUsedState = n6;
                this.useItem(this.iItemUsedState);
            }
        } else if (n6 == 0) {
            this.iItemUsedState = 0;
        }
    }

    public void action(int n, int n2) {
        if (!bFlagDestroyed) {
            if (this.ifAction(n2) && this.iEnergyValue <= 0) {
                if (!this.bPause) {
                    int n3 = 0;
                    if ((n & 2) != 0) {
                        n3 = 1;
                    }
                    if ((n & 0x40) != 0) {
                        n3 = 2;
                    }
                    if ((n & 4) != 0) {
                        n3 = 3;
                    }
                    if ((n & 0x20) != 0) {
                        n3 = 4;
                    }
                    if (n3 > 0) {
                        this.moveOrTurn(n3);
                    }
                }
                if ((n & 0x100) != 0) {
                    this.fire(1);
                    this.fireState = 1;
                }
            }
            if (this.ifSuperAction(n2)) {
                if ((n & 0x200) != 0) {
                    if (this.bullet[0].getState() == 0) {
                        ++this.iEnergyValue;
                    }
                } else if (this.iEnergyValue > 0) {
                    if (this.iEnergyValue >= iMaxEnergyValue) {
                        this.fireState = this.getLevel() + 2;
                        this.fire(this.fireState);
                    }
                    this.iEnergyValue = 0;
                }
            }
            if ((n & 0x400) != 0) {
                if (this.iState == 1 && this.iItemUsedState == 0) {
                    this.iItemUsedState = tc.getItemChoice();
                    this.useItem(this.iItemUsedState);
                }
            } else if (this.iItemUsedState > 0) {
                this.iItemUsedState = 0;
            }
        }
    }

    public void moveOrTurn(int n) {
        if (this.iDirection == n) {
            if (this.x % 8 == 0 && this.y % 8 == 0) {
                this.move(n, 2);
                if (this.ifHaveBarrier(this)) {
                    this.move(n, -2);
                } else {
                    this.move(n, -1);
                }
            } else {
                this.move(n, 1);
            }
        } else {
            this.turn(n);
        }
    }

    public boolean ifSuperAction(int n) {
        return this.iState == 1;
    }

    public void sendData() {
        super.sendData();
        SelfTank.tc.blueTooth.addElement(this.iEnergyValue);
        SelfTank.tc.blueTooth.addElement(this.iItemUsedState);
    }

    public void sceneUpdate() {
        super.sceneUpdate(this);
        switch (this.iState) {
            case 0: {
                --this.iTime;
                if (this.iTime > 0) break;
                this.toAppearInit();
                this.toAppear();
                if (!tc.ifAvoidCollides(this)) break;
                this.bAvoidCollides = true;
                break;
            }
            case 1: {
                if (this.bProtect) {
                    --this.iTime;
                    if (this.iTime <= 0) {
                        this.bProtect = false;
                    }
                }
                if (!bItemAppeared || !this.ifCollidesItem()) break;
                this.collidesItem();
                break;
            }
            case 2: {
                --this.iTime;
                if (this.iTime > 0) break;
                this.toWait();
                this.lifeInit();
                break;
            }
            case 3: {
                --this.iTime;
                if (this.iTime > 0 || this.iLife <= 0) break;
                this.toAppearing();
                this.setPosition(64 + this.iSide * 64, 192);
                --this.iLife;
            }
        }
    }

    public void toExplode() {
        super.toExplode();
        this.iEnergyValue = 0;
    }

    public void killOneEnemy(int n) {
        this.iScore += (n / 3 + 1) * 100;
        int n2 = n / 3;
        this.killEnemyNum[n2] = this.killEnemyNum[n2] + 1;
    }

    public void collidesItem() {
        this.itemUsed(iItemStyle);
        this.iScore += 500;
        tc.itemScoreAppear();
    }

    public void useItem(int n) {
        if (this.iItemNum[n - 1] > 0) {
            int n2 = n - 1;
            this.iItemNum[n2] = this.iItemNum[n2] - 1;
            this.itemUsed(n + 1);
        }
    }

    public void itemUsed(int n) {
        switch (n) {
            case 1: {
                ++this.iLife;
                break;
            }
            case 2: {
                if (this.iBulletSpeed < 2) {
                    this.iBulletSpeed = 2;
                    break;
                }
                if (this.iBulletNum < 2) {
                    this.iBulletNum = 2;
                    break;
                }
                if (this.iBloodNum >= 2) break;
                this.iBloodNum = 2;
                this.bDestroyRock = true;
                break;
            }
            case 3: {
                tc.pauseAllEnemy();
                break;
            }
            case 4: {
                this.setProtect(250);
                break;
            }
            case 5: {
                SelfTank.changeFlagAroundState(1);
                break;
            }
            case 6: {
                tc.bombAllEnemy();
            }
        }
    }

    public boolean ifCollidesBullet(Bullet bullet) {
        if (super.ifCollidesBullet(bullet)) {
            if (this.bProtect) {
                bullet.toWait();
            } else {
                int n = bullet.getSide();
                int n2 = this.getMinusAbs(n, this.iSide);
                if (n2 > 1) {
                    int n3 = bullet.getDamageLevel();
                    this.attacked(n3);
                } else if (n2 == 1) {
                    this.setPause(100);
                }
                bullet.toExplode();
            }
            return true;
        }
        return false;
    }

    public void attacked(int n) {
        this.iBloodNum -= n;
        if (this.iBloodNum < 1) {
            this.toExplode();
        }
    }

    public boolean ifGameOver() {
        return this.iLife == 0 && this.iState == 3;
    }

    public static void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.drawRegion(selfTankImage, n, n2, 16, 16, SelfTank.getTransform(n5), n3, n4, 0);
    }

    public void paint(Graphics graphics, int n) {
        super.paint(graphics);
        switch (this.iState) {
            case 1: {
                int n2;
                if (!this.bPause || this.iPauseTime % 4 <= 1) {
                    n2 = this.iBulletNum + this.iBloodNum + this.iBulletSpeed - 3;
                    graphics.drawRegion(selfTankImage, n2 * 16, this.iSide * 16, 16, 16, SelfTank.getTransform(this.iDirection), this.x, this.y, 0);
                }
                if (this.bProtect) {
                    graphics.setClip(this.x, this.y, 16, 16);
                    if (this.iTime % 2 != 0) {
                        graphics.drawImage(selfTankImage, this.x - 64, this.y, 0);
                    } else {
                        graphics.drawImage(selfTankImage, this.x - 64, this.y - 16, 0);
                    }
                    graphics.setClip(-layerX, -layerY, screenWidth, screenHeight);
                }
                if (this.iEnergyValue <= 0) break;
                n2 = this.x + this.iDirection + 6 - this.iDirection / 3 * 9 + this.iDirection / 4 * 14;
                int n3 = this.y + this.iDirection - 1 + this.iDirection / 2 * 14 - this.iDirection / 3 * 8 - this.iDirection / 4 * 16;
                graphics.setColor(255, 255, 255);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        graphics.fillRect(n2 - 8 + this.iEnergyValue % 5 + (8 - this.iEnergyValue % 5) * i, n3 - 8 + this.iEnergyValue % 5 + (8 - this.iEnergyValue % 5) * j, 1, 1);
                        graphics.fillRect(n2 - 4 + this.iEnergyValue % 5 + (4 - this.iEnergyValue % 5) * i, n3 - 4 + this.iEnergyValue % 5 + (4 - this.iEnergyValue % 5) * j, 1, 1);
                    }
                }
                if (this.iEnergyValue < iMaxEnergyValue) {
                    graphics.setColor(255, 255, 255);
                    graphics.drawLine(n2 - 1, n3, n2 + 1, n3);
                    graphics.drawLine(n2, n3 - 1, n2, n3 + 1);
                    break;
                }
                if (this.iEnergyValue < iMaxEnergyValue) break;
                if (n % 2 != 0) {
                    graphics.setColor(170, 240, 246);
                    graphics.fillRect(n2 - 3, n3, 8, 2);
                    graphics.fillRect(n2 - 2, n3 - 1, 6, 4);
                    graphics.fillRect(n2 - 1, n3 - 2, 4, 6);
                    graphics.fillRect(n2, n3 - 3, 2, 8);
                }
                graphics.setColor(255, 255, 255);
                graphics.fillRect(n2 - 1, n3, 4, 2);
                graphics.fillRect(n2, n3 - 1, 2, 4);
            }
        }
    }

    static {
        iMaxEnergyValue = 50;
    }
}

