/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;

public class TankCanvas
extends GameCanvas
implements Runnable {
    private Tanks tm;
    private Graphics g;
    private Font font;
    private InputStream is;
    private DataInputStream dis;
    private RecordStore recordStore;
    public BlueTooth blueTooth;
    private Image menuImage;
    private Image itemImage;
    private Image logoimage;
    private SelfTank[] selfTank;
    private EnemyTank[] enemyTank;
    private int width;
    private int height;
    private int iGameState = 7;
    private static int iLevel;
    private int leftSoftKey = -6;
    private int rightSoftKey = -7;
    private int layerX;
    private int layerY;
    private int iMaxScreenEnemyNum = 4;
    private int iCollidesChoice = 1;
    private int iDegree = 1;
    private int iPlayerChoice = 1;
    private int iRoleChoice;
    private int iPlayerNum;
    private int recordChoice = 1;
    private int iItemChoice = 1;
    private int iWaitTime;
    private boolean menuKeyFired;
    private boolean shopKeyFired;
    private boolean bBuyItem;
    private boolean bGameOver;
    private boolean bPassLevel;
    private boolean bInterrupt;
    public static int iSystemTime;
    private static int iFlagExplodeTime;
    private static boolean bFlagExplode;
    private static boolean bItemScoreAppeared;
    private static int iItemScoreAppearedTime;

    public TankCanvas(Tanks tanks) {
        super(false);
        this.tm = tanks;
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.g.setFont(this.font);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.layerX = (this.width - 208) / 2;
        this.layerY = (this.height - 208) / 2;
        SelfTank.canvasInit();
        MySprite.canvasInit(this);
        try {
            this.itemImage = Image.createImage((String)"/item.png");
        }
        catch (Exception exception) {
            System.out.println("item image load failed");
        }
    }

    public int getItemChoice() {
        return this.iItemChoice;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.runLogo();
        while (this.iGameState == 7) {
            this.runMainMenu();
            this.runGame();
            if (this.iGameState == 7) {
                this.g.translate(-this.layerX, -this.layerY);
                if (this.iPlayerNum > 1) {
                    this.blueTooth.closeConnect();
                    if (this.iPlayerChoice == 1) {
                        this.blueTooth.closeServer();
                    }
                    this.g.setColor(0, 0, 0);
                    this.g.fillRect(0, 0, this.width, this.height);
                    this.g.setColor(255, 255, 255);
                    this.g.drawString("\u4e0e\u5bf9\u65b9\u8fde\u63a5\u65ad\u5f00", this.width / 2, this.height / 2, 17);
                    this.flushGraphics();
                    int n = this.getKeyStates();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.g.setColor(255, 255, 255);
                    this.g.drawString("\u6309\u4efb\u610f\u952e\u8fd4\u56de\u4e3b\u83dc\u5355", this.width / 2, this.height, 33);
                    this.flushGraphics();
                    while ((n = this.getKeyStates()) == 0) {
                    }
                }
            }
            if (this.iGameState != 31) continue;
            this.runPassAllLevel();
        }
    }

    public void runLogo() {
        int n;
        String string = "\u4e2a\u4eba\u521b\u4f5c\u7eaf\u5c5e\u5a31\u4e50\u4e0d\u6d89\u7248\u6743\u8bf7\u52ff\u5546\u7528";
        int n2 = 0;
        int n3 = this.font.getHeight();
        int n4 = this.width * 3 / 4;
        int n5 = this.height / 2;
        int n6 = this.width / 8;
        int n7 = this.height / 4;
        int n8 = this.width / 8;
        int n9 = this.getKeyStates();
        while (n2 <= n4 && (n9 = this.getKeyStates()) == 0) {
            this.g.setColor(0, 0, 0);
            this.g.fillRect(0, 0, this.width, this.height);
            this.g.setColor(242, 209, 77);
            this.g.fillRect(n6, n7, n4, n5);
            this.drawColumn(n6 + n4, n7 - 25, n5 + 40);
            this.g.setColor(0, 0, 0);
            for (int i = 0; i < 4; ++i) {
                for (n = 0; n < 4; ++n) {
                    this.g.drawSubstring(string, i * 4 + n, 1, n6 + n8 * (5 - i), n7 + n5 / 5 * (n + 1), 40);
                }
            }
            this.g.setColor(242, 209, 77);
            this.drawColumn(n6 + n4 - 10 - n2, n7 - 25, n5 + 40);
            this.g.setColor(242, 209, 77);
            this.g.fillRect(n6 + n4, n7, 12, n5);
            this.g.fillRect(n6 + n4 - 12 - n2, n7, 12, n5);
            this.g.setColor(0, 0, 0);
            this.g.drawLine(n6 + n4, n7 - 25, n6 + n4, n7 + n5 + 25);
            this.g.drawLine(n6 + n4 - n2, n7 - 25, n6 + n4 - n2, n7 + n5 + 25);
            this.g.drawLine(n6 + n4 - 12 - n2, n7, n6 + n4 + 12, n7);
            this.g.drawLine(n6 + n4 - 12 - n2, n7 + n5, n6 + n4 + 12, n7 + n5);
            this.g.fillRect(0, 0, n6 + n4 - 12 - n2, this.height);
            this.g.setColor(255, 255, 255);
            this.g.drawString("\u6309\u4efb\u610f\u952e\u8df3\u8fc7", this.width / 2, this.height, 33);
            this.flushGraphics();
            n2 += n4 / 30;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.flushGraphics();
        int n10 = this.getKeyStates();
        while ((n10 = this.getKeyStates()) == 0) {
        }
        this.g.setColor(255, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.font = Font.getFont((int)0, (int)0, (int)16);
        this.g.setFont(this.font);
        n = this.font.stringWidth("K.");
        int n11 = this.height / 4;
        int n12 = 10;
        int n13 = n * 4 + n12 * 3;
        int n14 = (this.width - n13) / 2;
        this.g.setColor(0, 0, 0);
        this.g.drawString("S.", n14, n11, 0);
        this.g.drawString("K.", n14 + n + n12, n11, 0);
        this.g.drawString("N.", n14 + n * 2 + n12 * 2, n11, 0);
        this.g.drawString("K.", n14 + n * 3 + n12 * 3, n11, 0);
        this.g.setColor(0, 0, 0);
        this.g.fillRect(n14, n11 + n3 + 5, n13, 2);
        String string2 = "\u6e38\u620f\u5c31\u662f\u6e38\u620f";
        int n15 = this.height / 2;
        int n16 = 10;
        int n17 = this.font.stringWidth("\u6e38");
        int n18 = 10;
        int n19 = (this.width - n16 * 2 - n17 * 6) / 5;
        int n20 = this.font.getHeight();
        this.g.setColor(0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            int n21 = n16 + i * (n17 + n19);
            int n22 = n15 + i % 2 * (n20 + n18);
            this.g.drawChar(string2.charAt(i), n21, n22, 0);
        }
        this.flushGraphics();
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.g.setFont(this.font);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawColumn(int n, int n2, int n3) {
        this.g.setColor(152, 130, 31);
        this.g.fillArc(n, n2, 10, 10, 0, 180);
        this.g.fillRect(n, n2 + 5, 10, n3);
        this.g.fillArc(n, n2 + n3, 10, 10, 180, 360);
    }

    public void runPassAllLevel() {
        int n;
        this.g.setClip(0, 0, this.width, this.height);
        try {
            this.logoimage = Image.createImage((String)"/logo.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 168;
        int n3 = 16;
        int n4 = n2 / 2 / 14;
        int n5 = n3 / 2 / 2;
        int n6 = (this.width - n2) / 2;
        int n7 = this.height / 4;
        int n8 = this.height;
        while (n8 >= this.height / 6 * 5) {
            this.g.setColor(0, 0, 0);
            this.g.fillRect(0, 0, this.width, this.height);
            this.drawConImage1(n8, n6, n7, n2, n3);
            n8 -= 4;
            this.flushGraphics();
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {}
        }
        int n9 = 0;
        int n10 = 0;
        while (n9 <= 30) {
            this.g.setColor(0, 0, 0);
            this.g.fillRect(0, 0, this.width, this.height);
            this.drawConImage1(n8, n6, n7, n2, n3);
            for (int i = 0; i < 4; ++i) {
                n10 = (this.width - 64) / 5 * (i + 1) + 16 * i + 7;
                for (n = -1; n < 2; ++n) {
                    for (int j = -1; j < 2; ++j) {
                        this.g.setColor(255, 255, 255);
                        this.g.fillRect(n10 + (8 - n9 % 5) * n, n8 + (8 - n9 % 5) * j, 1, 1);
                        this.g.fillRect(n10 + (4 - n9 % 5) * n, n8 + (4 - n9 % 5) * j, 1, 1);
                    }
                }
                if (n9 <= 12) continue;
                if (n9 % 2 != 0) {
                    this.g.setColor(170, 240, 246);
                    this.g.fillRect(n10 - 3, n8, 8, 2);
                    this.g.fillRect(n10 - 2, n8 - 1, 6, 4);
                    this.g.fillRect(n10 - 1, n8 - 2, 4, 6);
                    this.g.fillRect(n10, n8 - 3, 2, 8);
                }
                this.g.setColor(255, 255, 255);
                this.g.fillRect(n10 - 1, n8, 4, 2);
                this.g.fillRect(n10, n8 - 1, 2, 4);
            }
            ++n9;
            this.flushGraphics();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        int n11 = n8;
        n = 0;
        while (n11 >= n7) {
            this.g.setColor(0, 0, 0);
            this.g.fillRect(0, 0, this.width, this.height);
            this.g.setClip(n6, n7, n2, n3);
            this.g.drawImage(this.logoimage, n6, n7 - 52, 0);
            this.g.setClip(0, 0, this.width, this.height);
            this.drawConImage1(n8, n6, n7, n2, this.getMin(n11 - n7, n3));
            this.g.setColor(255, 255, 255);
            for (int i = 0; i < 4; ++i) {
                n = (this.width - 64) / 5 * (i + 1) + 16 * i + 6;
                this.g.fillRect(n, n11 - 1, 2, 4);
                this.g.fillRect(n - 1, n11, 4, 2);
            }
            n11 -= 8;
            this.flushGraphics();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        int n12 = -197;
        int n13 = this.height / 2;
        while (n12 <= (this.width - 197) / 2) {
            this.g.setColor(0, 0, 0);
            this.g.fillRect(0, 0, this.width, this.height);
            this.g.setClip(n6, n7, 168, 16);
            this.g.drawImage(this.logoimage, n6, n7 - 52, 0);
            this.g.setClip(0, 0, this.width, this.height);
            this.drawCongratulationLine(1, n9, n6, n7, n4, n5, n2, n3);
            this.drawConImage1(n8, n6, n7, n2, 0);
            this.drawConImage2(n12, n13, n9);
            ++n9;
            n12 += 5;
            this.flushGraphics();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        int n14 = this.getKeyStates();
        while (true) {
            this.g.setColor(0, 0, 0);
            this.g.fillRect(0, 0, this.width, this.height);
            this.g.setClip(n6, n7, 168, 16);
            this.g.drawImage(this.logoimage, n6, n7 - 52, 0);
            this.g.setClip(0, 0, this.width, this.height);
            this.drawCongratulationLine(1, n9, n6, n7, n4, n5, n2, n3);
            this.drawConImage1(n8, n6, n7, n2, 0);
            this.drawConImage2(n12, n13, n9);
            ++n9;
            n14 = this.getKeyStates();
            if (n14 != 0) break;
            this.flushGraphics();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    public void drawConImage1(int n, int n2, int n3, int n4, int n5) {
        this.g.setColor(255, 0, 0);
        this.g.fillRect(n2, n3, n4, n5);
        for (int i = 0; i < 4; ++i) {
            SelfTank.paint(this.g, 16 * i, 0, (this.width - 64) / 5 * (i + 1) + 16 * i, n, 1);
        }
    }

    public void drawConImage2(int n, int n2, int n3) {
        int n4;
        this.g.setClip(n, n2, 197, 51);
        this.g.drawImage(this.logoimage, n, n2, 0);
        int[] nArray = new int[10];
        int[] nArray2 = new int[10];
        for (n4 = 0; n4 < 10; ++n4) {
            nArray[n4] = n + n4 * 20;
            nArray2[n4] = n2 - 20;
        }
        for (n4 = 0; n4 < 10; ++n4) {
            if (n3 % 2 != 0) {
                this.drawGreenStar(nArray[n4], nArray2[n4]);
                continue;
            }
            this.drawReserveGreenStar(nArray[n4], nArray2[n4]);
        }
        this.g.setClip(0, 0, this.width, this.height);
    }

    public void drawGreenStar(int n, int n2) {
        this.g.setClip(n, n2, 16, 16);
        this.g.drawImage(this.logoimage, n, n2, 0);
    }

    public void drawReserveGreenStar(int n, int n2) {
        this.g.setClip(n, n2, 16, 16);
        this.g.drawImage(this.logoimage, n - 16, n2, 0);
    }

    public void drawCongratulationLine(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        if (n2 % 2 != 0) {
            this.g.setColor(255, 255, 255);
        } else {
            this.g.setColor(0, 255, 0);
        }
        for (n9 = 0; n9 < 14; ++n9) {
            this.g.drawLine(n3 + n5 * (2 * n9 + 1 - n2 % 2), n4 - n, n3 + n5 * (2 * n9 + 1 - n2 % 2) + n5 - 1, n4 - n);
            this.g.drawLine(n3 + n5 * (2 * n9 + n2 % 2), n4 + n8 + n, n3 + n5 * (2 * n9 + n2 % 2) + n5 - 1, n4 + n8 + n);
        }
        for (n9 = 0; n9 < 2; ++n9) {
            this.g.drawLine(n3 - n, n4 + n6 * (2 * n9 + n2 % 2), n3 - n, n4 + n6 * (2 * n9 + n2 % 2) + n6 - 1);
            this.g.drawLine(n3 + n7 + n, n4 + n6 * (2 * n9 + 1 - n2 % 2), n3 + n7 + n, n4 + n6 * (2 * n9 + 1 - n2 % 2) + n6 - 1);
        }
    }

    public int getMin(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public void runMainMenu() {
        int n = this.getKeyStates();
        this.loadMainMenuImage();
        String[] stringArray = new String[]{"\u5355\u4eba\u6e38\u620f", "\u53cc\u4eba\u6e38\u620f", "\u5e2e\u52a9", "\u5173\u4e8e", "\u9000\u51fa\u6e38\u620f"};
        int n2 = this.font.stringWidth("\u5355\u4eba\u6e38\u620f");
        int n3 = 10;
        int n4 = (this.width - n2) / 2 - n3;
        int n5 = 108 + this.font.getHeight() - n3;
        int n6 = this.height;
        this.iGameState = 0;
        while (this.iGameState == 0 && (n = this.getKeyStates()) == 0 && n6 > 0) {
            this.drawMainMenuBack(n6);
            this.drawStandardMenu(0, 0, 0, n4, n5 + n6, stringArray, 5, n3, 255, 255, 255, n2, 0, 255, 255, 0);
            n6 -= 5;
            this.flushGraphics();
            try {
                Thread.sleep(40L);
            }
            catch (Exception exception) {}
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iGameState = 1;
        this.runStandardMenu(this.iGameState, 0, 0, 0, n4, n5, stringArray, 5, n3, 255, 255, 255, n2, 0, 255, 255);
        this.menuImage = null;
        System.gc();
    }

    public void loadMainMenuImage() {
        try {
            this.menuImage = Image.createImage((String)"/menu.png");
        }
        catch (Exception exception) {
            System.out.println("menuimage load failed");
        }
    }

    public void drawMainMenuBack(int n) {
        this.g.setColor(0, 0, 0);
        this.g.fillRect(0, 0, this.width, this.height);
        int n2 = (this.width - 176) / 2;
        int n3 = 20 + n;
        int n4 = n3 + 39;
        int n5 = (this.width - 68) / 2;
        int n6 = this.height - 50 + n;
        int n7 = n6 + 30;
        String string = "by sei ki no ko @ 2009.11.14";
        this.g.setClip(n2, n3, 176, 29);
        this.g.drawImage(this.menuImage, n2 - 116, n3, 0);
        this.g.setClip(n2 + 30, n4, 116, 29);
        this.g.drawImage(this.menuImage, n2 - 86, n4 - 29, 0);
        this.g.setClip(n5, n6, 36, 8);
        this.g.drawImage(this.menuImage, n5 - 232, n6 - 29, 0);
        this.g.setClip(n5 + 36, n6, 31, 8);
        this.g.drawImage(this.menuImage, n5 - 196, n6 - 37, 0);
        this.g.setClip(0, 0, this.width, this.height);
        this.g.setColor(255, 255, 255);
        this.g.drawString(string, this.width / 2, n7, 17);
    }

    public void runStandardMenu(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        int n16 = 1;
        int n17 = this.getKeyStates();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        while (this.iGameState == n) {
            n17 = this.getKeyStates();
            if ((n17 & 2) != 0) {
                if (!bl) {
                    n16 += (n7 + 1 - n16) / n7 * n7 - 1;
                    bl = true;
                }
            } else if (bl) {
                bl = false;
            }
            if ((n17 & 0x40) != 0) {
                if (!bl2) {
                    n16 += 1 - n16 / n7 * n7;
                    bl2 = true;
                }
            } else if (bl2) {
                bl2 = false;
            }
            if ((n17 & 0x100) != 0) {
                if (!bl3) {
                    this.dealStandardMenuFired(n, n16);
                    bl3 = true;
                }
            } else if (bl3) {
                bl3 = false;
            }
            if (this.iGameState == n) {
                if (n == 8 && this.iPlayerNum > 1) {
                    this.draw();
                }
                this.drawStandardMenuBack(n);
                this.drawStandardMenu(n2, n3, n4, n5, n6, stringArray, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16);
                this.flushGraphics();
            }
            if (this.iPlayerNum <= 1 || n != 8 && n != 12) continue;
            this.gameUpdate();
            System.gc();
            try {
                Thread.sleep(40L);
            }
            catch (Exception exception) {}
        }
    }

    public void dealStandardMenuFired(int n, int n2) {
        switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        this.startOrContinue();
                        break;
                    }
                    case 2: {
                        this.makeSureIfRestart();
                        if (this.iGameState != 3) break;
                        this.twoPlayersGameInit();
                        this.choosePlayer();
                        break;
                    }
                    case 3: {
                        this.runHelp();
                        break;
                    }
                    case 4: {
                        this.runAbout();
                        break;
                    }
                    case 5: {
                        this.tm.exitGame();
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.choosePlayer();
                        break;
                    }
                    case 2: {
                        this.runLoad();
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 1: {
                        this.menuToGame();
                        break;
                    }
                    case 2: {
                        if (this.iPlayerNum == 1 && !this.ifGameOver()) {
                            this.runSave();
                            break;
                        }
                        this.showCanNotRecord();
                        break;
                    }
                    case 3: {
                        this.makeSureIfReturn();
                    }
                }
                break;
            }
            case 12: {
                switch (n2) {
                    case 1: {
                        this.save();
                        this.iGameState = 11;
                        break;
                    }
                    case 2: {
                        this.iGameState = 11;
                    }
                }
                break;
            }
            case 14: {
                switch (n2) {
                    case 1: {
                        this.load();
                        this.iGameState = 5;
                        break;
                    }
                    case 2: {
                        this.iGameState = 13;
                    }
                }
                break;
            }
            case 16: {
                switch (n2) {
                    case 1: {
                        this.bBuyItem = true;
                    }
                }
                this.iGameState = 15;
                break;
            }
            case 25: {
                this.blueTooth.searchServerService(n2 - 1);
                this.iGameState = 5;
            }
        }
    }

    public void drawStandardMenu(int n, int n2, int n3, int n4, int n5, String[] stringArray, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        int n16 = this.font.getHeight();
        int n17 = n11 + n7 * 2;
        int n18 = n6 * (n16 + n7) + n7;
        this.g.setColor(n, n2, n3);
        this.g.fillRect(n4, n5, n17, n18);
        if (n15 > 0) {
            this.g.setColor(n12, n13, n14);
            this.g.fillRect(n4, n5 + (n15 - 1) * (n16 + n7), n17, n16 + n7 * 2);
        }
        this.g.setColor(n8, n9, n10);
        for (int i = 0; i < n6; ++i) {
            this.g.drawString(stringArray[i], n4 + n17 / 2, n5 + n7 + i * (n16 + n7), 17);
        }
    }

    public void drawStandardMenuBack(int n) {
        switch (n) {
            case 1: {
                this.drawMainMenuBack(0);
                break;
            }
            case 2: {
                this.drawStartOrContinueBack();
            }
        }
    }

    public void startOrContinue() {
        this.iPlayerNum = 1;
        this.iGameState = 2;
        int n = this.font.stringWidth("\u5f00\u59cb\u6e38\u620f");
        int n2 = 10;
        int n3 = (this.width - n) / 2 - n2;
        int n4 = this.height / 2 - this.font.getHeight() - n2 / 2 * 3;
        String[] stringArray = new String[]{"\u5f00\u59cb\u6e38\u620f", "\u7ee7\u7eed\u6e38\u620f"};
        this.runStandardMenu(this.iGameState, 255, 255, 255, n3, n4, stringArray, 2, n2, 0, 0, 0, n, 255, 0, 255);
    }

    public void twoPlayersGameInit() {
        this.iPlayerNum = 2;
        this.blueTooth = new BlueTooth(this);
    }

    public void drawStartOrContinueBack() {
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
    }

    public void choosePlayer() {
        this.iGameState = 3;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 1;
        int n2 = this.getKeyStates();
        while (this.iGameState == 3) {
            n2 = this.getKeyStates();
            if ((n2 & 4) != 0) {
                if (!bl) {
                    n += (3 - n) / 2 * 2 - 1;
                    bl = true;
                }
            } else if (bl) {
                bl = false;
            }
            if ((n2 & 0x20) != 0) {
                if (!bl2) {
                    n += 1 - n / 2 * 2;
                    bl2 = true;
                }
            } else {
                bl2 = false;
            }
            if ((n2 & 0x100) != 0) {
                if (!bl3) {
                    this.iRoleChoice = n;
                    this.iPlayerChoice = this.iPlayerNum == 1 ? 1 : n;
                    if (this.iPlayerNum == 1 || this.iPlayerChoice == 1) {
                        this.runSet();
                        if (this.iGameState == 5) {
                            this.gameDataInit();
                        }
                    } else {
                        this.iGameState = 19;
                        while (this.iGameState == 19) {
                            this.drawSearchServer();
                            this.flushGraphics();
                            if (this.blueTooth.searchServer()) {
                                this.runChooseServer();
                                if (this.iGameState != 5) continue;
                                this.gameDataInit();
                                continue;
                            }
                            this.showSearchServerFailed();
                        }
                    }
                    bl3 = true;
                }
            } else if (bl3) {
                bl3 = false;
            }
            if (this.iGameState != 3) continue;
            this.drawChoosePlayer(n);
            this.flushGraphics();
        }
    }

    public void gameDataInit() {
        iLevel = 1;
        int[] nArray = new int[5];
        for (int i = 0; i < 5; ++i) {
            nArray[i] = this.iDegree / 4 * (this.iDegree - 3);
        }
        this.gameInit(2, 0, 0, nArray);
    }

    public void drawChoosePlayer(int n) {
        int n2 = this.width / 4;
        int n3 = 30;
        int n4 = this.height / 3;
        int n5 = 30;
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u9009\u62e9\u89d2\u8272", this.width / 2, n4, 17);
        int n6 = this.width / 2 - n2 / 2 - 16;
        int n7 = n6 + (n - 1) * (n2 + 16);
        int n8 = n4 + n3;
        int n9 = 8;
        int n10 = n8 + n5;
        this.g.fillTriangle(n7, n10 + n9, n7 + 16, n10 + n9, n7 + 8, n10);
        for (int i = 0; i < 2; ++i) {
            SelfTank.paint(this.g, 0, i * 16, this.width / 2 + (i * 2 - 1) * n2 / 2 - (1 - i) * 16, n4 + n3, 1);
        }
        this.g.setClip(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
    }

    public void runChooseServer() {
        int n;
        this.iGameState = 25;
        this.drawChooseServer();
        this.flushGraphics();
        int n2 = this.font.getHeight();
        int n3 = this.blueTooth.vector.size();
        String[] stringArray = new String[n3];
        for (n = 0; n < n3; ++n) {
            stringArray[n] = this.blueTooth.getBlueToothName(n);
        }
        n = 10;
        int n4 = this.width;
        int n5 = 0;
        int n6 = n2;
        this.runStandardMenu(25, 0, 255, 255, n5, n6, stringArray, stringArray.length, n, 0, 0, 0, n4, 255, 255, 255);
    }

    public void drawChooseServer() {
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u9009\u62e9\u73a9\u5bb6", this.width / 2, 0, 17);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
    }

    public void drawSearchServer() {
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u6b63\u5728\u641c\u7d22\u670d\u52a1\u5668...", this.width / 2, this.height / 2, 17);
        this.g.drawString("\u53d6\u6d88", this.width, this.height, 40);
    }

    public void drawSearchClient() {
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u6b63\u5728\u641c\u7d22\u5ba2\u6237\u7aef...", this.width / 2, this.height / 2, 17);
        this.g.drawString("\u53d6\u6d88", this.width, this.height, 40);
    }

    public void makeSureIfRestart() {
        this.iGameState = 26;
        String string = "\u6ce8\u610f";
        String string2 = "\u5982\u679c\u8981\u8fdb\u884c\u53cc\u4eba\u84dd\u7259\u8054\u673a\u6e38\u620f\uff0c\u5e76\u4e14\u5728\u6e38\u620f\u7a0b\u5e8f\u542f\u52a8\u540e\u5df2\u73a9\u8fc7\u4e00\u6b21\u5355\u4eba\u6216\u53cc\u4eba\u6e38\u620f\uff0c\u90a3\u4e48\u8bf7\u5148\u9000\u51fa\u6e38\u620f\u7a0b\u5e8f\uff0c\u518d\u91cd\u65b0\u542f\u52a8\u7a0b\u5e8f\uff0c\u5426\u5219\u6e38\u620f\u5c06\u51fa\u73b0\u9519\u8bef\uff0c\u8fd9\u662f\u6e38\u620f\u4e2d\u7684\u4e00\u4e2aBUG\uff0c\u4f5c\u8005\u76ee\u524d\u8fd8\u65e0\u6cd5\u89e3\u51b3\uff0c\u8bf7\u89c1\u8c05\uff01$";
        this.runStandardAbout(this.iGameState, string, string2);
    }

    public void runHelp() {
        this.iGameState = 20;
        String string = "\u5e2e\u52a9";
        String string2 = "\u6e38\u620f\u754c\u9762\u7684\u7279\u6b8a\u6309\u952e\uff1a$\u6570\u5b57\u952e1\u30013\uff1a\u5411\u5de6\u6216\u5411\u53f3\u9009\u62e9\u9053\u5177$\u6570\u5b57\u952e7\uff1a\u5fc5\u6740\u6280\u84c4\u6c14$\u6570\u5b57\u952e9\uff1a\u4f7f\u7528\u9053\u5177$\u5de6\u8f6f\u952e\uff1a\u8fdb\u5165\u5546\u5e97$\u53f3\u8f6f\u952e\uff1a\u8fdb\u5165\u83dc\u5355$\u6ce8\uff1a\u4ee5\u4e0a\u6309\u952e\u53ea\u9488\u5bf9\u5927\u90e8\u5206\u673a\u578b\uff0c\u90e8\u5206\u673a\u578b\u53ef\u80fd\u65e0\u6cd5\u4f7f\u7528\u3002$\u96be\u5ea6\u9009\u62e9\uff1a$\u539f\u7248\uff1a\u6bcf\u5173\u5766\u514b\u56fa\u5b9a\u90fd\u662f20\u8f86\u3002\u5176\u5b83\u9009\u62e9\uff1a\u7b2c\u4e00\u517325\u8f86\uff0c\u4ee5\u540e\u6bcf\u5173\u52a01\u8f86,\u4e0a\u9650\u4e3a40\u8f86$\u5546\u5e97\uff1a\u53ef\u5229\u7528\u6240\u5f97\u5206\u6570\u8d2d\u4e70\u5404\u79cd\u9053\u5177\uff0c\u5e76\u5728\u6e38\u620f\u4e2d\u4f7f\u7528\u3002$\u5173\u4e8e\u53cc\u4eba\u84dd\u7259\u6e38\u620f\uff1a\u7531\u4e8e\u84dd\u7259\u6280\u672f\u4f5c\u8005\u4ecd\u5904\u5728\u6d4b\u8bd5\u9636\u6bb5\u6240\u4ee5\u53cc\u4eba\u84dd\u7259\u6e38\u620f\u53ef\u80fd\u4f1a\u51fa\u73b0\u53cc\u65b9\u6e38\u620f\u901f\u5ea6\u53d8\u6162\u7b49\u95ee\u9898\uff0c\u7b49\u5f85\u89e3\u51b3\u4e2d\u2026\u2026$\u56e0\u52a0\u5165\u58f0\u97f3\u4f1a\u660e\u663e\u51cf\u6162\u6e38\u620f\u901f\u5ea6\uff0c\u6545\u6e38\u620f\u4e2d\u5e76\u672a\u52a0\u5165\u58f0\u97f3\u6548\u679c\u3002$\u672c\u6e38\u620f\u76ee\u524d\u53ea\u9002\u7528\u4e8e\u5c4f\u5e55\u5206\u8fa8\u7387\u81f3\u5c11\u4e3a240*320\u7684\u624b\u673a\uff0c\u5176\u5b83\u5206\u8fa8\u7387\u624b\u673a\u867d\u7136\u80fd\u8fd0\u884c\u6e38\u620f\uff0c\u4f46\u753b\u9762\u663e\u793a\u4e0d\u5b8c\u5168\u3002$";
        this.runStandardAbout(this.iGameState, string, string2);
    }

    public void runAbout() {
        this.iGameState = 21;
        String string = "\u5173\u4e8e";
        String string2 = "\u672c\u6e38\u620f\u4e3a\u4e2a\u4eba\u4f5c\u54c1\uff0c\u53ea\u4f9b\u5a31\u4e50\u4e4b\u7528\uff0c\u4e0d\u6d89\u53ca\u4efb\u4f55\u7248\u6743\u95ee\u9898\uff0c\u8bf7\u52ff\u7528\u4e8e\u4efb\u4f55\u5546\u4e1a\u7528\u9014\u3002$\u6ce8\uff1a\u4f5c\u8005\u672c\u4eba\u5e76\u975e\u4e13\u4e1a\u6e38\u620f\u7f16\u7a0b\u4eba\u5458\uff0c\u6545\u6e38\u620f\u4e2d\u53ef\u80fd\u5b58\u5728\u9519\u8bef\uff0c\u5982\u6709\u53d1\u73b0\uff0c\u53ef\u8054\u7cfb\u4f5c\u8005\u3002$\u90ae\u7bb1\uff1aseikinoko@163.com$";
        this.runStandardAbout(this.iGameState, string, string2);
    }

    public void runStandardAbout(int n, String string, String string2) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        int n6 = 12;
        int n7 = 7;
        int n8 = 0;
        int n9 = string2.length();
        for (n4 = 0; n4 < n9; n4 += n5) {
            n5 = 0;
            int n10 = n9 - n4;
            if (n10 > n6) {
                n10 = n6;
            }
            for (n5 = 0; n5 < n10; ++n5) {
                if (string2.charAt(n4 + n5) != '$') continue;
                ++n5;
                break;
            }
            ++n8;
        }
        n5 = n8 / n7;
        if (n8 % n7 != 0) {
            ++n5;
        }
        int[] nArray = new int[n8];
        int n11 = 0;
        for (n4 = 0; n4 < n9; n4 += n3) {
            n3 = 0;
            n2 = n9 - n4;
            if (n2 > n6) {
                n2 = n6;
            }
            for (n3 = 0; n3 < n2 && string2.charAt(n4 + n3) != '$'; ++n3) {
            }
            nArray[n11] = ++n3;
            ++n11;
        }
        n3 = 1;
        n2 = 1;
        int n12 = this.getKeyStates();
        int n13 = 1;
        while (this.iGameState == n) {
            n12 = this.getKeyStates();
            if ((n12 & 2) != 0) {
                if (n3 == 0) {
                    n13 += (n5 + 1 - n13) / n5 * n5 - 1;
                    n3 = 1;
                }
            } else if (n3 != 0) {
                n3 = 0;
            }
            if ((n12 & 0x40) != 0) {
                if (n2 == 0) {
                    n13 += 1 - n13 / n5 * n5;
                    n2 = 1;
                }
            } else if (n2 != 0) {
                n2 = 0;
            }
            this.drawStandardAbout(string, string2, n6, nArray, n13, n7, n5);
            this.flushGraphics();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    public void drawStandardAbout(String string, String string2, int n, int[] nArray, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        for (n7 = 1; n7 < n2; ++n7) {
            for (n6 = 0; n6 < n3; ++n6) {
                n8 += nArray[n6 + (n7 - 1) * n3];
            }
        }
        n7 = (n2 - 1) * n3;
        n6 = 5;
        int n9 = 10;
        int n10 = this.font.getHeight();
        String string3 = "";
        for (n5 = 0; n5 < n; ++n5) {
            string3 = string3 + "\u4e16";
        }
        n5 = this.font.stringWidth(string3);
        int n11 = n3 * n10 + n6 * (n3 - 1);
        int n12 = (this.width - n9 - n5) / 2;
        int n13 = (this.height - n10 - n11) / 2;
        int n14 = n12;
        int n15 = n10 + n13;
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString(string, this.width / 2, 0, 17);
        this.g.drawRect(0, 0, this.width, n10);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
        if (this.iGameState == 26) {
            this.g.drawString("\u7ee7\u7eed", 0, this.height, 36);
        }
        this.g.setColor(0, 0, 0);
        int n16 = this.width - n9;
        int n17 = this.height - n10 * 2;
        int n18 = n17 / n4;
        n17 = n18 * n4;
        int n19 = n18 * (n2 - 1) + n10;
        this.g.drawRect(n16, n10, n9, n17);
        this.g.setColor(0, 0, 0);
        this.g.fillRect(n16, n19, n9, n18);
        int n20 = nArray.length - n7;
        if (n20 > n3) {
            n20 = n3;
        }
        this.g.setColor(0, 0, 0);
        for (int i = 0; i < n20; ++i) {
            int n21;
            int n22 = n8;
            for (n21 = 0; n21 < i; ++n21) {
                n22 += nArray[n21 + n7];
            }
            n21 = nArray[n7 + i];
            if (n21 < n) {
                --n21;
            }
            this.g.drawSubstring(string2, n22, n21, n14, n15 + i * (n10 + n6), 0);
        }
    }

    public void runSet() {
        this.iGameState = 4;
        int n = 1;
        int n2 = 3;
        int n3 = 5;
        int n4 = 10;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = this.getKeyStates();
        while (this.iGameState == 4) {
            while (this.iGameState == 4) {
                n5 = this.getKeyStates();
                if ((n5 & 2) != 0) {
                    if (!bl) {
                        bl = true;
                        n += (n2 + 1 - n) / n2 * n2 - 1;
                    }
                } else if (bl) {
                    bl = false;
                }
                if ((n5 & 0x40) != 0) {
                    if (!bl2) {
                        bl2 = true;
                        n += 1 - n / n2 * n2;
                    }
                } else if (bl2) {
                    bl2 = false;
                }
                if ((n5 & 4) != 0) {
                    if (!bl3) {
                        switch (n) {
                            case 1: {
                                this.iDegree += (n3 + 1 - this.iDegree) / n3 * n3 - 1;
                                break;
                            }
                            case 2: {
                                this.iMaxScreenEnemyNum += (n4 + 1 - this.iMaxScreenEnemyNum) / n4 * n4 - 1;
                                break;
                            }
                            case 3: {
                                this.iCollidesChoice += (3 - this.iCollidesChoice) / 2 * 2 - 1;
                            }
                        }
                        bl3 = true;
                    }
                } else if (bl3) {
                    bl3 = false;
                }
                if ((n5 & 0x20) != 0) {
                    if (!bl4) {
                        switch (n) {
                            case 1: {
                                this.iDegree += 1 - this.iDegree / n3 * n3;
                                break;
                            }
                            case 2: {
                                this.iMaxScreenEnemyNum += 1 - this.iMaxScreenEnemyNum / n4 * n4;
                                break;
                            }
                            case 3: {
                                this.iCollidesChoice += 1 - this.iCollidesChoice / 2 * 2;
                            }
                        }
                        bl4 = true;
                    }
                } else if (bl4) {
                    bl4 = false;
                }
                this.drawSet(n, n2, n3, n4);
                this.flushGraphics();
                System.gc();
            }
            if (this.iGameState != 18) continue;
            while (this.iGameState == 18) {
                this.drawSearchClient();
                this.flushGraphics();
                if (this.blueTooth.searchClient()) {
                    this.iGameState = 5;
                    continue;
                }
                this.showSearchClientFailed();
            }
        }
    }

    public void showSearchClientFailed() {
        this.iGameState = 23;
        String string = "\u65e0\u5ba2\u6237\u7aef\u8fde\u63a5";
        this.drawSearchFailed(string);
        this.flushGraphics();
        while (this.iGameState == 23) {
        }
    }

    public void showSearchServerFailed() {
        this.iGameState = 22;
        String string = "\u641c\u7d22\u670d\u52a1\u5668\u5931\u8d25";
        this.drawSearchFailed(string);
        this.flushGraphics();
        while (this.iGameState == 22) {
        }
    }

    public void drawSearchFailed(String string) {
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString(string, this.width / 2, this.height / 2, 17);
        this.g.drawString("\u91cd\u65b0\u641c\u7d22", 0, this.height, 36);
        this.g.drawString("\u53d6\u6d88", this.width, this.height, 40);
    }

    public void drawSet(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        this.g.setColor(255, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        int n14 = 0;
        int n15 = this.font.getHeight();
        int n16 = (this.height - n15 - n14) / n2;
        int n17 = 10;
        int n18 = 6;
        this.g.setColor(0, 0, 0);
        for (n13 = 0; n13 < n2; ++n13) {
            this.g.drawRect(0, n16 * n13, this.width, n16);
        }
        n13 = 5;
        int n19 = 30;
        int n20 = n13 * 4 + n15 * 2 + n17;
        int n21 = (n16 - n20) / 2;
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u96be\u5ea6\u9009\u62e9", this.width / 2, n21, 17);
        int n22 = n3 * n17 + (n3 - 1) * n19;
        int n23 = (this.width - n22) / 2;
        int n24 = n21 + n15 + n13;
        String[] stringArray = new String[]{"\u539f\u7248", "\u7b80\u5355", "\u666e\u901a", "\u56f0\u96be", "\u6781\u96be"};
        int n25 = n24 + n17 + n13;
        this.g.setColor(0, 0, 0);
        for (n12 = 0; n12 < n3; ++n12) {
            n11 = n23 + n12 * (n17 + n19);
            this.g.drawArc(n11, n24, n17, n17, 0, 360);
            n10 = n11 + n17 / 2;
            this.g.drawString(stringArray[n12], n10, n25, 17);
        }
        n12 = n23 + (n17 - n18) / 2 + (this.iDegree - 1) * (n17 + n19);
        n11 = n24 + (n17 - n18) / 2;
        this.g.setColor(0, 255, 255);
        this.g.fillArc(n12, n11, n18, n18, 0, 360);
        n10 = 10;
        int n26 = 10;
        int n27 = 4;
        int n28 = 10;
        int n29 = n15 * 2 + n10 + n26 + n27 + n28;
        int n30 = (n16 - n29) / 2 + n16;
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u654c\u4eba\u540c\u65f6\u51fa\u73b0\u7684\u6570\u91cf", this.width / 2, n30, 17);
        int n31 = 3;
        int n32 = 7;
        int n33 = 15;
        int n34 = (this.width - n33 * n4) / 2;
        int n35 = n34 + (this.iMaxScreenEnemyNum - 1) * n33 - n31 / 2;
        int n36 = n30 + n15 + n10;
        this.g.setColor(0, 0, 0);
        this.g.fillRect(n35, n36, n31, n26);
        int n37 = n35 - (n32 - n31) / 2;
        int n38 = n36 + n26;
        this.g.fillTriangle(n37, n38, n37 + n32, n38, n37 + n32 / 2, n38 + n27);
        int n39 = n38 + n27;
        int n40 = n39 + n28;
        this.g.setColor(0, 0, 0);
        for (n9 = 0; n9 < n4; ++n9) {
            n8 = n34 + n9 * n33;
            this.g.drawLine(n8, n39, n8, n39 + n28);
            this.g.drawString("" + (n9 + 1), n8, n40, 17);
        }
        this.g.drawLine(n34, n40, n34 + n33 * (n4 - 1), n40);
        n9 = 10;
        n8 = (n15 + n9) * 2 + n17;
        int n41 = n16 * 2 + (n16 - n8) / 2;
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u654c\u4eba\u662f\u5426\u78b0\u649e\u9053\u5177", this.width / 2, n41, 17);
        int n42 = n41 + n15 + n9;
        int n43 = 50;
        int n44 = (this.width - (n17 * 2 + n43)) / 2;
        int n45 = n42 + n17 + n9;
        String[] stringArray2 = new String[]{"\u5426", "\u662f"};
        this.g.setColor(0, 0, 0);
        for (n7 = 0; n7 < 2; ++n7) {
            n6 = n44 + n7 * (n17 + n43);
            this.g.drawArc(n6, n42, n17, n17, 0, 360);
            n5 = n6 + n17 / 2;
            this.g.drawString(stringArray2[n7], n5, n45, 17);
        }
        n7 = n44 + (n17 - n18) / 2 + (this.iCollidesChoice - 1) * (n17 + n43);
        n6 = n42 + (n17 - n18) / 2;
        this.g.setColor(0, 255, 255);
        this.g.fillArc(n7, n6, n18, n18, 0, 360);
        n5 = 16;
        int n46 = 8;
        int n47 = 10;
        int n48 = (n16 - n5) / 2 + (n - 1) * n16;
        this.g.setColor(0, 0, 0);
        this.g.fillTriangle(n47, n48, n47, n48 + n5, n47 + n46, n48 + n5 / 2);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u5f00\u59cb", 0, this.height, 36);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
    }

    public void runGame() {
        while (this.iGameState == 5) {
            this.levelInit();
            this.iGameState = 6;
            while (this.iGameState == 6) {
                if (!this.menuKeyFired && !this.shopKeyFired || this.iPlayerNum != 1) {
                    this.runLevel();
                }
                if (this.menuKeyFired) {
                    this.runMenu();
                }
                if (!this.shopKeyFired) continue;
                this.runShop();
            }
        }
        this.memoryRecycle();
    }

    public void runLevel() {
        long l = System.currentTimeMillis();
        this.gameUpdate();
        this.draw();
        this.flushGraphics();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.gc();
        if (l3 < 40L) {
            try {
                Thread.sleep(40L - l3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void gameUpdate() {
        ++iSystemTime;
        this.input();
        this.enemyAction();
        this.sceneUpdate();
    }

    public void runMenu() {
        this.iGameState = 8;
        String[] stringArray = new String[]{"\u8fd4\u56de\u6e38\u620f", "\u4fdd\u5b58\u6e38\u620f", "\u8fd4\u56de\u6807\u9898"};
        int n = this.font.stringWidth("\u8fd4\u56de\u6e38\u620f");
        int n2 = 10;
        int n3 = (208 - n) / 2 - n2;
        int n4 = (208 - this.font.getHeight() * stringArray.length - n2 * (stringArray.length + 1)) / 2;
        this.runStandardMenu(8, 0, 255, 255, n3, n4, stringArray, stringArray.length, n2, 0, 0, 0, n, 255, 255, 255);
    }

    public void runShop() {
        this.g.translate(-this.layerX, -this.layerY);
        this.iGameState = 15;
        int n = this.getKeyStates();
        int n2 = 1;
        int n3 = 0;
        int n4 = 6;
        int[] nArray = new int[6];
        int[] nArray2 = new int[]{4000, 3000, 2000, 2000, 2000, 2000};
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        while (this.iGameState == 15) {
            n = this.getKeyStates();
            if ((n & 2) != 0) {
                if (!bl) {
                    n2 += (n4 + 1 - n2) / n4 * n4 - 1;
                    bl = true;
                }
            } else if (bl) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                if (!bl2) {
                    n2 += 1 - n2 / n4 * n4;
                    bl2 = true;
                }
            } else if (bl2) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                if (!bl3) {
                    if (nArray[n2 - 1] > 0) {
                        int n5 = n2 - 1;
                        nArray[n5] = nArray[n5] - 1;
                        n3 -= nArray2[n2 - 1];
                    }
                    bl3 = true;
                }
            } else if (bl3) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                if (!bl4) {
                    int n6 = n2 - 1;
                    nArray[n6] = nArray[n6] + 1;
                    n3 += nArray2[n2 - 1];
                    bl4 = true;
                }
            } else if (bl4) {
                bl4 = false;
            }
            if ((n & 0x100) != 0) {
                if (!bl5) {
                    this.makeSureIfBuy();
                    bl5 = true;
                }
            } else if (bl5) {
                bl5 = false;
            }
            if (this.bBuyItem) {
                if (n3 <= this.selfTank[0].getScore()) {
                    // empty if block
                }
                this.selfTank[0].boughtItem(n3, nArray);
                for (int i = 0; i < 6; ++i) {
                    nArray[i] = 0;
                }
                n3 = 0;
                this.bBuyItem = false;
            }
            this.drawShop(n2, n3, nArray);
            this.flushGraphics();
            if (this.iPlayerNum > 1) {
                this.gameUpdate();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.gc();
        }
    }

    public void makeSureIfBuy() {
        this.iGameState = 16;
        String string = "\u786e\u8ba4\u8d2d\u4e70";
        int n = this.font.stringWidth(string);
        int n2 = this.font.getHeight();
        int n3 = (this.width - n) / 2;
        int n4 = this.height / 2 - n2;
        this.g.setColor(0, 255, 0);
        this.g.fillRect(n3, n4, n, n2);
        this.g.setColor(0, 0, 0);
        this.g.drawString(string, n3, n4, 0);
        String[] stringArray = new String[]{"\u662f", "\u5426"};
        int n5 = 10;
        this.runStandardMenu(this.iGameState, 255, 255, 0, n3, n4 + this.font.getHeight(), stringArray, 2, n5, 0, 0, 0, 50, 255, 255, 255);
    }

    public void showScoreNotEnough() {
        this.iGameState = 17;
        int n = this.getKeyStates();
        String[] stringArray = new String[]{"\u5206\u6570\u4e0d\u8db3", "\u65e0\u6cd5\u8d2d\u4e70"};
        int n2 = this.font.stringWidth(stringArray[0]);
        int n3 = this.font.getHeight();
        int n4 = (this.width - n2) / 2;
        int n5 = this.height / 2 - n3;
        this.g.setColor(0, 255, 0);
        this.g.fillRect(n4, n5, n2, n3 * 2);
        this.g.setColor(0, 0, 0);
        for (int i = 0; i < 2; ++i) {
            this.g.drawString(stringArray[i], n4, n5 + i * n3, 0);
        }
        this.flushGraphics();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.iGameState == 17) {
            n = this.getKeyStates();
            if (n == 0) continue;
            this.iGameState = 15;
        }
    }

    public void drawShop(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        int n11 = this.font.getHeight();
        int n12 = 30;
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u5546\u5e97", this.width / 2, (n12 - n11) / 2, 17);
        int n13 = 60;
        int n14 = (this.width - n13) / 2;
        this.g.setColor(0, 0, 0);
        this.g.drawRect(n14, 0, n13, n12);
        int n15 = 10;
        int n16 = 16;
        int n17 = (n14 - (n16 * 3 + n15 * 2)) / 2;
        int n18 = (n12 - n11) / 2;
        SelfTank.paint(this.g, this.selfTank[0].getLevel() * 16, this.selfTank[0].getSide() * 16, n17, (n12 - 16) / 2, 1);
        this.g.setColor(0, 0, 0);
        this.g.drawString("x", n17 + n15 + n16, n18, 0);
        this.g.drawString("" + this.selfTank[0].getLife(), n17 + (n15 + n16) * 2, n18, 0);
        this.g.setColor(0, 0, 0);
        this.g.drawRect(0, 0, n14, n12);
        String string = "\u5206\u6570:";
        int n19 = this.font.stringWidth(string);
        int n20 = (this.width + n13) / 2;
        this.g.setColor(0, 0, 0);
        this.g.drawString(string, n20, n18, 0);
        this.g.drawString("" + this.selfTank[0].getScore(), n20 + n19, n18, 0);
        this.g.setColor(0, 0, 0);
        this.g.drawRect(n20, 0, n14, n12);
        int n21 = 80;
        int n22 = (this.height - n11 - n12) / 6;
        int n23 = (n21 - (n16 * 3 + n15 * 2)) / 2;
        String string2 = "\u9053\u5177 ";
        this.g.setColor(0, 0, 0);
        this.g.drawString(string2, n21 / 2, n12 + (n22 - n11) / 2, 17);
        for (n10 = 0; n10 < 5; ++n10) {
            int n24 = n12 + (n10 + 1) * n22;
            n9 = n24 + (n22 - 16) / 2;
            n8 = n24 + (n22 - n11) / 2;
            this.g.setClip(n23, n9, 16, 16);
            this.g.drawImage(this.itemImage, n23 - (n10 + 1) % 3 * 16, n9 - (n10 + 1) / 3 * 16, 0);
            this.g.setClip(0, 0, this.width, this.height);
            this.g.setColor(0, 0, 0);
            this.g.drawString("x", n23 + n16 + n15, n8, 0);
            this.g.drawString("" + this.selfTank[0].getItemNum(n10), n23 + (n16 + n15) * 2, n8, 0);
        }
        for (n10 = 0; n10 < 6; ++n10) {
            this.g.setColor(0, 0, 0);
            this.g.drawRect(0, n12 + n10 * n22, n21, n22);
        }
        n10 = (this.height - n11 - n12) / 8;
        String string3 = "\u8d2d\u4e70\u6240\u9700\u5206\u6570:";
        n9 = n12 + (n10 - n11) / 2;
        n8 = this.width - n21;
        this.g.setColor(0, 0, 0);
        this.g.drawString(string3, n21, n9, 0);
        this.g.drawString("" + n2, n21 + this.font.stringWidth(string3), n9, 0);
        this.g.setColor(0, 0, 0);
        this.g.drawRect(n21, n12, n8, n10);
        this.g.setColor(0, 0, 0);
        int n25 = n12 + n10 + (n10 - n11) / 2;
        this.g.drawString("\u8d2d\u4e70\u9053\u5177", n21 + (this.width - n21) / 2, n25, 17);
        this.g.setColor(0, 0, 0);
        this.g.drawRect(n21, n12 + n10, n8, n10);
        int n26 = 30;
        int n27 = 10;
        int n28 = 30;
        for (n7 = 0; n7 < 6; ++n7) {
            n6 = n21 + n26;
            n5 = n12 + (n7 + 2) * n10;
            n4 = n5 + (n10 - 16) / 2;
            n3 = n5 + (n10 - n11) / 2;
            this.g.setClip(n6, n4, 16, 16);
            this.g.drawImage(this.itemImage, n6 - n7 % 3 * 16, n4 - n7 / 3 * 16, 0);
            this.g.setClip(0, 0, this.width, this.height);
            this.g.setColor(0, 0, 0);
            this.g.drawString("x", n6 + 16 + n27, n3, 0);
            this.g.drawString("" + nArray[n7], n6 + 32 + n27 + n28, n3, 0);
            this.g.setColor(0, 0, 0);
            this.g.drawRect(n21, n5, n8, n10);
        }
        n7 = 5;
        n6 = 16;
        n5 = n12 + (n + 1) * n10;
        n4 = n21 + n7;
        n3 = n5 + (n10 - n6) / 2;
        this.g.setColor(0, 0, 0);
        this.g.fillTriangle(n4, n3, n4, n3 + n6, n4 + n6 / 2, n3 + n6 / 2);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
    }

    public void shopToGame() {
        this.iGameState = 6;
        this.shopKeyFired = false;
        this.g.translate(this.layerX, this.layerY);
    }

    public void gameInit(int n, int n2, int n3, int[] nArray) {
        int n4;
        if (this.iPlayerNum > 1 && this.iPlayerChoice == 1) {
            this.blueTooth.startSend();
            this.blueTooth.addElement(this.iDegree);
            this.blueTooth.addElement(this.iMaxScreenEnemyNum);
            this.blueTooth.addElement(this.iCollidesChoice);
            this.blueTooth.overSend();
        }
        if (this.iPlayerNum > 1 && this.iPlayerChoice != 1) {
            this.blueTooth.startReceive();
            this.iDegree = this.blueTooth.getIntElement();
            this.iMaxScreenEnemyNum = this.blueTooth.getIntElement();
            this.iCollidesChoice = this.blueTooth.getIntElement();
        }
        this.selfTank = new SelfTank[this.iPlayerNum];
        for (n4 = 0; n4 < this.iPlayerNum; ++n4) {
            this.selfTank[n4] = new SelfTank((2 - this.iPlayerNum) * (this.iRoleChoice - 1) + n4, 2);
        }
        this.enemyTank = new EnemyTank[this.iMaxScreenEnemyNum];
        for (n4 = 0; n4 < this.iMaxScreenEnemyNum; ++n4) {
            this.enemyTank[n4] = new EnemyTank(3, 1);
        }
        EnemyTank.passSetParameter(this.iDegree, this.iMaxScreenEnemyNum, this.iCollidesChoice);
        MySprite.gameToInit(this.layerX, this.layerY, this.width, this.height, this.iPlayerChoice, this.iPlayerNum);
        for (n4 = 0; n4 < this.iPlayerNum; ++n4) {
            this.selfTank[n4].gameInit(n + 1, n2, n3, nArray);
        }
        this.bGameOver = false;
    }

    public void levelInit() {
        int n;
        this.g.setColor(255, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("STAGE   " + iLevel, this.width / 2, this.height / 2, 33);
        this.flushGraphics();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.is = this.getClass().getResourceAsStream("/" + iLevel + ".dat");
        this.dis = new DataInputStream(this.is);
        MySprite.mapInit(this.dis);
        try {
            this.dis.close();
            this.is.close();
        }
        catch (Exception exception) {
            System.out.println("inputstream close failed");
        }
        this.dis = null;
        this.is = null;
        System.gc();
        Tank.levelStaticInit();
        EnemyTank.levelStaticInit(iLevel);
        for (n = 0; n < this.iPlayerNum; ++n) {
            this.selfTank[n].levelInit();
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            this.enemyTank[n].levelInit();
        }
        this.bPassLevel = false;
        this.g.translate(this.layerX, this.layerY);
        n = this.width / 2;
        while (n >= 0) {
            this.draw();
            this.g.setColor(255, 255, 255);
            this.g.fillRect(-this.layerX, -this.layerY, n, this.height);
            this.g.fillRect(this.width - n, -this.layerY, n, this.height);
            n -= 10;
            this.flushGraphics();
            System.gc();
            try {
                Thread.sleep(70L);
            }
            catch (Exception exception) {}
        }
    }

    public void input() {
        int n = this.getKeyStates();
        n = this.getKeyStates();
        if (!this.menuKeyFired && !this.shopKeyFired) {
            this.selfTank[this.iPlayerChoice - 1].action(n, iSystemTime);
        }
        if (this.iPlayerNum > 1) {
            this.blueTooth.startSend();
            this.selfTank[this.iPlayerChoice - 1].sendData();
            this.blueTooth.overSend();
        }
        if (this.iPlayerNum > 1) {
            this.blueTooth.startReceive();
            int n2 = this.blueTooth.getIntElement();
            int n3 = this.blueTooth.getIntElement();
            int n4 = this.blueTooth.getIntElement();
            int n5 = this.blueTooth.getIntElement();
            int n6 = this.blueTooth.getIntElement();
            int n7 = this.blueTooth.getIntElement();
            this.selfTank[2 - this.iPlayerChoice].action(n2, n3, n4, n5, n6, n7);
        }
    }

    public void enemyAction() {
        for (int i = 0; i < this.iMaxScreenEnemyNum; ++i) {
            this.enemyTank[i].action(iSystemTime);
        }
    }

    public void sceneUpdate() {
        int n;
        for (n = 0; n < this.iPlayerNum; ++n) {
            this.selfTank[n].sceneUpdate();
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            this.enemyTank[n].sceneUpdate();
        }
        if (bFlagExplode && --iFlagExplodeTime <= 0) {
            bFlagExplode = false;
        }
        if (bItemScoreAppeared && --iItemScoreAppearedTime <= 0) {
            bItemScoreAppeared = false;
        }
        Tank.flagAroundUpdate();
        if (!this.bGameOver && this.ifGameOver()) {
            this.bGameOver = true;
            this.setWaitTime();
        }
        if (!this.bPassLevel && EnemyTank.ifPassLevel()) {
            this.bPassLevel = true;
            this.setWaitTime();
        }
        if (this.bGameOver || this.bPassLevel) {
            --this.iWaitTime;
            if (this.iWaitTime <= 0) {
                this.runResult();
            }
        }
    }

    public void setWaitTime() {
        this.iWaitTime = 50;
    }

    public boolean ifGameOver() {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.iPlayerNum; ++i) {
            if (!this.selfTank[i].ifGameOver()) continue;
            ++n;
        }
        if (n > this.iPlayerNum - 1) {
            bl = true;
        }
        if (MySprite.isFlagDestroyed()) {
            bl = true;
        }
        return bl;
    }

    public void pauseAllEnemy() {
        for (int i = 0; i < this.iMaxScreenEnemyNum; ++i) {
            this.enemyTank[i].setPause(250);
        }
    }

    public void bombAllEnemy() {
        for (int i = 0; i < this.iMaxScreenEnemyNum; ++i) {
            this.enemyTank[i].setBomb();
        }
    }

    public void killOneEnemy(int n, int n2) {
        this.selfTank[(this.iPlayerNum - 1) * n].killOneEnemy(n2);
    }

    public void enemyCollidesItem(int n) {
        switch (n) {
            case 1: 
            case 4: {
                for (int i = 0; i < this.iMaxScreenEnemyNum; ++i) {
                    this.enemyTank[i].collidesLife();
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.iMaxScreenEnemyNum; ++i) {
                    this.enemyTank[i].collidesStar();
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.iPlayerNum; ++i) {
                    this.selfTank[i].setPause(200);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.iPlayerNum; ++i) {
                    this.selfTank[i].setBomb();
                }
                break;
            }
        }
    }

    public void flagToExplode() {
        bFlagExplode = true;
        iFlagExplodeTime = 5;
        for (int i = 0; i < this.iPlayerNum; ++i) {
            this.selfTank[i].setEnergyValue(0);
        }
    }

    public void itemScoreAppear() {
        bItemScoreAppeared = true;
        iItemScoreAppearedTime = 5;
    }

    public boolean ifTankCollidesTank(Tank tank) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.iPlayerNum; ++n) {
            if (!tank.collidesWith(this.selfTank[n]) || this.selfTank[n].isAvoidCollides() && tank.isAvoidCollides()) continue;
            ++n2;
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            if (!tank.collidesWith(this.enemyTank[n]) || this.enemyTank[n].isAvoidCollides() && tank.isAvoidCollides()) continue;
            ++n2;
        }
        return n2 > 0;
    }

    public boolean ifBulletCollidesTank(Bullet bullet) {
        int n;
        for (n = 0; n < this.iPlayerNum; ++n) {
            if (!this.selfTank[n].ifCollidesBullet(bullet)) continue;
            return true;
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            if (!this.enemyTank[n].ifCollidesBullet(bullet)) continue;
            return true;
        }
        return false;
    }

    public boolean ifBulletCollidesBullet(Bullet bullet) {
        int n;
        for (n = 0; n < this.iPlayerNum; ++n) {
            if (!this.selfTank[n].ifBulletCollidesBullet(bullet)) continue;
            return true;
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            if (!this.enemyTank[n].ifBulletCollidesBullet(bullet)) continue;
            return true;
        }
        return false;
    }

    public boolean ifAvoidCollides(Tank tank) {
        int n;
        for (n = 0; n < this.iPlayerNum; ++n) {
            if (!tank.collidesWith(this.selfTank[n])) continue;
            this.selfTank[n].setAvoidCollides(true);
            return true;
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            if (!tank.collidesWith(this.enemyTank[n])) continue;
            this.enemyTank[n].setAvoidCollides(true);
            return true;
        }
        return false;
    }

    public boolean ifCancelAvoidCollides(Tank tank) {
        int n;
        for (n = 0; n < this.iPlayerNum; ++n) {
            if (!tank.collidesWith(this.selfTank[n])) continue;
            return false;
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            if (!tank.collidesWith(this.enemyTank[n])) continue;
            return false;
        }
        return true;
    }

    public void draw() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        this.g.setColor(200, 200, 200);
        this.g.fillRect(-this.layerX, -this.layerY, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.fillRect(0, 0, 208, 208);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u5546\u5e97", -this.layerX, this.layerY + 208, 36);
        this.g.drawString("\u83dc\u5355", this.layerX + 208, this.layerY + 208, 40);
        int n15 = EnemyTank.getMaxNum();
        int n16 = EnemyTank.getKilledNum();
        int n17 = EnemyTank.getScreenNum();
        for (n14 = 0; n14 < n15 - n16 - n17; ++n14) {
            n13 = n14 % 2 * 8 + 208;
            n12 = n14 / 2 * 8;
            this.g.setClip(n13, n12, 7, 7);
            this.g.drawImage(this.itemImage, n13 - 64, n12 - 24, 0);
        }
        this.g.setClip(-this.layerX, -this.layerY, this.width, this.height);
        n14 = 10;
        n13 = this.font.getHeight();
        n12 = n14 * 4 + n13 * 5 + 16;
        int n18 = (208 - n12) / 2;
        int n19 = (n13 + n14) * 2;
        int n20 = -16;
        for (n11 = 0; n11 < this.iPlayerNum; ++n11) {
            n10 = this.selfTank[n11].getSide();
            n9 = n18 + n10 * n19 + n13 + n14;
            this.g.setColor(0, 0, 0);
            this.g.drawString(n10 + 1 + "P", n20, n9 - n14 - n13, 0);
            this.drawSelfSmallTank(n20, n9);
            this.g.setClip(-this.layerX, -this.layerY, this.width, this.height);
            this.g.setColor(0, 0, 0);
            n8 = this.selfTank[n11].getLife();
            this.g.drawString("" + n8, n20 + 8, n9 - 3, 0);
        }
        n11 = -16;
        n10 = n18 + n19 * 2;
        this.drawRedFlag(n11, n10);
        this.g.setClip(-this.layerX, -this.layerY, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("" + iLevel, n11, n10 + 16, 0);
        n9 = 96;
        n8 = 192;
        this.g.setClip(n9, n8, 16, 16);
        if (!MySprite.isFlagDestroyed()) {
            this.g.drawImage(this.itemImage, n9 - 48, n8, 0);
        } else {
            this.g.drawImage(this.itemImage, n9 - 64, n8, 0);
        }
        this.g.setClip(-this.layerX, -this.layerY, this.width, this.height);
        if (bFlagExplode) {
            switch (iFlagExplodeTime) {
                case 1: 
                case 4: {
                    MySprite.drawBulletExplode(this.g, 96, 192);
                    break;
                }
                case 2: 
                case 3: {
                    MySprite.drawTankExplode(this.g, 96, 192);
                }
            }
        }
        if (bItemScoreAppeared) {
            n7 = Tank.getItemX();
            n6 = Tank.getItemY();
            this.g.setColor(255, 255, 255);
            this.g.drawString("500", n7, n6, 0);
        }
        MySprite.drawTiledLayerExceptGrass(this.g);
        for (n7 = 0; n7 < this.iPlayerNum; ++n7) {
            this.selfTank[n7].paint(this.g, iSystemTime);
        }
        for (n7 = 0; n7 < this.iMaxScreenEnemyNum; ++n7) {
            this.enemyTank[n7].paint(this.g);
        }
        MySprite.drawGrass(this.g);
        if (Tank.isItemAppeared() && iSystemTime % 4 < 3) {
            n7 = Tank.getItemX();
            n6 = Tank.getItemY();
            n5 = Tank.getItemStyle();
            this.g.setClip(n7, n6, 16, 16);
            n4 = (n5 - 1) % 3;
            this.g.drawImage(this.itemImage, n7 - n4 * 16, n6 - n5 / 4 * 16, 0);
            this.g.setClip(-this.layerX, -this.layerY, this.width, this.height);
        }
        if (this.bGameOver) {
            if (this.iWaitTime >= 10) {
                this.drawGameOverWord(this.iWaitTime - 10);
            } else {
                this.drawGameOverWord(0);
            }
        }
        n7 = 10;
        n6 = 2;
        n5 = 80 + n7 * 6;
        n4 = this.layerY - 1;
        int n21 = (208 - n5) / 2;
        int n22 = -this.layerY;
        this.g.setColor(0, 0, 0);
        this.g.drawRect(n21, n22, n5, n4);
        for (n3 = 0; n3 < 5; ++n3) {
            n2 = n21 + n7 * (n3 + 1) + 16 * n3;
            n = n22 + n6;
            this.g.setClip(n2, n, 16, 16);
            this.g.drawImage(this.itemImage, n2 - (n3 + 1) % 3 * 16, n - (n3 + 1) / 3 * 16, 0);
            this.g.setClip(-this.layerX, -this.layerY, this.width, this.height);
            this.g.setColor(0, 0, 0);
            this.g.drawString("" + this.selfTank[this.iPlayerChoice - 1].getItemNum(n3), n2, n22 + n6 * 2 + 16, 0);
        }
        this.g.setColor(0, 0, 0);
        n3 = n21 + n7 * this.iItemChoice + 16 * (this.iItemChoice - 1);
        n2 = n22 + n6 * 3 + 32;
        n = 8;
        this.g.fillTriangle(n3, n2 + n, n3 + 16, n2 + n, n3 + 8, n2);
        int n23 = this.selfTank[this.iPlayerChoice - 1].getEnergyValue();
        int n24 = SelfTank.getMaxEnergyValue();
        int n25 = this.font.getHeight();
        int n26 = 5;
        int n27 = 5;
        int n28 = (208 - n24) / 2;
        int n29 = 208 + n26;
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u80fd\u91cf\u6761:", n28 - n27, 208 + n26, 24);
        this.g.setColor(0, 0, 0);
        this.g.drawRect(n28, n29, n24, n25);
        this.g.setColor(0, 255, 0);
        if (n23 <= n24) {
            this.g.fillRect(n28 + 1, n29 + 1, n23 - 1, n25 - 1);
        } else {
            this.g.fillRect(n28 + 1, n29 + 1, n24 - 1, n25 - 1);
        }
    }

    public void drawRedFlag(int n, int n2) {
        this.g.setClip(n, n2, 16, 16);
        this.g.drawImage(this.itemImage, n - 48, n2 - 16, 0);
    }

    public void drawSelfSmallTank(int n, int n2) {
        this.g.setClip(n, n2, 7, 8);
        this.g.drawImage(this.itemImage, n - 64, n2 - 16, 0);
    }

    public void drawGameOverWord(int n) {
        int n2 = 10;
        this.g.setColor(255, 0, 0);
        this.g.drawString("GAME", 104, 104 + n * 6, 17);
        this.g.drawString("OVER", 104, 104 + n * 6 + n2, 17);
    }

    public void runResult() {
        int n;
        this.iGameState = 30;
        for (int i = 0; i < this.iPlayerNum; ++i) {
            if (this.selfTank[i].getState() != 1) continue;
            this.selfTank[i].addLife();
        }
        this.g.translate(-this.layerX, -this.layerY);
        int[] nArray = new int[this.iPlayerNum];
        int[][] nArray2 = new int[this.iPlayerNum][4];
        int[] nArray3 = new int[this.iPlayerNum];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = 0; n < this.iPlayerNum; ++n) {
            nArray3[n] = -1;
            for (int i = 0; i < 4; ++i) {
                nArray2[n][i] = -1;
            }
        }
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < this.iPlayerNum; ++i) {
                nArray[i] = this.selfTank[i].getKillEnemyNum(n);
            }
            while (this.ifCount(nArray2, nArray, n)) {
                for (int i = 0; i < this.iPlayerNum; ++i) {
                    if (nArray2[i][n] >= nArray[i]) continue;
                    int[] nArray4 = nArray2[i];
                    int n2 = n;
                    nArray4[n2] = nArray4[n2] + 1;
                }
                this.drawResult(nArray2, nArray3);
                this.flushGraphics();
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.iPlayerNum; ++i) {
            nArray3[i] = this.selfTank[i].getTotalKillNum();
        }
        this.drawResult(nArray2, nArray3);
        this.flushGraphics();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nArray = null;
        nArray2 = null;
        nArray3 = null;
        System.gc();
        if (this.bPassLevel) {
            this.g.setColor(255, 255, 255);
            this.g.fillRect(0, 0, this.width, this.height);
            this.iGameState = 5;
            this.is = this.getClass().getResourceAsStream("/" + ++iLevel + ".dat");
            if (this.is == null) {
                this.iGameState = 31;
            }
        } else {
            this.runGameOver();
            this.iGameState = 7;
            this.g.translate(this.layerX, this.layerY);
        }
    }

    public void drawResult(int[][] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.g.setColor(0, 0, 0);
        this.g.fillRect(0, 0, this.width, this.height);
        int n5 = 10;
        int n6 = 10;
        int n7 = this.font.getHeight();
        int n8 = this.font.stringWidth("20");
        int n9 = this.font.stringWidth("PTS");
        int n10 = n7 * 8 + n6 * 7;
        int n11 = (this.height - n10) / 4;
        int n12 = this.width / 2 - 8;
        int n13 = (n6 + n7) * 3 + n11;
        int n14 = n6 - (16 - n7);
        int n15 = n13 + (16 - n7) / 2;
        int n16 = n15 + (n7 + n6) * 4;
        this.g.setColor(255, 255, 255);
        this.g.drawString("STAGE  " + iLevel, this.width / 2, n11, 17);
        for (n4 = 0; n4 < 4; ++n4) {
            n3 = n13 + (n14 + 16) * n4;
            EnemyTank.paint(this.g, 0, n4 * 16, n12, n3, 1);
        }
        for (n4 = 0; n4 < this.iPlayerNum; ++n4) {
            int n17;
            int n18;
            n3 = this.selfTank[n4].getSide();
            n2 = 0;
            n2 = n3 == 0 ? 24 : 20;
            n = (n3 * 2 - 1) * (n5 + 8) + this.width / 2;
            int n19 = this.width / 2 + (n3 * 2 - 1) * (n5 * 2 + 8 + n8);
            int n20 = this.width / 2 + (n3 * 2 - 1) * (n5 * 3 + n9 + n8 + 8);
            for (n18 = 0; n18 < 4; ++n18) {
                n17 = n15 + (n7 + n6) * n18;
                if (nArray[n4][n18] >= 0) {
                    this.g.setColor(255, 255, 255);
                    this.g.drawString("" + nArray[n4][n18], n, n17, n2);
                    this.g.drawString("" + nArray[n4][n18] * (n18 + 1) * 100, n20, n17, n2);
                }
                this.g.drawString("PTS", n19, n17, n2);
            }
            n18 = this.width / 2 + (n3 * 2 - 1) * (8 + n5 * 2 + n8);
            n17 = n15 - n6 - n7;
            this.g.setColor(255, 255, 0);
            this.g.drawString("" + this.selfTank[n4].getScore(), n18, n17, n2);
            this.g.setColor(255, 0, 0);
            this.g.drawString("" + (n3 + 1) + "-PLAYER", n18, n17 - n6 - n7, n2);
            if (nArray2[n4] < 0) continue;
            this.g.setColor(255, 255, 255);
            this.g.drawString("" + nArray2[n4], n, n16, n2);
        }
        n4 = this.width / 2 - 8 - n5 * 2 - n8;
        this.g.setColor(255, 255, 255);
        this.g.drawString("TOTAL", n4, n16, 24);
        n3 = (n8 + n5) * 2 + 16;
        n2 = 3;
        n = n16 - n2;
        this.g.setColor(255, 255, 255);
        this.g.fillRect((this.width - n3) / 2, n, n3, n2);
    }

    public boolean ifCount(int[][] nArray, int[] nArray2, int n) {
        int n2 = 0;
        for (int i = 0; i < this.iPlayerNum; ++i) {
            if (nArray[i][n] >= nArray2[i]) continue;
            ++n2;
        }
        return n2 > 0;
    }

    public void runGameOver() {
        this.loadMainMenuImage();
        this.g.setColor(0, 0, 0);
        this.g.fillRect(0, 0, this.width, this.height);
        int n = 10;
        int n2 = (this.width - 116) / 2;
        int n3 = this.height / 2 - 29 - n;
        this.g.setClip(n2, n3, 116, 29);
        this.g.drawImage(this.menuImage, n2, n3, 0);
        int n4 = this.height / 2 + n;
        this.g.setClip(n2, n4, 116, 29);
        this.g.drawImage(this.menuImage, n2, n4 - 29, 0);
        this.flushGraphics();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void memoryRecycle() {
        int n;
        for (n = 0; n < this.iPlayerNum; ++n) {
            this.selfTank[n] = null;
        }
        for (n = 0; n < this.iMaxScreenEnemyNum; ++n) {
            this.enemyTank[n] = null;
        }
        System.gc();
    }

    public void menuToGame() {
        this.menuKeyFired = false;
        this.iGameState = 6;
    }

    public void runSave() {
        this.iGameState = 11;
        this.g.translate(-this.layerX, -this.layerY);
        int[][] nArray = new int[2][4];
        this.showRecord(nArray);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.getKeyStates();
        int n2 = 2;
        this.recordChoice = 1;
        while (this.iGameState == 11) {
            n = this.getKeyStates();
            if ((n & 2) != 0) {
                if (!bl) {
                    this.recordChoice += (n2 + 1 - this.recordChoice) / n2 * n2 - 1;
                    bl = true;
                }
            } else if (bl) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                if (!bl2) {
                    this.recordChoice += 1 - this.recordChoice / n2 * n2;
                    bl2 = true;
                }
            } else if (bl2) {
                bl2 = false;
            }
            if ((n & 0x100) != 0) {
                if (!bl3) {
                    this.makeSureIfSave(this.recordChoice, nArray);
                    bl3 = true;
                }
            } else if (bl3) {
                bl3 = false;
            }
            this.drawRecord(this.recordChoice, nArray);
            this.flushGraphics();
            if (this.iPlayerNum > 1) {
                this.gameUpdate();
                try {
                    Thread.sleep(40L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.gc();
        }
    }

    public void drawRecordBack() {
        this.g.setColor(0, 255, 255);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(0, 0, 0);
        this.g.drawString("\u8fd4\u56de", this.width, this.height, 40);
    }

    public void showRecord(int[][] nArray) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)"myStore", (boolean)true);
        }
        catch (Exception exception) {
            System.out.println("open store failed");
        }
        for (int i = 1; i <= 2; ++i) {
            if (!this.ifRecordExist(i)) continue;
            try {
                byte[] byArray = this.recordStore.getRecord(i);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.dis = new DataInputStream(byteArrayInputStream);
            }
            catch (Exception exception) {
                System.out.println("get record failed");
            }
            try {
                for (int j = 0; j < nArray[0].length; ++j) {
                    nArray[i - 1][j] = this.dis.readInt();
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("read num failed");
            }
        }
    }

    public boolean ifRecordExist(int n) {
        boolean bl = true;
        try {
            byte[] byArray = this.recordStore.getRecord(n);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void makeSureIfSave(int n, int[][] nArray) {
        this.iGameState = 12;
        String string = "";
        string = nArray[n - 1][0] > 0 ? "\u786e\u8ba4\u8986\u76d6\u5b58\u6863" : "\u786e\u8ba4\u5b58\u6863";
        int n2 = this.font.stringWidth(string);
        int n3 = (this.width - n2) / 2;
        int n4 = this.height / 2;
        this.g.setColor(0, 255, 0);
        this.g.fillRect(n3, n4, n2, this.font.getHeight());
        this.g.setColor(0, 0, 0);
        this.g.drawString(string, n3, n4, 0);
        String[] stringArray = new String[]{"\u662f", "\u5426"};
        int n5 = 10;
        this.runStandardMenu(this.iGameState, 0, 255, 0, n3, n4 + this.font.getHeight(), stringArray, 2, n5, 0, 0, 0, 50, 255, 255, 0);
        this.showRecord(nArray);
    }

    public void drawRecord(int n, int[][] nArray) {
        this.drawRecordBack();
        int n2 = 30;
        int n3 = 20;
        int n4 = this.font.stringWidth("20");
        int n5 = n4 * 2 + 40 + (n3 + n2) * 2;
        int n6 = 50;
        int n7 = (this.width - n5) / 2;
        int n8 = this.height / 2 - n6;
        int n9 = this.font.getHeight();
        this.g.setColor(255, 255, 255);
        this.g.fillRect(n7, n8, n5, n6 * 2);
        this.g.setColor(255, 0, 255);
        this.g.fillRect(n7, n8 + (n - 1) * n6, n5, n6);
        for (int i = 0; i < 2; ++i) {
            if (nArray[i][0] <= 0) continue;
            int n10 = n8 + i * n6 + n6 / 2;
            int n11 = n10 - n9 / 2;
            int n12 = n7 + n3;
            this.drawRedFlag(n12, n10 - 8);
            this.g.setClip(0, 0, this.width, this.height);
            this.g.setColor(0, 0, 0);
            this.g.drawString("" + nArray[i][0], n12 + 16, n11, 0);
            int n13 = n12 + 16 + n4 + n2;
            SelfTank.paint(this.g, nArray[i][1] * 16, (nArray[i][2] - 1) * 16, n13, n10 - 8, 1);
            int n14 = n13 + 16 + n2;
            this.drawSelfSmallTank(n14, n10 - 4);
            this.g.setClip(0, 0, this.width, this.height);
            this.g.setColor(0, 0, 0);
            this.g.drawString("" + nArray[i][3], n14 + 8, n11, 0);
        }
    }

    public void save() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(iLevel);
            dataOutputStream.writeInt(this.selfTank[0].getLevel());
            dataOutputStream.writeInt(this.iRoleChoice);
            dataOutputStream.writeInt(this.selfTank[0].getLife());
            dataOutputStream.writeInt(this.selfTank[0].getScore());
            for (int i = 0; i < 5; ++i) {
                dataOutputStream.writeInt(this.selfTank[0].getItemNum(i));
            }
            dataOutputStream.writeInt(this.iDegree);
            dataOutputStream.writeInt(this.iMaxScreenEnemyNum);
            dataOutputStream.writeInt(this.iCollidesChoice);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.ifRecordExist(this.recordChoice)) {
                this.recordStore.setRecord(this.recordChoice, byArray, 0, byArray.length);
            } else {
                this.recordStore.addRecord(byArray, 0, byArray.length);
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("save failed");
        }
    }

    public void runLoad() {
        this.iGameState = 13;
        int[][] nArray = new int[2][4];
        this.showRecord(nArray);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.getKeyStates();
        int n2 = 2;
        this.recordChoice = 1;
        while (this.iGameState == 13) {
            n = this.getKeyStates();
            if ((n & 2) != 0) {
                if (!bl) {
                    this.recordChoice += (n2 + 1 - this.recordChoice) / n2 * n2 - 1;
                    bl = true;
                }
            } else if (bl) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                if (!bl2) {
                    this.recordChoice += 1 - this.recordChoice / n2 * n2;
                    bl2 = true;
                }
            } else if (bl2) {
                bl2 = false;
            }
            if ((n & 0x100) != 0) {
                if (!bl3) {
                    this.makeSureIfLoad(this.recordChoice, nArray);
                    bl3 = true;
                }
            } else if (bl3) {
                bl3 = false;
            }
            this.drawRecord(this.recordChoice, nArray);
            this.flushGraphics();
        }
    }

    public void makeSureIfLoad(int n, int[][] nArray) {
        this.iGameState = 14;
        String string = "";
        if (nArray[n - 1][0] > 0) {
            string = "\u786e\u8ba4\u8bfb\u6863";
            int n2 = this.font.stringWidth(string);
            int n3 = (this.width - n2) / 2;
            int n4 = this.height / 2;
            this.g.setColor(0, 255, 0);
            this.g.fillRect(n3, n4, n2, this.font.getHeight());
            this.g.setColor(0, 0, 0);
            this.g.drawString(string, n3, n4, 0);
            String[] stringArray = new String[]{"\u662f", "\u5426"};
            int n5 = 10;
            this.runStandardMenu(this.iGameState, 0, 255, 0, n3, n4 + this.font.getHeight(), stringArray, 2, n5, 0, 0, 0, 50, 255, 255, 0);
        } else {
            this.iGameState = 13;
        }
    }

    public void load() {
        try {
            byte[] byArray = this.recordStore.getRecord(this.recordChoice);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.dis = new DataInputStream(byteArrayInputStream);
            iLevel = this.dis.readInt();
            int n = this.dis.readInt();
            this.iRoleChoice = this.dis.readInt();
            int n2 = this.dis.readInt();
            int n3 = this.dis.readInt();
            int[] nArray = new int[5];
            for (int i = 0; i < 5; ++i) {
                nArray[i] = this.dis.readInt();
            }
            this.iDegree = this.dis.readInt();
            this.iMaxScreenEnemyNum = this.dis.readInt();
            this.iCollidesChoice = this.dis.readInt();
            this.gameInit(n2, n, n3, nArray);
            this.dis.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("load failed");
        }
    }

    public void showCanNotRecord() {
        this.iGameState = 10;
        String string = "";
        if (this.iPlayerNum != 1) {
            string = "\u53cc\u4eba\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u5b58\u6863";
        }
        if (this.ifGameOver()) {
            string = "\u6e38\u620f\u7ed3\u675f\u65e0\u6cd5\u5b58\u6863";
        }
        int n = this.font.stringWidth(string);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.getKeyStates();
        while (this.iGameState == 10) {
            n2 = this.getKeyStates();
            if (n2 != 0) {
                this.returnToMenu();
                break;
            }
            if (this.iPlayerNum > 1) {
                this.gameUpdate();
                this.draw();
                String[] stringArray = new String[]{"\u8fd4\u56de\u6e38\u620f", "\u4fdd\u5b58\u6e38\u620f", "\u8fd4\u56de\u6807\u9898"};
                int n3 = this.font.stringWidth("\u8fd4\u56de\u6e38\u620f");
                int n4 = 10;
                int n5 = (208 - n3) / 2 - n4;
                int n6 = (208 - this.font.getHeight() * stringArray.length - n4 * (stringArray.length + 1)) / 2;
                this.drawStandardMenu(0, 255, 255, n5, n6, stringArray, stringArray.length, n4, 0, 0, 0, n3, 255, 255, 255, 2);
                System.gc();
            }
            this.g.setColor(0, 255, 0);
            this.g.fillRect((208 - n) / 2, 104, n, this.font.getHeight());
            this.g.setColor(0, 0, 0);
            this.g.drawString(string, (208 - n) / 2, 104, 0);
            this.flushGraphics();
            if (this.iPlayerNum <= 1) continue;
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {}
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void makeSureIfReturn() {
        this.iGameState = 9;
        int n = this.getKeyStates();
        boolean bl = true;
        while (this.iGameState == 9) {
            n = this.getKeyStates();
            if ((n & 0x100) != 0) {
                if (!bl) {
                    this.returnToMainMenu();
                }
            } else if (bl) {
                bl = false;
            }
            if (this.iPlayerNum > 1) {
                this.gameUpdate();
                this.draw();
                String[] stringArray = new String[]{"\u8fd4\u56de\u6e38\u620f", "\u4fdd\u5b58\u6e38\u620f", "\u8fd4\u56de\u6807\u9898"};
                int n2 = this.font.stringWidth("\u8fd4\u56de\u6e38\u620f");
                int n3 = 10;
                int n4 = (208 - n2) / 2 - n3;
                int n5 = (208 - this.font.getHeight() * stringArray.length - n3 * (stringArray.length + 1)) / 2;
                this.drawStandardMenu(0, 255, 255, n4, n5, stringArray, stringArray.length, n3, 0, 0, 0, n2, 255, 255, 255, 3);
                System.gc();
                try {
                    Thread.sleep(40L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.g.setColor(0, 0, 0);
            this.g.drawString("\u662f", 0, 208, 20);
            this.g.drawString("\u5426", 208, 208, 24);
            this.flushGraphics();
        }
        if (this.iGameState == 8) {
            this.draw();
        }
    }

    public void returnToMenu() {
        this.iGameState = 8;
        this.draw();
    }

    public void returnToMainMenu() {
        this.iGameState = 7;
        this.menuKeyFired = false;
    }

    public void keyPressed(int n) {
        if (this.iGameState == 6 && this.selfTank[this.iPlayerChoice - 1].getState() == 1) {
            switch (n) {
                case 49: {
                    this.iItemChoice += (6 - this.iItemChoice) / 5 * 5 - 1;
                    break;
                }
                case 51: {
                    this.iItemChoice += 1 - this.iItemChoice / 5 * 5;
                }
            }
        }
        if (n == this.rightSoftKey) {
            switch (this.iGameState) {
                case 2: {
                    this.iGameState = 1;
                    break;
                }
                case 3: {
                    if (this.iPlayerNum == 1) {
                        this.iGameState = 2;
                        break;
                    }
                    this.iGameState = 1;
                    break;
                }
                case 4: {
                    this.iGameState = 3;
                    break;
                }
                case 6: {
                    this.menuKeyFired = true;
                    break;
                }
                case 8: {
                    this.menuToGame();
                    break;
                }
                case 9: {
                    this.iGameState = 8;
                    break;
                }
                case 10: {
                    this.returnToMenu();
                    break;
                }
                case 11: {
                    this.g.translate(this.layerX, this.layerY);
                    this.returnToMenu();
                    break;
                }
                case 13: {
                    this.iGameState = 2;
                    break;
                }
                case 15: {
                    this.shopToGame();
                    break;
                }
                case 18: {
                    this.blueTooth.cancelSearchClient();
                    break;
                }
                case 19: {
                    this.blueTooth.cancelSearchServer();
                    break;
                }
                case 20: 
                case 21: {
                    this.iGameState = 1;
                    break;
                }
                case 22: {
                    this.iGameState = 3;
                    break;
                }
                case 23: {
                    this.iGameState = 4;
                    break;
                }
                case 25: {
                    this.iGameState = 3;
                    break;
                }
                case 26: {
                    this.iGameState = 1;
                }
            }
        } else if (n == this.leftSoftKey) {
            switch (this.iGameState) {
                case 4: {
                    if (this.iPlayerNum < 2) {
                        this.iGameState = 5;
                        break;
                    }
                    this.iGameState = 18;
                    break;
                }
                case 6: {
                    if (this.bGameOver) break;
                    this.shopKeyFired = true;
                    break;
                }
                case 9: {
                    this.returnToMainMenu();
                    break;
                }
                case 10: {
                    this.returnToMenu();
                    break;
                }
                case 22: {
                    this.iGameState = 19;
                    break;
                }
                case 23: {
                    this.iGameState = 18;
                    break;
                }
                case 26: {
                    this.iGameState = 3;
                }
            }
        }
    }

    protected void hideNotify() {
        if (this.iGameState == 6 && this.iPlayerNum > 1) {
            this.menuKeyFired = true;
            this.bInterrupt = true;
        }
    }

    protected void showNotify() {
        if (this.iGameState == 8 && this.bInterrupt && this.iPlayerNum > 1) {
            this.menuToGame();
            this.bInterrupt = false;
        }
    }
}

