/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI;

import CWA2DAPI.CWAInputGlobal;
import CWA2DAPI.CWAInputListener;

public abstract class CWAInput
implements CWAInputListener,
CWAInputGlobal {
    protected boolean onListen;
    private CWAInputListener _listener;
    private int _keyState;
    private int _keyDownState;
    private int _keyUpState;
    private int _curKeyState;
    private int _curKeyDownState;
    private int _curKeyUpState;
    public int pointX = -1;
    public int pointY = -1;
    private int pointX2 = -1;
    private int pointY2 = -1;
    public int pointY3 = 0;
    public int pointX3 = 0;

    public int getKeyValue(int key) {
        switch (key) {
            case 48: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 42: {
                return 1024;
            }
            case 35: {
                return 2048;
            }
            case -1: {
                return 4096;
            }
            case -2: {
                return 8192;
            }
            case -3: {
                return 16384;
            }
            case -4: {
                return 32768;
            }
            case -5: {
                return 65536;
            }
            case -21: 
            case -6: {
                return 131072;
            }
            case -22: 
            case -7: {
                return 262144;
            }
        }
        return 0;
    }

    public boolean isKeyDown(int key) {
        return (this._curKeyDownState & key) != 0;
    }

    public boolean isPointerDown(int x, int y, int w, int h) {
        if (this.pointX < x || this.pointX > x + w || this.pointY < y || this.pointY > y + h) {
            return false;
        }
        this.pointY3 = this.pointY;
        this.pointX3 = this.pointX;
        this.pointX = -1;
        this.pointY = -1;
        return true;
    }

    public boolean isKeyUp(int key) {
        return (this._curKeyUpState & key) != 0;
    }

    public boolean isPointerUp() {
        return this.pointX2 == -1 && this.pointY2 == -1;
    }

    public boolean isKeyHold(int key) {
        return (this._curKeyState & key) != 0;
    }

    protected boolean isPointerHold(int x, int y, int w, int h) {
        return this.pointX2 >= x && this.pointX2 <= x + w && this.pointY2 >= y && this.pointY2 <= y + h;
    }

    public void clearKey() {
        this._keyState = 0;
        this._keyDownState = 0;
        this._keyUpState = 0;
        this._curKeyState = 0;
        this._curKeyDownState = 0;
        this._curKeyUpState = 0;
        if (this._listener != null) {
            this._listener.clearKey();
        }
    }

    protected void keyStateDestroy() {
        this._keyState = 0;
        this._keyDownState = 0;
        this._keyUpState = 0;
    }

    protected void getKey() {
        this._curKeyState = this._keyState;
        this._curKeyDownState = this._keyDownState;
        this._curKeyUpState = this._keyUpState;
        this._keyDownState = 0;
        this._keyUpState = 0;
    }

    public void keyPressed(int key) {
        int code = this.getKeyValue(key);
        this._keyDownState |= code;
        this._keyState |= code;
        if (this._listener != null) {
            this._listener.keyPressed(key);
        }
    }

    public void keyReleased(int key) {
        int code = this.getKeyValue(key);
        this._keyUpState |= code;
        this._keyState &= ~code;
        if (this._listener != null) {
            this._listener.keyReleased(key);
        }
    }

    public void pointerPressed(int x, int y) {
        this.pointX2 = x;
        this.pointY2 = y;
        if (this._listener != null) {
            this._listener.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        this.pointX = x;
        this.pointY = y;
        this.pointX2 = -1;
        this.pointY2 = -1;
        if (this._listener != null) {
            this._listener.pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._listener != null) {
            this._listener.pointerDragged(x, y);
        }
    }

    public void onListen(boolean on) {
        this.clearKey();
        this.onListen = on;
    }

    protected void setListener(CWAInputListener listener) {
        if (this._listener != null) {
            this._listener.onListen(false);
            this._listener = null;
        }
        if (listener != null) {
            listener.onListen(true);
            this._listener = listener;
        }
    }

    public void setKey(int k) {
        this._curKeyDownState = k;
    }

    public int getPointX() {
        return this.pointX;
    }

    public int getPointY() {
        return this.pointY;
    }
}

