/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI;

import CWA2DAPI.CWACommon;
import CWA2DAPI.DrawStringInfo;
import CWA2DAPI.cwaEX.CWADebug;
import CWAUI.CWAUIContainer;
import CWAUI.CWAUIFonts;
import CWAUI.CWAUIIBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CWATools {
    private static int cyc_times = 5;
    private static int num_max = 300;
    private static int[] search = null;
    private static Random rd;
    public static int[][] tempData1;
    private static int[] crc_table;
    public static int[] color;
    static DrawStringInfo info;
    static char[] splitChar;
    public static int pageLine;
    public static int totalLine;
    public static String[] lineArray;
    public static int heGap;
    public static int curPage;
    public static int prePage;
    public static String strP;

    public static int byte2int(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static byte[] int2byte(int n) {
        byte[] b = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return b;
    }

    public static short byte2short(byte[] b) {
        return (short)(b[1] & 0xFF | (b[0] & 0xFF) << 8);
    }

    public static byte[] short2byte(short n) {
        byte[] b = new byte[]{(byte)(n >> 8), (byte)n};
        return b;
    }

    public static int getSub(int[] count, int start, int length) {
        int temp = 0;
        for (int i = 0; i < length; ++i) {
            temp += count[start + i];
        }
        return temp;
    }

    public static short[] arrayAppend(short[] src, short[] add) {
        int pos = 0;
        if (src != null) {
            pos = src.length;
        }
        short[] temp = new short[pos + add.length];
        if (src != null) {
            System.arraycopy(src, 0, temp, 0, src.length);
        }
        System.arraycopy(add, 0, temp, pos, add.length);
        return temp;
    }

    public static void getStream(byte[] obj, String name, int skip) {
        try {
            InputStream input = name.substring(0, 1).endsWith("/") ? new Object().getClass().getResourceAsStream(name) : new Object().getClass().getResourceAsStream("/" + name);
            DataInputStream dinput = new DataInputStream(input);
            dinput.skip(skip);
            dinput.read(obj, 0, obj.length);
            dinput.close();
        }
        catch (Exception e) {
            System.out.println("GameInf err at getStream()  :  " + e);
        }
    }

    public static short[] loadInfShort(byte[] inf, short[] des, int[] position) {
        short length1 = CWATools.loadInfShort(inf, position);
        short singleDataLength = CWATools.loadInfShort(inf, position);
        if (length1 == 0) {
            return null;
        }
        des = new short[length1 * singleDataLength];
        for (int i = 0; i < des.length; ++i) {
            byte a0 = inf[position[0]];
            position[0] = position[0] + 1;
            byte a1 = inf[position[0]];
            position[0] = position[0] + 1;
            des[i] = (short)(a0 << 8 | a1 & 0xFF);
        }
        return des;
    }

    public static short[][] loadInfShort(byte[] inf, short[][] des, int[] position) {
        int length1 = CWATools.loadInfShort(inf, position);
        short singleDataLength = CWATools.loadInfShort(inf, position);
        if (length1 == 0) {
            return null;
        }
        des = new short[length1][];
        for (int i = 0; i < length1; ++i) {
            short length2 = CWATools.loadInfShort(inf, position);
            des[i] = new short[length2 * singleDataLength];
            for (int j = 0; j < des[i].length; ++j) {
                byte a0 = inf[position[0]];
                position[0] = position[0] + 1;
                byte a1 = inf[position[0]];
                position[0] = position[0] + 1;
                des[i][j] = (short)(a0 << 8 | a1 & 0xFF);
            }
        }
        return des;
    }

    public static short loadInfShort(byte[] inf, int[] position) {
        int n = position[0];
        position[0] = n + 1;
        int n2 = position[0];
        position[0] = n2 + 1;
        return (short)((inf[n] & 0xFF) << 8 | inf[n2] & 0xFF);
    }

    public static InputStream getInputStream(String fileName) {
        try {
            return "".getClass().getResourceAsStream(fileName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[][] getInt2DArray(InputStream is) {
        short t = 0;
        Object rtn = null;
        try {
            if (is == null) {
                return rtn;
            }
            DataInputStream dis = new DataInputStream(is);
            t = dis.readShort();
            if (t >= 0) {
                rtn = new int[t][];
            }
            for (int i = 0; i < ((int[][])rtn).length; ++i) {
                t = dis.readShort();
                rtn[i] = new int[t];
                for (int j = 0; j < rtn[i].length; ++j) {
                    rtn[i][j] = dis.readInt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static short[][] getShort2DArray(InputStream is) {
        short t = 0;
        Object rtn = null;
        try {
            if (is == null) {
                return rtn;
            }
            DataInputStream dis = new DataInputStream(is);
            t = dis.readShort();
            if (t >= 0) {
                rtn = new short[t][];
            }
            for (int i = 0; i < ((short[][])rtn).length; ++i) {
                t = dis.readShort();
                rtn[i] = new short[t];
                for (int j = 0; j < rtn[i].length; ++j) {
                    rtn[i][j] = dis.readShort();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static byte[][] getByte2DArray(InputStream is) {
        short t = 0;
        Object rtn = null;
        try {
            if (is == null) {
                return rtn;
            }
            DataInputStream dis = new DataInputStream(is);
            t = dis.readShort();
            if (t >= 0) {
                rtn = new byte[t][];
            }
            for (int i = 0; i < ((byte[][])rtn).length; ++i) {
                t = dis.readShort();
                rtn[i] = new byte[t];
                for (int j = 0; j < rtn[i].length; ++j) {
                    rtn[i][j] = dis.readByte();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static String[][] get2DStrings(InputStream is) {
        String[][] rtn = null;
        StringBuffer strb = new StringBuffer();
        short t = 0;
        int num = 0;
        try {
            DataInputStream dis = new DataInputStream(is);
            t = dis.readShort();
            if (t == 0) {
                return null;
            }
            if (t > 0) {
                rtn = new String[t][];
            }
            for (int m = 0; m < rtn.length; ++m) {
                t = dis.readShort();
                rtn[m] = new String[t];
                for (int j = 0; j < rtn[m].length; ++j) {
                    num = dis.readByte();
                    for (int k = 0; k < num; ++k) {
                        t = dis.readShort();
                        strb.append((char)t);
                    }
                    rtn[m][j] = strb.toString();
                    strb = new StringBuffer();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtn;
    }

    public static int Abs(int tmp) {
        return tmp >= 0 ? tmp : -tmp;
    }

    public static int stance(int x1, int y1, int x2, int y2) {
        int x = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        int y = 0;
        for (int b = 0x40000000; b > 0; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int hypotenuse(int dis_x, int dis_y) {
        int x = dis_x * dis_x + dis_y * dis_y;
        int y = 0;
        for (int b = 0x40000000; b > 0; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int min(int a, int b) {
        return a > b ? b : a;
    }

    public static int max(int a, int b) {
        return a < b ? b : a;
    }

    public static int sqrt(int x) {
        if (x <= 0) {
            return 0;
        }
        int l1 = 2;
        int l2 = 0;
        for (int i = 0; i < 25 && (l2 > (l1 = (l1 + x / l1) / 2) || i == 0); ++i) {
            l2 = l1;
        }
        return l1;
    }

    public static int sqrt(int n, int type) {
        if (search == null) {
            search = new int[num_max / cyc_times + 1];
            int temp = cyc_times * cyc_times;
            for (int i = search.length - 1; i > -1; --i) {
                CWATools.search[i] = i * i * temp;
            }
        }
        int i = 0;
        int j = 0;
        int temp = 0;
        if (n < 0) {
            return -1;
        }
        if (n <= search[30]) {
            if (n <= search[15]) {
                temp = 5;
                if (n <= search[5]) {
                    for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                    }
                } else {
                    temp = 10;
                    if (n <= search[10]) {
                        for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                        }
                    } else {
                        temp = 15;
                        for (i = 15 - 4; i <= temp && n > search[i]; ++i) {
                        }
                    }
                }
            } else {
                temp = 20;
                if (n <= search[20]) {
                    for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                    }
                } else {
                    temp = 25;
                    if (n <= search[25]) {
                        for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                        }
                    } else {
                        temp = 30;
                        for (i = 30 - 4; i <= temp && n > search[i]; ++i) {
                        }
                    }
                }
            }
        } else if (n <= search[45]) {
            temp = 35;
            if (n <= search[35]) {
                for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                }
            } else {
                temp = 40;
                if (n <= search[40]) {
                    for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                    }
                } else {
                    temp = 45;
                    for (i = 45 - 4; i <= temp && n > search[i]; ++i) {
                    }
                }
            }
        } else {
            temp = 50;
            if (n <= search[50]) {
                for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                }
            } else {
                temp = 55;
                if (n <= search[55]) {
                    for (i = temp - 4; i <= temp && n > search[i]; ++i) {
                    }
                } else {
                    temp = 60;
                    for (i = 60 - 4; i <= temp && n > search[i]; ++i) {
                    }
                }
            }
        }
        temp = i * cyc_times;
        for (j = temp - cyc_times + 1; j <= temp; ++j) {
            if (j * j < n) continue;
            if (type == 0) {
                return j;
            }
            if (type != 1) continue;
            return j - 1;
        }
        return -1;
    }

    public static int getInt4Float(int numerator, int denominator) {
        if (numerator < 1 || denominator < 1) {
            throw new IllegalArgumentException();
        }
        return numerator / denominator + (numerator % denominator == 0 ? 0 : 1);
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public static int getRandom(int n) {
        if (rd == null) {
            rd = new Random(CWATools.getTime());
        }
        return (rd.nextInt() >>> 1) % n;
    }

    public static int getUnsigRandom(int n) {
        if (rd == null) {
            rd = new Random(CWATools.getTime());
        }
        return -n + (rd.nextInt() >>> 1) % (2 * n);
    }

    public static int getRandom(int min, int max) {
        if (rd == null) {
            rd = new Random(CWATools.getTime());
        }
        return (rd.nextInt() >>> 1) % (max - min + 1) + min;
    }

    public static int getRandomIndex(int[] array, int randNum) {
        int i = 0;
        for (i = 0; i < array.length && randNum < array[i]; ++i) {
        }
        return i;
    }

    public static boolean isCollide(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2, int trans) {
        if (trans % 2 != 0) {
            int tmp = w1;
            w1 = h1;
            h1 = tmp;
        }
        return x1 + w1 >= x2 && x2 + w2 >= x1 && y1 + h1 > y2 && y2 + h2 > y1;
    }

    public static boolean isCollides(int x1, int y1, int x2, int y2, int w, int h) {
        return x1 >= x2 && x1 <= x2 + w && y1 >= y2 && y1 <= y2 + h;
    }

    public static boolean isCollides(int actorX1, int actorY1, int actorX2, int actorY2, short[] coll1, short[] coll2) {
        return actorX1 + coll1[0] + coll1[2] >= actorX2 + coll2[0] && actorX1 + coll1[0] <= actorX2 + coll2[0] + coll2[2] && actorY1 + coll1[1] <= actorY2 + coll2[1] + coll2[3] && actorY1 + coll1[1] + coll1[3] >= actorY2 + coll2[1];
    }

    public static boolean isCollides(int x1, int y1, int w1, int h1, int x2, int y2, short[] coll2) {
        return x1 + w1 >= x2 + coll2[0] && x1 <= x2 + coll2[0] + coll2[2] && y1 <= y2 + coll2[1] + coll2[3] && y1 + h1 >= y2 + coll2[1];
    }

    public static boolean isCollides(int x1, int y1, int x2, int y2, short[] coll2) {
        return x1 >= x2 + coll2[0] && x1 <= x2 + coll2[0] + coll2[2] && y1 <= y2 + coll2[1] + coll2[3] && y1 >= y2 + coll2[1];
    }

    public static Image loadNormalImg(String folder, String name) {
        Image rImg = null;
        try {
            rImg = Image.createImage((String)(folder + name + ".png"));
        }
        catch (Exception e) {
            CWADebug.setErrorMsg(e, folder + name + ".png error!!");
            return null;
        }
        return rImg;
    }

    public static Image createImage(String folder, String name) {
        Image rImg = null;
        rImg = CWATools.readPngData(folder + name + ".mid");
        return rImg;
    }

    public static Image readPngData(String strName) {
        byte[] pngData = CWATools.readPngToByte(strName);
        return Image.createImage((byte[])pngData, (int)0, (int)pngData.length);
    }

    public static byte[] readPngToByte(String strName) {
        byte[] pngBuffer = null;
        try {
            int j;
            int chunkLength = 0;
            int colorLength = 0;
            int offset = 0;
            byte[] chunkData = null;
            int CRCChecksumIndex = 0;
            InputStream is = "".getClass().getResourceAsStream(strName);
            DataInputStream dis = new DataInputStream(is);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(CWATools.getBytes(-1991225785L, 4));
            out.write(CWATools.getBytes(218765834L, 4));
            offset += 8;
            out.write(CWATools.getBytes(13L, 4));
            out.write(CWATools.getBytes(1229472850L, 4));
            out.write(CWATools.getBytes(dis.readInt(), 4));
            out.write(CWATools.getBytes(dis.readInt(), 4));
            out.write(dis.readByte());
            byte pngType = dis.readByte();
            tempData1 = new int[20][2];
            out.write(pngType);
            out.write(CWATools.getBytes(0L, 3));
            out.write(CWATools.getBytes(0L, 4));
            CWATools.tempData1[CRCChecksumIndex][0] = offset;
            CWATools.tempData1[CRCChecksumIndex][1] = 13;
            offset += tempData1[CRCChecksumIndex][1] + 12;
            ++CRCChecksumIndex;
            if (pngType == 3) {
                chunkLength = dis.readInt();
                out.write(CWATools.getBytes(chunkLength, 4));
                out.write(CWATools.getBytes(1347179589L, 4));
                chunkData = new byte[chunkLength];
                for (j = 0; j < chunkData.length; ++j) {
                    chunkData[j] = (byte)(dis.read() & 0xFF);
                }
                out.write(chunkData);
                out.write(CWATools.getBytes(0L, 4));
                CWATools.tempData1[CRCChecksumIndex][0] = offset;
                CWATools.tempData1[CRCChecksumIndex][1] = chunkLength;
                offset += tempData1[CRCChecksumIndex][1] + 12;
                ++CRCChecksumIndex;
                chunkLength = dis.readInt();
                if (chunkLength == 1951551059) {
                    colorLength = dis.read();
                    if (colorLength == 0) {
                        colorLength = 256;
                    }
                    out.write(CWATools.getBytes(colorLength, 4));
                    out.write(CWATools.getBytes(1951551059L, 4));
                    int lucencyIndex = dis.read();
                    for (int j2 = 0; j2 < colorLength; ++j2) {
                        if (j2 == lucencyIndex) {
                            out.write(0);
                            continue;
                        }
                        out.write(255);
                    }
                    out.write(CWATools.getBytes(0L, 4));
                    CWATools.tempData1[CRCChecksumIndex][0] = offset;
                    CWATools.tempData1[CRCChecksumIndex][1] = colorLength;
                    offset += tempData1[CRCChecksumIndex][1] + 12;
                    ++CRCChecksumIndex;
                    chunkLength = dis.readInt();
                } else {
                    CWATools.tempData1[CRCChecksumIndex][0] = offset;
                    CWATools.tempData1[CRCChecksumIndex][1] = chunkLength;
                    ++CRCChecksumIndex;
                }
            } else if (pngType == 6) {
                chunkLength = dis.readInt();
            }
            out.write(CWATools.getBytes(chunkLength, 4));
            out.write(CWATools.getBytes(1229209940L, 4));
            chunkData = new byte[chunkLength];
            for (j = 0; j < chunkData.length; ++j) {
                chunkData[j] = (byte)(dis.read() & 0xFF);
            }
            out.write(chunkData);
            out.write(CWATools.getBytes(0L, 4));
            CWATools.tempData1[CRCChecksumIndex][0] = offset;
            CWATools.tempData1[CRCChecksumIndex][1] = chunkLength;
            offset += tempData1[CRCChecksumIndex][1] + 12;
            ++CRCChecksumIndex;
            out.write(CWATools.getBytes(0L, 4));
            out.write(CWATools.getBytes(1229278788L, 4));
            out.write(CWATools.getBytes(-1371381630L, 4));
            pngBuffer = out.toByteArray();
            is.close();
            out.close();
            for (int i = 0; i < CRCChecksumIndex; ++i) {
                CWATools.CRCChecksum(pngBuffer, tempData1[i][0], tempData1[i][1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pngBuffer;
    }

    public static byte[] getBytes(long num, int len) {
        byte[] rtn = null;
        rtn = new byte[len];
        int i = len - 1;
        int j = 0;
        while (i >= 0) {
            rtn[j] = (byte)(num >> i * 8 & 0xFFL);
            --i;
            ++j;
        }
        return rtn;
    }

    private static void CRCChecksum(byte[] imgData, int chunkOffset, int chunkLen) {
        int checksum = CWATools.checksum(imgData, chunkOffset + 4, chunkLen + 4);
        imgData[chunkOffset + 8 + chunkLen] = (byte)(checksum >> 24 & 0xFF);
        imgData[chunkOffset + 8 + chunkLen + 1] = (byte)(checksum >> 16 & 0xFF);
        imgData[chunkOffset + 8 + chunkLen + 2] = (byte)(checksum >> 8 & 0xFF);
        imgData[chunkOffset + 8 + chunkLen + 3] = (byte)(checksum & 0xFF);
    }

    private static int checksum(byte[] buf, int off, int len) {
        return ~CWATools.update_crc(buf, off, len);
    }

    private static int update_crc(byte[] buf, int off, int len) {
        int c = -1;
        if (crc_table == null) {
            CWATools.make_crc_table();
        }
        for (int n = off; n < len + off; ++n) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
        }
        return c;
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            CWATools.crc_table[n] = c;
        }
    }

    public static boolean loadImage(String folder, String name, Image[] imgArr) {
        InputStream is = "".getClass().getResourceAsStream(folder + name + ".bin");
        int i = 0;
        try {
            for (i = 0; i < imgArr.length; ++i) {
                int len = (is.read() & 0xFF) << 24;
                len |= (is.read() & 0xFF) << 16;
                len |= (is.read() & 0xFF) << 8;
                byte[] buffer = new byte[len |= is.read() & 0xFF];
                is.read(buffer, 0, buffer.length);
                imgArr[i] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (OutOfMemoryError e) {
            CWADebug.setErrorMsg(e, folder + name + ".png OutOfMemoryError at index " + i);
        }
        catch (Exception e) {
            CWADebug.setErrorMsg(e, folder + name + ".png error at index " + i);
        }
        return true;
    }

    public static Image createImage(byte[] res, int start, int length) {
        return Image.createImage((byte[])res, (int)start, (int)length);
    }

    public static int[] getPixels(Image src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] pixels = new int[w * h];
        src.getRGB(pixels, 0, w, 0, 0, w, h);
        return pixels;
    }

    public static Image drawPixels(int[] pixels, int w, int h, boolean alpha) {
        Image img = Image.createRGBImage((int[])pixels, (int)w, (int)h, (boolean)alpha);
        pixels = null;
        return img;
    }

    public static boolean checkIsSimulate() {
        boolean t1 = Runtime.getRuntime().totalMemory() >= 8000000L;
        boolean t2 = true;
        try {
            Class.forName("emulator.Emulator");
            Class.forName("com.sprintpcs.util.System");
        }
        catch (Exception e) {
            t2 = false;
        }
        String platForm = System.getProperty("microedition.platform");
        boolean t3 = platForm.toLowerCase().indexOf("wtk") != -1;
        boolean t4 = platForm.toLowerCase().indexOf("javasdk") != -1;
        boolean t5 = platForm.toLowerCase().indexOf("j2me") != -1;
        return false;
    }

    public static int GetArrayRealLength(int[] src) {
        int realLength = 0;
        for (int i = 0; i < src.length; ++i) {
            if (src[i] != -1) continue;
            realLength = i;
            break;
        }
        return realLength;
    }

    public static CWAUIIBase GetRefFromId(CWAUIIBase bc, int id) {
        if (bc.GetId() == id) {
            return bc;
        }
        for (int i = 0; i < bc.GetChildUI().length && bc.GetChildUI()[i] != null; ++i) {
            if (bc.GetChildUI()[i].GetType() == 0) {
                CWAUIIBase tmpb = CWATools.GetRefFromId((CWAUIContainer)bc.GetChildUI()[i], id);
                if (tmpb == null) continue;
                return tmpb;
            }
            if (bc.GetChildUI()[i].GetId() != id) continue;
            return bc.GetChildUI()[i];
        }
        return null;
    }

    public static int[] InitArray(int[] src, int length) {
        src = new int[length];
        for (int i = 0; i < length; ++i) {
            src[i] = -1;
        }
        return src;
    }

    public static void InsertArray(int[] src, int insertIndex, int num) {
        int j;
        if (insertIndex >= src.length || insertIndex < 0) {
            return;
        }
        int realLength = 0;
        for (j = insertIndex; j < src.length; ++j) {
            if (src[j] != -1) continue;
            realLength = j;
            break;
        }
        for (j = insertIndex + realLength - 1; j >= insertIndex; --j) {
            if (insertIndex + j + 1 >= src.length) continue;
            src[j + 1] = src[j];
        }
        src[insertIndex] = num;
    }

    public static void GetStreamToByteArray(byte[] obj, String name, int skip) {
        try {
            int index = 0;
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) == '/') continue;
                index = i;
                break;
            }
            String fileName = "/" + name.substring(index);
            InputStream input = new Object().getClass().getResourceAsStream(fileName);
            DataInputStream dinput = new DataInputStream(input);
            dinput.skip(skip);
            dinput.read(obj, 0, obj.length);
            dinput.close();
        }
        catch (Exception e) {
            System.out.println("GameInf err at getStream()  :  " + e);
        }
    }

    public static byte LoadByteFromByteArray(byte[] inf, int[] position) {
        int n = position[0];
        position[0] = n + 1;
        return (byte)(inf[n] & 0xFF);
    }

    public static short LoadShortFromByteArray(byte[] inf, int[] position) {
        int n = position[0];
        position[0] = n + 1;
        int n2 = position[0];
        position[0] = n2 + 1;
        return (short)((inf[n] & 0xFF) << 8 | inf[n2] & 0xFF);
    }

    public static int LoadIntFromByteArray(byte[] inf, int[] position) {
        int n = position[0];
        position[0] = n + 1;
        int n2 = position[0];
        position[0] = n2 + 1;
        int n3 = position[0];
        position[0] = n3 + 1;
        int n4 = position[0];
        position[0] = n4 + 1;
        return (inf[n] & 0xFF) << 24 | (inf[n2] & 0xFF) << 16 | (inf[n3] & 0xFF) << 8 | inf[n4] & 0xFF;
    }

    public static String bytesToString(byte[] b) {
        char[] c = new char[b.length >> 1];
        for (int i = 0; i < b.length; i += 2) {
            c[i >> 1] = (char)(b[i + 0] << 8 | b[i + 1] & 0xFF);
        }
        return new String(c);
    }

    public static void BaseUIMove(CWAUIIBase ui, int dx, int dy, CWAUIIBase root) {
        ui.SetX(ui.GetX() + dx, root);
        ui.SetY(ui.GetY() + dy, root);
        if (ui.GetType() != 1 && ui.GetType() == 0) {
            for (int i = 0; i < ui.GetChildUI().length && ui.GetChildUI()[i] != null; ++i) {
                CWATools.BaseUIMove(ui.GetChildUI()[i], dx, dy, root);
            }
        }
    }

    public static void drawString(Graphics g, String str, int color, int x, int y, int fontH, int areaW, int areaH, Font font, boolean multiLine, int align, int[] ScrollPos, int ScrollSpeed, byte fontLibrary, CWAUIFonts fonts, byte fontFramePattern, boolean[] isEnd) {
        if (fontLibrary != -1 && fonts != null) {
            fontH = fonts.stringHeight();
        }
        int[] brush = new int[1 + CWATools.color.length];
        brush[0] = color;
        for (int i = 1; i < brush.length; ++i) {
            brush[i] = CWATools.color[i - 1];
        }
        info = CWATools.divideString(str, fontH, areaW, multiLine, font, fontLibrary, fonts, 1);
        int fontWidth = 0;
        if (CWATools.info.pos > 0) {
            if (multiLine) {
                if (CWATools.info.colorData[CWATools.info.pos - 1][3] + fontH > areaH) {
                    isEnd[0] = true;
                    if (CWATools.info.colorData[CWATools.info.pos - 1][3] + fontH > ScrollPos[1]) {
                        ScrollPos[1] = ScrollPos[1] + ScrollSpeed;
                    } else {
                        ScrollPos[1] = -areaH;
                        isEnd[1] = true;
                    }
                } else {
                    isEnd[1] = true;
                    isEnd[0] = true;
                    ScrollPos[1] = 0;
                }
            } else {
                fontWidth = font.stringWidth(str);
                if (fontLibrary != -1 && fonts != null) {
                    fontWidth = fonts.stringLength(str);
                }
                if (fontWidth > areaW) {
                    isEnd[1] = true;
                    if (fontWidth > ScrollPos[0]) {
                        ScrollPos[0] = ScrollPos[0] + ScrollSpeed;
                        if (ScrollPos[0] >= fontWidth - areaW) {
                            isEnd[0] = true;
                        }
                    } else {
                        ScrollPos[0] = -areaW;
                    }
                } else {
                    isEnd[0] = true;
                    isEnd[1] = true;
                    ScrollPos[0] = 0;
                }
            }
        }
        for (int i = 0; i < CWATools.info.pos; ++i) {
            if (multiLine) {
                g.clipRect(x, y, areaW, areaH);
                CWATools.drawString(g, str.substring(CWATools.info.colorData[i][0], CWATools.info.colorData[i][1]), brush[CWATools.info.colorData[i][4]], x + CWATools.info.colorData[i][2], y + CWATools.info.colorData[i][3] - ScrollPos[1], 20, fontLibrary, fonts, fontFramePattern);
                g.clipRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                continue;
            }
            int drawX = 0;
            int drawY = 0;
            switch (align) {
                case 4: {
                    drawX = fontWidth > areaW ? x : x + (areaW - (CWATools.info.totalWidth + CWATools.info.charW)) / 2;
                    drawY = y + (areaH - fontH) / 2;
                    break;
                }
                case 3: {
                    drawX = x;
                    drawY = y + (areaH - fontH) / 2;
                    break;
                }
                case 5: {
                    drawX = x + (areaW - (CWATools.info.totalWidth + CWATools.info.charW));
                    drawY = y + (areaH - fontH) / 2;
                    break;
                }
                case 6: {
                    drawX = x;
                    drawY = y + (areaH - fontH);
                    break;
                }
                case 8: {
                    drawX = x + (areaW - (CWATools.info.totalWidth + CWATools.info.charW));
                    drawY = y + (areaH - fontH);
                    break;
                }
                case 7: {
                    drawX = fontWidth > areaW ? x : x + (areaW - (CWATools.info.totalWidth + CWATools.info.charW)) / 2;
                    drawY = y + (areaH - fontH);
                    break;
                }
                case 0: {
                    drawX = x;
                    drawY = y;
                    break;
                }
                case 2: {
                    drawX = x + (areaW - (CWATools.info.totalWidth + CWATools.info.charW));
                    drawY = y;
                    break;
                }
                case 1: {
                    drawX = x + (areaW - (CWATools.info.totalWidth + CWATools.info.charW)) / 2;
                    drawY = y;
                    break;
                }
            }
            g.clipRect(x, y, areaW, areaH);
            CWATools.drawString(g, str.substring(CWATools.info.colorData[i][0], CWATools.info.colorData[i][1]), brush[CWATools.info.colorData[i][4]], drawX + CWATools.info.colorData[i][2] - ScrollPos[0], drawY + CWATools.info.colorData[i][3], 20, fontLibrary, fonts, fontFramePattern);
            g.clipRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
        }
    }

    private static DrawStringInfo divideString(String str, int fontH, int areaW, boolean multiLine, Font font, byte fontLibrary, CWAUIFonts fonts, int where) {
        DrawStringInfo info = new DrawStringInfo();
        int countBegin = 0;
        int countW = 0;
        int countH = 0;
        int colorI = 0;
        for (int i = 0; i < str.length(); ++i) {
            int w;
            if (str.charAt(i) == '#' && i != str.length() - 1) {
                if (str.charAt(i + 1) == 'n') {
                    info.colorData[info.pos++] = new int[]{countBegin, i, countW, countH, colorI};
                    countW = 0;
                    countH += fontH + 1;
                    countBegin = i + 2;
                } else if (str.charAt(i + 1) >= '0' && str.charAt(i + 1) <= '7') {
                    info.totalWidth += info.charW;
                    info.colorData[info.pos++] = new int[]{countBegin, i, countW, countH, colorI};
                    w = font.charsWidth(str.substring(countBegin, i).toCharArray(), 0, i - countBegin);
                    if (fontLibrary != -1 && fonts != null) {
                        w = fonts.substringWidth(str.substring(countBegin, i), 0, i - countBegin);
                    }
                    countW += w;
                    colorI = str.charAt(i + 1) - 48;
                    countBegin = i + 2;
                }
            } else if (i - countBegin >= 0) {
                w = font.charsWidth(str.substring(countBegin, i + 1).toCharArray(), 0, i - countBegin + 1);
                if (fontLibrary != -1 && fonts != null) {
                    w = fonts.substringWidth(str.substring(countBegin, i + 1), 0, i - countBegin + 1);
                }
                info.charW = w;
                if (multiLine && countW + info.charW >= areaW) {
                    info.colorData[info.pos++] = new int[]{countBegin, i, countW, countH, colorI};
                    countW = 0;
                    countH += fontH + 1;
                    countBegin = i;
                }
            }
            if (i != str.length() - 1) continue;
            if (i == countBegin) {
                int j = 0;
                for (j = 0; j < splitChar.length; ++j) {
                    if (str.charAt(i) != splitChar[j]) continue;
                    info.colorData[info.pos - 1][1] = i + 1;
                    break;
                }
                if (j < splitChar.length) continue;
                info.colorData[info.pos++] = new int[]{countBegin, i + 1, countW, countH, colorI};
                continue;
            }
            if (i + 1 - countBegin <= 0) continue;
            info.colorData[info.pos++] = new int[]{countBegin, i + 1, countW, countH, colorI};
        }
        return info;
    }

    public static String[] getLineString(String str, int[][] colorData, int length) {
        strP = str;
        curPage = 1;
        prePage = 0;
        String[] lineStrings = new String[50];
        int nunOfLines = 0;
        int height = colorData[0][3];
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            if (height != colorData[i][3]) {
                height = colorData[i][3];
                lineStrings[nunOfLines++] = str.substring(begin, colorData[i][0]);
                begin = colorData[i][0];
            }
            if (i != length - 1) continue;
            lineStrings[nunOfLines++] = str.substring(begin, colorData[i][1]);
            break;
        }
        String[] result = new String[nunOfLines];
        System.arraycopy(lineStrings, 0, result, 0, result.length);
        return result;
    }

    public static void drawString(Graphics g, String str, int color, int x, int y, int align, int fontLibrary, CWAUIFonts fonts, int fontFramePattern) {
        if (fontLibrary != -1 && fonts != null) {
            fonts.drawString(str, x, y, align, color, g);
        } else {
            g.setColor(color);
            g.drawString(str, x, y, align);
        }
    }

    public static void drawStringBorder(Graphics g, String str, int color, int x, int y, int align, int fontLibrary, CWAUIFonts fonts, int fontFramePattern) {
        switch (fontFramePattern) {
            case 0: {
                if (fontLibrary != -1 && fonts != null) {
                    fonts.drawString(str, x - 1, y, align, 8607289, g);
                    fonts.drawString(str, x + 1, y, align, 8607289, g);
                    break;
                }
                g.setColor(8607289);
                g.drawString(str, x - 1, y, align);
                g.drawString(str, x + 1, y, align);
                break;
            }
            case 1: {
                if (fontLibrary != -1 && fonts != null) {
                    fonts.drawString(str, x, y - 1, align, 8607289, g);
                    fonts.drawString(str, x, y + 1, align, 8607289, g);
                    break;
                }
                g.setColor(8607289);
                g.drawString(str, x, y - 1, align);
                g.drawString(str, x, y + 1, align);
                break;
            }
            case 2: {
                if (fontLibrary != -1 && fonts != null) {
                    fonts.drawString(str, x, y - 1, align, 8607289, g);
                    fonts.drawString(str, x, y + 1, align, 8607289, g);
                    fonts.drawString(str, x - 1, y, align, 8607289, g);
                    fonts.drawString(str, x + 1, y, align, 8607289, g);
                    break;
                }
                g.setColor(8607289);
                g.drawString(str, x, y - 1, align);
                g.drawString(str, x, y + 1, align);
                g.drawString(str, x - 1, y, align);
                g.drawString(str, x + 1, y, align);
            }
        }
        if (fontLibrary != -1 && fonts != null) {
            fonts.drawString(str, x, y, align, color, g);
        } else {
            g.setColor(color);
            g.drawString(str, x, y, align);
        }
    }

    public static void getText(String strp, int fontH, int areaW, Font font, boolean multiLine, byte fontLibrary, CWAUIFonts fonts) {
        if (fontLibrary != -1 && fonts != null) {
            fontH = fonts.stringHeight();
        }
        DrawStringInfo info = CWATools.divideString(strp, fontH, areaW, multiLine, font, fontLibrary, fonts, 2);
        for (int i = 0; i < info.pos && info.colorData[i] != null; ++i) {
        }
        lineArray = CWATools.getLineString(strp, info.colorData, info.pos);
    }

    public static void totalLine() {
        totalLine = lineArray.length;
    }

    public static void PageLine(int height) {
        pageLine = height / (CWACommon.getFontHeight() + heGap);
    }

    public static String getPageStr(int page) {
        StringBuffer sb = new StringBuffer();
        for (int i = pageLine * prePage; i < (page * pageLine > lineArray.length ? lineArray.length : page * pageLine); ++i) {
            sb.append(lineArray[i]);
        }
        prePage = page;
        return sb.toString();
    }

    public static int maxPage() {
        if (lineArray.length % pageLine == 0) {
            return lineArray.length / pageLine;
        }
        return lineArray.length / pageLine + 1;
    }

    public static void addPage() {
        ++curPage;
    }

    public static void reducePage() {
        --curPage;
    }

    public static String[] split(String str, char sp) {
        Object[] s = null;
        String tempStr = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int len = 0;
        while (n != -1 && (n = str.trim().indexOf(sp, len)) != -1) {
            tempStr = str.trim().substring(len, n);
            len = n + 1;
            vector.addElement(tempStr);
        }
        vector.addElement(str.substring(len));
        s = new String[vector.size()];
        vector.copyInto(s);
        return s;
    }

    public static int getInteger(String num) {
        return Integer.parseInt(num);
    }

    public static short getShort(String num) {
        return Short.parseShort(num);
    }

    public static byte getByte(String num) {
        return Byte.parseByte(num);
    }

    public static byte[] getByteArray(String num) {
        String[] str = CWATools.split(num, ',');
        byte[] byteArray = new byte[str.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = CWATools.getByte(str[i]);
        }
        return byteArray;
    }

    public static long[] getTime(long time) {
        long[] rTtime = new long[]{time / 3600000L, time / 60000L, time / 1000L};
        return rTtime;
    }

    static {
        tempData1 = new int[20][2];
        color = new int[]{1862801, 15673612, 12067264, 11689977, 16359727, 0xFF0000, 255};
        info = null;
        splitChar = new char[]{'\uff0c', '\u3002', '\uff1f', '\uff01', '\uff1a', '\uff1b', '\u2019', '\u201d', '\u3001'};
        pageLine = 0;
        totalLine = 0;
        heGap = 0;
        curPage = 1;
        prePage = 0;
        strP = null;
    }
}

