/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwaEX;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAEffect2D;
import CWA2DAPI.cwaEX.CWAImageARGB;
import CWA2DAPI.cwaEX.CWAImageUtil;
import CWA2DAPI.cwabase2d.CWACamera;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWAUI.CWAUIManager;
import game.GameBattle;
import game.GameEvent;
import game.GameUI;
import game.GameWorld;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CWAScreenChange {
    private static CWAScreenChange _screenchange;
    public static final byte SCREEN_ALPHA = 0;
    public static final byte SCREEN_ALPHA_ON = 1;
    public static final byte SCREEN_ALPHA_OFF = 2;
    public static final byte SCREEN_ROUND_OFF = 3;
    public static final byte SCREEN_GRID_OFF = 4;
    public static final byte SCREEN_GRID_ON = 5;
    public static final byte SCREEN_BATTLE_FIELD_OFF = 6;
    public static final byte SCREEN_BATTLE_BOSS_OFF = 7;
    public static final byte SCREEN_BATTLE_NPC_OFF = 8;
    public static final byte SCREEN_BLACK = 9;
    public static final byte SCREEN_FLASH = 10;
    public static final byte SCREEN_SHAKE = 11;
    public static final byte SCREEN_OPEN = 12;
    public static final byte SCREEN_CLOSE = 13;
    public static final byte SCREEN_IMAGE_ALPHA_ON = 14;
    public static final byte SCREEN_IMAGE_ALPHA_OFF = 15;
    public static final byte SCREEN_STAR = 16;
    public static final byte SCREEN_CIRCLE = 17;
    public static final byte SCREEN_MENU_CARTOON = 18;
    public static final byte SCREEN_SHUTTER_CLOSE = 19;
    public static final byte SCREEN_SHUTTER_OPEN = 20;
    public int screenType = -1;
    public int screenStar = -1;
    public int screenOpen = -1;
    public int screenMenu = -1;
    public boolean isScreenOver;
    public boolean isScreenOpen;
    public int count;
    public int countOpen;
    public int alpha_c = 0;
    public int shadow_h_width = 20;
    public int step = 5;
    public int alphaColor = -2013265920;
    public int[] alphaArray = null;
    public int[] alphaArray1 = null;
    public int[] temp_alphaArray = null;
    public int[] finalColor = null;
    public int grid_width = 16;
    public int grid_eclosion_width = 4;
    public int grid_whole_spread_c = 0;
    public int[][] grid_whole_color_plate;
    public int[] grid_unit_spread_c;
    public int paint_num = 20;
    public int paint_method = 0;
    public int fieldType;
    public static CWAUIManager _ui;
    public static GameUI _gui;
    private static short[][] action;
    private static short[][] npcAction;
    private short[][] shakePos = new short[][]{{-20, 20, 20, -20, -15, 15, -15, 15, -5, 5, -5, 5}, {-5, 5, 5, -5}, {-5, 10, -5}};
    private int shakeDir = 0;
    private int shakeRate = 0;
    private int shakeTime = 0;
    private int shakeCount = 0;
    private int screenNum = 0;
    private int screenStep = 0;
    private int screen_w;
    private int screen_h1;
    private int screen_h2;
    private int flashNum = 0;
    private int flashStop = 0;
    private Image aphaImg = null;
    private CWAImageARGB imagArgb = null;
    private int imgX;
    private int imgY;
    private int r = 0;
    private int cirType = 0;
    private int centreX = 0;
    private int centreY = 0;
    private int[] cirArcColor = new int[]{0xFFFFFF, 9115396};
    private static int tileWidth;
    private static int[] screenDarkArg;
    private CWAEffect2D effect;
    int maxFrame = 0;
    int curFrame = 0;
    static final byte TRANS_NONE = 0;
    static final byte TRANS_ROT90 = 5;
    static final byte TRANS_ROT180 = 3;
    static final byte TRANS_ROT270 = 6;
    static final byte TRANS_MIRROR = 2;
    static final byte TRANS_MIRROR_ROT90 = 7;
    static final byte TRANS_MIRROR_ROT180 = 1;
    static final byte TRANS_MIRROR_ROT270 = 4;
    public static byte[] manual;
    public byte alphaType = (byte)-1;
    private int alphaX;
    private int alphaY;
    private int totalW;
    private int totalH;
    private int srcW;
    private int srcH;
    private int preAlphaX;
    private int preAlphaY;
    private static final int[][] PT;
    private byte starNum = (byte)30;
    private Image[] starImg;
    private Image bkImg = null;
    private int[][] star;
    private int borderX = 0;
    private int borderY = 0;
    private byte dir = 0;
    public static final byte DIR_UP = 0;
    public static final byte DIR_RUP = 1;
    public static final byte DIR_RIGHT = 2;
    public static final byte DIR_RDOWN = 3;
    public static final byte DIR_DOWN = 4;
    public static final byte DIR_LDOWN = 5;
    public static final byte DIR_LEFT = 6;
    public static final byte DIR_LUP = 7;
    public boolean isBack = false;
    public boolean backRender = false;

    public static CWAScreenChange getInstance() {
        if (_screenchange == null) {
            _ui = CWAUIManager.getInstance();
            _gui = new GameUI();
            _screenchange = new CWAScreenChange();
        }
        return _screenchange;
    }

    public void render(Graphics g) {
        if (this.screenType == -1 && this.screenOpen == -1 && this.screenMenu == -1) {
            return;
        }
        switch (this.screenMenu) {
            case 18: {
                _ui.draw(g);
                if (this.count < action.length) break;
                this.count = 0;
                this.screenMenu = -1;
                this.isScreenOver = true;
                action = null;
                _ui.close("/data/ui/menu1.ui");
                return;
            }
        }
        switch (this.screenType) {
            case 0: 
            case 1: 
            case 2: {
                this.isScreenOver = this.drawScreenALPHA(g);
                break;
            }
            case 3: {
                this.isScreenOver = this.drawScreenChange(g);
                break;
            }
            case 4: {
                if (this.isScreenOver) {
                    this.screenType = -1;
                    g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                    break;
                }
                this.isScreenOver = this.drawScreenGRID(g);
                break;
            }
            case 5: {
                if (this.isScreenOver) break;
                this.isScreenOver = this.drawScreenGRID(g);
                break;
            }
            case 6: {
                if (this.isScreenOver) {
                    this.screenType = -1;
                    g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                    break;
                }
                this.isScreenOver = this.drawField(g);
                break;
            }
            case 7: {
                if (this.effect == null) break;
                this.effect.render(g, 0, 0);
                break;
            }
            case 8: {
                if (this.count >= 5) {
                    g.drawImage(GameBattle.getInstance().battleBackGround, 0, 0, 20);
                }
                _ui.draw(g);
                if (this.count < npcAction.length) break;
                this.count = 0;
                this.screenType = -1;
                this.isScreenOver = true;
                _ui.close("/data/ui/npcEnemy.ui");
                return;
            }
            case 9: {
                g.setColor(this.alphaColor);
                g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                break;
            }
            case 10: {
                if (this.count > this.flashNum) break;
                if (this.count % 3 / (this.flashStop + 1) == 0) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                } else if (this.count % 3 / (this.flashStop + 1) == 1) {
                    g.setColor(0);
                    g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                }
                ++this.count;
                break;
            }
            case 14: 
            case 15: {
                this.isScreenOver = this.drawAphaImg(g);
                break;
            }
            case 17: {
                g.setColor(this.cirArcColor[this.alphaColor]);
                this.fillArc(g, this.centreX, this.centreY, this.r);
                break;
            }
            case 19: 
            case 20: {
                this.isScreenOver = this.drawDark(g);
            }
        }
        switch (this.screenOpen) {
            case 12: {
                g.setColor(0);
                g.fillRect(0, 0, this.screen_w, this.screen_h1 - this.countOpen * this.screen_h1 / this.screenNum);
                g.fillRect(0, CWACommon.getHeight() - this.screen_h2 + this.countOpen * this.screen_h2 / this.screenNum, this.screen_w, this.screen_h2 - this.countOpen * this.screen_h2 / this.screenNum);
                break;
            }
            case 13: {
                g.setColor(0);
                g.fillRect(0, 0, this.screen_w, this.countOpen * this.screen_h1 / this.screenNum);
                g.fillRect(0, CWACommon.getHeight() - this.countOpen * this.screen_h2 / this.screenNum, this.screen_w, this.countOpen * this.screen_h2 / this.screenNum);
            }
        }
    }

    public void setCurFrame(int frame) {
        this.curFrame = frame;
        switch (this.screenType) {
            case 7: {
                short spId = CWADataManager.DataBase[0][GameBattle.getInstance().getEnemyId(0)][17];
                short x = 118;
                short y = 160;
                switch (this.curFrame) {
                    case 0: {
                        short[] data = new short[]{8, x, y, spId, 0, 1, 0, 4, 0, 2, 1, 8, 0, -16, 10, 0, 0};
                        this.effect = new CWAEffect2D();
                        this.effect.init(data);
                        this.effect.setScreen(true);
                        this.effect.start();
                        break;
                    }
                    case 1: {
                        short[] data = new short[]{17, x, y, spId, 0, 1, 100, 255, 255, 255, 12, 0, 1, 1, 9};
                        this.effect.init(data);
                        this.effect.start();
                        break;
                    }
                    case 2: {
                        short[] data = new short[]{17, x, y, spId, 0, 1, 255, 255, 255, 255, 15, 0, 1, 1, 13};
                        this.effect.init(data);
                        this.effect.start();
                        break;
                    }
                    case 3: {
                        short[] data = new short[]{9, x, y, spId, 0, 1, 160, 255, 255, 255, 0, 4, 1};
                        this.effect.init(data);
                        this.effect.start();
                    }
                }
                break;
            }
            case 8: {
                this.maxFrame = npcAction[this.count].length;
            }
        }
        switch (this.screenMenu) {
            case 18: {
                this.maxFrame = action[this.count].length;
            }
        }
    }

    public void update() {
        if (this.screenType == -1 && this.screenOpen == -1 && this.screenMenu == -1) {
            return;
        }
        switch (this.screenType) {
            case 8: {
                if (this.curFrame < this.maxFrame) {
                    _gui.updateNpcEnemy(this.count, npcAction[this.count][this.curFrame]);
                    ++this.curFrame;
                } else {
                    ++this.count;
                    if (this.count < npcAction.length) {
                        this.setCurFrame(0);
                    }
                }
                _ui.update();
                break;
            }
            case 7: {
                if (this.effect == null || this.effect.update()) break;
                ++this.curFrame;
                if (this.curFrame >= 4) {
                    this.isScreenOver = true;
                    this.screenType = -1;
                    this.count = 0;
                    this.effect = null;
                    return;
                }
                this.setCurFrame(this.curFrame);
                break;
            }
            case 11: {
                if (this.shakeDir == 0) {
                    if (this.shakeCount >= this.shakePos[this.shakeRate].length * this.shakeTime) {
                        this.screenType = -1;
                        this.isScreenOver = true;
                        this.shakeCount = 0;
                        CWACamera.getInstance().type = CWACamera.getInstance().preType;
                        return;
                    }
                    CWACamera.getInstance().moveX(this.shakePos[this.shakeRate][this.shakeCount % this.shakePos[this.shakeRate].length]);
                    ++this.shakeCount;
                    break;
                }
                if (this.shakeCount >= this.shakePos[this.shakeRate].length * this.shakeTime) {
                    this.screenType = -1;
                    this.isScreenOver = true;
                    this.shakeCount = 0;
                    CWACamera.getInstance().type = CWACamera.getInstance().preType;
                    return;
                }
                CWACamera.getInstance().moveY(this.shakePos[this.shakeRate][this.shakeCount % this.shakePos[this.shakeRate].length]);
                ++this.shakeCount;
                break;
            }
            case 10: {
                if (this.count <= this.flashNum) break;
                this.isScreenOver = true;
                this.screenType = -1;
                this.count = 0;
                break;
            }
            case 17: {
                ++this.count;
                if (this.cirType == 0) {
                    if ((CWACommon.getWidth() - this.centreX) * (CWACommon.getWidth() - this.centreX) + (CWACommon.getHeight() - this.centreY) * (CWACommon.getHeight() - this.centreY) < this.r * this.r) {
                        this.count = 0;
                        this.isScreenOver = true;
                    }
                    this.r += 10;
                    break;
                }
                if (this.cirType == 1) {
                    this.r -= 10;
                    if (this.r > 0) break;
                    this.count = 0;
                    this.screenType = -1;
                    this.isScreenOver = true;
                    break;
                }
                if (this.count <= 10) {
                    this.r += 10;
                    break;
                }
                if (this.count > 10 && this.count <= 20) {
                    this.r -= 10;
                    break;
                }
                this.count = 0;
                this.isScreenOver = true;
                this.screenType = -1;
            }
        }
        switch (this.screenOpen) {
            case 13: {
                this.countOpen += this.screenStep;
                if (this.countOpen <= this.screenNum) break;
                this.countOpen = this.screenNum;
                this.isScreenOpen = true;
                break;
            }
            case 12: {
                this.countOpen += this.screenStep;
                if (this.countOpen <= this.screenNum) break;
                this.countOpen = 0;
                this.isScreenOpen = true;
                this.screenOpen = -1;
            }
        }
        switch (this.screenMenu) {
            case 18: {
                if (this.curFrame < this.maxFrame) {
                    _gui.updateMenuCartoon(this.count, action[this.count][this.curFrame]);
                    ++this.curFrame;
                } else {
                    ++this.count;
                    if (this.count < action.length) {
                        this.setCurFrame(0);
                    }
                }
                _ui.update();
            }
        }
    }

    public boolean drawField(Graphics g) {
        if (this.count < 10) {
            if (this.count % 3 == 1) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
            } else {
                GameWorld.getInstance().backRender(g, 0, 0, CWACommon.getWidth(), CWACommon.getHeight());
                GameWorld.getInstance().world.render(g, 1);
            }
            ++this.count;
        } else {
            if (this.count >= CWACommon.getWidth()) {
                g.setColor(0);
                g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                return true;
            }
            switch (this.fieldType) {
                case 0: {
                    int i;
                    g.setColor(0);
                    g.fillRect(0, 0, this.count, (int)CWACommon.getHalfHeight());
                    for (i = 1; i < 6; ++i) {
                        g.fillRect(this.count + i * 15, 0, 15 - i * 3, (int)CWACommon.getHalfHeight());
                    }
                    g.fillRect(CWACommon.getWidth() - this.count, (int)CWACommon.getHalfHeight(), this.count, (int)CWACommon.getHalfHeight());
                    for (i = 1; i < 6; ++i) {
                        g.fillRect(CWACommon.getWidth() - this.count - i * 15, (int)CWACommon.getHalfHeight(), 15 - i * 3, (int)CWACommon.getHalfHeight());
                    }
                    this.count += 15;
                    break;
                }
                case 1: {
                    g.setColor(0);
                    boolean fill = false;
                    for (int i = 0; i < CWACommon.getHeight(); i += 10) {
                        if (fill) {
                            g.fillRect(0, i, this.count, 10);
                            fill = false;
                            continue;
                        }
                        g.fillRect(CWACommon.getWidth() - this.count, i, this.count, 10);
                        fill = true;
                    }
                    this.count += 15;
                    break;
                }
                case 2: {
                    g.setColor(0);
                    boolean fill = false;
                    for (int i = 0; i < CWACommon.getWidth(); i += 10) {
                        if (fill) {
                            g.fillRect(i, 0, 10, this.count);
                            fill = false;
                            continue;
                        }
                        g.fillRect(i, CWACommon.getHeight() - this.count, 10, this.count);
                        fill = true;
                    }
                    this.count += 15;
                }
            }
        }
        return false;
    }

    public boolean drawScreenALPHA(Graphics g) {
        int i;
        int tempColor = this.alphaColor & 0xFFFFFF;
        int alpha = 0;
        boolean over = false;
        int tempAlphaColor = 0;
        if (this.screenType == 0) {
            tempAlphaColor = this.alphaColor;
        } else if (this.screenType == 1) {
            if (255 - this.alpha_c * this.step < 0) {
                --this.alpha_c;
                this.screenType = -1;
                over = true;
            }
            alpha = 255 - this.alpha_c * this.step << 24;
            tempAlphaColor = tempColor | alpha;
        } else if (this.screenType == 2) {
            if (this.alpha_c * this.step > 255) {
                --this.alpha_c;
                over = true;
            }
            alpha = this.alpha_c * this.step << 24;
            tempAlphaColor = tempColor | alpha;
        }
        int n = this.paint_num;
        int img_height = CWACommon.getHeight() / n + 1;
        int img_length = CWACommon.getWidth() * img_height;
        if (this.alphaArray == null || this.alphaArray.length != img_length) {
            this.alphaArray = new int[img_length];
        }
        if (this.alphaArray[0] != tempAlphaColor) {
            for (i = 0; i < this.alphaArray.length; ++i) {
                this.alphaArray[i] = tempAlphaColor;
            }
        }
        for (i = 0; i < n; ++i) {
            g.drawRGB(this.alphaArray, 0, (int)CWACommon.getWidth(), 0, i * img_height, (int)CWACommon.getWidth(), img_height, true);
        }
        if (over) {
            this.release();
            return true;
        }
        ++this.alpha_c;
        return false;
    }

    public boolean drawAphaImg(Graphics g) {
        boolean over = false;
        int alpha = 0;
        if (this.screenType == 15) {
            alpha = this.alpha_c;
            if (alpha >= 255) {
                alpha = 255;
                this.alpha_c = 255;
                over = true;
            }
        } else if (this.screenType == 14 && (alpha = 255 - this.alpha_c) <= 0) {
            alpha = 0;
            this.screenType = -1;
            over = true;
        }
        if (this.imagArgb != null) {
            this.imagArgb = CWAImageUtil.transparent(this.imagArgb, alpha);
            g.drawRGB(this.imagArgb.argb, 0, this.imagArgb.w, this.imgX - this.imagArgb.w / 2, this.imgY - this.imagArgb.h / 2, this.imagArgb.w, this.imagArgb.h, true);
        }
        if (over) {
            this.screenType = -1;
            this.release();
            return true;
        }
        this.alpha_c += this.step;
        return false;
    }

    public boolean drawAphaImage(Graphics g) {
        boolean over = false;
        if (this.alpha_c >= this.imagArgb.h) {
            this.alpha_c = this.imagArgb.h;
        }
        for (int i = 0; i < this.alpha_c * this.imagArgb.w; ++i) {
            if (this.imagArgb.argb[i] == 0xFFFFFF || this.imagArgb.argb[i] == 0) continue;
            this.imagArgb.argb[i] = this.imagArgb.argb[i] & 0xFFFFFF;
        }
        g.drawRGB(this.imagArgb.argb, 0, this.imagArgb.w, this.imgX - this.imagArgb.w / 2, this.imgY - this.imagArgb.h / 2, this.imagArgb.w, this.imagArgb.h, true);
        this.alpha_c += this.step;
        if (over) {
            this.release();
            return true;
        }
        return false;
    }

    public boolean drawScreenGRID(Graphics g) {
        int tempColor = this.alphaColor & 0xFFFFFF;
        int alpha = 0;
        int shadow_half_r = this.grid_eclosion_width;
        int alpha_step = 255 / (shadow_half_r * 2 + 1);
        int half_w = this.grid_width / 2;
        int r = 200 * half_w / 120;
        int r2 = r * r;
        int central_circle_pos = 0;
        int color_plate_num = this.grid_whole_spread_c / this.grid_width + 1;
        int a_w = CWACommon.getWidth() / this.grid_width;
        int a_h = CWACommon.getHeight() / this.grid_width;
        int a_w_half = a_w / 2;
        int a_h_half = a_h / 2;
        int[] one_color_plate = new int[r];
        if (this.grid_whole_color_plate == null) {
            this.grid_whole_color_plate = new int[CWATools.sqrt(a_w_half * a_w_half + a_h_half * a_h_half, 0)][];
        }
        if (this.grid_unit_spread_c == null) {
            this.grid_unit_spread_c = new int[this.grid_whole_color_plate.length];
        }
        if (color_plate_num > this.grid_whole_color_plate.length) {
            color_plate_num = this.grid_whole_color_plate.length;
        }
        for (int i = 0; i < color_plate_num; ++i) {
            if (this.grid_whole_color_plate[i] == null) {
                this.grid_whole_color_plate[i] = new int[this.grid_width * this.grid_width];
            }
            if (this.grid_unit_spread_c[i] >= r + shadow_half_r) continue;
            central_circle_pos = -shadow_half_r + this.grid_unit_spread_c[i];
            int dis = 0;
            for (int j = 0; j < one_color_plate.length; ++j) {
                dis = j - central_circle_pos;
                if (dis > shadow_half_r) {
                    alpha = this.screenType == 4 ? 0 : 255;
                } else if (dis < -shadow_half_r) {
                    alpha = this.screenType == 4 ? 255 : 0;
                } else if (this.screenType == 4) {
                    alpha = 127 - dis * alpha_step;
                } else if (this.screenType == 5) {
                    alpha = 127 + dis * alpha_step;
                }
                one_color_plate[j] = tempColor | alpha << 24;
            }
            int temp_r = r - 1;
            int temp_r_outer = central_circle_pos + shadow_half_r;
            int temp_r_inner = central_circle_pos - shadow_half_r;
            if (temp_r_inner < 0) {
                temp_r_inner = 0;
            }
            int outer_r2 = temp_r_outer * r2 / temp_r;
            int inner_r2 = temp_r_inner * r2 / temp_r;
            int distance2 = 0;
            int temp1 = 0;
            int temp2 = 0;
            int temp3 = 0;
            for (int k = 0; k < this.grid_width; ++k) {
                temp1 = (k - half_w) * (k - half_w);
                temp2 = k * this.grid_width;
                for (int j = 0; j < this.grid_width; ++j) {
                    distance2 = temp1 + (j - half_w) * (j - half_w);
                    temp3 = CWATools.sqrt(distance2, 1);
                    this.grid_whole_color_plate[i][temp2 + j] = distance2 > outer_r2 ? (this.screenType == 4 ? 0 : -16777216) : (distance2 < inner_r2 ? (this.screenType == 4 ? -16777216 : 0) : one_color_plate[temp3]);
                }
            }
            int n = i;
            this.grid_unit_spread_c[n] = this.grid_unit_spread_c[n] + 1;
        }
        boolean over = true;
        g.setColor(tempColor);
        int temp1 = 0;
        int temp2 = 0;
        int distance2 = 0;
        for (int i = 0; i < a_h; ++i) {
            temp1 = (i - a_h_half) * (i - a_h_half);
            for (int j = 0; j < a_w; ++j) {
                distance2 = temp1 + (j - a_w_half) * (j - a_w_half);
                temp2 = CWATools.sqrt(distance2, 1);
                if (this.grid_whole_color_plate[temp2] == null) {
                    if (this.screenType != 5) continue;
                    g.fillRect(j * this.grid_width, i * this.grid_width, this.grid_width, this.grid_width);
                    continue;
                }
                if (this.grid_unit_spread_c[temp2] >= r + shadow_half_r) {
                    if (this.screenType != 4) continue;
                    g.fillRect(j * this.grid_width, i * this.grid_width, this.grid_width, this.grid_width);
                    continue;
                }
                over = false;
                g.drawRGB(this.grid_whole_color_plate[temp2], 0, this.grid_width, j * this.grid_width, i * this.grid_width, this.grid_width, this.grid_width, true);
            }
        }
        if (over) {
            this.release();
            return true;
        }
        this.grid_whole_spread_c += 15;
        return false;
    }

    public static int[] rotate(int[] org_img, int[] dest_img, int width, int height, byte degree) {
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            if (degree != 5) break block10;
                            for (int i = 0; i < height; ++i) {
                                int temp2 = i * width;
                                int temp3 = -1 - i;
                                int j = 0;
                                int k = 1;
                                while (j < width) {
                                    dest_img[k * height + temp3] = org_img[temp2 + j];
                                    ++j;
                                    ++k;
                                }
                            }
                            break block11;
                        }
                        if (degree != 3) break block12;
                        int temp3 = width * height - 1;
                        for (int i = 0; i < height; ++i) {
                            int temp1 = i * width;
                            int temp2 = temp3 - i * width;
                            for (int j = 0; j < width; ++j) {
                                dest_img[temp2 - j] = org_img[temp1 + j];
                            }
                        }
                        break block11;
                    }
                    if (degree != 6) break block13;
                    int temp1 = width - 1;
                    for (int i = 0; i < height; ++i) {
                        int temp2 = temp1 * height + i;
                        int temp3 = i * width;
                        for (int j = 0; j < width; ++j) {
                            dest_img[temp2 - j * height] = org_img[temp3 + j];
                        }
                    }
                    break block11;
                }
                if (degree == 0 || degree == 7) break block11;
                if (degree != 1) break block14;
                int temp3 = height - 1;
                for (int i = 0; i < height; ++i) {
                    int temp1 = i * width;
                    int temp2 = (temp3 - i) * width;
                    for (int j = 0; j < width; ++j) {
                        dest_img[temp2 + j] = org_img[temp1 + j];
                    }
                }
                break block11;
            }
            if (degree == 4 || degree != 2) break block11;
            int temp1 = width - 1;
            for (int i = 0; i < height; ++i) {
                int temp2 = i * width;
                int temp3 = temp2 + temp1;
                for (int j = 0; j < width; ++j) {
                    dest_img[temp3 - j] = org_img[temp2 + j];
                }
            }
        }
        return dest_img;
    }

    public boolean drawScreenChange(Graphics g) {
        short alphaW = CWACommon.getWidth();
        short alphaH = CWACommon.getHeight();
        int tempColor = this.alphaColor & 0xFFFFFF;
        int alpha = 0;
        int shadow_half_r = this.shadow_h_width;
        int alpha_step = 255 / shadow_half_r / 2;
        int half_w = alphaW / 2;
        int half_h = alphaH / 2;
        int r = 200 * half_w / 120;
        int r2 = r * r;
        boolean isDrawOver = false;
        if (this.finalColor == null) {
            this.finalColor = new int[r];
        }
        int central_circle_pos = r + shadow_half_r - this.alpha_c * 2;
        if (this.alpha_c <= 0) {
            isDrawOver = true;
            central_circle_pos = r + shadow_half_r - --this.alpha_c * 2;
        }
        if (this.alphaArray == null || this.alphaArray.length != half_w * half_h) {
            this.alphaArray = new int[half_w * half_h];
        }
        if (this.temp_alphaArray == null || this.temp_alphaArray.length != half_w * half_h) {
            this.temp_alphaArray = new int[half_w * half_h];
        }
        int dis = 0;
        for (int i = 0; i < this.finalColor.length; ++i) {
            dis = i - central_circle_pos;
            alpha = dis > shadow_half_r ? 255 : (dis < -shadow_half_r ? 0 : 127 + dis * alpha_step);
            this.finalColor[i] = tempColor | alpha << 24;
        }
        int temp_r = r - 1;
        int temp_r_outer = central_circle_pos + shadow_half_r;
        int temp_r_inner = central_circle_pos - shadow_half_r;
        if (temp_r_inner < 0) {
            temp_r_inner = 0;
        }
        int outer_r2 = temp_r_outer * r2 / temp_r;
        int inner_r2 = temp_r_inner * r2 / temp_r;
        int distance2 = 0;
        for (int i = 0; i < half_h; ++i) {
            int temp1 = i * i;
            int temp2 = i * half_w;
            for (int j = 0; j < half_w; ++j) {
                distance2 = temp1 + j * j;
                this.alphaArray[temp2 + j] = distance2 > outer_r2 ? -16777216 : (distance2 < inner_r2 ? 0 : this.finalColor[temp_r * distance2 / r2]);
            }
        }
        if (this.alphaArray != null) {
            g.drawRGB(this.alphaArray, 0, half_w, half_w, half_h, half_w, half_h, true);
            g.drawRGB(CWAScreenChange.rotate(this.alphaArray, this.temp_alphaArray, half_w, half_h, (byte)2), 0, half_w, 0, half_h, half_w, half_h, true);
            g.drawRGB(CWAScreenChange.rotate(this.alphaArray, this.temp_alphaArray, half_w, half_h, (byte)3), 0, half_w, 0, 0, half_w, half_h, true);
            g.drawRGB(CWAScreenChange.rotate(this.alphaArray, this.temp_alphaArray, half_w, half_h, (byte)1), 0, half_w, half_w, 0, half_w, half_h, true);
        }
        if (isDrawOver) {
            this.release();
            return true;
        }
        this.alpha_c -= 10;
        return false;
    }

    public void initScreen(int color) {
        this.alpha_c = CWACommon.getHalfWidth();
        this.shadow_h_width = 10;
        this.alphaColor = color;
        this.alphaArray = null;
        this.temp_alphaArray = null;
        this.finalColor = null;
    }

    public void setAlphaType(byte type) {
        this.alphaType = type;
        if (type == -1) {
            this.alphaArray1 = null;
            this.imagArgb = null;
        }
    }

    public void initAphaArc(byte alphaType, int x, int y, int totalW, int totalH, int w, int h) {
        this.alphaType = alphaType;
        this.setAlphaSrc(x, y);
        this.totalW = totalW;
        this.totalH = totalH;
        this.srcW = w;
        this.srcH = h;
    }

    public void initSrc() {
        if (this.alphaType == 0) {
            for (int i = 0; i < this.alphaArray1.length; ++i) {
                int tempx = i % this.totalW;
                int tempy = i / this.totalW;
                this.alphaArray1[i] = CWATools.stance(tempx, tempy, this.alphaX, this.alphaY) <= this.srcW ? this.alphaArray1[i] & 0xFFFFFF : -16777216;
            }
        }
        this.imagArgb.init(this.alphaArray1, this.totalW, this.totalH);
    }

    public void expandSrc() {
        if (this.alphaArray1 == null) {
            return;
        }
        if (this.preAlphaX == this.alphaX && this.preAlphaY == this.alphaY) {
            return;
        }
        this.initSrc();
    }

    public void setAlphaWH(int w, int h) {
        this.srcW = w;
        this.srcH = h;
    }

    public void setAlphaSrc(int x, int y) {
        this.preAlphaX = this.alphaX;
        this.preAlphaY = this.alphaY;
        this.alphaX = x;
        this.alphaY = y;
    }

    public void drawAphaArc(Graphics g, int x, int y) {
        if (this.alphaType == -1 || this.imagArgb.argb == null) {
            return;
        }
        g.drawRGB(this.imagArgb.argb, 0, this.imagArgb.w, x, y, this.imagArgb.w, this.imagArgb.h, true);
    }

    public void drawSquare(Graphics g, int x, int y) {
        g.setColor(0);
        g.fillRect(0, 0, this.totalW, this.alphaY - this.srcH - y);
        g.fillRect(0, this.alphaY - this.srcH - y, this.alphaX - this.srcW - x, this.srcH * 2);
        g.fillRect(0, this.alphaY + this.srcH - y, this.totalW, this.totalH - (this.alphaY + this.srcH - y));
        g.fillRect(this.alphaX + this.srcW - x, this.alphaY - this.srcH - y, this.totalW - (this.alphaX + this.srcW - x), this.srcH * 2);
    }

    public void init(int color, int type) {
        this.alpha_c = 0;
        this.alphaColor = color;
        if (type == 12 || type == 13) {
            this.screenOpen = type;
            this.isScreenOpen = false;
        } else if (type == 18) {
            this.screenMenu = type;
        } else {
            this.screenType = type;
        }
        this.isScreenOver = false;
        switch (this.screenType) {
            case 1: 
            case 2: {
                this.step = 17;
                break;
            }
            case 3: {
                this.alpha_c = CWACommon.getHalfWidth();
                this.shadow_h_width = 20;
                break;
            }
            case 4: 
            case 5: {
                this.grid_whole_spread_c = 0;
                break;
            }
            case 6: {
                this.count = 0;
                this.fieldType = CWATools.getRandom(2);
                break;
            }
            case 7: {
                this.setCurFrame(0);
                break;
            }
            case 8: {
                this.count = 0;
                _gui.initNpcEnemy(0);
                this.setCurFrame(0);
                break;
            }
            case 10: 
            case 17: {
                this.count = 0;
                break;
            }
            case 19: {
                this.openShutter();
                break;
            }
            case 20: {
                this.closeShutter();
            }
        }
    }

    public void setShakeParam(int shakeDir, int shakeRate, int shakeTime) {
        CWACamera.getInstance().setType((byte)3);
        this.shakeDir = shakeDir;
        this.shakeRate = shakeRate;
        this.shakeTime = shakeTime;
    }

    public void setBlackScreen(int screenNum, int screenStep, int screen_w, int screen_h1, int screen_h2) {
        this.countOpen = 0;
        this.screenNum = screenNum;
        this.screenStep = screenStep;
        this.screen_w = screen_w;
        this.screen_h1 = screen_h1;
        this.screen_h2 = screen_h2;
    }

    public void setFlashScreen(int flashNum, int flashStop) {
        this.flashNum = flashNum;
        this.flashStop = flashStop;
    }

    public void setArc(int cirType, int centerX, int centerY, int r) {
        this.cirType = cirType;
        this.centreX = centerX;
        this.centreY = centerY;
        this.r = r;
    }

    public void setImage(String name, int imgX, int imgY, int step) {
        if (GameEvent.isReCall == 1) {
            this.aphaImg = CWATools.createImage("/data/tex/", name);
            this.aphaImg = CWAImageUtil.blackWhite(this.aphaImg);
        } else {
            this.aphaImg = CWATools.createImage("/data/tex/", name);
        }
        this.imagArgb = new CWAImageARGB();
        this.imagArgb = CWAImageUtil.getImageARGB(this.aphaImg, this.imagArgb);
        this.imgX = imgX;
        this.imgY = imgY;
        this.step = step;
    }

    public void setMenuCartoon() {
        this.screenType = -1;
        this.count = 0;
        action = new short[][]{{7}, {8}, {10}, {12}, {16}, {18}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {20}, {200, 200, 100, 100, 50, 50, 0, 0}, {38, 38, 39, 39, 40, 40, 41, 41, 42, 42}, {43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48}};
        _gui.initMenuCartoon();
        this.setCurFrame(0);
    }

    public void release() {
        this.alphaArray = null;
        this.temp_alphaArray = null;
        this.finalColor = null;
        this.grid_whole_color_plate = null;
        this.grid_unit_spread_c = null;
        this.aphaImg = null;
    }

    public void init(int borderX, int borderY, byte starNum, byte dir, Image bkImg, String[] imgName) {
        int i;
        this.screenStar = borderX;
        if (this.screenType == 17 && this.cirType == 0) {
            return;
        }
        this.screenType = -1;
        if (this.screenStar < 16) {
            return;
        }
        this.starNum = starNum;
        this.borderX = borderX;
        this.borderY = borderY;
        this.dir = dir;
        this.bkImg = bkImg;
        this.starImg = null;
        this.starImg = new Image[imgName.length];
        for (i = 0; i < imgName.length; ++i) {
            this.starImg[i] = CWATools.createImage("/data/tex/", imgName[i]);
        }
        this.star = new int[starNum][5];
        for (i = 0; i < starNum; ++i) {
            this._gainStar(i, false);
        }
    }

    private void _gainStar(int i, boolean rebirth) {
        int ran = CWATools.getRandom(100);
        this.star[i][0] = ran < 3 ? this.starImg.length - 1 : (ran < 15 ? this.starImg.length - 2 : (ran < 50 ? this.starImg.length - 3 : 0));
        this.star[i][1] = CWATools.getRandom(CWACommon.getWidth());
        this.star[i][2] = CWATools.getRandom(CWACommon.getHeight());
        this.star[i][3] = CWATools.getRandom(PT[this.star[i][0]][1] - PT[this.star[i][0]][0]) + PT[this.star[i][0]][0];
        this.star[i][4] = CWATools.getUnsigRandom(2);
    }

    private void _gainStar1(int i, boolean rebirth) {
        int ran = CWATools.getRandom(100);
        this.star[i][0] = ran < 5 ? this.starImg.length - 1 : (ran < 15 ? this.starImg.length - 2 : (ran < 50 ? this.starImg.length - 3 : 0));
        this.star[i][1] = CWATools.getRandom(CWACommon.getWidth());
        this.star[i][2] = this.star[i][0] == 0 ? (this.star[i][1] > 100 && this.star[i][1] < 180 ? this.borderY + CWATools.getRandom(CWACommon.getHeight() - this.borderY) : this.borderY + CWATools.getRandom(CWACommon.getHeight() - this.borderY - 40)) : (this.star[i][0] == 1 ? this.borderY + 20 + CWATools.getRandom(CWACommon.getHeight() - this.borderY - 20) : this.borderY + CWATools.getRandom(CWACommon.getHeight() - this.borderY));
        this.star[i][3] = CWATools.getRandom(PT[this.star[i][0]][0]) + PT[this.star[i][0]][1];
        this.star[i][4] = CWATools.getUnsigRandom(2);
    }

    public void drawStarBack(Graphics g) {
        if (this.screenStar < 16) {
            return;
        }
        if (this.bkImg == null) {
            g.setColor(0);
            g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
        } else {
            int w = this.bkImg.getWidth();
            for (int i = 0; i < CWACommon.getWidth() / w; ++i) {
                g.drawImage(this.bkImg, i * w, 0, 20);
            }
        }
        this.backRender = false;
        if (!this.isBack) {
            return;
        }
        this.drawStar(g);
        this.backRender = true;
    }

    public void drawStar(Graphics g) {
        if (this.screenStar < 16 && !this.backRender) {
            return;
        }
        for (int i = 0; i < this.starNum; ++i) {
            if (this.star[i][1] < CWACommon.getWidth() && this.star[i][2] < CWACommon.getHeight()) {
                g.drawImage(this.starImg[this.star[i][0]], this.star[i][1], this.star[i][2], 20);
            }
            switch (this.dir) {
                case 0: {
                    int[] nArray = this.star[i];
                    nArray[2] = nArray[2] - this.star[i][3];
                    break;
                }
                case 1: {
                    int[] nArray = this.star[i];
                    nArray[1] = nArray[1] + this.star[i][3];
                    int[] nArray2 = this.star[i];
                    nArray2[2] = nArray2[2] - this.star[i][3];
                    break;
                }
                case 2: {
                    int[] nArray = this.star[i];
                    nArray[1] = nArray[1] + this.star[i][3];
                    break;
                }
                case 3: {
                    int[] nArray = this.star[i];
                    nArray[1] = nArray[1] + this.star[i][3];
                    int[] nArray3 = this.star[i];
                    nArray3[2] = nArray3[2] + this.star[i][3];
                    break;
                }
                case 4: {
                    int[] nArray = this.star[i];
                    nArray[2] = nArray[2] + this.star[i][3];
                    break;
                }
                case 5: {
                    int[] nArray = this.star[i];
                    nArray[1] = nArray[1] - this.star[i][3];
                    int[] nArray4 = this.star[i];
                    nArray4[2] = nArray4[2] + this.star[i][3];
                    break;
                }
                case 6: {
                    int[] nArray = this.star[i];
                    nArray[1] = nArray[1] - this.star[i][3];
                    break;
                }
                case 7: {
                    int[] nArray = this.star[i];
                    nArray[1] = nArray[1] - this.star[i][3];
                    int[] nArray5 = this.star[i];
                    nArray5[2] = nArray5[2] - this.star[i][3];
                }
            }
            if (this.star[i][1] >= this.borderX - this.starImg[this.star[i][0]].getWidth() && this.star[i][2] >= this.borderY - this.starImg[this.star[i][0]].getHeight()) continue;
            this._gainStar(i, true);
        }
    }

    public void drawStar1(Graphics g) {
        if (this.screenStar < 17) {
            return;
        }
        g.setColor(0);
        g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
        for (int i = 0; i < this.starNum; ++i) {
            if (this.star[i][1] < CWACommon.getWidth() && this.star[i][2] < CWACommon.getHeight()) {
                g.drawImage(this.starImg[this.star[i][0]], this.star[i][1], this.star[i][2], 20);
            }
            int[] nArray = this.star[i];
            nArray[1] = nArray[1] + this.star[i][4];
            switch (this.dir) {
                case 1: {
                    int[] nArray2 = this.star[i];
                    nArray2[1] = nArray2[1] + this.star[i][3];
                    int[] nArray3 = this.star[i];
                    nArray3[2] = nArray3[2] - this.star[i][3];
                }
            }
            if (this.star[i][0] == 0) {
                if (this.star[i][1] >= this.borderX - this.starImg[this.star[i][0]].getWidth() && this.star[i][2] >= this.borderY - 40 - this.starImg[this.star[i][0]].getHeight()) continue;
                this._gainStar1(i, true);
                continue;
            }
            if (this.star[i][0] == 1) {
                if (this.star[i][1] >= this.borderX - this.starImg[this.star[i][0]].getWidth() && this.star[i][2] >= this.borderY - 20 - this.starImg[this.star[i][0]].getHeight()) continue;
                this._gainStar1(i, true);
                continue;
            }
            if (this.star[i][0] != 2 || this.star[i][1] >= this.borderX - this.starImg[this.star[i][0]].getWidth() && this.star[i][2] >= this.borderY - this.starImg[this.star[i][0]].getHeight()) continue;
            this._gainStar1(i, true);
        }
    }

    public void fillArc(Graphics g, int x, int y, int r) {
        g.fillArc(x - r, y - r, r * 2, r * 2, 0, 360);
    }

    private void setScreenDark(int type) {
        CWAScreenChange.screenDarkArg[0] = 20;
        tileWidth = CWACommon.getWidth() / screenDarkArg[0];
        CWAScreenChange.screenDarkArg[1] = (CWACommon.getHeight() - 1) / screenDarkArg[0] + 1;
        CWAScreenChange.screenDarkArg[2] = type;
        CWAScreenChange.screenDarkArg[3] = CWATools.getRandom(0, 7);
        CWAScreenChange.screenDarkArg[4] = 0;
        this.isScreenOver = false;
    }

    private void openShutter() {
        this.setScreenDark(-1);
    }

    private void closeShutter() {
        this.setScreenDark(1);
    }

    public boolean drawDark(Graphics g) {
        g.setColor(this.alphaColor);
        int width = 0;
        for (int i = 0; i < tileWidth; ++i) {
            for (int j = 0; j < screenDarkArg[1]; ++j) {
                switch (screenDarkArg[2]) {
                    case 1: {
                        width = screenDarkArg[0];
                        break;
                    }
                    case -1: {
                        width = 0;
                    }
                }
                switch (screenDarkArg[3]) {
                    case 0: {
                        width = (width += (j - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 1: {
                        width = (width += (screenDarkArg[1] - j - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 2: {
                        width = (width += (i - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 3: {
                        width = (width += (8 - i - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 4: {
                        width = (width += ((i + j >> 1) - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 5: {
                        width = (width += ((8 - i + j >> 1) - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 6: {
                        width = (width += ((i + screenDarkArg[1] - j >> 1) - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                        break;
                    }
                    case 7: {
                        width = (width += ((8 - i + screenDarkArg[1] - j >> 1) - screenDarkArg[4]) * screenDarkArg[2]) < 0 ? 0 : (width > screenDarkArg[0] ? screenDarkArg[0] : width);
                    }
                }
                g.fillRect(screenDarkArg[0] * i + (screenDarkArg[0] - width >> 1), screenDarkArg[0] * j + (screenDarkArg[0] - width >> 1), width, width);
            }
        }
        screenDarkArg[4] = screenDarkArg[4] + 2;
        if (screenDarkArg[4] > 40) {
            if (this.screenType == 20) {
                this.screenType = -1;
            }
            if (this.screenType == 19) {
                g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
            }
            return true;
        }
        return false;
    }

    static {
        action = null;
        npcAction = new short[][]{{0}, {1}, {2}, {3}, {4, 5, 6, 7, 8}, {9}, {10}, {11, 12}, {13}, {14, 15, 16, 17, 18, 19, 20}, {21}, {22}};
        tileWidth = 0;
        screenDarkArg = new int[5];
        manual = new byte[]{0, 5, 3, 6, 2, 7, 1, 4};
        PT = new int[][]{{1, 3}, {1, 4}, {2, 5}, {2, 6}};
    }
}

