/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwabase2d;

import CWA2DAPI.CWATools;
import CWAEvent.CWAEvent;
import game.GameWorld;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CWADataManager {
    public static short[][] objectSpriteIndex;
    public static short[][] modImageIndex;
    public static short[][][] DataBase;
    public static String[] chs;
    public static CWAEvent[] worldEvent;
    public static int[][] sceneStructure;
    public static int[][][] roomStructure;
    public static int[][] texData;
    public static short[][] effectData;
    public static Image bk;

    public static void init() {
        CWADataManager.loadObjectSprite("/data/script/sprite.mid");
        CWADataManager._loadModImage("/data/mod/modInfo.mid");
        CWADataManager.loadChs("/data/script/chs.mid");
        CWADataManager.loadNpcDialog("/data/script/npcDialog.mid");
        CWADataManager._initTex(4);
        CWADataManager.loadDatabase("/data/script/db.mid");
        CWADataManager.loadBK();
    }

    private static void loadNpcDialog(String path) {
        try {
            InputStream is = CWATools.getInputStream(path);
            String[][] tempStr = CWATools.get2DStrings(is);
            GameWorld.dialog = new String[tempStr.length];
            for (int i = 0; i < tempStr.length; ++i) {
                System.arraycopy(tempStr[i], 0, GameWorld.dialog, i, tempStr[i].length);
            }
            is.close();
            is = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void loadBK() {
        bk = CWATools.createImage("/data/tex/", "bk");
    }

    public static short getDataBase(byte db, short dbId, byte pro) {
        return DataBase[db][dbId][pro];
    }

    private static void loadDatabase(String path) {
        try {
            InputStream is = CWATools.getInputStream(path);
            DataBase = new short[9][][];
            for (int i = 0; i < 9; ++i) {
                CWADataManager.DataBase[i] = CWATools.getShort2DArray(is);
            }
            is.close();
            is = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadObjectSprite(String path) {
        try {
            InputStream is = CWATools.getInputStream(path);
            objectSpriteIndex = CWATools.getShort2DArray(is);
            is.close();
            is = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadChs(String path) {
        try {
            InputStream is = CWATools.getInputStream(path);
            String[][] tempStr = CWATools.get2DStrings(is);
            chs = new String[tempStr.length];
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < tempStr.length; ++i) {
                sb.delete(0, sb.length());
                for (int j = 0; j < tempStr[i].length; ++j) {
                    sb.append(tempStr[i][j]);
                }
                CWADataManager.chs[i] = sb.toString();
            }
            is.close();
            is = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void _initTex(int num) {
        texData = new int[num][];
        for (int i = 0; i < num; ++i) {
            CWADataManager.texData[i] = CWATools.getPixels(CWATools.createImage("/data/tex/", "tex_" + i));
        }
    }

    private static void _loadModImage(String fileName) {
        try {
            InputStream is = "".getClass().getResourceAsStream(fileName);
            DataInputStream br = new DataInputStream(is);
            int modNum = br.readByte();
            modImageIndex = new short[modNum][];
            for (int i = 0; i < modNum; ++i) {
                int imgNum = br.readByte();
                CWADataManager.modImageIndex[i] = new short[imgNum];
                for (int j = 0; j < imgNum; ++j) {
                    short imgId;
                    CWADataManager.modImageIndex[i][j] = imgId = br.readShort();
                }
            }
            br.close();
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void loadGameStructure(String path) {
        try {
            InputStream in = "".getClass().getResourceAsStream(path);
            DataInputStream dis = new DataInputStream(in);
            int scenceCount = dis.readShort();
            sceneStructure = new int[scenceCount][];
            roomStructure = new int[scenceCount][][];
            for (int i = 0; i < scenceCount; ++i) {
                CWADataManager.sceneStructure[i] = new int[6];
                CWADataManager.sceneStructure[i][0] = dis.readShort();
                CWADataManager.sceneStructure[i][1] = dis.readShort();
                CWADataManager.sceneStructure[i][2] = dis.readByte();
                CWADataManager.sceneStructure[i][3] = dis.readByte();
                CWADataManager.sceneStructure[i][4] = dis.readInt();
                CWADataManager.sceneStructure[i][5] = dis.readInt();
                int roomCount = dis.readByte();
                CWADataManager.roomStructure[i] = new int[roomCount][];
                for (int j = 0; j < roomCount; ++j) {
                    CWADataManager.roomStructure[i][j] = new int[6];
                    CWADataManager.roomStructure[i][j][0] = dis.readShort();
                    CWADataManager.roomStructure[i][j][1] = dis.readShort();
                    CWADataManager.roomStructure[i][j][2] = dis.readByte();
                    CWADataManager.roomStructure[i][j][3] = dis.readByte();
                    CWADataManager.roomStructure[i][j][4] = dis.readInt();
                    CWADataManager.roomStructure[i][j][5] = dis.readInt();
                }
            }
            dis.close();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadWorldEvent(String path) {
        try {
            short s;
            int i;
            InputStream in = "".getClass().getResourceAsStream(path);
            DataInputStream dis = new DataInputStream(in);
            byte by = dis.readShort();
            String[] worldStr = null;
            if (by > 0) {
                worldStr = new String[by];
                for (i = 0; i < by; ++i) {
                    int strLen = dis.readByte();
                    StringBuffer str = new StringBuffer();
                    for (int j = 0; j < strLen; ++j) {
                        str.append((char)(dis.read() << 8 | dis.read()));
                    }
                    worldStr[i] = str.toString();
                }
            }
            if ((s = (short)dis.readByte()) > 0) {
                worldEvent = new CWAEvent[s];
                for (i = 0; i < s; i = (int)((byte)(i + 1))) {
                    CWADataManager.worldEvent[i] = new CWAEvent();
                    worldEvent[i].init(dis, (byte)i, -1, worldStr);
                }
            }
            dis.close();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

