/*
 * Decompiled with CFR 0.152.
 */
package CWAEvent;

import CWAEvent.CWAEventStruct;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class CWAEvent {
    private CWAEventStruct[] eventItem;
    private byte _eid;
    private Vector events;
    private byte curPtr;
    private byte state;
    private int _srId;

    public void init(DataInputStream dis, byte eid, int srId, String[] wordStr) throws IOException {
        this._eid = eid;
        this._srId = srId;
        int evtItemCount = dis.readShort();
        this.eventItem = new CWAEventStruct[evtItemCount];
        this.events = new Vector();
        for (int i = 0; i < evtItemCount; ++i) {
            this.eventItem[i] = new CWAEventStruct();
            this.eventItem[i].init(dis, wordStr);
            this.events.addElement(this.eventItem[i]);
        }
        this.setState((byte)0);
    }

    public void release() {
        if (this.eventItem != null) {
            for (int i = 0; i < this.eventItem.length; ++i) {
                this.eventItem[i].release();
                this.eventItem[i] = null;
            }
            this.eventItem = null;
        }
        this._eid = 0;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public byte getEventId() {
        return this._eid;
    }

    public byte getCurPtr() {
        return this.curPtr;
    }

    public void setCurPtr(byte ptr) {
        this.curPtr = ptr;
    }

    public CWAEventStruct getCurEvent() {
        if (this.curPtr >= this.events.size()) {
            return null;
        }
        return (CWAEventStruct)this.events.elementAt(this.curPtr);
    }

    public CWAEventStruct firstEvent() {
        return (CWAEventStruct)this.events.firstElement();
    }

    public void next() {
        CWAEventStruct e = this.getCurEvent();
        this.curPtr = (byte)(this.curPtr + 1);
        if (this.curPtr >= this.events.size()) {
            this.curPtr = 0;
        }
    }

    public int[] getSrId() {
        if (this._srId == -1) {
            return null;
        }
        int[] srId = new int[]{this._srId >> 8 & 0xFF, this._srId & 0xFF};
        return srId;
    }
}

