/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ui;

import com.zy.ui.ActionListener;
import com.zy.ui.AutoRunScollLabel;
import com.zy.ui.Label;
import com.zy.ui.Panel;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public abstract class AbstractScollPanel
extends Panel {
    protected Font font = null;
    protected String text = null;
    protected int allPageTotleLine = 0;
    protected int onePageTotleLine = 0;
    protected int textColor = 0;
    protected String[] allLineString = null;
    protected AutoRunScollLabel titleLabel = null;
    protected boolean titleView = true;
    private static final String LINE_BREAKS = "|";
    protected Label softLeftButton = null;
    protected Label softRightButton = null;
    protected String softLeftNotMaxButtonText = null;
    protected String softLeftMaxButtonText = null;
    protected String softRightNotFirstButtonText = null;
    protected String softRightFirstButtonText = null;

    public AbstractScollPanel(String title, String text, int width, int height, int titleColor, int titleBackColor, int textColor, int backColor, boolean viewBackColor) {
        super(width, height, backColor, viewBackColor);
        this.setTitle(title, titleColor, titleBackColor);
        this.init(text, textColor);
    }

    public AbstractScollPanel(String text, int width, int height, int textColor, int backColor, boolean viewBackColor) {
        super(width, height, backColor, viewBackColor);
        this.setTitleView(false);
        this.init(text, textColor);
    }

    public AbstractScollPanel(String text, int width, int height, int textColor) {
        super(width, height, 0, false);
        this.setTitleView(false);
        this.init(text, textColor);
    }

    private void init(String text, int textColor) {
        this.textColor = textColor;
        this.text = text.trim();
        this.font = Font.getDefaultFont();
        this.allPageTotleLine();
    }

    public void setTitle(String title, int titleColor, int titleBackColor) {
        if (title == null) {
            this.setTitleView(false);
            this.titleLabel = null;
        } else {
            this.titleLabel = new AutoRunScollLabel(title, this.getWidth(), 1, titleColor, titleBackColor, true);
            this.titleLabel.setXRelativeParent(this.getWidth() - this.titleLabel.getWidth() >> 1);
            this.append(this.titleLabel);
            this.setTitleView(true);
        }
    }

    public void setFont(Font font) {
        this.font = null;
        this.font = font;
        this.reset();
    }

    private void reset() {
        this.allPageTotleLine();
        this.scollPanelTextAreaHeight();
        this.onePageTotleLine();
    }

    protected void allPageTotleLine() {
        if (this.text != null && !this.text.equals("")) {
            int i;
            this.allLineString = null;
            Vector stringBufferVector = new Vector();
            StringBuffer sb = new StringBuffer();
            int tempOneLineStringWidth = 0;
            for (i = 0; i < this.text.length(); ++i) {
                String tempOneStr = this.text.substring(i, i + 1);
                if (LINE_BREAKS.equals(tempOneStr)) {
                    tempOneLineStringWidth = 0;
                    this.addString(stringBufferVector, sb);
                    continue;
                }
                int tempOneStrWidth = this.font.stringWidth(tempOneStr);
                int tempOneLineStringWidth2 = tempOneLineStringWidth + tempOneStrWidth;
                if (tempOneLineStringWidth2 > this.getWidth()) {
                    tempOneLineStringWidth = 0;
                    this.addString(stringBufferVector, sb);
                    sb.append(tempOneStr);
                    tempOneLineStringWidth = tempOneStrWidth;
                    continue;
                }
                sb.append(tempOneStr);
                tempOneLineStringWidth = tempOneLineStringWidth2;
            }
            this.addString(stringBufferVector, sb);
            sb = null;
            this.allPageTotleLine = stringBufferVector.size();
            this.allLineString = new String[this.allPageTotleLine];
            for (i = 0; i < this.allPageTotleLine; ++i) {
                this.allLineString[i] = (String)stringBufferVector.elementAt(i);
                System.out.println("allLineString[" + i + "]= " + this.allLineString[i]);
            }
        }
        System.out.println("allPageTotleLine= " + this.allPageTotleLine);
    }

    private void addString(Vector sbv, StringBuffer sb) {
        if (sb.length() > 0) {
            sbv.addElement(sb.toString());
            sb.delete(0, sb.length());
        }
    }

    public void setTitleView(boolean show) {
        this.titleView = show ? this.titleLabel != null && !this.titleLabel.getText().trim().equals("") : false;
    }

    public abstract void addSoftLeftButton(String var1, String var2, ActionListener var3);

    public abstract void addSoftRightButton(String var1, String var2, ActionListener var3);

    protected abstract int scollPanelTextAreaHeight();

    protected abstract void onePageTotleLine();

    public abstract boolean isFirst();

    public abstract boolean isLast();
}

