/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.cwabase2d.CWADataManager;
import game.GameBattle;
import game.GameManager;
import game.GameWorld;
import javax.microedition.lcdui.Graphics;

public class GameConsole
extends CWACommon
implements CWAGlobal {
    private static GameConsole gc = null;
    public StringBuffer keyContrl = null;
    public GameWorld gameWorld = GameWorld.getInstance();
    private GameBattle gameBattle = GameBattle.getInstance();
    private final int MAXSKILL;
    private int[] mapNum = new int[]{2, 7, 8, 8, 13, 7, 2, 13, 7, 8, 15, 29};
    private int[] mapIndex = new int[]{0, 2, 9, 17, 25, 38, 45, 47, 60, 67, 75, 90};
    public byte index = 0;
    public byte srIndex = 0;
    public byte sceneIndex = 0;
    public byte roomIndex = 0;
    public byte petIndex = 0;
    private static final byte CONSOLE_MENU = 0;
    private static final byte CONSOLE_SCENE = 1;
    private static final byte CONSOLE_PET = 2;
    public static boolean openBattle = false;
    String[] str = new String[]{"1: \u573a\u666f\u63a7\u5236", "2: \u5ba0\u7269\u63a7\u5236"};
    String[] str1 = new String[]{"\u9009\u62e9\u573a\u666f", "\u9009\u62e9\u623f\u95f4", "\u9047\u654c\u8c03\u8bd5"};
    short[] pos = new short[]{0, 0, 198, 198, 151, 55, 80, 63, 118, 118, 118, 132, 112, 174, 160, 368, 136, 136, 230, 245, 167, 135, 168, 198};
    String[] sceneName = new String[]{"CG\u573a\u666f", "\u6751\u5e84", "\u78a7\u6c34", "\u539f\u6728", "\u7c98\u571f", "\u9ed1\u77f3", "\u9ed1\u9f99\u795e\u6bbf", "\u5929\u754c", "\u8fdc\u53e4", "\u9053\u9986", "\u795e\u517d\u8ff7\u5bab", "\u5ba4\u5185"};

    public GameConsole() {
        this.MAXSKILL = 10;
    }

    public static GameConsole getInstance() {
        if (gc == null) {
            gc = new GameConsole();
        }
        return gc;
    }

    public void update() {
        if (!this.onListen) {
            return;
        }
        this.getKey();
        switch (this.gamestate) {
            case 0: {
                if (!this.isKeyDown(196640)) break;
                switch (this.index) {
                    case 0: {
                        this.setState((byte)1);
                        break;
                    }
                    case 1: {
                        this.setState((byte)2);
                    }
                }
                break;
            }
            case 1: {
                if (this.isKeyDown(16400)) {
                    this.roomIndex = 0;
                    this.srIndex = (byte)(this.srIndex - 1);
                    if (this.srIndex > 0) break;
                    this.srIndex = 0;
                    break;
                }
                if (this.isKeyDown(32832)) {
                    this.roomIndex = 0;
                    this.srIndex = (byte)(this.srIndex + 1);
                    if (this.srIndex <= this.str1.length - 1) break;
                    this.srIndex = (byte)(this.str1.length - 1);
                    break;
                }
                if (this.isKeyDown(4100)) {
                    if (this.srIndex == 0) {
                        this.sceneIndex = (byte)(this.sceneIndex - 1);
                        if (this.sceneIndex > 0) break;
                        this.sceneIndex = 0;
                        break;
                    }
                    if (this.srIndex == 1) {
                        this.roomIndex = (byte)(this.roomIndex - 1);
                        if (this.roomIndex > 0) break;
                        this.roomIndex = 0;
                        break;
                    }
                    if (this.srIndex != 2) break;
                    openBattle = !openBattle;
                    break;
                }
                if (this.isKeyDown(8448)) {
                    if (this.srIndex == 0) {
                        this.sceneIndex = (byte)(this.sceneIndex + 1);
                        if (this.sceneIndex < this.mapNum.length - 1) break;
                        this.sceneIndex = (byte)(this.mapNum.length - 1);
                        break;
                    }
                    if (this.srIndex == 1) {
                        this.roomIndex = (byte)(this.roomIndex + 1);
                        if (this.roomIndex < this.mapNum[this.sceneIndex] - 1) break;
                        this.roomIndex = (byte)(this.mapNum[this.sceneIndex] - 1);
                        break;
                    }
                    if (this.srIndex != 2) break;
                    openBattle = !openBattle;
                    break;
                }
                if (this.isKeyDown(196640)) {
                    this.gameWorld.sceneId = this.sceneIndex;
                    this.gameWorld.roomId = this.roomIndex;
                    GameWorld.getInstance().doorId = -1;
                    GameWorld.isPlayer = true;
                    isHaveSms = false;
                    this.gameWorld.playerX = this.pos[this.sceneIndex * 2];
                    this.gameWorld.playerY = this.pos[this.sceneIndex * 2 + 1];
                    this.gameWorld.release();
                    GameManager.getInstance().setState((byte)9);
                    break;
                }
                if (!this.isKeyDown(1024)) break;
                GameManager.getInstance().setState((byte)10);
                break;
            }
            case 2: {
                if (this.isKeyDown(4100)) {
                    this.petIndex = (byte)(this.petIndex - 1);
                    if (this.petIndex > 0) break;
                    this.petIndex = (byte)(CWADataManager.DataBase[0].length - 1);
                    break;
                }
                if (this.isKeyDown(8448)) {
                    this.petIndex = (byte)(this.petIndex + 1);
                    if (this.petIndex < CWADataManager.DataBase[0].length - 1) break;
                    this.petIndex = 0;
                    break;
                }
                if (!this.isKeyDown(196640)) break;
                this.gameBattle.release();
                System.out.println(" \u63095\u952e  petIndex = " + this.petIndex);
                this.gameWorld.checkEnemy();
                GameManager.getInstance().setState((byte)12);
            }
        }
    }

    public void render(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, (int)GameConsole.getWidth(), 100);
        switch (this.gamestate) {
            case 0: {
                g.setColor(0xFF0000);
                g.drawString("\u63a7\u5236\u53f0", GameConsole.getWidth() >> 1, 10, 17);
                g.setColor(0);
                for (int i = 0; i < this.str.length; ++i) {
                    if (this.index == i) {
                        g.setColor(0xFF0000);
                    } else {
                        g.setColor(0);
                    }
                    g.drawString(this.str[i], 10, 30 + i * 20, 20);
                }
                break;
            }
            case 1: {
                g.setColor(0xFF0000);
                g.drawString(this.str[this.index], GameConsole.getWidth() >> 1, 10, 17);
                for (int i = 0; i < this.str1.length; ++i) {
                    if (this.srIndex == i) {
                        g.setColor(0xFF0000);
                    } else {
                        g.setColor(0);
                    }
                    g.drawString(this.str1[i], 30 + i * 80, 30, 20);
                }
                g.setColor(0);
                g.drawString("\u573a\u666f: " + this.sceneIndex + "  " + this.sceneName[this.sceneIndex], 10, 50, 20);
                g.drawString("\u623f\u95f4: " + this.roomIndex + "  " + GameConsole.STR(384 + this.mapIndex[this.sceneIndex] + this.roomIndex), 10, 70, 20);
                if (openBattle) {
                    g.drawString("\u80fd\u9047\u654c", 120, 70, 20);
                    break;
                }
                g.drawString("\u4e0d\u80fd\u9047\u654c", 120, 70, 20);
                break;
            }
            case 2: {
                g.setColor(0xFF0000);
                g.drawString(this.str[1], GameConsole.getWidth() >> 1, 10, 17);
                g.drawString("\u5f53\u524d\u5ba0\u7269: " + this.petIndex + " \u540d\u79f0: " + GameConsole.STR(CWADataManager.DataBase[0][this.petIndex][0]), GameConsole.getWidth() >> 1, 30, 17);
            }
        }
    }

    public boolean init() {
        if (this.keyContrl == null) {
            this.keyContrl = new StringBuffer();
        }
        return true;
    }

    public void release() {
    }

    public void setState(byte state) {
        this.prestate = this.gamestate;
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                this.sceneIndex = (byte)this.gameWorld.sceneId;
                this.roomIndex = (byte)this.gameWorld.roomId;
            }
        }
        this.gamestate = state;
    }
}

