/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAEffect2D;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWASprite;
import game.GameBattle;
import game.GamePlayer;
import game.GameWorld;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GamePet
extends CWASprActor
implements CWAGlobal {
    public static final short LEVEL_MAX = 50;
    public static final short LEVEL_MIN = 5;
    public static final short PET_RESTAR = 100;
    public static final short EXCIT_INIT = 120;
    public static final short[] RESTAR = new short[]{90, 95, 100, 110, 125};
    public static final byte[] EVOLE_LEVEL = new byte[]{12, 30, 5};
    public static final byte BUF_RD = 0;
    public static final byte BUF_VAL1 = 1;
    public static final byte BUF_VAL2 = 2;
    public static final byte BUF_SKILLID = 3;
    public static final byte BUF_LIVE = 4;
    public static final byte BUF_VRMAX = 5;
    CWAEffect2D effect;
    short[][] bufArr;
    short[][] debufArr;
    byte[][] bufType;
    byte[] bufTypeNum;
    short[] skillPro;
    byte[] curSkill;
    byte curSkillNum;
    private short[] preProp;
    protected int battleHp = 0;
    private int preHp;
    private int preExp = 0;
    private int exp = 0;
    protected int addExp = 0;
    private int level = 0;
    protected short sprIndex;
    private byte petState = 0;
    private int pId = 0;
    protected byte isMutation;
    protected byte preSkillId;
    protected byte curSkillId;
    private int actorEnemy = 0;
    private boolean isBattle;
    protected short battleTime;
    protected byte battleProp;
    protected Vector vTarget = new Vector();
    protected Vector pTarget = new Vector();
    public byte hurtPos = 0;
    protected boolean cActor;
    protected short[] value;
    protected CWAEffect2D spEffect = null;
    public byte spelayer = 0;

    public GamePet() {
        this.baseProp = new short[23];
        this.curProp = new short[23];
        this.skillPro = new short[5];
        this.curSkill = new byte[5];
        this.preProp = new short[4];
        for (int i = 0; i < this.curSkill.length; ++i) {
            this.curSkill[i] = -1;
        }
        this.value = new short[16];
        this.bufArr = new short[16][5];
        this.debufArr = new short[11][5];
        this.bufType = new byte[][]{{-1, -1, -1}, {-1, -1, -1}};
        this.bufTypeNum = new byte[2];
        this.isReflection = false;
    }

    public void init(int id, int level, short itemId, byte excit, short ou, byte mutationType) {
        this.pId = id;
        this.level = level;
        if (ou == -1) {
            this.setProp((byte)0, (short)CWATools.getRandom(CWADataManager.DataBase[0][this.pId][3], CWADataManager.DataBase[0][this.pId][3]));
        } else {
            this.setProp((byte)0, ou);
        }
        this.setProp((byte)1, (short)(CWADataManager.DataBase[0][this.pId][5] + CWADataManager.DataBase[0][this.pId][6] * level + CWADataManager.DataBase[0][this.pId][7]));
        this.setProp((byte)2, (short)(CWADataManager.DataBase[0][this.pId][8] + CWADataManager.DataBase[0][this.pId][9] * level + CWADataManager.DataBase[0][this.pId][10]));
        this.setProp((byte)3, (short)(CWADataManager.DataBase[0][this.pId][11] + CWADataManager.DataBase[0][this.pId][12] * level / 10 + CWADataManager.DataBase[0][this.pId][13]));
        this.setProp((byte)4, (short)(CWADataManager.DataBase[0][this.pId][14] + CWADataManager.DataBase[0][this.pId][15] * level / 10 + CWADataManager.DataBase[0][this.pId][16]));
        this.setProp((byte)5, itemId);
        this.setProp((byte)6, excit);
        this.setMutation(mutationType);
        this.resetCurProp();
        this.sprIndex = CWADataManager.DataBase[0][this.pId][17];
        this.init();
    }

    public void init() {
        this.setPreHp(this.getCurProp((byte)1));
    }

    public void init(int[] baseData) {
        this.init(baseData[0], baseData[1], (short)baseData[2], (byte)baseData[3], (short)baseData[4], (byte)baseData[5]);
        this.setProp();
        this.init((short)baseData[6], baseData[7], baseData[8]);
        int[] skill = new int[baseData.length - 9];
        for (int i = 0; i < skill.length; ++i) {
            skill[i] = baseData[9 + i];
        }
        this.setSkill(skill);
    }

    public void init(short hp, int exp, int battleTime) {
        this.setProp();
        this.setCurProp((byte)1, hp);
        this.setPreHp(this.getCurProp((byte)1));
        this.exp = exp;
        this.battleTime = (byte)battleTime;
    }

    public void start() {
        super.start();
        if (this.sprite == null) {
            this.sprite = new CWASprite();
        }
        this.sprite.initSprite(this.sprIndex, false);
        this.setState((byte)0, (byte)-1, true);
    }

    public void stop() {
        super.stop();
        if (this.sprite != null) {
            this.sprite.removeSprite(5);
            this.sprite = null;
        }
    }

    public void initEffect(short type, byte state) {
        byte dir = this.faceDir;
        this.effect = null;
        this.effect = new CWAEffect2D();
        this.effect.init(new short[]{type, state, dir});
        this.effect.setPosition(this.actorX, this.actorY);
        int[] wh = null;
        if (type == 20 && state == 3 || type == 22 && state == 4) {
            wh = this.sprite.getFrameImgWH(0, dir);
            this.effect.setPosition(this.actorX, this.actorY - wh[3]);
        }
        this.effect.setScreen(true);
    }

    public void setSpData(int spId) {
        this.spEffect = new CWAEffect2D();
        short[] tempData = GameBattle.spEffect[spId];
        short[] data = new short[tempData.length + 5];
        System.arraycopy(tempData, 1, data, 6, tempData.length - 1);
        short[] data1 = new short[]{tempData[0], (short)this.getActorX(), (short)this.getActorY(), CWADataManager.DataBase[0][this.pId][17], 0, this.faceDir};
        System.arraycopy(data1, 0, data, 0, data1.length);
        this.spEffect.init(data);
        this.spEffect.setScreen(true);
    }

    public void setSpdata() {
        short[] tempData = new short[]{16, 0, 0, 4};
        this.spEffect = new CWAEffect2D();
        short[] data = new short[tempData.length + 5];
        System.arraycopy(tempData, 1, data, 6, tempData.length - 1);
        short[] data1 = new short[]{tempData[0], (short)this.getActorX(), (short)this.getActorY(), CWADataManager.DataBase[0][this.pId][17], 0, this.faceDir};
        System.arraycopy(data1, 0, data, 0, data1.length);
        this.spEffect.init(data);
        this.spEffect.setScreen(true);
        this.spEffect.start();
    }

    public void setState(byte state, byte animeMode, boolean reset) {
        switch (state) {
            case 0: {
                this.sprite.setAction(state, (byte)-1, reset);
                break;
            }
            case 1: {
                this.sprite.setAction(state, (byte)0, reset);
                switch (this.getPetId()) {
                    case 0: {
                        this.setSpData(27);
                        break;
                    }
                    case 10: {
                        this.spelayer = 1;
                        this.setSpData(28);
                        break;
                    }
                    case 91: {
                        this.setSpData(26);
                        break;
                    }
                    case 92: {
                        this.setSpData(25);
                        break;
                    }
                    case 97: 
                    case 98: {
                        this.setSpData(23);
                        break;
                    }
                    case 62: {
                        this.setSpData(24);
                        break;
                    }
                    case 75: {
                        this.setSpData(20);
                        break;
                    }
                    case 87: {
                        this.setSpData(21);
                    }
                }
                break;
            }
            case 2: {
                this.sprite.setAction(state, (byte)0, reset);
                break;
            }
            case 3: {
                if (GameBattle.getInstance().battleType != 0) break;
                this.stop();
                this.setSpdata();
                break;
            }
            case 4: {
                this.sprite.setAction(state, (byte)-1, reset);
            }
        }
        this.petState = state;
    }

    public void update() {
        switch (this.petState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        this.updateAction();
        if (this.effect != null) {
            this.effect.update();
        }
        if (this.spEffect != null) {
            this.spEffect.update();
        }
    }

    public void render(Graphics g) {
        if (this.spEffect != null && this.getState() == 1) {
            switch (this.getPetId()) {
                case 0: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 10: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 91: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 92: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 97: 
                case 98: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 62: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 75: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                    break;
                }
                case 87: {
                    if (!this.sprite.isCheckFrame(1)) break;
                    this.spEffect.start();
                }
            }
        }
        if (this.spEffect != null && this.spelayer == 0) {
            this.spEffect.render(g, 0, 0);
        }
        this.drawSprite(g);
        if (this.spEffect != null && this.spelayer == 1) {
            this.spEffect.render(g, 0, 0);
        }
        if (this.effect != null) {
            this.effect.render(g, 0, 0);
        }
    }

    public void drawSprite(Graphics g) {
        if (!this.isVisible) {
            return;
        }
        this.sprite.drawSprite(g, this.actorX, this.actorY, this.faceDir);
    }

    public byte getState() {
        return this.petState;
    }

    public int getPetId() {
        return this.pId;
    }

    public void setActorEmemy(int actorEnemy) {
        this.actorEnemy = actorEnemy;
    }

    public int getActorEnemy() {
        return this.actorEnemy;
    }

    public void setLevel(byte level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isMaxLevel() {
        return this.level == 50;
    }

    protected void addExp(int n) {
        if (this.level >= 50) {
            return;
        }
        this.exp += n * 50;
        if (this.exp < 0) {
            this.exp = 0;
        }
    }

    public boolean canUpLevel() {
        int levelUp;
        int n = levelUp = CWACommon.isSMSCheck ? 3 : 2;
        return this.getExp() >= this.levelExp(this.getLevel() + 1);
    }

    public int getLevelExp() {
        int levelUp = CWACommon.isSMSCheck ? 3 : 2;
        return this.levelExp(this.getLevel());
    }

    public int getNextLevelExp() {
        int levelUp;
        int n = levelUp = CWACommon.isSMSCheck ? 3 : 2;
        if (this.level >= 50) {
            return this.levelExp(50);
        }
        return this.levelExp(this.getLevel() + 1);
    }

    public void addLevel() {
        int levelUp = CWACommon.isSMSCheck ? 3 : 2;
        ++this.level;
        this.addExp(-this.levelExp(this.level));
        this.evolve();
        for (int i = 0; i < this.curSkill.length; ++i) {
            if (this.curSkill[i] == -1) continue;
            this.skillPro[i] = CWADataManager.DataBase[1][this.curSkill[i]][5];
        }
        this.setBaseProp();
    }

    public void addLevel(int addLevel) {
        this.level += addLevel;
        this.evolve();
        this.setBaseProp();
    }

    public int levelExp(int level) {
        return 15 * level * level - 200;
    }

    public void setProp() {
        if (GamePlayer.getInstance().getPokBadgeValue((byte)1, (byte)0) == 2 && GamePlayer.getInstance().getPokBadgeValue((byte)1, (byte)1) == 1) {
            short addHp = (short)(this.getProp((byte)1) * CWADataManager.DataBase[2][1][6] / 100);
            this.setProp((byte)1, (short)(this.getProp((byte)1) + addHp));
        }
        if (GamePlayer.getInstance().getPokBadgeValue((byte)2, (byte)0) == 2 && GamePlayer.getInstance().getPokBadgeValue((byte)2, (byte)1) == 1) {
            short addDef = (short)(this.getProp((byte)3) * CWADataManager.DataBase[2][2][6] / 100);
            this.setProp((byte)3, (short)(this.getProp((byte)3) + addDef));
        }
    }

    public void setBaseProp() {
        this.setProp((byte)1, (short)(CWADataManager.DataBase[0][this.pId][5] + CWADataManager.DataBase[0][this.pId][6] * this.level + CWADataManager.DataBase[0][this.pId][7]));
        this.setProp((byte)2, (short)(CWADataManager.DataBase[0][this.pId][8] + CWADataManager.DataBase[0][this.pId][9] * this.level + CWADataManager.DataBase[0][this.pId][10]));
        this.setProp((byte)3, (short)(CWADataManager.DataBase[0][this.pId][11] + CWADataManager.DataBase[0][this.pId][12] * this.level / 10 + CWADataManager.DataBase[0][this.pId][13]));
        this.setProp((byte)4, (short)(CWADataManager.DataBase[0][this.pId][14] + CWADataManager.DataBase[0][this.pId][15] * this.level / 10 + CWADataManager.DataBase[0][this.pId][16]));
        this.resetCurProp();
        this.setPreHp(this.getCurProp((byte)1));
    }

    public static short getHpProp(int pId, int level) {
        return (short)(CWADataManager.DataBase[0][pId][5] + CWADataManager.DataBase[0][pId][6] * level + CWADataManager.DataBase[0][pId][7]);
    }

    public void setPreLevelProp() {
        for (int i = 0; i < this.preProp.length; ++i) {
            this.preProp[i] = GamePet.getPetBasePro(this.pId, this.level - 5, 1 + i);
        }
    }

    public void setPreProp() {
        for (int i = 0; i < this.preProp.length; ++i) {
            this.preProp[i] = this.getProp((byte)(1 + i));
        }
    }

    public short getPreProp(int type) {
        return this.preProp[type];
    }

    public void chCurProp() {
        if (this.battleProp < 20) {
            this.battleProp = (byte)(this.battleProp + 1);
            this.setCurProp((byte)2, (short)(this.getProp((byte)2) + this.getProp((byte)2) * this.battleProp / 100));
            this.setCurProp((byte)3, (short)(this.getProp((byte)3) + this.getProp((byte)3) * this.battleProp / 100));
            this.setCurProp((byte)4, (short)(this.getProp((byte)4) + this.getProp((byte)4) * this.battleProp / 100));
        }
    }

    public int getExp() {
        return this.exp;
    }

    public void setPreExp(int exp) {
        this.preExp = exp;
    }

    public int getPreExp() {
        return this.preExp;
    }

    public int getAttack() {
        int attack = 0;
        if (((GamePet)this.target).getActorEnemy() == 0 && GamePlayer.getInstance().getPokBadgeValue((byte)4, (byte)0) == 2) {
            short addDef = (short)(this.target.getProp((byte)3) * (100 + CWADataManager.DataBase[2][4][5]) / 100);
            this.target.setCurProp((byte)3, addDef);
        }
        attack = ((GamePet)this.target).isAdornItem((byte)2) ? this.getCurProp((byte)2) * RESTAR[this.getProp((byte)0) - 1] / 100 - this.target.getCurProp((byte)3) * (100 + CWADataManager.DataBase[3][2][5]) / 100 * RESTAR[this.target.getProp((byte)0) - 1] / 100 : this.getCurProp((byte)2) * RESTAR[this.getProp((byte)0) - 1] / 100 - this.target.getCurProp((byte)3) * RESTAR[this.target.getProp((byte)0) - 1] / 100;
        return attack;
    }

    public void hurt(int dmg) {
        int tempDmg = dmg;
        if (tempDmg <= 0) {
            tempDmg = 1;
        }
        this.setPreHp(this.getCurProp((byte)1));
        this.setCurProp((byte)1, (short)(this.getCurProp((byte)1) - tempDmg));
        if (this.getCurProp((byte)1) <= 0) {
            this.setCurProp((byte)1, (short)0);
        }
    }

    public void addHp(int hp) {
        int tempHp = hp;
        this.setCurProp((byte)1, (short)(this.getCurProp((byte)1) + tempHp));
        if (this.getCurProp((byte)1) >= this.getProp((byte)1)) {
            this.setCurProp((byte)1, this.getProp((byte)1));
        }
    }

    public void addEnergy(int time) {
        for (int i = 0; i < this.curSkill.length; ++i) {
            if (this.curSkill[i] == -1) continue;
            int n = i;
            this.skillPro[n] = (short)(this.skillPro[n] + time);
            if (this.skillPro[i] < CWADataManager.DataBase[1][this.curSkill[i]][5]) continue;
            this.skillPro[i] = CWADataManager.DataBase[1][this.curSkill[i]][5];
        }
    }

    public boolean findBuf(int buf) {
        return this.bufArr[buf][4] == 1;
    }

    public Vector existBuf() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < 16; ++i) {
            if (this.bufArr[i][4] != 1) continue;
            v.addElement("" + i);
        }
        return v;
    }

    public int addBuf(byte buf, int value, int skillId) {
        int addHp = 0;
        if (buf == -1) {
            return addHp;
        }
        switch (buf) {
            case 0: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)3) * CWADataManager.DataBase[6][buf][3] / 100);
                this.bufArr[buf][2] = (short)(CWADataManager.DataBase[6][buf][4] * this.getAttack() / 100);
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) + this.bufArr[buf][1]));
                break;
            }
            case 1: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)3) * CWADataManager.DataBase[6][buf][3] / 100);
                this.bufArr[buf][2] = CWADataManager.DataBase[6][buf][4];
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) - this.bufArr[buf][1]));
                break;
            }
            case 2: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)3) * CWADataManager.DataBase[6][buf][3] / 100);
                this.bufArr[buf][2] = CWADataManager.DataBase[6][buf][4];
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) + this.bufArr[buf][1]));
                break;
            }
            case 3: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)1) * CWADataManager.DataBase[6][buf][3] / 100);
                addHp = this.bufArr[buf][1];
                this.setPreHp(this.getCurProp((byte)1));
                this.addHp(this.bufArr[buf][1]);
                break;
            }
            case 4: {
                this.value[4] = (short)skillId;
                this.bufArr[buf][1] = (short)(this.getProp((byte)3) * CWADataManager.DataBase[1][skillId][8] / 100);
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) + this.bufArr[buf][1]));
                break;
            }
            case 5: {
                this.bufArr[buf][1] = CWADataManager.DataBase[6][buf][3];
                break;
            }
            case 6: {
                this.bufArr[buf][1] = CWADataManager.DataBase[6][buf][3];
                this.bufArr[buf][2] = CWADataManager.DataBase[6][buf][4];
                break;
            }
            case 7: {
                this.value[7] = (short)skillId;
                this.bufArr[buf][1] = (short)(this.getProp((byte)4) * CWADataManager.DataBase[1][skillId][8] / 100);
                this.setCurProp((byte)4, (short)(this.getProp((byte)4) + this.bufArr[buf][1]));
                break;
            }
            case 8: {
                this.bufArr[buf][1] = CWADataManager.DataBase[6][buf][3];
                break;
            }
            case 9: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)4) * CWADataManager.DataBase[6][buf][3] / 100);
                this.bufArr[buf][2] = (short)(this.getProp((byte)3) * CWADataManager.DataBase[6][buf][4] / 100);
                this.setCurProp((byte)4, (short)(this.getProp((byte)4) + this.bufArr[buf][1]));
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) - this.bufArr[buf][2]));
                break;
            }
            case 10: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)2) * CWADataManager.DataBase[6][buf][3] / 100);
                this.setCurProp((byte)2, (short)(this.getProp((byte)2) + this.bufArr[buf][1]));
                break;
            }
            case 11: {
                this.bufArr[buf][1] = (short)value;
                GamePet pet = GameBattle.getInstance().gamePet[value];
                for (int i = 0; i < pet.getBufDebufNum(0); ++i) {
                    this.addBuf(pet.bufType[0][i], pet.bufArr[pet.bufType[0][i]][1], GameBattle.getInstance().gamePet[value].value[i]);
                }
                pet.removeAllbuf();
                break;
            }
            case 12: {
                this.value[12] = 1;
                break;
            }
            case 13: {
                this.bufArr[buf][1] = (short)(this.getProp((byte)1) * CWADataManager.DataBase[6][buf][3] / 100);
                addHp = this.bufArr[buf][1];
                this.setPreHp(this.getCurProp((byte)1));
                this.addHp(this.bufArr[buf][1]);
                this.removeAllDebuf();
                break;
            }
            case 14: {
                this.removeAllDebuf();
                break;
            }
            case 15: {
                this.bufArr[buf][1] = (short)(value * CWADataManager.DataBase[6][buf][3]);
            }
        }
        this.setBufDebufType(0, buf);
        this.bufArr[buf][0] = CWADataManager.DataBase[6][buf][2];
        this.bufArr[buf][4] = 1;
        return addHp;
    }

    public void removeBuf(int buf) {
        this.bufArr[buf][4] = 0;
        for (byte i = 2; i <= 4; i = (byte)(i + 1)) {
            this.setCurProp(i, this.getProp(i));
        }
    }

    public int bufVal(int buf) {
        int addHp = 0;
        switch (buf) {
            case 0: {
                break;
            }
            case 1: {
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) - this.bufArr[buf][1]));
                break;
            }
            case 2: {
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) + this.bufArr[buf][1]));
                break;
            }
            case 3: {
                addHp = this.bufArr[buf][1];
                this.setPreHp(this.getCurProp((byte)1));
                this.addHp(this.bufArr[buf][1]);
                break;
            }
            case 4: {
                this.setCurProp((byte)3, (short)(this.getCurProp((byte)3) + this.bufArr[buf][1]));
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.setCurProp((byte)4, (short)(this.getProp((byte)4) + this.bufArr[buf][1]));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.setCurProp((byte)4, (short)(this.getProp((byte)4) + this.bufArr[buf][1]));
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) - this.bufArr[buf][2]));
                break;
            }
            case 10: {
                this.setCurProp((byte)2, (short)(this.getProp((byte)2) + this.bufArr[buf][1]));
                break;
            }
            case 11: {
                GamePet pet = GameBattle.getInstance().gamePet[this.bufArr[11][1]];
                for (int i = 0; i < pet.getBufDebufNum(0); ++i) {
                    this.addBuf(pet.bufType[0][i], pet.bufArr[pet.bufType[0][i]][1], GameBattle.getInstance().gamePet[this.bufArr[11][1]].value[i]);
                }
                pet.removeAllbuf();
                break;
            }
            case 12: {
                this.value[12] = 2;
                break;
            }
            case 13: {
                addHp = this.bufArr[buf][1];
                this.setPreHp(this.getCurProp((byte)1));
                this.addHp(this.bufArr[buf][1]);
                break;
            }
            case 14: {
                break;
            }
        }
        return addHp;
    }

    public boolean findDebuf(int debuf) {
        return this.debufArr[debuf][4] == 1;
    }

    public Vector existDebuf() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < 11; ++i) {
            if (this.debufArr[i][4] != 1) continue;
            v.addElement("" + i);
        }
        return v;
    }

    public byte addDebuf(byte debuf, short value, short skillId, short incr) {
        if (debuf == -1) {
            return -1;
        }
        if (this.isAdornItem((byte)3)) {
            if (CWATools.getRandom(100) > incr * (100 - CWADataManager.DataBase[3][3][5]) / 100) {
                return -1;
            }
        } else {
            int rand;
            if (this.findBuf(14)) {
                return -1;
            }
            if (incr != -1 && (rand = CWATools.getRandom(100)) > incr) {
                return -1;
            }
        }
        switch (debuf) {
            case 0: {
                this.debufArr[debuf][1] = value;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.debufArr[debuf][1] = value;
                break;
            }
            case 4: {
                this.debufArr[debuf][1] = CWADataManager.DataBase[1][skillId][8];
                break;
            }
            case 5: {
                this.debufArr[debuf][1] = (short)(this.getProp((byte)4) * CWADataManager.DataBase[1][skillId][8] / 100);
                this.setCurProp((byte)4, (short)(this.getProp((byte)4) - this.debufArr[debuf][1]));
                break;
            }
            case 6: {
                this.debufArr[debuf][1] = CWADataManager.DataBase[1][skillId][8];
                break;
            }
            case 7: {
                this.debufArr[debuf][1] = (short)(this.getProp((byte)3) * CWADataManager.DataBase[1][skillId][8] / 100);
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) - this.debufArr[debuf][1]));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        this.setBufDebufType(1, debuf);
        this.debufArr[debuf][0] = this.getActorEnemy() == 0 && GamePlayer.getInstance().getPokBadgeValue((byte)6, (byte)0) == 2 && GamePlayer.getInstance().getPokBadgeValue((byte)6, (byte)1) == 1 ? (short)(CWADataManager.DataBase[7][debuf][2] / 2) : CWADataManager.DataBase[7][debuf][2];
        this.debufArr[debuf][3] = skillId;
        this.debufArr[debuf][4] = 1;
        return debuf;
    }

    public void removeAllDebuf() {
        int i;
        for (i = 0; i < 11; ++i) {
            if (this.debufArr[i][4] != 1) continue;
            this.removeDebuf(i);
        }
        for (i = 0; i < 3; ++i) {
            this.removeSolt(1, i);
        }
    }

    public void removeAllbuf() {
        int i;
        for (i = 0; i < 16; ++i) {
            if (this.bufArr[i][4] != 1) continue;
            this.removeBuf(i);
        }
        for (i = 0; i < 3; ++i) {
            this.removeSolt(0, i);
        }
    }

    public void removeDebuf(int debuf) {
        this.debufArr[debuf][4] = 0;
        for (byte i = 2; i <= 4; i = (byte)(i + 1)) {
            this.setCurProp(i, this.getProp(i));
        }
    }

    public void removeSolt(int type, int debufIndex) {
        this.bufType[type][debufIndex] = -1;
        if (this.bufTypeNum[type] > 0) {
            int n = type;
            this.bufTypeNum[n] = (byte)(this.bufTypeNum[n] - 1);
        }
    }

    public void debufVal(int debuf) {
        switch (debuf) {
            case 0: {
                short atk = this.debufArr[0][1];
                short v = CWADataManager.DataBase[1][this.debufArr[0][3]][8];
                this.hurt(atk / v);
                if (this.canBattle()) break;
                this.setState((byte)3, (byte)0, true);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.debufArr[debuf][0] > 1) break;
                short atk = this.debufArr[debuf][1];
                short value1 = CWADataManager.DataBase[1][this.debufArr[debuf][3]][8];
                this.hurt(atk * value1 / 100);
                if (this.canBattle()) break;
                this.setState((byte)3, (byte)0, true);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.setCurProp((byte)4, (short)(this.getProp((byte)4) - this.debufArr[debuf][1]));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.setCurProp((byte)3, (short)(this.getProp((byte)3) - this.debufArr[debuf][1]));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
    }

    public void debufUpdate(int debuf, int bufIndex) {
        if (this.findDebuf(debuf)) {
            if (this.debufArr[debuf][0] > 0) {
                short[] sArray = this.debufArr[debuf];
                sArray[0] = (short)(sArray[0] - 1);
            }
            if (this.debufArr[debuf][0] <= 0) {
                this.removeDebuf(debuf);
                this.removeSolt(1, bufIndex);
            }
        }
    }

    public void bufUpdate(int buf, int bufIndex) {
        if (this.findBuf(buf)) {
            if (this.bufArr[buf][0] > 0) {
                short[] sArray = this.bufArr[buf];
                sArray[0] = (short)(sArray[0] - 1);
            }
            if (this.bufArr[buf][0] <= 0) {
                this.removeBuf(buf);
                this.removeSolt(0, bufIndex);
            }
        }
    }

    public void setBufDebufType(int type, byte id) {
        int i = 0;
        for (i = 0; i < 3; ++i) {
            if (this.bufType[type][i] != -1) continue;
            int j = 0;
            for (j = 0; j < 3; ++j) {
                if (this.bufType[type][j] != id) continue;
                return;
            }
            if (j < 3) continue;
            this.bufType[type][i] = id;
            if (this.bufTypeNum[type] >= 3) break;
            int n = type;
            this.bufTypeNum[n] = (byte)(this.bufTypeNum[n] + 1);
            break;
        }
        if (i >= 3) {
            this.bufType[type][0] = id;
        }
    }

    public byte getBufDebufNum(int type) {
        return this.bufTypeNum[type];
    }

    public boolean isAdornItem(byte itemId) {
        return this.getProp((byte)5) == itemId;
    }

    public int canUseSkillNum() {
        return this.curSkillNum;
    }

    public int[] canLearnSkill() {
        int[] learn = null;
        Vector<String> vl = new Vector<String>();
        short slv = 0;
        short petType = CWADataManager.DataBase[0][this.pId][18];
        short petDep = CWADataManager.DataBase[0][this.pId][1];
        int j = 0;
        int skillLevel = this.getSkillLevel();
        for (int id = petDep * 10; id < petDep * 10 + 10; ++id) {
            slv = CWADataManager.DataBase[1][id][4];
            if (slv > CWADataManager.DataBase[8][petType][skillLevel]) continue;
            for (j = 0; j < this.curSkill.length && id != this.curSkill[j]; ++j) {
            }
            if (j < this.curSkill.length) continue;
            vl.addElement(String.valueOf(id));
        }
        if (vl.size() > 0) {
            learn = new int[vl.size()];
            for (int i = 0; i < learn.length; ++i) {
                learn[i] = Integer.parseInt((String)vl.elementAt(i));
            }
        }
        return learn;
    }

    public void learnSkill(byte id) {
        for (int i = 0; i < this.curSkill.length; ++i) {
            if (this.curSkill[i] != -1) continue;
            this.curSkill[i] = id;
            this.curSkillNum = (byte)(this.curSkillNum + 1);
            this.skillPro[i] = CWADataManager.DataBase[1][id][5];
            break;
        }
    }

    public void getRandSkill() {
        int sId = 0;
        short petSort = CWADataManager.DataBase[0][this.pId][1];
        if (this.level <= 5) {
            sId = petSort * 10;
            boolean canAdd = true;
            for (int j = 0; j < this.curSkill.length; ++j) {
                if (sId != this.curSkill[j]) continue;
                canAdd = false;
                break;
            }
            if (canAdd) {
                this.learnSkill((byte)sId);
            }
        } else {
            if (this.canUseSkillNum() >= this.getSkillLevel() + 1) {
                return;
            }
            int[] canLearn = this.canLearnSkill();
            int lnum = canLearn.length;
            int rad = 0;
            for (int i = 0; i < canLearn.length; ++i) {
                rad = CWATools.getRandom(lnum);
                this.learnSkill((byte)canLearn[rad]);
                if (this.canUseSkillNum() >= this.getLevel() / 10 + 1) break;
                for (int j = rad; j < lnum - 1; ++j) {
                    canLearn[j] = canLearn[j + 1];
                }
                --lnum;
            }
        }
    }

    public boolean canUseSkill(int id) {
        if (id == -1) {
            return false;
        }
        return this.skillPro[id] > 0;
    }

    public void useSkill(byte id, GamePet target) {
        this.setTarget(target);
        this.preSkillId = this.curSkillId;
        this.curSkillId = id;
        for (int i = 0; i < this.curSkill.length; ++i) {
            if (this.curSkill[i] != id) continue;
            int n = i;
            this.skillPro[n] = (short)(this.skillPro[n] - 1);
            if (this.findBuf(12) && this.value[12] == 1) {
                int n2 = i;
                this.skillPro[n2] = (short)(this.skillPro[n2] + 1);
            }
            if (!this.findBuf(8)) continue;
            int n3 = i;
            this.skillPro[n3] = (short)(this.skillPro[n3] - 1);
        }
    }

    public void setSkill(int[] data) {
        this.curSkillNum = (byte)data[0];
        for (int i = 0; i < data[0]; ++i) {
            this.curSkill[i] = (byte)data[i + 1];
            this.skillPro[i] = (short)data[data[0] + 1 + i];
        }
    }

    public byte getSkill(int index) {
        if (index > this.curSkill.length - 1 || index < 0) {
            return -1;
        }
        return this.curSkill[index];
    }

    public short getSkillPro(byte id, byte pro) {
        return CWADataManager.DataBase[1][id][pro];
    }

    public int getSkillLevel() {
        int[] skill = new int[]{5, 10, 20, 30, 40};
        int temp = 0;
        for (int i = 0; i < skill.length; ++i) {
            if (this.level < skill[i]) continue;
            temp = i;
        }
        return temp;
    }

    public void setUseSkillId(byte skillId) {
        this.curSkillId = skillId;
    }

    public byte getUseSkillId() {
        return this.curSkillId;
    }

    public void resetCurProp() {
        this.setProp();
        super.resetCurProp();
        this.setPreHp(this.getProp((byte)1));
    }

    public void resetPet() {
        for (int i = 0; i < this.curSkill.length; ++i) {
            if (this.curSkill[i] == -1) continue;
            this.skillPro[i] = CWADataManager.DataBase[1][this.curSkill[i]][5];
        }
        this.resetCurProp();
        this.start();
    }

    public int evolvePet(int itemId, int itemNum) {
        if (CWADataManager.DataBase[0][this.pId][20] == itemId && CWADataManager.DataBase[0][this.pId][21] == itemNum) {
            return CWADataManager.DataBase[0][this.pId][19];
        }
        return -1;
    }

    public void evolve() {
        short nextPetId;
        if (GameWorld.vectorEvole == null) {
            GameWorld.vectorEvole = new Vector();
        }
        if ((nextPetId = CWADataManager.getDataBase((byte)0, (short)this.getPetId(), (byte)19)) == -1) {
            return;
        }
        short itemNum = CWADataManager.getDataBase((byte)0, (short)this.getPetId(), (byte)21);
        int itemId = CWADataManager.getDataBase((byte)0, (short)this.getPetId(), (byte)20) + 12;
        boolean next = false;
        if (!GameWorld.isEvoleTip && this.canEvolution() >= 1 && this.getLevel() >= EVOLE_LEVEL[CWADataManager.getDataBase((byte)0, nextPetId, (byte)2) - 1] && GamePlayer.getInstance().getItemNum(itemId, (byte)2) >= itemNum) {
            next = true;
        } else if (this.canEvolution() >= 1 && this.getLevel() >= EVOLE_LEVEL[CWADataManager.getDataBase((byte)0, nextPetId, (byte)2) - 1]) {
            next = true;
        }
        if (next) {
            int[] temp = new int[]{this.getPetId(), CWADataManager.DataBase[0][this.getPetId()][0]};
            GameWorld.vectorEvole.addElement(temp);
            GameWorld.evoleData[0] = (byte)this.getLevel();
            GameWorld.evoleData[1] = (byte)this.getPetId();
            GameWorld.tipEvole = 0;
        }
    }

    public void setMutation(byte mutationType) {
        this.isMutation = mutationType;
        int addProp = 0;
        switch (mutationType) {
            case 7: {
                addProp = 7;
                this.setProp((byte)2, (short)(this.getProp((byte)2) * 90 / 100));
                this.setProp((byte)4, (short)(this.getProp((byte)4) + addProp));
                this.setProp((byte)1, (short)(this.getProp((byte)1) * 80 / 100));
                break;
            }
            case 8: {
                addProp = -2;
                this.setProp((byte)2, (short)(this.getProp((byte)2) * 130 / 100));
                this.setProp((byte)4, (short)(this.getProp((byte)4) + addProp));
                this.setProp((byte)1, (short)(this.getProp((byte)1) * 80 / 100));
                break;
            }
            case 9: {
                addProp = -2;
                this.setProp((byte)2, (short)(this.getProp((byte)2) * 90 / 100));
                this.setProp((byte)4, (short)(this.getProp((byte)4) + addProp));
                this.setProp((byte)1, (short)(this.getProp((byte)1) * 130 / 100));
            }
        }
    }

    public boolean isBattle() {
        return this.isBattle;
    }

    public void setBattle(boolean isBattle) {
        this.isBattle = isBattle;
    }

    public int getPetData(byte type) {
        return CWADataManager.DataBase[0][this.pId][type];
    }

    public static short getPetBasePro(int pId, int level, int type) {
        switch (type) {
            case 1: {
                return (short)(CWADataManager.DataBase[0][pId][5] + CWADataManager.DataBase[0][pId][6] * level + CWADataManager.DataBase[0][pId][7]);
            }
            case 2: {
                return (short)(CWADataManager.DataBase[0][pId][8] + CWADataManager.DataBase[0][pId][9] * level + CWADataManager.DataBase[0][pId][10]);
            }
            case 3: {
                return (short)(CWADataManager.DataBase[0][pId][11] + CWADataManager.DataBase[0][pId][12] * level / 10 + CWADataManager.DataBase[0][pId][13]);
            }
            case 4: {
                return (short)(CWADataManager.DataBase[0][pId][14] + CWADataManager.DataBase[0][pId][15] * level / 10 + CWADataManager.DataBase[0][pId][16]);
            }
        }
        return 0;
    }

    public int getHpPer() {
        return this.getCurProp((byte)1) * 100 / this.getProp((byte)1);
    }

    public int getPreHpPer() {
        return this.getPreHp() * 100 / this.getProp((byte)1);
    }

    public int getPreHp() {
        return this.preHp;
    }

    public void setPreHp(int preHp) {
        this.preHp = preHp >= this.getProp((byte)1) ? (int)this.getProp((byte)1) : preHp;
    }

    public int getExpPer() {
        return this.exp * 100 / this.getNextLevelExp();
    }

    public int getExpPer(int exp) {
        return exp * 100 / this.getNextLevelExp();
    }

    public static int getExpPer(short petId, short exp, short level) {
        int nextExp = 0;
        int levelUp = CWACommon.isSMSCheck ? 3 : 2;
        nextExp = level >= 50 ? 37300 : 15 * level * level - 200;
        return exp * 100 / nextExp;
    }

    public int[] getBaseData() {
        int[] data = new int[9 + this.canUseSkillNum() * 2 + 1];
        data[0] = this.pId;
        data[1] = this.level;
        data[2] = this.getProp((byte)5);
        data[3] = this.getCurProp((byte)6);
        data[4] = this.getProp((byte)0);
        data[5] = this.isMutation;
        data[6] = this.getCurProp((byte)1);
        data[7] = this.exp;
        data[8] = this.battleTime;
        data[9] = this.canUseSkillNum();
        for (int i = 0; i < this.canUseSkillNum(); ++i) {
            data[10 + i] = this.curSkill[i];
            data[10 + data[9] + i] = this.skillPro[i];
        }
        return data;
    }

    public int[] getSkillData() {
        int[] data = new int[this.canUseSkillNum() * 2 + 1];
        data[0] = this.canUseSkillNum();
        for (int i = 0; i < this.canUseSkillNum(); ++i) {
            data[i + 1] = this.curSkill[i];
            data[data[0] + i + 1] = this.skillPro[i];
        }
        return data;
    }

    public int canEvolution() {
        if (this.getPetData((byte)19) == -1) {
            return 0;
        }
        if (CWADataManager.DataBase[0][this.getPetData((byte)19)][2] == 1) {
            return 1;
        }
        if (CWADataManager.DataBase[0][this.getPetData((byte)19)][2] == 2) {
            return 1;
        }
        if (CWADataManager.DataBase[0][this.getPetData((byte)19)][2] == 3) {
            return 2;
        }
        return 0;
    }

    public void useItem(int itemId) {
        short ahp = 0;
        short energy = 0;
        switch (CWADataManager.DataBase[4][itemId][5]) {
            case 1: {
                ahp = (short)(this.getProp((byte)1) * CWADataManager.DataBase[4][itemId][6] / 100 + CWADataManager.DataBase[4][itemId][7]);
                this.setPreHp(this.getCurProp((byte)1) + ahp);
                this.addHp(ahp);
                break;
            }
            case 2: {
                energy = CWADataManager.DataBase[4][itemId][6];
                this.addEnergy(energy);
                break;
            }
            case 3: {
                ahp = (short)(this.getProp((byte)1) * CWADataManager.DataBase[4][itemId][6] / 100 + CWADataManager.DataBase[4][itemId][7]);
                energy = CWADataManager.DataBase[4][itemId][8];
                this.setPreHp(this.getCurProp((byte)1) + ahp);
                this.addHp(ahp);
                this.addEnergy(energy);
                break;
            }
            case 4: {
                this.start();
                ahp = (short)(this.getProp((byte)1) * CWADataManager.DataBase[4][itemId][6] / 100 + CWADataManager.DataBase[4][itemId][7]);
                energy = CWADataManager.DataBase[4][itemId][8];
                this.setPreHp(ahp);
                this.addHp(ahp);
                this.addEnergy(energy);
                break;
            }
            case 5: {
                this.removeAllDebuf();
                break;
            }
            case 6: {
                this.setCurProp((byte)6, (short)2);
            }
        }
        GamePlayer.getInstance().removeItem(itemId, 1, (byte)0);
    }

    public int canUseItem(int index) {
        if (!this.canBattle() && CWADataManager.DataBase[4][index][5] != 4) {
            return 8;
        }
        switch (CWADataManager.DataBase[4][index][5]) {
            case 0: {
                return 6;
            }
            case 1: {
                if (this.getProp((byte)1) != this.getCurProp((byte)1)) break;
                return 2;
            }
            case 2: {
                int skillnum = this.canUseSkillNum();
                for (int i = 0; i < skillnum; ++i) {
                    if (this.skillPro[i] >= this.getSkillPro(this.curSkill[i], (byte)5)) continue;
                    return -1;
                }
                return 3;
            }
            case 3: {
                int statetemp = -1;
                if (this.getProp((byte)1) == this.getCurProp((byte)1) || !this.canBattle()) {
                    statetemp = 2;
                }
                int skillnum = this.canUseSkillNum();
                for (int i = 0; i < skillnum; ++i) {
                    if (this.skillPro[i] >= this.getSkillPro(this.curSkill[i], (byte)5)) continue;
                    return -1;
                }
                if (statetemp != 2) break;
                return 7;
            }
            case 4: {
                if (!this.canBattle()) break;
                return 1;
            }
            case 5: {
                for (int i = 0; i < this.debufArr.length; ++i) {
                    if (!this.findDebuf(i)) continue;
                    return -1;
                }
                return 4;
            }
            case 6: {
                if (this.getCurProp((byte)6) < 2) break;
                return 5;
            }
        }
        return -1;
    }

    public boolean canBattle() {
        return this.getCurProp((byte)1) > 0;
    }

    public byte isBane(GamePet target) {
        short atkPet = CWADataManager.DataBase[0][this.pId][1];
        short defPet = CWADataManager.DataBase[0][target.pId][1];
        short atkPetQu = CWADataManager.DataBase[0][this.pId][22];
        short defPetQu = CWADataManager.DataBase[0][target.pId][22];
        boolean atkb = false;
        boolean defb = false;
        if (atkPetQu == 2 && defPetQu == 2) {
            atkb = true;
            defb = true;
        } else if (atkPetQu == 2 && defPetQu != 2) {
            atkb = true;
        } else if (atkPetQu != 2 && defPetQu == 2) {
            defb = true;
        } else {
            atkb = true;
            defb = true;
        }
        if (atkb && (atkPet == 0 && defPet == 1 || atkPet == 1 && defPet == 2 || atkPet == 2 && defPet == 3 || atkPet == 3 && defPet == 0 || atkPet == 5 && defPet == 6 || atkPet == 6 && defPet == 4 || atkPet == 4 && defPet == 5)) {
            return 0;
        }
        if (defb && (defPet == 0 && atkPet == 1 || defPet == 1 && atkPet == 2 || defPet == 2 && atkPet == 3 || defPet == 3 && atkPet == 0 || defPet == 5 && atkPet == 6 || defPet == 6 && atkPet == 4 || defPet == 4 && atkPet == 5)) {
            return 1;
        }
        return -1;
    }

    public int[] calHarm(GamePet target) {
        int rand;
        int rand2;
        int bjFlag = 0;
        int bj = 5;
        int harm = this.getAttack();
        short dep = CWADataManager.DataBase[0][this.pId][1];
        if (this.sprIndex == GamePlayer.getInstance().pokPetMapArray[dep] + GamePlayer.getInstance().pokPetMapMaxNum[dep] - 1) {
            bj = 30;
        }
        bj += this.getCurProp((byte)4) / 2;
        if (this.isAdornItem((byte)4)) {
            bj += CWADataManager.DataBase[3][4][5];
        }
        if ((rand2 = CWATools.getRandom(100)) <= bj) {
            harm = harm * 3 / 2;
            bjFlag = 1;
        }
        if (this.isAdornItem((byte)0)) {
            if (this.getCurProp((byte)1) <= CWADataManager.DataBase[3][0][5] * this.getProp((byte)1) / 100) {
                harm = harm * (100 + CWADataManager.DataBase[3][0][6]) / 100;
            }
        } else if (this.isAdornItem((byte)1)) {
            harm = harm * (100 + CWADataManager.DataBase[3][1][5]) / 100;
        }
        byte debuf = (byte)CWADataManager.DataBase[1][this.curSkillId][7];
        short incr = -1;
        int tempHarm = harm;
        switch (this.curSkillId) {
            case 0: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 69: {
                harm = harm * CWADataManager.DataBase[1][this.curSkillId][3] / 100;
                break;
            }
            case 1: 
            case 7: {
                harm = harm * CWADataManager.DataBase[1][this.curSkillId][3] / 100 + harm / CWADataManager.DataBase[1][this.curSkillId][8];
                break;
            }
            case 2: 
            case 8: 
            case 22: 
            case 28: 
            case 41: 
            case 47: {
                harm = harm * CWADataManager.DataBase[1][this.curSkillId][3] / 100;
                incr = CWADataManager.DataBase[1][this.curSkillId][8];
                break;
            }
            case 3: 
            case 9: {
                if (target.findDebuf(0)) {
                    harm = harm * CWADataManager.DataBase[1][this.curSkillId][8] / 100;
                    break;
                }
                harm = harm * CWADataManager.DataBase[1][this.curSkillId][3] / 100;
                break;
            }
            case 23: 
            case 29: {
                if (target.findDebuf(1)) {
                    harm = harm * CWADataManager.DataBase[1][this.curSkillId][8] / 100;
                    break;
                }
                harm = harm * CWADataManager.DataBase[1][this.curSkillId][3] / 100;
                break;
            }
            case 43: 
            case 49: {
                harm = harm * CWADataManager.DataBase[1][this.curSkillId][3] / 100;
                target.removeAllbuf();
                break;
            }
            case 53: 
            case 59: {
                int perHp = this.getCurProp((byte)1) * 100 / this.getProp((byte)1);
                harm = harm * (CWADataManager.DataBase[1][this.curSkillId][8] - perHp) / 100;
                break;
            }
            default: {
                debuf = -1;
            }
        }
        if (tempHarm <= 0) {
            tempHarm = 1;
        }
        byte df = target.addDebuf(debuf, (short)tempHarm, this.curSkillId, incr);
        if (this.findBuf(0) && this.bufArr[0][0] == 0) {
            harm += this.bufArr[0][2];
        }
        if (this.findBuf(1)) {
            harm += harm * this.bufArr[1][2] / 100;
        }
        if (this.findDebuf(6)) {
            harm -= harm * this.debufArr[6][1] / 100;
        }
        if (target.findBuf(6) && (rand = CWATools.getRandom(100)) <= this.bufArr[6][1]) {
            harm = harm * this.bufArr[6][2] / 100;
        }
        if (this.findBuf(8)) {
            harm += harm * this.bufArr[8][1] / 100;
        }
        if (this.getActorEnemy() == 0 && GamePlayer.getInstance().getPokBadgeValue((byte)3, (byte)0) == 2 && GamePlayer.getInstance().getPokBadgeValue((byte)3, (byte)1) == 1 && GameWorld.battleArea == 2) {
            harm += harm * CWADataManager.DataBase[2][3][5] / 100;
        }
        if (this.getActorEnemy() == 0 && GamePlayer.getInstance().getPokBadgeValue((byte)6, (byte)0) == 2) {
            harm += harm * CWADataManager.DataBase[2][6][5] / 100;
        }
        if (this.isBane(target) == 0) {
            harm *= 3;
        } else if (this.isBane(target) == 1) {
            harm = harm * 60 / 100;
        }
        if (harm <= 0) {
            harm = 1;
        } else {
            int rd = CWATools.getRandom(100);
            int floatb = harm * 2 / 100;
            if (rd > 50) {
                if (floatb <= 0) {
                    ++harm;
                }
            } else if (floatb <= 0) {
                --harm;
            }
            if (harm <= 0) {
                harm = 1;
            }
        }
        if (target.findBuf(5) && (rand = CWATools.getRandom(100)) <= target.bufArr[5][1]) {
            this.value[5] = (short)harm;
            return new int[]{harm, bjFlag, df};
        }
        return new int[]{harm, bjFlag, df};
    }

    public String baneStr() {
        String[] str = new String[]{"\u6728\u7cfb", "\u571f\u7cfb", "\u6c34\u7cfb", "\u706b\u7cfb", "\u9b3c\u7cfb", "\u98ce\u7cfb", "\u7535\u7cfb"};
        short atkPet = CWADataManager.DataBase[0][this.pId][1];
        return str[atkPet];
    }

    public static String baneStr(int petId) {
        String[] str = new String[]{"\u6728\u7cfb", "\u571f\u7cfb", "\u6c34\u7cfb", "\u706b\u7cfb", "\u9b3c\u7cfb", "\u98ce\u7cfb", "\u7535\u7cfb"};
        short atkPet = CWADataManager.DataBase[0][petId][1];
        return str[atkPet];
    }
}

