/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAScreenChange;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwabase2d.CWACamera;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAMap;
import game.GameEvent;
import game.GameManager;
import game.GameNpc;
import game.GamePet;
import game.GameWorld;
import java.util.Vector;

public class GamePlayer
extends CWASprActor {
    private static GamePlayer _gameplayer;
    public static final int pokPetMax = 6;
    public static final int bankPetMax = 100;
    public static final int pokRidePetMax = 4;
    public static final int itemMax = 99;
    public int rideIndex;
    private int moveStance;
    private int moveCount;
    public byte isReloading;
    private int autoCount;
    private boolean isPassometer;
    public int passometer;
    public int passometerMin;
    public int passometerMax;
    public int passStep;
    public int avertStep;
    public boolean isInit;
    public GamePet[] pokPet;
    public int pokPetSize;
    public byte[][] pokBadge;
    public byte[][] pokPetMap;
    public byte[][] pokPetType;
    public byte[] pokPetNum;
    public byte pokPetTypeNum;
    public byte pokPetGodz;
    public byte pokPetRare;
    public byte hatchPetNum;
    public Vector pokConsumable;
    public Vector pokBall;
    public Vector pokAmulet;
    public Vector pokMatertal;
    public Vector pokSpecial;
    public Vector pokPetBank;
    public byte[] pokRidePet;
    public byte[] pokHavePet;
    public short[] hatchPet;
    public Vector saleItem;
    public boolean[] taskItem;
    public static boolean stepSand;
    public Vector getGold;
    private int gold;
    private int badge;
    public int[] pokPetMapArray = new int[]{0, 16, 32, 48, 64, 76, 88};
    public int[] pokPetMapMaxNum = new int[]{16, 16, 16, 16, 12, 12, 12};
    public static byte[][] trapSand;
    public static short[][] trapSandPos;
    public Vector npcBomb = null;

    public static GamePlayer getInstance() {
        if (_gameplayer == null) {
            _gameplayer = new GamePlayer();
        }
        return _gameplayer;
    }

    public void delete() {
        this.pokPetSize = 0;
        _gameplayer = null;
    }

    public GamePlayer() {
        int i;
        this.baseProp = new short[3];
        this.curProp = new short[3];
        this.pokPet = new GamePet[6];
        this.pokBadge = new byte[8][2];
        this.taskItem = new boolean[21];
        this.pokConsumable = new Vector();
        this.pokBall = new Vector();
        int[] temp = new int[]{0, 0, 1};
        this.pokBall.addElement(temp);
        this.pokAmulet = new Vector();
        this.pokMatertal = new Vector();
        this.pokSpecial = new Vector();
        this.pokPetBank = new Vector();
        this.getGold = new Vector();
        this.pokPetMap = new byte[7][];
        this.pokPetNum = new byte[7];
        this.pokPetType = new byte[7][];
        this.hatchPet = new short[]{-1, -1, -1, -1, -1};
        for (i = 0; i < this.pokPetType.length; ++i) {
            this.pokPetType[i] = new byte[this.pokPetMapMaxNum[i]];
            for (int j = 0; j < this.pokPetType[i].length; ++j) {
                this.pokPetType[i][j] = -1;
            }
        }
        this.pokPetMap[0] = new byte[16];
        this.pokPetMap[1] = new byte[16];
        this.pokPetMap[2] = new byte[16];
        this.pokPetMap[3] = new byte[16];
        this.pokPetMap[4] = new byte[12];
        this.pokPetMap[5] = new byte[12];
        this.pokPetMap[6] = new byte[12];
        this.pokRidePet = new byte[4];
        this.pokHavePet = new byte[4];
        this.isReloading = 0;
        for (i = 0; i < 8; ++i) {
            this.pokBadge[i][0] = 0;
            this.pokBadge[i][1] = 0;
        }
        for (i = 0; i < 4; ++i) {
            this.pokRidePet[i] = 0;
        }
        this.gold = 1000;
        this.badge = 0;
        this.rideIndex = -1;
        this.isInit = false;
    }

    public void init(short[] data) {
        if (this.rideIndex == -1) {
            this.initSprite(0, false);
        }
        this.ridePet(this.rideIndex);
        this.reCallImage();
        this.actorX = data[0];
        this.actorY = data[1];
        this.setState((byte)0, (byte)data[2]);
        this.setProp((byte)0, data[3]);
        this.setProp((byte)1, data[4]);
        this.setProp((byte)2, data[5]);
        if (this.rideIndex == -1) {
            this.resetCurProp();
        }
        this.layer = 1;
        this.passometerMin = data[6];
        this.passometerMax = data[7];
        this.passometer = this.getPassometer();
        if (this.isReloading == 1) {
            this.changeImage(0, 107, true);
        }
        if (this.shadowActor == null) {
            this.shadowActor = new CWASprActor();
            this.shadowActor.initSprite(337, false);
        }
        this.shadowActor.setPosition(this.actorX, this.actorY);
        if (this.sprite.sprIndex == 4) {
            this.shadowActor.setAction((byte)0, (byte)0, false);
        } else {
            this.shadowActor.setAction((byte)1, (byte)0, false);
        }
        this.shadowActor.start();
        this.setTarget(null);
        this.isInit = true;
    }

    public boolean flyIsMapBorder(int actorX, int actorY) {
        switch (this.faceDir) {
            case 2: {
                return CWAMap.getInstance().isMapBorder(actorX, actorY - 25 - this.moveStance);
            }
            case 0: {
                return CWAMap.getInstance().isMapBorder(actorX, actorY - 25 + this.moveStance);
            }
            case 3: {
                return CWAMap.getInstance().isMapBorder(actorX - this.moveStance, actorY - 25);
            }
            case 1: {
                return CWAMap.getInstance().isMapBorder(actorX + this.moveStance, actorY - 25);
            }
        }
        return false;
    }

    public void update() {
        if (this.isFollow() && this.target.getRoleState() != 0) {
            this.followTarget(((CWASprActor)this.target).sprite, this.sprite);
        } else {
            switch (this.roleState) {
                case 0: {
                    if (this.pokRidePet[2] == 2 || !this.canWater()) break;
                    this.setState((byte)3, this.faceDir);
                    break;
                }
                case 1: {
                    if (this.pokRidePet[2] == 2) {
                        if (this.flyIsMapBorder(this.actorX, this.actorY)) break;
                        GameWorld.collNpc = this.checkCollNpc();
                        this.setTarget(null);
                        for (int i = 0; i < GameWorld.getInstance().npc.length; ++i) {
                            this.checkCollItem(i);
                        }
                        this.move(this.getCurProp((byte)0));
                        this.moveCount = this.moveCount < 8 ? (this.moveCount += this.getCurProp((byte)0)) : 4;
                        this.passometerUpdate();
                        break;
                    }
                    GameWorld.collNpc = this.checkCollNpc();
                    if (this.checkCollNPC() && this.checkCollMap()) {
                        this.move(this.moveStance);
                        this.moveCount = this.moveCount < 8 ? (this.moveCount += this.moveStance) : 4;
                        this.passometerUpdate();
                        break;
                    }
                    this.moveCount = 0;
                    break;
                }
                case 2: {
                    if (this.checkCollNPC() && this.checkCollMap()) {
                        this.move(this.moveStance);
                        this.moveCount = this.moveCount < 8 ? (this.moveCount += this.moveStance) : 4;
                        this.passometerUpdate();
                        break;
                    }
                    this.moveCount = 0;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    int i;
                    if (this.autoCount < 16) {
                        switch (this.preFaceDir) {
                            case 1: 
                            case 3: {
                                if (this.preFaceDir == 3) {
                                    if (this.actorX > this.target.getActorX()) {
                                        this.move(this.preFaceDir, 4);
                                    }
                                } else if (this.actorX < this.target.getActorX()) {
                                    this.move(this.preFaceDir, 4);
                                }
                                if (this.preY > this.target.getActorY() - 16) {
                                    if (this.actorY <= this.target.getActorY() - 16) {
                                        this.setPositionY(this.target.getActorY() - 16);
                                        break;
                                    }
                                    this.move(2, 4);
                                    break;
                                }
                                if (this.preY >= this.target.getActorY() - 16) break;
                                if (this.actorY >= this.target.getActorY() - 16) {
                                    this.setPositionY(this.target.getActorY() - 16);
                                    break;
                                }
                                this.move(0, 4);
                                break;
                            }
                            case 0: 
                            case 2: {
                                if (this.preFaceDir == 2) {
                                    if (this.actorY > this.target.getActorY() - 16) {
                                        this.move(this.preFaceDir, 4);
                                    }
                                } else if (this.actorY < this.target.getActorY() - 16) {
                                    this.move(this.preFaceDir, 4);
                                }
                                if (this.preX > this.target.getActorX()) {
                                    if (this.actorX <= this.target.getActorX()) {
                                        this.setPositionX(this.target.getActorX());
                                        break;
                                    }
                                    this.move(3, 4);
                                    break;
                                }
                                if (this.preX >= this.target.getActorX()) break;
                                if (this.actorX >= this.target.getActorX()) {
                                    this.setPositionX(this.target.getActorX());
                                    break;
                                }
                                this.move(1, 4);
                            }
                        }
                        if (this.autoCount % 4 == 3) {
                            this.setAction((byte)1, (byte)-1, false);
                        } else {
                            this.setAction((byte)(this.autoCount % 4), (byte)-1, false);
                        }
                        this.setActorDir((byte)(this.autoCount % 4));
                        ++this.autoCount;
                        break;
                    }
                    int index = 0;
                    for (i = 0; i < trapSand.length; ++i) {
                        if (GameWorld.getInstance().sceneId != trapSand[i][0] || GameWorld.getInstance().roomId != trapSand[i][1]) continue;
                        GameWorld.getInstance().sceneId = trapSand[i][2];
                        GameWorld.getInstance().roomId = trapSand[i][3];
                        index = trapSand[i][4];
                        break;
                    }
                    for (i = 0; i < trapSandPos[index].length / 4; ++i) {
                        if (((GameNpc)this.target).npcId < trapSandPos[index][i * 4] || ((GameNpc)this.target).npcId > trapSandPos[index][i * 4 + 1]) continue;
                        GameWorld.getInstance().playerX = trapSandPos[index][i * 4 + 2];
                        GameWorld.getInstance().playerY = trapSandPos[index][i * 4 + 3];
                        break;
                    }
                    stepSand = true;
                    GameWorld.getInstance().doorId = -1;
                    GameManager.getInstance().setState((byte)9);
                    break;
                }
                case 6: {
                    if (this.canSlide()) {
                        this.move(this.getProp((byte)2));
                        break;
                    }
                    this.move(this.getCurProp((byte)1));
                    this.setState((byte)0, this.faceDir);
                    break;
                }
                case 7: {
                    if (((GameNpc)this.target).isStandPlayer == 0) {
                        if (this.autoCount < 7) {
                            this.move(4);
                            ++this.autoCount;
                            break;
                        }
                        if (this.autoCount != 7) break;
                        if (this.faceDir == 3) {
                            this.setAction((byte)1, (byte)-1, false);
                        } else {
                            this.setAction(this.faceDir, (byte)-1, false);
                        }
                        this.setActorDir(this.faceDir);
                        ((GameNpc)this.target).standNpcOn();
                        ++this.autoCount;
                        break;
                    }
                    if (((GameNpc)this.target).isStandPlayer != 2) break;
                    if (this.autoCount < 8 && this.autoCount > 0) {
                        this.move(4);
                        --this.autoCount;
                        break;
                    }
                    if (this.autoCount == 8) {
                        this.setState((byte)7, this.faceDir);
                        --this.autoCount;
                        break;
                    }
                    ((GameNpc)this.target).isStandPlayer = 0;
                    ((GameNpc)this.target).setTarget(null);
                    this.setTarget(null);
                    this.setState((byte)0, this.faceDir);
                    break;
                }
                case 8: {
                    if (this.autoCount < 16) {
                        if (this.autoCount % 4 == 3) {
                            this.setAction((byte)1, (byte)-1, false);
                        } else {
                            this.setAction((byte)(this.autoCount % 4), (byte)-1, false);
                        }
                        this.setActorDir((byte)(this.autoCount % 4));
                        ++this.autoCount;
                        break;
                    }
                    int x = GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorX - GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorX % this.getProp((byte)2);
                    int y = GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorY - GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorY % this.getProp((byte)2);
                    this.setPosition(x, y);
                    this.shadowActor.setPosition(x, y);
                    this.setState((byte)0, GameWorld.getInstance().npc[GameWorld.getInstance().doorId].playerDirection);
                    this.move(32);
                    CWACamera.getInstance().setSpeed(8);
                    CWACamera.getInstance().setArrive(false);
                    break;
                }
                case 9: {
                    if (this.autoCount < 16) {
                        if (this.autoCount % 4 == 3) {
                            this.setAction((byte)1, (byte)-1, false);
                        } else {
                            this.setAction((byte)(this.autoCount % 4), (byte)-1, false);
                        }
                        this.setActorDir((byte)(this.autoCount % 4));
                        ++this.autoCount;
                        break;
                    }
                    int x = GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorX - GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorX % this.getProp((byte)2);
                    int y = GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorY - GameWorld.getInstance().npc[GameWorld.getInstance().doorId].actorY % this.getProp((byte)2);
                    this.setPosition(x, y);
                    this.shadowActor.setPosition(x, y);
                    this.setState((byte)10, this.faceDir);
                    CWACamera.getInstance().setSpeed(8);
                    CWACamera.getInstance().setArrive(false);
                    break;
                }
                case 10: {
                    if (this.autoCount > 0) {
                        if (this.autoCount % 4 == 3) {
                            this.setAction((byte)1, (byte)-1, false);
                        } else {
                            this.setAction((byte)(this.autoCount % 4), (byte)-1, false);
                        }
                        this.setActorDir((byte)(this.autoCount % 4));
                        --this.autoCount;
                        break;
                    }
                    this.setState((byte)0, GameWorld.getInstance().npc[GameWorld.getInstance().doorId].playerDirection);
                    this.move(32);
                }
            }
        }
    }

    public boolean playerRotate() {
        if (this.autoCount < 16) {
            if (this.autoCount % 4 == 3) {
                this.setAction((byte)1, (byte)-1, false);
            } else {
                this.setAction((byte)(this.autoCount % 4), (byte)-1, false);
            }
            this.setActorDir((byte)(this.autoCount % 4));
            ++this.autoCount;
        } else {
            this.autoCount = 0;
            return true;
        }
        return false;
    }

    public void setState(byte state, byte face) {
        this.preRoleState = this.roleState;
        switch (state) {
            case 0: {
                if (this.pokRidePet[2] != 2 && this.canWater()) {
                    this.setState((byte)3, face);
                    return;
                }
                if (face == 3) {
                    this.setAction((byte)1, (byte)-1, false);
                } else {
                    this.setAction(face, (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 1: {
                if (this.pokRidePet[2] != 2 && this.canWater()) {
                    this.setState((byte)2, face);
                    return;
                }
                if (this.getAction() < 6) {
                    if (face == 3) {
                        this.setAction((byte)4, (byte)-1, face);
                        break;
                    }
                    this.setAction((byte)(3 + face), (byte)-1, face);
                    break;
                }
                if (face == 3) {
                    this.setAction((byte)(state * 3 + 1), (byte)-1, false);
                } else {
                    this.setAction((byte)(state * 3 + face), (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 2: {
                if (this.canWater()) {
                    if (this.getAction() < 9) {
                        if (face == 3) {
                            this.setAction((byte)7, (byte)-1, face);
                        } else {
                            this.setAction((byte)(6 + face), (byte)-1, face);
                        }
                    } else if (face == 3) {
                        this.setAction((byte)(state * 3 + 1), (byte)-1, false);
                    } else {
                        this.setAction((byte)(state * 3 + face), (byte)-1, false);
                    }
                } else if (face == 3) {
                    this.setAction((byte)(this.roleState * 3 + 1), (byte)-1, false);
                } else {
                    this.setAction((byte)(this.roleState * 3 + face), (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 3: {
                if (face == 3) {
                    this.setAction((byte)(state * 3 + 1), (byte)-1, false);
                } else {
                    this.setAction((byte)(state * 3 + face), (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 4: {
                this.setAction((byte)(state * 3), (byte)-2, false);
                this.setActorDir(face);
                this.moveCount = 0;
                break;
            }
            case 5: {
                this.autoCount = 0;
                this.setPreActorDir(face);
                this.setPrePosition(this.actorX, this.actorY);
                if (face == 3) {
                    this.setAction((byte)1, (byte)-1, false);
                } else {
                    this.setAction(face, (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 6: {
                if (face == 3) {
                    this.setAction((byte)1, (byte)-1, false);
                } else {
                    this.setAction(face, (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 7: {
                if (face == 3) {
                    this.setAction((byte)4, (byte)-1, false);
                } else {
                    this.setAction((byte)(3 + face), (byte)-1, false);
                }
                this.setActorDir(face);
                break;
            }
            case 8: 
            case 9: {
                this.autoCount = 0;
                this.setActorDir(face);
            }
        }
        this.roleState = state;
        if (this.roleState == 0 || this.roleState == 1) {
            if (GameWorld.getInstance().followSp != null) {
                GameWorld.getInstance().followSp.setAction(true);
            }
        } else if (GameWorld.getInstance().followSp != null) {
            GameWorld.getInstance().followSp.setAction(false);
        }
    }

    public boolean haveRidePet(int n) {
        if (this.pokRidePet[n] == 0) {
            return true;
        }
        return true;
    }

    public boolean canRidePet(int n) {
        if (this.pokHavePet[n] == 1) {
            return true;
        }
        return true;
    }

    public boolean canDownPet() {
        return this.rideIndex != 2 || CWAMap.getInstance().getMapTile(0, this.actorX + 7, this.actorY + 7) == 0 && CWAMap.getInstance().getMapTile(0, this.actorX - 8, this.actorY - 8) == 0;
    }

    public void ridePet(int index) {
        if (index == -1) {
            return;
        }
        this.pokRidePet[index] = 2;
        this.sprite.releaseSprite(11);
        this.initSprite(1 + index, false);
        this.reCallImage();
        if (this.isReloading == 1) {
            this.changeImage(1, 107, true);
        }
        this.setState((byte)0, this.faceDir);
        if (this.pokRidePet[index] == 2 && index == 0 || this.pokRidePet[index] == 2 && index == 1) {
            this.setCurProp((byte)0, (short)8);
        } else {
            this.setCurProp((byte)0, (short)4);
        }
        if (this.pokRidePet[2] == 2 && GameWorld.getInstance().followSp != null) {
            GameWorld.getInstance().followSp.stop();
        }
        this.moveStance = this.getCurProp((byte)0);
        this.rideIndex = index;
    }

    public void downPet() {
        this.sprite.releaseSprite(10);
        this.initSprite(0, false);
        this.reCallImage();
        for (int i = 0; i < 4; ++i) {
            if (this.pokRidePet[i] != 2) continue;
            this.pokRidePet[i] = 1;
        }
        if (this.isReloading == 1) {
            this.changeImage(0, 107, true);
        }
        if (GameWorld.getInstance().followSp != null) {
            GameWorld.getInstance().followSp.start();
        }
        this.setCurProp((byte)0, this.getProp((byte)0));
        this.rideIndex = -1;
    }

    public void reloading() {
        this.isReloading = 1;
        boolean isRide = false;
        for (int i = 0; i < 4; ++i) {
            if (this.pokRidePet[i] != 2) continue;
            isRide = true;
            break;
        }
        if (isRide) {
            this.changeImage(1, 107, true);
        } else {
            this.changeImage(0, 107, true);
        }
    }

    public void strip() {
        this.isReloading = 0;
        boolean isRide = false;
        for (int i = 0; i < 4; ++i) {
            if (this.pokRidePet[i] != 2) continue;
            isRide = true;
            break;
        }
        if (isRide) {
            this.changeImage(1, 100, true);
        } else {
            this.changeImage(0, 100, true);
        }
    }

    public short checkCollNpc() {
        for (short i = 0; i < GameWorld.getInstance().npc.length; i = (short)((short)(i + 1))) {
            if (!GameWorld.getInstance().npc[i].isVisible() || GameWorld.getInstance().npc[i].sprite.sprIndex > 85 && GameWorld.getInstance().npc[i].sprite.sprIndex != 226 && GameWorld.getInstance().npc[i].sprite.sprIndex != 92 && GameWorld.getInstance().npc[i].sprite.sprIndex != 102 && GameWorld.getInstance().npc[i].sprite.sprIndex != 137 || GameWorld.getInstance().npc[i].actorType != 0 || GameWorld.getInstance().npc[i].npcType != 1 && GameWorld.getInstance().npc[i].npcType != 18 || !this.canCollNpc(GameWorld.getInstance().npc[i], this.sprite.getbeattData(), GameWorld.getInstance().npc[i].sprite.getbeattData())) continue;
            if (GameWorld.getInstance().npc[i].getBqType() == 0) {
                GameWorld.getInstance().setBq((byte)13, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY - 40, GameWorld.getInstance().npc[i]);
                if (GameWorld.getInstance().npc[i].bqSprite != null) {
                    GameWorld.getInstance().npc[i].bqSprite.stop();
                }
            } else if (GameWorld.getInstance().npc[i].getBqType() == 1) {
                GameWorld.getInstance().setBq((byte)13, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY - 40, GameWorld.getInstance().npc[i]);
                if (GameEvent.taskVector != null && GameEvent.taskVector.size() > 0) {
                    for (int j = 0; j < GameEvent.taskVector.size(); ++j) {
                        if (!((CWASprActor)GameEvent.taskVector.elementAt((int)j)).target.equals(GameWorld.getInstance().npc[i])) continue;
                        ((CWASprActor)GameEvent.taskVector.elementAt(j)).stop();
                        break;
                    }
                }
            } else {
                GameWorld.getInstance().setBq((byte)13, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY - 40, GameWorld.getInstance().npc[i]);
                if (GameWorld.getInstance().npc[i].smilies != 0) {
                    GameWorld.getInstance().npc[i].bqStop();
                }
            }
            return i;
        }
        GameWorld.getInstance().removeBq(1);
        GameEvent.eventTalk = false;
        return -1;
    }

    public boolean checkCollItem(int i) {
        switch (GameWorld.getInstance().npc[i].actorType) {
            case 3: {
                short[] beatArea = GameWorld.getInstance().npc[i].sprite.getbeattData();
                short x = beatArea[0];
                short y = beatArea[1];
                short w = (short)(beatArea[2] + 16);
                short h = (short)(beatArea[3] + 16);
                if (!GameWorld.getInstance().npc[i].isColl || !this.canCollNpc(GameWorld.getInstance().npc[i], this.sprite.getbeattData(), new short[]{x, y, w, h})) break;
                this.setTarget(GameWorld.getInstance().npc[i]);
            }
        }
        return true;
    }

    public boolean checkCollNPC() {
        this.setTarget(null);
        boolean coll = true;
        if (this.npcBomb != null) {
            this.npcBomb.removeAllElements();
        }
        block24: for (int i = 0; i < GameWorld.getInstance().npc.length; ++i) {
            this.checkCollItem(i);
            if (!GameWorld.getInstance().npc[i].isColl || !this.canCollNpc(GameWorld.getInstance().npc[i], this.sprite.getbeattData(), GameWorld.getInstance().npc[i].sprite.getbeattData())) continue;
            switch (GameWorld.getInstance().npc[i].actorType) {
                case 0: {
                    switch (GameWorld.getInstance().npc[i].npcType) {
                        case 0: {
                            return false;
                        }
                        case 4: 
                        case 11: {
                            if (GameWorld.getInstance().npc[i].getRoleState() == 2 || !GameWorld.getInstance().npc[i].isVisible()) break;
                            this.setTarget(GameWorld.getInstance().npc[i]);
                            return false;
                        }
                        case 5: {
                            if (GameWorld.getInstance().npc[i].getRoleState() != 2) {
                                if (this.pokBadge[5][0] == 2) {
                                    this.setTarget(GameWorld.getInstance().npc[i]);
                                }
                                return false;
                            }
                        }
                        case 6: {
                            if (GameWorld.getInstance().npc[i].getRoleState() == 2) break;
                            if (this.pokRidePet[3] != 2) {
                                if (this.pokBadge[2][0] == 2) {
                                    this.setTarget(GameWorld.getInstance().npc[i]);
                                    if (this.npcBomb == null) {
                                        this.npcBomb = new Vector();
                                    }
                                    this.npcBomb.addElement(GameWorld.getInstance().npc[i]);
                                    GameWorld.getInstance().npc[i].initTip(20);
                                }
                                coll = false;
                                break;
                            }
                            GameWorld.getInstance().npc[i].setState((byte)1);
                            GameWorld.getInstance().world.changeActorLayer(GameWorld.getInstance().npc[i], 2);
                            break;
                        }
                        case 15: {
                            if (GameWorld.getInstance().npc[i].getRoleState() == 2) break;
                            if (this.taskItem[6]) {
                                this.setTarget(GameWorld.getInstance().npc[i]);
                                return false;
                            }
                            GameWorld.getInstance().npc[i].setState((byte)1);
                            GameWorld.getInstance().world.changeActorLayer(GameWorld.getInstance().npc[i], 2);
                            break;
                        }
                        case 7: {
                            if (GameWorld.getInstance().npc[i].getRoleState() == 2) break;
                            if (this.pokRidePet[3] != 2) {
                                if (this.pokBadge[1][0] == 2) {
                                    this.setTarget(GameWorld.getInstance().npc[i]);
                                    if (this.npcBomb == null) {
                                        this.npcBomb = new Vector();
                                    }
                                    this.npcBomb.addElement(GameWorld.getInstance().npc[i]);
                                    GameWorld.getInstance().npc[i].initTip(30);
                                }
                                coll = false;
                                break;
                            }
                            GameWorld.getInstance().npc[i].setState((byte)1);
                            GameWorld.getInstance().world.changeActorLayer(GameWorld.getInstance().npc[i], 2);
                            break;
                        }
                        case 8: {
                            if (!GameWorld.getInstance().npc[i].isVisible()) break;
                            if ((GameNpc)GameWorld.getInstance().npc[i].target != null && ((GameNpc)GameWorld.getInstance().npc[i].target).templaserArea > ((GameNpc)GameWorld.getInstance().npc[i].target).laserArea) {
                                return false;
                            }
                            block25: for (int j = 0; j < GameWorld.getInstance().npc.length; ++j) {
                                if (!GameWorld.getInstance().npc[j].isColl || GameWorld.getInstance().npc[j].equals(GameWorld.getInstance().npc[i]) || GameWorld.getInstance().npc[j].actorType != 0 || GameWorld.getInstance().npc[j].npcType != 8 && GameWorld.getInstance().npc[j].npcType != 11) continue;
                                switch (this.faceDir) {
                                    case 2: {
                                        if (!CWATools.isCollides(GameWorld.getInstance().npc[i].getActorX(), GameWorld.getInstance().npc[i].getActorY() - 8, GameWorld.getInstance().npc[j].getActorX(), GameWorld.getInstance().npc[j].getActorY(), GameWorld.getInstance().npc[i].sprite.getbeattData(), GameWorld.getInstance().npc[j].sprite.getbeattData())) continue block25;
                                        return false;
                                    }
                                    case 0: {
                                        if (!CWATools.isCollides(GameWorld.getInstance().npc[i].getActorX(), GameWorld.getInstance().npc[i].getActorY() + 8, GameWorld.getInstance().npc[j].getActorX(), GameWorld.getInstance().npc[j].getActorY(), GameWorld.getInstance().npc[i].sprite.getbeattData(), GameWorld.getInstance().npc[j].sprite.getbeattData())) continue block25;
                                        return false;
                                    }
                                    case 3: {
                                        if (!CWATools.isCollides(GameWorld.getInstance().npc[i].getActorX() - 8, GameWorld.getInstance().npc[i].getActorY(), GameWorld.getInstance().npc[j].getActorX(), GameWorld.getInstance().npc[j].getActorY(), GameWorld.getInstance().npc[i].sprite.getbeattData(), GameWorld.getInstance().npc[j].sprite.getbeattData())) continue block25;
                                        return false;
                                    }
                                    case 1: {
                                        if (!CWATools.isCollides(GameWorld.getInstance().npc[i].getActorX() + 8, GameWorld.getInstance().npc[i].getActorY(), GameWorld.getInstance().npc[j].getActorX(), GameWorld.getInstance().npc[j].getActorY(), GameWorld.getInstance().npc[i].sprite.getbeattData(), GameWorld.getInstance().npc[j].sprite.getbeattData())) continue block25;
                                        return false;
                                    }
                                }
                            }
                            GameWorld.getInstance().npc[i].setState((byte)1);
                            GameWorld.getInstance().npc[i].setActorDir(this.faceDir);
                            return false;
                        }
                        case 9: {
                            if (CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 2 || CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 1) {
                                return false;
                            }
                            if (this.faceDir != 3 && this.faceDir != 1) break;
                            this.autoCount = 0;
                            this.setState((byte)7, this.faceDir);
                            GameWorld.getInstance().npc[i].setTarget(this);
                            this.setTarget(GameWorld.getInstance().npc[i]);
                            return false;
                        }
                        case 10: {
                            if (CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 2 || CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 1) {
                                return false;
                            }
                            if (this.faceDir != 0 && this.faceDir != 2) break;
                            this.autoCount = 0;
                            this.setState((byte)7, this.faceDir);
                            GameWorld.getInstance().npc[i].setTarget(this);
                            this.setTarget(GameWorld.getInstance().npc[i]);
                            return false;
                        }
                        case 14: {
                            return false;
                        }
                        case 16: {
                            this.setTarget(GameWorld.getInstance().npc[i]);
                        }
                    }
                    continue block24;
                }
                case 3: {
                    return false;
                }
                case 1: {
                    if (GameWorld.getInstance().npc[i].npcType != 3) continue block24;
                    return false;
                }
            }
        }
        return coll;
    }

    public boolean checkCollMap() {
        this.moveStance = this.getCurProp((byte)0);
        int leftX = this.actorX - 8;
        int topY = this.actorY - 8;
        int rightX = this.actorX + 7;
        int downY = this.actorY + 7;
        byte[] tile = new byte[]{-1, -1, -1, -1, -1};
        switch (this.faceDir) {
            case 2: {
                if (CWAMap.getInstance().isMapBorder(this.actorX, topY - this.moveStance)) {
                    return false;
                }
                tile[0] = CWAMap.getInstance().getMapTile(0, leftX, topY - this.moveStance);
                tile[1] = CWAMap.getInstance().getMapTile(0, rightX, topY - this.moveStance);
                tile[2] = CWAMap.getInstance().getMapTile(0, this.actorX, topY - this.moveStance);
                if (!this.canMove(tile[0]) && !this.canMove(tile[1])) {
                    if (CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 3) {
                        return false;
                    }
                    tile[0] = CWAMap.getInstance().getMapTile(0, this.actorX - 16, topY - this.moveStance);
                    tile[1] = CWAMap.getInstance().getMapTile(0, this.actorX + 16, topY - this.moveStance);
                    tile[3] = CWAMap.getInstance().getMapTile(0, this.actorX - 16, this.actorY);
                    tile[4] = CWAMap.getInstance().getMapTile(0, this.actorX + 16, this.actorY);
                    this.moveStance = this.getCurProp((byte)1);
                    if (!this.canMove(tile[0])) {
                        return this.tileWork(tile[1], (byte)1);
                    }
                    if (!this.canMove(tile[1])) {
                        return this.tileWork(tile[0], (byte)3);
                    }
                    if (this.canMove(tile[4])) {
                        return this.tileWork(tile[1], (byte)1);
                    }
                    if (this.canMove(tile[3])) {
                        return this.tileWork(tile[0], (byte)3);
                    }
                } else {
                    if (!this.canMove(tile[0])) {
                        this.moveStance = this.getCurProp((byte)1);
                        return this.tileWork(tile[1], (byte)1);
                    }
                    if (!this.canMove(tile[1])) {
                        this.moveStance = this.getCurProp((byte)1);
                        return this.tileWork(tile[0], (byte)3);
                    }
                    return this.tileWork(tile[2], (byte)2);
                }
            }
            case 0: {
                if (CWAMap.getInstance().isMapBorder(this.actorX, downY + this.moveStance)) {
                    return false;
                }
                tile[0] = CWAMap.getInstance().getMapTile(0, leftX, downY + this.moveStance);
                tile[1] = CWAMap.getInstance().getMapTile(0, rightX, downY + this.moveStance);
                tile[2] = CWAMap.getInstance().getMapTile(0, this.actorX, downY + this.moveStance);
                if (!this.canMove(tile[0]) && !this.canMove(tile[1])) {
                    if (CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 3) {
                        return false;
                    }
                    tile[0] = CWAMap.getInstance().getMapTile(0, leftX - 16, downY + this.moveStance);
                    tile[1] = CWAMap.getInstance().getMapTile(0, rightX + 16, downY + this.moveStance);
                    tile[3] = CWAMap.getInstance().getMapTile(0, this.actorX - 16, this.actorY);
                    tile[4] = CWAMap.getInstance().getMapTile(0, this.actorX + 16, this.actorY);
                    this.moveStance = this.getCurProp((byte)1);
                    if (!this.canMove(tile[0])) {
                        return this.tileWork(tile[1], (byte)1);
                    }
                    if (!this.canMove(tile[1])) {
                        return this.tileWork(tile[0], (byte)3);
                    }
                    if (this.canMove(tile[4])) {
                        return this.tileWork(tile[1], (byte)1);
                    }
                    if (this.canMove(tile[3])) {
                        return this.tileWork(tile[0], (byte)3);
                    }
                } else {
                    if (!this.canMove(tile[0])) {
                        this.moveStance = this.getCurProp((byte)1);
                        return this.tileWork(tile[1], (byte)1);
                    }
                    if (!this.canMove(tile[1])) {
                        this.moveStance = this.getCurProp((byte)1);
                        return this.tileWork(tile[0], (byte)3);
                    }
                    return this.tileWork(tile[2], (byte)0);
                }
            }
            case 3: {
                if (CWAMap.getInstance().isMapBorder(leftX - this.moveStance, this.actorY)) {
                    return false;
                }
                tile[0] = CWAMap.getInstance().getMapTile(0, leftX - this.moveStance, topY);
                tile[1] = CWAMap.getInstance().getMapTile(0, leftX - this.moveStance, downY);
                tile[2] = CWAMap.getInstance().getMapTile(0, leftX - this.moveStance, this.actorY);
                if (!this.canMove(tile[0]) && !this.canMove(tile[1])) {
                    if (CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 3) {
                        return false;
                    }
                    tile[0] = CWAMap.getInstance().getMapTile(0, leftX - this.moveStance, topY - 16);
                    tile[1] = CWAMap.getInstance().getMapTile(0, leftX - this.moveStance, downY + 16);
                    tile[3] = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - 16);
                    tile[4] = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + 16);
                    this.moveStance = this.getCurProp((byte)1);
                    if (!this.canMove(tile[0])) {
                        return this.tileWork(tile[1], (byte)0);
                    }
                    if (!this.canMove(tile[1])) {
                        return this.tileWork(tile[0], (byte)2);
                    }
                    if (this.canMove(tile[4])) {
                        return this.tileWork(tile[1], (byte)0);
                    }
                    if (this.canMove(tile[3])) {
                        return this.tileWork(tile[0], (byte)2);
                    }
                } else {
                    if (!this.canMove(tile[0])) {
                        this.moveStance = this.getCurProp((byte)1);
                        return this.tileWork(tile[1], (byte)0);
                    }
                    if (!this.canMove(tile[1])) {
                        this.moveStance = this.getCurProp((byte)1);
                        return this.tileWork(tile[0], (byte)2);
                    }
                    return this.tileWork(tile[2], (byte)3);
                }
            }
            case 1: {
                if (CWAMap.getInstance().isMapBorder(rightX + this.moveStance, this.actorY)) {
                    return false;
                }
                tile[0] = CWAMap.getInstance().getMapTile(0, rightX + this.moveStance, topY);
                tile[1] = CWAMap.getInstance().getMapTile(0, rightX + this.moveStance, downY);
                tile[2] = CWAMap.getInstance().getMapTile(0, rightX + this.moveStance, this.actorY);
                if (!this.canMove(tile[0]) && !this.canMove(tile[1])) {
                    if (CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) == 3) {
                        return false;
                    }
                    tile[0] = CWAMap.getInstance().getMapTile(0, rightX + this.moveStance, topY - 16);
                    tile[1] = CWAMap.getInstance().getMapTile(0, rightX + this.moveStance, downY + 16);
                    tile[3] = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - 16);
                    tile[4] = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + 16);
                    this.moveStance = this.getCurProp((byte)1);
                    if (!this.canMove(tile[0])) {
                        return this.tileWork(tile[1], (byte)0);
                    }
                    if (!this.canMove(tile[1])) {
                        return this.tileWork(tile[0], (byte)2);
                    }
                    if (this.canMove(tile[4])) {
                        return this.tileWork(tile[1], (byte)0);
                    }
                    if (!this.canMove(tile[3])) break;
                    return this.tileWork(tile[0], (byte)2);
                }
                if (!this.canMove(tile[0])) {
                    this.moveStance = this.getCurProp((byte)1);
                    return this.tileWork(tile[1], (byte)0);
                }
                if (!this.canMove(tile[1])) {
                    this.moveStance = this.getCurProp((byte)1);
                    return this.tileWork(tile[0], (byte)2);
                }
                return this.tileWork(tile[2], (byte)1);
            }
        }
        return true;
    }

    public boolean canMove(byte tile) {
        switch (tile) {
            case 1: {
                return false;
            }
            case 2: {
                return this.pokBadge[3][0] == 2;
            }
        }
        return true;
    }

    public boolean canCollNpc(GameNpc npc, short[] myDate, short[] npcData) {
        if (npcData == null) {
            return false;
        }
        switch (this.faceDir) {
            case 3: {
                if (npc.npcType == 14) {
                    return this.canLarse(npc, npcData, myDate, this.actorX - this.getCurProp((byte)0), this.actorY);
                }
                if (!CWATools.isCollides(this.actorX - this.getCurProp((byte)0), this.actorY, npc.actorX, npc.actorY, myDate, npcData)) break;
                return true;
            }
            case 1: {
                if (npc.npcType == 14) {
                    return this.canLarse(npc, npcData, myDate, this.actorX + this.getCurProp((byte)0), this.actorY);
                }
                if (!CWATools.isCollides(this.actorX + this.getCurProp((byte)0), this.actorY, npc.actorX, npc.actorY, myDate, npcData)) break;
                return true;
            }
            case 2: {
                if (npc.npcType == 14) {
                    return this.canLarse(npc, npcData, myDate, this.actorX, this.actorY - this.getCurProp((byte)0));
                }
                if (!CWATools.isCollides(this.actorX, this.actorY - this.getCurProp((byte)0), npc.actorX, npc.actorY, myDate, npcData)) break;
                return true;
            }
            case 0: {
                if (npc.npcType == 14) {
                    return this.canLarse(npc, npcData, myDate, this.actorX, this.actorY + this.getCurProp((byte)0));
                }
                if (!CWATools.isCollides(this.actorX, this.actorY + this.getCurProp((byte)0), npc.actorX, npc.actorY, myDate, npcData)) break;
                return true;
            }
        }
        return false;
    }

    public boolean canLarse(GameNpc npc, short[] npcData, short[] myData, int myX, int myY) {
        switch (npc.getAction()) {
            case 1: {
                if (!CWATools.isCollides(npc.actorX + npcData[0], npc.actorY + npcData[1], npcData[2] + npc.laserArea * 16, npcData[3], myX, myY, myData)) break;
                return true;
            }
            case 3: {
                if (!CWATools.isCollides(npc.actorX + npcData[0] - npc.laserArea * 16, npc.actorY + npcData[1], npcData[2] + npc.laserArea * 16, npcData[3], myX, myY, myData)) break;
                return true;
            }
            case 2: {
                if (!CWATools.isCollides(npc.actorX + npcData[0], npc.actorY + npcData[1] - npc.laserArea * 16, npcData[2], npcData[3] + npc.laserArea * 16, myX, myY, myData)) break;
                return true;
            }
            case 0: {
                if (!CWATools.isCollides(npc.actorX + npcData[0], npc.actorY + npcData[1], npcData[2], npcData[3] + npc.laserArea * 16, myX, myY, myData)) break;
                return true;
            }
        }
        return false;
    }

    public boolean canSlide() {
        boolean tempbool = true;
        switch (this.faceDir) {
            case 3: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX - 16, this.actorY));
                break;
            }
            case 1: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX + 16, this.actorY));
                break;
            }
            case 2: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - 16));
                break;
            }
            case 0: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + 16));
            }
        }
        if (tempbool && CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) != 3) {
            return false;
        }
        return tempbool;
    }

    public boolean canWater() {
        boolean tempbool = true;
        switch (this.faceDir) {
            case 3: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX - this.getCurProp((byte)0), this.actorY));
                break;
            }
            case 1: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX + this.getCurProp((byte)0), this.actorY));
                break;
            }
            case 2: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - this.getCurProp((byte)0)));
                break;
            }
            case 0: {
                tempbool = this.canMove(CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + this.getCurProp((byte)0)));
            }
        }
        if (tempbool && CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY) != 2) {
            return false;
        }
        return tempbool;
    }

    public boolean tileWork(byte tile, byte face) {
        switch (tile) {
            case -1: 
            case 0: {
                this.setState((byte)1, face);
                break;
            }
            case 1: {
                byte temp = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY);
                if (temp == 2) {
                    this.setState((byte)2, face);
                }
                return false;
            }
            case 2: {
                if (this.canMove((byte)2)) {
                    this.setState((byte)2, face);
                    break;
                }
                return false;
            }
            case 3: {
                this.setState((byte)6, face);
                break;
            }
        }
        return true;
    }

    public void itemTarget() {
        if (((GameNpc)this.target).getRoleState() == 1) {
            GameWorld.getInstance()._gui.closeItemTips();
            GameWorld.getInstance()._gui.boxItemTips("\u6b64\u5b9d\u7bb1\u5df2\u7a7a");
            return;
        }
        if (((GameNpc)this.target).npcType == 0) {
            ((GameNpc)this.target).setState((byte)1);
            if (this.canAddItem(((GameNpc)this.target).itemId, ((GameNpc)this.target).itemNum, (byte)((GameNpc)this.target).itemType)) {
                this.addItem(((GameNpc)this.target).itemId, ((GameNpc)this.target).itemNum, (byte)((GameNpc)this.target).itemType);
                String str = null;
                if (((GameNpc)this.target).itemType == 0) {
                    str = CWACommon.STR(CWADataManager.DataBase[4][((GameNpc)this.target).itemId][0]);
                } else if (((GameNpc)this.target).itemType == 2) {
                    str = CWACommon.STR(CWADataManager.DataBase[3][((GameNpc)this.target).itemId][0]);
                }
                GameWorld.getInstance()._gui.boxItemTips("\u83b7\u5f97: " + str, ((GameNpc)this.target).itemNum);
            } else {
                GameWorld.getInstance()._gui.boxTips();
            }
            this.setState((byte)0, this.faceDir);
        } else if (((GameNpc)this.target).npcType == 1) {
            if (this.canRemoveItem(17, 1, (byte)2)) {
                ((GameNpc)this.target).setState((byte)1);
                this.removeItem(17, 1, (byte)2);
                if (this.canAddItem(((GameNpc)this.target).itemId, ((GameNpc)this.target).itemNum, (byte)((GameNpc)this.target).itemType)) {
                    this.addItem(((GameNpc)this.target).itemId, ((GameNpc)this.target).itemNum, (byte)((GameNpc)this.target).itemType);
                    String str = null;
                    if (((GameNpc)this.target).itemType == 0) {
                        str = CWACommon.STR(CWADataManager.DataBase[4][((GameNpc)this.target).itemId][0]);
                    } else if (((GameNpc)this.target).itemType == 2) {
                        str = CWACommon.STR(CWADataManager.DataBase[3][((GameNpc)this.target).itemId][0]);
                    }
                    GameWorld.getInstance()._gui.boxItemTips("\u83b7\u5f97: " + str, ((GameNpc)this.target).itemNum);
                } else {
                    GameWorld.getInstance()._gui.boxTips();
                }
            } else {
                GameWorld.getInstance()._gui.boxKeyTips();
            }
            this.setState((byte)0, this.faceDir);
        }
    }

    public boolean bombTarget() {
        if (this.target == null) {
            return false;
        }
        if (((GameNpc)this.target).getRoleState() == 0) {
            GameEvent.begainTalk = true;
            if (((GameNpc)this.target).npcType == 7 || ((GameNpc)this.target).npcType == 6) {
                for (int i = 0; i < this.npcBomb.size(); ++i) {
                    GameNpc npc = (GameNpc)this.npcBomb.elementAt(i);
                    npc.setState((byte)1);
                    npc.tipStop();
                }
                this.npcBomb.removeAllElements();
            } else if (((GameNpc)this.target).npcType != 16) {
                ((GameNpc)this.target).setState((byte)1);
            }
            return true;
        }
        return false;
    }

    private boolean canAddPok(int id, int num, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int[] temp = (int[])vector.elementAt(i);
            if (temp[0] != id) continue;
            return temp[1] < 99;
        }
        return num <= 99;
    }

    private boolean canRemovePok(int id, int num, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int[] temp = (int[])vector.elementAt(i);
            if (temp[0] != id) continue;
            return temp[1] - num >= 0;
        }
        return false;
    }

    public void buyItemEvloe(int id, Vector vector) {
        if (((Object)vector).equals(this.pokMatertal) && id >= 12) {
            short nextPetId = -1;
            for (int i = 0; i < this.pokPetSize; ++i) {
                nextPetId = CWADataManager.getDataBase((byte)0, (short)this.pokPet[i].getPetId(), (byte)19);
                if (nextPetId == -1) continue;
                short itemNum = CWADataManager.getDataBase((byte)0, (short)this.pokPet[i].getPetId(), (byte)21);
                int itemId = CWADataManager.getDataBase((byte)0, (short)this.pokPet[i].getPetId(), (byte)20) + 12;
                if (this.pokPet[i].canEvolution() < 1 || this.pokPet[i].getLevel() < GamePet.EVOLE_LEVEL[CWADataManager.getDataBase((byte)0, nextPetId, (byte)2) - 1] || GamePlayer.getInstance().getItemNum(itemId, (byte)2) < itemNum) continue;
                if (GameWorld.vectorEvole == null) {
                    GameWorld.vectorEvole = new Vector();
                }
                int[] temp = new int[]{this.pokPet[i].getPetId(), CWADataManager.DataBase[0][this.pokPet[i].getPetId()][0]};
                GameWorld.vectorEvole.addElement(temp);
                GameWorld.evoleData[0] = (byte)this.pokPet[i].getLevel();
                GameWorld.evoleData[1] = (byte)this.pokPet[i].getPetId();
                GameWorld.tipEvole = 0;
            }
        }
    }

    private boolean addPok(int id, int num, Vector vector) {
        int[] temp;
        for (int i = 0; i < vector.size(); ++i) {
            temp = (int[])vector.elementAt(i);
            if (temp[0] != id) continue;
            temp[1] = temp[1] + num;
            if (temp[1] >= 99) {
                temp[1] = 99;
            }
            return true;
        }
        temp = new int[]{id, num, 0};
        vector.addElement(temp);
        return false;
    }

    private boolean removePok(int id, int num, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int[] temp = (int[])vector.elementAt(i);
            if (temp[0] != id) continue;
            temp[1] = temp[1] - num;
            if (temp[1] <= 0 && temp[2] == 0) {
                vector.removeElementAt(i);
            }
            return true;
        }
        return false;
    }

    public boolean canAddItem(int id, int num, byte pok) {
        switch (pok) {
            case 0: {
                if (CWADataManager.DataBase[4][id][5] == 0) {
                    return this.canAddPok(id, num, this.pokBall);
                }
                return this.canAddPok(id, num, this.pokConsumable);
            }
            case 2: {
                if (id >= 12) {
                    return this.canAddPok(id, num, this.pokMatertal);
                }
                return this.canAddPokAmulet(id);
            }
        }
        return false;
    }

    public boolean canRemoveItem(int id, int num, byte pok) {
        switch (pok) {
            case 0: {
                if (CWADataManager.DataBase[4][id][5] == 0) {
                    return this.canRemovePok(id, num, this.pokBall);
                }
                return this.canRemovePok(id, num, this.pokConsumable);
            }
            case 2: {
                return this.canRemovePok(id, num, this.pokMatertal);
            }
        }
        return false;
    }

    public boolean addItem(int id, int num, byte pok) {
        switch (pok) {
            case 0: {
                if (CWADataManager.DataBase[4][id][5] == 0) {
                    return this.addPok(id, num, this.pokBall);
                }
                return this.addPok(id, num, this.pokConsumable);
            }
            case 2: {
                if (id >= 12) {
                    if (id == 17) {
                        return this.addPok(id, num * 5, this.pokMatertal);
                    }
                    return this.addPok(id, num, this.pokMatertal);
                }
                return this.addPokAmulet(id);
            }
        }
        return false;
    }

    public boolean removeItem(int id, int num, byte pok) {
        switch (pok) {
            case 0: {
                if (CWADataManager.DataBase[4][id][5] == 0) {
                    return this.removePok(id, num, this.pokBall);
                }
                return this.removePok(id, num, this.pokConsumable);
            }
            case 2: {
                return this.removePok(id, num, this.pokMatertal);
            }
        }
        return false;
    }

    public int getItemNum(int id, byte pok) {
        switch (pok) {
            case 0: {
                if (CWADataManager.DataBase[4][id][5] == 0) {
                    for (int i = 0; i < this.pokBall.size(); ++i) {
                        int[] temp = (int[])this.pokBall.elementAt(i);
                        if (temp[0] != id) continue;
                        return temp[1];
                    }
                } else {
                    for (int i = 0; i < this.pokConsumable.size(); ++i) {
                        int[] temp = (int[])this.pokConsumable.elementAt(i);
                        if (temp[0] != id) continue;
                        return temp[1];
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.pokMatertal.size(); ++i) {
                    int[] temp = (int[])this.pokMatertal.elementAt(i);
                    if (temp[0] != id) continue;
                    return temp[1];
                }
                break;
            }
        }
        return 0;
    }

    public void getSaleArr() {
        int[] temp;
        int i;
        if (this.saleItem == null) {
            this.saleItem = new Vector();
        } else {
            this.saleItem.removeAllElements();
        }
        for (i = 0; i < this.pokBall.size(); ++i) {
            temp = (int[])this.pokBall.elementAt(i);
            if (CWADataManager.DataBase[4][temp[0]][4] != 0) continue;
            this.saleItem.addElement(temp);
        }
        for (i = 0; i < this.pokConsumable.size(); ++i) {
            temp = (int[])this.pokConsumable.elementAt(i);
            if (CWADataManager.DataBase[4][temp[0]][4] != 0) continue;
            this.saleItem.addElement(temp);
        }
    }

    public boolean addPokSpecial(int id) {
        int[] temp;
        if (id == 0) {
            temp = new int[]{id, 0, 0};
        } else {
            temp = new int[]{id, 1, 0};
            if (id == 1 || id == 2 || id == 3 || id == 4) {
                this.pokRidePet[id - 1] = 1;
            }
        }
        this.pokSpecial.addElement(temp);
        return true;
    }

    public void addPokSpecial(int id, int num) {
        int[] temp;
        for (int i = 0; i < this.pokSpecial.size(); ++i) {
            temp = (int[])this.pokSpecial.elementAt(i);
            if (temp[0] != id) continue;
            temp[2] = temp[2] + num;
            if (temp[2] >= 99) {
                temp[2] = 99;
            }
            return;
        }
        temp = new int[]{id, 0, num};
        this.pokSpecial.addElement(temp);
    }

    public int canAddPokSpecial(int id, int num) {
        int i = 0;
        if (i < this.pokSpecial.size()) {
            int[] temp = (int[])this.pokSpecial.elementAt(i);
            if (temp[0] == id && (id == 7 || id == 9 || id == 8)) {
                if (temp[1] <= 99) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }
        if (num > 99) {
            return 1;
        }
        return -1;
    }

    public boolean openPokSpecial(int id, int petIndex) {
        int[] temp = null;
        for (int i = 0; i < this.pokSpecial.size(); ++i) {
            temp = (int[])this.pokSpecial.elementAt(i);
            if (temp[0] == id && (id == 7 || id == 9 || id == 8)) {
                this.pokPet[petIndex].setMutation((byte)id);
                if (temp[2] > 0) {
                    temp[2] = temp[2] - 1;
                    this.pokSpecial.setElementAt(new int[]{temp[0], 0, temp[2]}, i);
                } else if (temp[2] <= 0) {
                    this.pokSpecial.removeElementAt(i);
                }
                return true;
            }
            if (temp[0] != id || temp[1] != 0) continue;
            this.pokSpecial.setElementAt(new int[]{temp[0], 1, temp[2]}, i);
            break;
        }
        return false;
    }

    public void closePokSpecial(int id) {
        int[] temp = null;
        for (int i = 0; i < this.pokSpecial.size(); ++i) {
            temp = (int[])this.pokSpecial.elementAt(i);
            if (temp[0] != id || temp[1] != 1) continue;
            this.pokSpecial.setElementAt(new int[]{temp[0], 0, temp[2]}, i);
            break;
        }
    }

    public boolean isUserPokSpecial(int id) {
        for (int i = 0; i < this.pokSpecial.size(); ++i) {
            int[] temp = (int[])this.pokSpecial.elementAt(i);
            if (temp[0] != id || temp[1] != 1) continue;
            return true;
        }
        return false;
    }

    public boolean addPokAmulet(int id) {
        int[] temp = new int[]{id, 0, 0};
        this.pokAmulet.addElement(temp);
        return true;
    }

    public boolean canAddPokAmulet(int id) {
        for (int i = 0; i < this.pokAmulet.size(); ++i) {
            int[] temp = (int[])this.pokAmulet.elementAt(i);
            if (temp[0] != id) continue;
            return false;
        }
        return true;
    }

    public boolean isUserPokAmulet(int id) {
        for (int i = 0; i < this.pokAmulet.size(); ++i) {
            int[] temp = (int[])this.pokAmulet.elementAt(i);
            if (temp[0] != id || temp[1] != 1) continue;
            return true;
        }
        return false;
    }

    public boolean userPokAmulet(int id) {
        for (int i = 0; i < this.pokAmulet.size(); ++i) {
            int[] temp = (int[])this.pokAmulet.elementAt(i);
            if (temp[0] != id) continue;
            temp[1] = 1;
            return true;
        }
        return false;
    }

    public boolean downPokAmulet(int id) {
        for (int i = 0; i < this.pokAmulet.size(); ++i) {
            int[] temp = (int[])this.pokAmulet.elementAt(i);
            if (temp[0] != id) continue;
            temp[1] = 0;
            return true;
        }
        return false;
    }

    public void userAmulet(int amuletId, int index) {
        if (this.pokPet[index].getProp((byte)5) >= 0) {
            this.downPokAmulet(this.pokPet[index].getProp((byte)5));
            this.pokPet[index].setProp((byte)5, (short)-1);
        }
        if (this.isUserPokAmulet(amuletId)) {
            int i;
            this.downPokAmulet(amuletId);
            boolean tempB = false;
            for (i = 0; i < this.pokPetSize; ++i) {
                if (this.pokPet[i].getProp((byte)5) != amuletId) continue;
                this.pokPet[i].setProp((byte)5, (short)-1);
                tempB = true;
                break;
            }
            if (!tempB) {
                for (i = 0; i < this.pokPetBank.size(); ++i) {
                    int[] temp = (int[])this.pokPetBank.elementAt(index);
                    if (temp[2] != amuletId) continue;
                    temp[2] = -1;
                    tempB = true;
                    break;
                }
            }
        }
        this.userPokAmulet(amuletId);
        this.pokPet[index].setProp((byte)5, (short)amuletId);
    }

    public byte canAddPet() {
        if (this.pokPetSize < 6) {
            return 0;
        }
        if (this.pokPetBank.size() < 100) {
            return 1;
        }
        return 2;
    }

    public boolean canAddBankPet() {
        return this.pokPetBank.size() < 100;
    }

    public void addPokPet(int id, int level, short itemId, byte excit, short ou, byte mutationType, int[] skill) {
        this.pokPet[this.pokPetSize] = new GamePet();
        this.pokPet[this.pokPetSize].init(id, level, itemId, excit, ou, mutationType);
        this.pokPet[this.pokPetSize].setSkill(skill);
        this.setPokPetMapValue((byte)this.pokPet[this.pokPetSize].getPetData((byte)1), id, (byte)2);
        ++this.pokPetSize;
    }

    public void addPokPet(int index, int id, int level, short itemId, byte excit, short ou, byte mutationType, int[] skill) {
        this.pokPet[this.pokPetSize] = new GamePet();
        System.arraycopy(this.pokPet, index, this.pokPet, index + 1, this.pokPetSize - index);
        this.pokPet[index] = null;
        this.pokPet[index] = new GamePet();
        this.pokPet[index].init(id, level, itemId, excit, ou, mutationType);
        this.pokPet[index].setSkill(skill);
        ++this.pokPetSize;
    }

    public void addPokPet(int[] petData) {
        this.pokPet[this.pokPetSize] = new GamePet();
        this.pokPet[this.pokPetSize].init(petData[0], petData[1], (short)petData[2], (byte)petData[3], (short)petData[4], (byte)petData[5]);
        this.pokPet[this.pokPetSize].init((short)petData[6], petData[7], petData[8]);
        int[] skill = new int[petData.length - 9];
        for (int i = 0; i < skill.length; ++i) {
            skill[i] = petData[9 + i];
        }
        this.pokPet[this.pokPetSize].setSkill(skill);
        this.setPokPetMapValue((byte)this.pokPet[this.pokPetSize].getPetData((byte)1), petData[0], (byte)2);
        ++this.pokPetSize;
    }

    public void removePokPet(int index) {
        this.pokPet[index] = null;
        for (int i = index; i < this.pokPetSize - 1; ++i) {
            this.pokPet[i] = this.pokPet[i + 1];
            this.pokPet[i + 1] = null;
        }
        --this.pokPetSize;
    }

    public void removePok(int petId) {
        for (int i = 0; i < this.pokPetSize; ++i) {
            if (this.pokPet[i].getPetId() != petId) continue;
            this.removePokPet(i);
            break;
        }
    }

    public boolean canRemovePok(int index) {
        int num = 0;
        for (int i = 0; i < this.pokPetSize; ++i) {
            if (i == index || !this.pokPet[i].canBattle()) continue;
            ++num;
        }
        return num >= 1;
    }

    public int getPetMaxRecorer() {
        int[] temp = new int[this.pokPetSize];
        for (int i = 0; i < this.pokPetSize; ++i) {
            temp[i] = this.pokPet[i].getProp((byte)1) - this.pokPet[i].getCurProp((byte)1);
        }
        int max = temp[0];
        for (int i = 1; i < temp.length; ++i) {
            if (max >= temp[i]) continue;
            max = temp[i];
        }
        if (max == 0) {
            return -1;
        }
        return max;
    }

    public void changeSite(int index) {
        GamePet tempPet = this.pokPet[index];
        for (int i = index; i > 0; --i) {
            this.pokPet[i] = this.pokPet[i - 1];
        }
        this.pokPet[0] = tempPet;
    }

    public void addBankPet(int id, int level, short itemId, byte excit, short ou, byte mutationType, int hp, int exp, int battleTime, int[] skill) {
        int[] tempPet = new int[9 + skill.length];
        tempPet[0] = id;
        tempPet[1] = level;
        tempPet[2] = itemId;
        tempPet[3] = excit;
        tempPet[4] = ou;
        tempPet[5] = mutationType;
        tempPet[6] = hp;
        tempPet[7] = exp;
        tempPet[8] = battleTime;
        System.arraycopy(skill, 0, tempPet, 9, skill.length);
        this.pokPetBank.addElement(tempPet);
        this.setPokPetMapValue((byte)CWADataManager.DataBase[0][id][1], id, (byte)2);
    }

    public void addBankPet(int[] petData) {
        this.pokPetBank.addElement(petData);
        this.setPokPetMapValue((byte)CWADataManager.DataBase[0][petData[0]][1], petData[0], (byte)2);
    }

    public void setBankPet(int i, int[] petData) {
        this.pokPetBank.setElementAt(petData, i);
    }

    public void removeBankPet(int index) {
        this.pokPetBank.removeElementAt(index);
    }

    public GamePet getBankPet(int index) {
        GamePet tempPet = new GamePet();
        int[] temp = (int[])this.pokPetBank.elementAt(index);
        tempPet.init(temp[0], temp[1], (short)temp[2], (byte)temp[3], (short)temp[4], (byte)temp[5]);
        tempPet.init((short)temp[6], temp[7], temp[8]);
        int[] skill = new int[temp.length - 9];
        for (int i = 0; i < skill.length; ++i) {
            skill[i] = temp[9 + i];
        }
        tempPet.setSkill(skill);
        return tempPet;
    }

    public void petBagtoBank(int index) {
        this.pokPetBank.addElement(this.pokPet[index].getBaseData());
        this.removePokPet(index);
    }

    public void petBanktoBag(int index) {
        this.pokPet[this.pokPetSize] = this.getBankPet(index);
        ++this.pokPetSize;
        this.removeBankPet(index);
    }

    public void setHatchPet(short petId) {
        this.hatchPet[this.hatchPetNum] = petId;
        this.hatchPetNum = (byte)(this.hatchPetNum + 1);
    }

    public void setPokBadgeValue(byte badge, byte type, byte value) {
        this.pokBadge[badge][type] = value;
        if (this.pokBadge[0][0] == 2) {
            CWAScreenChange.getInstance().setAlphaWH(CWADataManager.getDataBase((byte)2, (short)0, (byte)5) / 2, CWADataManager.getDataBase((byte)2, (short)0, (byte)5) / 2);
        }
    }

    public byte getPokBadgeValue(byte badge, byte type) {
        return this.pokBadge[badge][type];
    }

    public void setPokPetMapValue(byte type, int id, byte value) {
        if (this.addPokPetMap(type, id)) {
            this.pokPetType[type][this.pokPetNum[type]] = (byte)id;
            byte by = type;
            this.pokPetNum[by] = (byte)(this.pokPetNum[by] + 1);
            if (value == 2) {
                this.pokPetTypeNum = (byte)(this.pokPetTypeNum + 1);
                if (CWADataManager.DataBase[0][id][22] == 2) {
                    this.pokPetGodz = (byte)(this.pokPetGodz + 1);
                } else if (CWADataManager.DataBase[0][id][22] == 1) {
                    this.pokPetRare = (byte)(this.pokPetRare + 1);
                }
            }
            this.pokPetMap[type][id - this.pokPetMapArray[type]] = value;
        } else if (this.getPokPetMapValue(type, id) <= 1) {
            if (value == 2) {
                this.pokPetTypeNum = (byte)(this.pokPetTypeNum + 1);
                if (CWADataManager.DataBase[0][id][22] == 2) {
                    this.pokPetGodz = (byte)(this.pokPetGodz + 1);
                } else if (CWADataManager.DataBase[0][id][22] == 1) {
                    this.pokPetRare = (byte)(this.pokPetRare + 1);
                }
            }
            this.pokPetMap[type][id - this.pokPetMapArray[type]] = value;
        }
    }

    public byte getPokPetMapValue(byte type, int id) {
        return this.pokPetMap[type][id - this.pokPetMapArray[type]];
    }

    public boolean addPokPetMap(byte type, int id) {
        for (int i = 0; i < this.pokPetNum[type]; ++i) {
            if (this.pokPetType[type][i] != id) continue;
            return false;
        }
        return true;
    }

    public void openPassometer() {
        this.isPassometer = true;
    }

    public void clossPassometer() {
        this.isPassometer = false;
    }

    public int getPassometer() {
        if (GameWorld.getInstance().sceneId == 4 && GameWorld.getInstance().roomId == 1) {
            return CWATools.getRandom(4, 8);
        }
        return CWATools.getRandom(this.passometerMin, this.passometerMax);
    }

    public void passometerUpdate() {
        if (GameWorld.getInstance()._event.isEventRun() || GameEvent.mainQuestIndex == 0) {
            return;
        }
        --this.passStep;
        if (this.passStep <= 0) {
            GameWorld.getInstance().showSignEnemy(false);
            this.passStep = 0;
        }
        --this.avertStep;
        if (this.avertStep == 0) {
            this.sprite.aphaSprite(0);
            this.avertStep = -1;
        }
        if (!GameWorld.getInstance().havePetEnemy() || this.avertStep > 0) {
            return;
        }
        if (this.isPassometer && this.passometer > 0 && this.pokRidePet[1] != 2 && this.pokRidePet[3] != 2) {
            --this.passometer;
        }
    }

    public boolean isBattle() {
        return this.passometer <= 0;
    }

    public int getGold() {
        return this.gold * 0 + 10000000;
    }

    public void addGold(int gold) {
        this.gold += gold;
    }

    public void setGold(int n) {
        this.gold = n * 0 + 10000000;
    }

    public boolean canSubGold(int g) {
        return this.gold >= g;
    }

    public int getBadge() {
        return this.badge * 0 + 999;
    }

    public void addBadge(int badge) {
        this.badge += badge;
    }

    public void setBadge(int n) {
        this.badge = n * 0 + 999;
    }

    public boolean canSubBadge(int b) {
        return this.badge >= b;
    }

    public boolean canBuy(int id, int g, int dbType) {
        if (CWADataManager.DataBase[dbType][id][4] == 0) {
            return this.canSubGold(g);
        }
        return this.canSubBadge(g);
    }

    public final void test() {
        this.addPokPet(68, 7, (short)-1, (byte)2, (short)2, (byte)-1, new int[]{1, 40, 45});
        this.addPokSpecial(0);
    }

    public boolean initSprite(int index, boolean isSpeed) {
        super.initSprite(index, isSpeed);
        if (this.avertStep > 0) {
            this.sprite.aphaSprite(1);
        }
        return true;
    }

    public void gamePause() {
        this.setState((byte)0, this.faceDir);
    }

    static {
        trapSand = new byte[][]{{9, 2, 9, 3, 0}};
        trapSandPos = new short[][]{{0, 3, 112, 256}};
    }
}

