/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwaEX;

import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAImageARGB;
import CWA2DAPI.cwabase2d.CWASprite;
import javax.microedition.lcdui.Image;

public class CWAImageUtil {
    public static byte TEXTURE_MIX = 0;
    public static byte TEXTURE_BLEND = 1;
    public static byte TEXTURE_REPLACE = (byte)2;

    public static CWAImageARGB getImageARGB(Image src, CWAImageARGB argb) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] pixels = new int[w * h];
        src.getRGB(pixels, 0, w, 0, 0, w, h);
        for (int i = 0; i < pixels.length; ++i) {
            if (pixels[i] != -1 && pixels[i] != -16777216) continue;
            pixels[i] = 0xFFFFFF;
        }
        argb.init(pixels, w, h);
        return argb;
    }

    public static CWAImageARGB getFrameImg(CWASprite sprite, int frame, int[] wh, byte trans, CWAImageARGB argb) {
        Image frameImg = Image.createImage((int)wh[2], (int)wh[3]);
        frameImg.getGraphics().setColor(0);
        frameImg.getGraphics().fillRect(0, 0, wh[2], wh[3]);
        sprite.drawFrame(frameImg.getGraphics(), frame, -wh[0], -wh[1], trans, 20, false);
        argb.x = wh[0];
        argb.y = wh[1];
        return CWAImageUtil.getImageARGB(frameImg, argb);
    }

    public static CWAImageARGB reSize(CWAImageARGB src, int destW, int destH) {
        int[] destPixels = new int[destW * destH];
        for (int destY = 0; destY < destH; ++destY) {
            for (int destX = 0; destX < destW; ++destX) {
                int srcX = destX * src.w / destW;
                int srcY = destY * src.h / destH;
                destPixels[destX + destY * destW] = src.argb[srcX + srcY * src.w];
            }
        }
        src.init(destPixels, destW, destH);
        src.x = src.x * destW / src.w / 10;
        src.y = src.y * destW / src.w / 10;
        return src;
    }

    public static CWAImageARGB scale(CWAImageARGB src, int scale) {
        int destW = src.w * scale / 10;
        int destH = src.h * scale / 10;
        int[] destPixels = new int[destW * destH];
        for (int destY = 0; destY < destH; ++destY) {
            for (int destX = 0; destX < destW; ++destX) {
                int srcX = destX * src.w / destW;
                int srcY = destY * src.h / destH;
                destPixels[destX + destY * destW] = src.argb[srcX + srcY * src.w];
            }
        }
        src.init(destPixels, destW, destH);
        src.x = src.x * scale / 10;
        src.y = src.y * scale / 10;
        return src;
    }

    public static CWAImageARGB reLightContrast(CWAImageARGB src, int contrast, int light) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = (argb & 0xFF0000) >> 16;
                g = (argb & 0xFF00) >> 8;
                b = argb & 0xFF;
                r = r * contrast + light;
                g = g * contrast + light;
                b = b * contrast + light;
                if (r > 255) {
                    r = 255;
                } else if (r < 0) {
                    r = 0;
                }
                if (g > 255) {
                    g = 255;
                } else if (g < 0) {
                    g = 0;
                }
                if (b > 255) {
                    b = 255;
                } else if (b < 0) {
                    b = 0;
                }
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return src;
    }

    public static CWAImageARGB negative(CWAImageARGB src) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = 255 - ((argb & 0xFF0000) >> 16);
                g = 255 - ((argb & 0xFF00) >> 8);
                b = 255 - (argb & 0xFF);
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return src;
    }

    public static CWAImageARGB transparent(CWAImageARGB src, int transparent) {
        if (transparent < 0 || transparent > 255) {
            return src;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src.argb[i] == 0xFFFFFF || src.argb[i] == 0) continue;
            if (src.argb[i] == -16777216) {
                int n = i;
                src.argb[n] = src.argb[n] & 0;
                continue;
            }
            src.argb[i] = transparent << 24 | src.argb[i] & 0xFFFFFF;
        }
        return src;
    }

    public static Image transparent(Image img, int transparent) {
        CWAImageARGB src = new CWAImageARGB();
        int w = img.getWidth();
        int h = img.getHeight();
        Image frameImg = Image.createImage((int)w, (int)h);
        frameImg.getGraphics().setColor(0);
        frameImg.getGraphics().fillRect(0, 0, w, h);
        frameImg.getGraphics().drawImage(img, 0, 0, 20);
        src.init(CWATools.getPixels(frameImg), w, h);
        CWAImageUtil.transparent(src, transparent);
        img = CWATools.drawPixels(src.argb, src.w, src.h, true);
        src.release();
        return img;
    }

    public static CWAImageARGB changeColor(CWAImageARGB src, int apha, int red, int green, int blue) {
        int r = red;
        int g = green;
        int b = blue;
        for (int i = 0; i < src.argb.length; ++i) {
            if (src.argb[i] == 0xFFFFFF) continue;
            src.argb[i] = apha < 0 || apha > 255 ? r << 16 | g << 8 | b : apha << 24 | r << 16 | g << 8 | b;
        }
        return src;
    }

    public static CWAImageARGB texture2D(CWAImageARGB src, CWAImageARGB texture, byte type) {
        int texX = 0;
        int texY = 0;
        if (type == TEXTURE_MIX) {
            src = CWAImageUtil.reLightContrast(src, 5, 5);
        }
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int argb = src.argb[i * src.w + ii];
                int temp = texture.argb[texY * texture.w + texX];
                if (argb >> 24 != 0) {
                    if (type == TEXTURE_MIX) {
                        src.argb[i * src.w + ii] = argb & temp;
                    } else if (type == TEXTURE_BLEND) {
                        src.argb[i * src.w + ii] = argb | temp;
                    } else if (type == TEXTURE_REPLACE) {
                        src.argb[i * src.w + ii] = temp;
                    }
                }
                if (texX < texture.w - 1) {
                    ++texX;
                    continue;
                }
                texX = 0;
            }
            texY = texY < texture.h - 1 ? ++texY : 0;
            texX = 0;
        }
        return src;
    }

    public static CWAImageARGB blackWhite(CWAImageARGB src) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int temp;
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = (argb & 0xFF0000) >> 16;
                g = (argb & 0xFF00) >> 8;
                b = argb & 0xFF;
                r = temp = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                g = temp;
                b = temp;
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return src;
    }

    public static Image blackWhite(Image imgsrc) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        CWAImageARGB src = new CWAImageARGB();
        src.init(CWATools.getPixels(imgsrc), imgsrc.getWidth(), imgsrc.getHeight());
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int temp;
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = (argb & 0xFF0000) >> 16;
                g = (argb & 0xFF00) >> 8;
                b = argb & 0xFF;
                r = temp = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                g = temp;
                b = temp;
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        imgsrc = CWATools.drawPixels(src.argb, src.w, src.h, true);
        src.release();
        return imgsrc;
    }

    public static CWAImageARGB crayon(CWAImageARGB src) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int r1 = 0;
        int g1 = 0;
        int b1 = 0;
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = (argb & 0xFF0000) >> 16;
                g = (argb & 0xFF00) >> 8;
                b = argb & 0xFF;
                if (i + 1 == src.h) {
                    r1 = 0;
                    g1 = 0;
                    b1 = 0;
                } else {
                    argb = src.argb[(i + 1) * src.w + ii];
                    r1 = (argb & 0xFF0000) >> 16;
                    g1 = (argb & 0xFF00) >> 8;
                    b1 = argb & 0xFF;
                }
                if (ii + 1 == src.w) {
                    r2 = 0;
                    g2 = 0;
                    b2 = 0;
                } else {
                    argb = src.argb[i * src.w + ii + 1];
                    r2 = (argb & 0xFF0000) >> 16;
                    g2 = (argb & 0xFF00) >> 8;
                    b2 = argb & 0xFF;
                }
                r = (int)Math.sqrt(2 * (r - r1) * (r - r1) + (r - r2) * (r - r2));
                g = (int)Math.sqrt(2 * (g - g1) * (g - g1) + (g - g2) * (g - g2));
                b = (int)Math.sqrt(2 * (b - b1) * (b - b1) + (b - b2) * (b - b2));
                r = 255 - r;
                g = 255 - g;
                b = 255 - b;
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return src;
    }

    public static CWAImageARGB hoodwink(CWAImageARGB src) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = (argb & 0xFF0000) >> 16;
                g = (argb & 0xFF00) >> 8;
                b = argb & 0xFF;
                r = (int)(0.299 * (double)r);
                g = (int)(0.587 * (double)g);
                b = (int)(0.114 * (double)b);
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return src;
    }

    public static CWAImageARGB neonLight(CWAImageARGB src) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int r1 = 0;
        int g1 = 0;
        int b1 = 0;
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        for (int i = 0; i < src.h; ++i) {
            for (int ii = 0; ii < src.w; ++ii) {
                int argb = src.argb[i * src.w + ii];
                a = (argb & 0xFF000000) >> 24;
                r = (argb & 0xFF0000) >> 16;
                g = (argb & 0xFF00) >> 8;
                b = argb & 0xFF;
                if (i + 1 == src.h) {
                    r1 = 0;
                    g1 = 0;
                    b1 = 0;
                } else {
                    argb = src.argb[(i + 1) * src.w + ii];
                    r1 = (argb & 0xFF0000) >> 16;
                    g1 = (argb & 0xFF00) >> 8;
                    b1 = argb & 0xFF;
                }
                if (ii + 1 == src.w) {
                    r2 = 0;
                    g2 = 0;
                    b2 = 0;
                } else {
                    argb = src.argb[i * src.w + ii + 1];
                    r2 = (argb & 0xFF0000) >> 16;
                    g2 = (argb & 0xFF00) >> 8;
                    b2 = argb & 0xFF;
                }
                r = (int)Math.sqrt(2 * (r - r1) * (r - r1) + (r - r2) * (r - r2));
                g = (int)Math.sqrt(2 * (g - g1) * (g - g1) + (g - g2) * (g - g2));
                b = (int)Math.sqrt(2 * (b - b1) * (b - b1) + (b - b2) * (b - b2));
                src.argb[i * src.w + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return src;
    }

    public static CWAImageARGB rotate(CWAImageARGB src, int cx, int cy, double theta) {
        if (Math.abs(theta % 360.0) < 1.0) {
            return src;
        }
        int dx = cx > src.w / 2 ? cx : src.w - cx;
        int dy = cy > src.h / 2 ? cy : src.h - cy;
        double dr = Math.sqrt(dx * dx + dy * dy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        double radian = theta * Math.PI / 180.0;
        for (int i = 0; i < src.w; ++i) {
            for (int j = 0; j < src.h; ++j) {
                if (src.argb[j * src.w + i] >> 24 == 0) continue;
                double destX = dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian);
                double destY = dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian);
                destMap[(int)destY * wh2 + (int)destX] = src.argb[j * src.w + i];
            }
        }
        src.init(destMap, wh2, wh2);
        return src;
    }
}

