/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwabase2d;

import CWA2DAPI.CWAGlobal;
import CWA2DAPI.cwabase2d.CWAActor;

public class CWACamera
extends CWAActor
implements CWAGlobal {
    private static CWACamera _camera;
    private static final byte TRACK_X = 0;
    private static final byte TRACK_Y = 1;
    private static final byte TRACK_SPEED = 2;
    private static final byte TRACK_W = 3;
    private static final byte TRACK_H = 4;
    private static final byte TRACK_DELTA = 5;
    public byte type = 0;
    public byte preType = 0;
    public int cameraW;
    public int cameraH;
    private int[][] track;
    private int delay;
    private int count;
    private int speed;
    private boolean isArrive = true;

    public static CWACamera getInstance() {
        if (_camera == null) {
            _camera = new CWACamera();
        }
        return _camera;
    }

    public void start() {
        this.isAction = true;
    }

    public void release() {
        if (this.track != null) {
            this.track = null;
        }
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setArrive(boolean isImmediately) {
        this.isArrive = isImmediately;
    }

    public void setCommonCamera(int x, int y, int cameraw, int camerah, boolean isImmediately) {
        this.setType((byte)0);
        this.cameraW = cameraw;
        this.cameraH = camerah;
        this.isArrive = isImmediately;
        if (this.isArrive) {
            this.actorX = x;
            this.actorY = y;
        } else {
            this.setTarget(x, y);
        }
    }

    public void setTargetCamera(CWAActor actor, int cameraw, int camerah, boolean isImmediately) {
        this.setType((byte)1);
        this.setTarget(actor);
        this.cameraW = cameraw;
        this.cameraH = camerah;
        this.isArrive = isImmediately;
        if (this.isArrive) {
            this.actorX = this.target.actorX;
            this.actorY = this.target.actorY;
        }
    }

    public void setTrackCamera(int[][] track) {
        this.setType((byte)2);
        this.track = track;
        this.count = 0;
        this.cameraW = track[this.count][3];
        this.cameraH = track[this.count][4];
        this.delay = track[this.count][5];
        this.isArrive = false;
    }

    public boolean isArrive() {
        return this.isArrive;
    }

    public void setType(byte type) {
        this.preType = this.type;
        this.type = type;
    }

    public void update() {
        switch (this.type) {
            case 0: {
                if (this.isArrive || !this.movePoint(this.speed, this.targetX, this.targetY)) break;
                this.isArrive = true;
                break;
            }
            case 1: {
                if (this.isArrive) {
                    this.actorX = this.target.actorX;
                    this.actorY = this.target.actorY;
                    break;
                }
                if (!this.movePoint(this.speed, this.target.actorX, this.target.actorY)) break;
                this.isArrive = true;
                break;
            }
            case 2: {
                if (this.isArrive) {
                    return;
                }
                if (this.delay > 0) {
                    --this.delay;
                    break;
                }
                if (this.actorX == this.track[this.count][0] && this.actorY == this.track[this.count][1]) {
                    if (this.count < this.track.length) {
                        ++this.count;
                        this.delay = this.track[this.count][5];
                        this.cameraW = this.track[this.count][3];
                        this.cameraH = this.track[this.count][4];
                        break;
                    }
                    this.isArrive = true;
                    break;
                }
                this.movePoint(this.track[this.count][2], this.track[this.count][0], this.track[this.count][1]);
            }
        }
    }
}

