/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwabase2d;

import java.io.ByteArrayOutputStream;
import javax.microedition.rms.RecordStore;

public class CWARms {
    private String name;
    private RecordStore rms;
    private int record_nums;
    private final byte RMS_GET_NUMS;
    private final byte RMS_ADD_RECORD;
    private final byte RMS_REMOVE_RECORD = (byte)2;
    private final byte RMS_GET_RECORD = (byte)3;
    private final byte RMS_SET_RECORD = (byte)4;
    private final byte RMS_CLOSE = (byte)6;
    private final byte RMS_DELETE = (byte)7;
    private int curRmsRecordID = 1;

    public CWARms(String na, int RmsCount) {
        this.RMS_GET_NUMS = 0;
        this.RMS_ADD_RECORD = 1;
        this.name = na;
        if (this.getRecordNums() == 0) {
            this.initRms(RmsCount);
        } else if (this.getRecordNums() != RmsCount) {
            this.delete();
            this.initRms(RmsCount);
        }
    }

    private void initRms(int RmsCount) {
        try {
            byte[] temp = new byte[]{0};
            for (int i = 0; i < RmsCount; ++i) {
                this.addRecord(temp, 0, temp.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRecordID(int ID) {
        this.curRmsRecordID = ID + 1;
    }

    private int getRecordNums() {
        this.rmsOptions(this.curRmsRecordID, null, 0, 0, 0);
        return this.record_nums;
    }

    private void addRecord(byte[] info, int start, int length) {
        this.rmsOptions(this.curRmsRecordID, info, start, length, 1);
    }

    public void removeRecord() {
        this.setRecord(new byte[]{0}, 0, 1);
    }

    private void setRecord(byte[] info, int start, int length) {
        this.rmsOptions(this.curRmsRecordID, info, start, length, 4);
    }

    private byte[] getRecord(int recordId) {
        return this.rmsOptions(recordId, null, 0, 0, 3);
    }

    public byte[] getRecords() {
        byte[] tmp = this.rmsOptions(this.curRmsRecordID, null, 0, 0, 3);
        byte[] tmpSave = new byte[tmp.length - 1];
        System.arraycopy(tmp, 1, tmpSave, 0, tmpSave.length);
        return tmpSave;
    }

    public byte[] getRecords(int recordID) {
        byte[] tmp = this.rmsOptions(recordID + 1, null, 0, 0, 3);
        byte[] tmpSave = new byte[tmp.length - 1];
        System.arraycopy(tmp, 1, tmpSave, 0, tmpSave.length);
        this.close();
        return tmpSave;
    }

    public void save(ByteArrayOutputStream baos) {
        byte[] tmp = baos.toByteArray();
        byte[] tmpSave = new byte[tmp.length + 1];
        System.arraycopy(tmp, 0, tmpSave, 1, tmp.length);
        tmpSave[0] = 1;
        this.setRecord(tmpSave, 0, tmpSave.length);
        this.close();
    }

    public boolean haveRecord(int recordID) {
        return this.getRecord(recordID + 1)[0] != 0;
    }

    public boolean haveRecord() {
        return this.getRecord(this.curRmsRecordID)[0] != 0;
    }

    private void close() {
        this.rmsOptions(0, null, 0, 0, 6);
    }

    public void delete() {
        this.rmsOptions(0, null, 0, 0, 7);
    }

    private byte[] rmsOptions(int recordId, byte[] info, int start, int length, int flag) {
        try {
            if (flag == 7 || flag == 6) {
                if (this.rms != null) {
                    this.rms.closeRecordStore();
                    this.rms = null;
                }
                if (flag == 7) {
                    RecordStore.deleteRecordStore((String)this.name);
                }
                return null;
            }
            if (this.rms == null) {
                this.rms = RecordStore.openRecordStore((String)this.name, (boolean)true);
            }
            switch (flag) {
                case 0: {
                    this.record_nums = this.rms.getNumRecords();
                    break;
                }
                case 1: {
                    this.rms.addRecord(info, start, length);
                    break;
                }
                case 2: {
                    this.rms.deleteRecord(recordId);
                    break;
                }
                case 3: {
                    return this.rms.getRecord(recordId);
                }
                case 4: {
                    this.rms.setRecord(recordId, info, start, length);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

