/*
 * Decompiled with CFR 0.152.
 */
package CWAUI;

import CWA2DAPI.CWACommon;
import CWAUI.CWAUICommandListener;
import CWAUI.CWAUIControl;
import CWAUI.CWAUIFonts;
import CWAUI.CWAUIItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CWAUIManager {
    private static CWAUIManager _instance;
    private Hashtable _elements = new Hashtable();
    private Vector _renderList = new Vector();
    private Vector _curKey = new Vector();
    public CWAUIControl curControl;
    public CWAUIFonts fonts = new CWAUIFonts(12);

    private CWAUIManager() {
        this.fonts.LoadFonts("/data/script/fonts_12.mid");
    }

    public static CWAUIManager getInstance() {
        if (_instance == null) {
            _instance = new CWAUIManager();
        }
        return _instance;
    }

    public void release() {
        if (_instance != null) {
            _instance.clear();
        }
        this.curControl = null;
    }

    public void draw(Graphics g) {
        if (this._renderList != null) {
            for (int i = 0; i < this._renderList.size(); ++i) {
                CWAUIControl dlg = (CWAUIControl)this._renderList.elementAt(i);
                dlg.RenderAll(g);
            }
        }
        g.setClip(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
    }

    public void update() {
        if (this.curControl != null) {
            this.curControl.updateAll();
        }
    }

    public void show(String key, int sprIndex, CWAUICommandListener cl) {
        CWAUIControl Control = (CWAUIControl)this._elements.get(key);
        if (Control != null) {
            if (!key.equals("/data/ui/dialog.ui")) {
                this._elements.remove(key);
            }
            this._renderList.removeElement(Control);
            if (!key.equals("/data/ui/dialog.ui")) {
                Control.Release();
                Control = null;
            }
            if (key.equals("/data/ui/dialog.ui")) {
                this._renderList.addElement(Control);
                this.curControl = Control;
                this._curKey.addElement(key);
            }
        }
        if (Control == null) {
            Control = new CWAUIControl(cl);
            Control.Load(this.fonts);
            Control.Load(key, sprIndex, false);
            this._elements.put(key, Control);
            this._renderList.addElement(Control);
            this.curControl = Control;
            this._curKey.addElement(key);
        }
    }

    public void close(String key) {
        CWAUIControl Control = (CWAUIControl)this._elements.get(key);
        if (Control != null) {
            if (this.curControl.equals(Control)) {
                this.curControl = null;
            }
            if (!key.equals("/data/ui/dialog.ui")) {
                this._elements.remove(key);
            }
            this._renderList.removeElement(Control);
            this._curKey.removeElement(key);
            if (!key.equals("/data/ui/dialog.ui")) {
                Control.Release();
                Control = null;
            }
        }
        if (this._elements.size() > 0 && this._renderList.size() > 0) {
            this.curControl = (CWAUIControl)this._renderList.lastElement();
        }
    }

    public void clear() {
        Enumeration e = this._elements.elements();
        while (e.hasMoreElements()) {
            CWAUIControl Control = (CWAUIControl)e.nextElement();
            Control.Release();
            Object var2_2 = null;
        }
        this._elements.clear();
        this._renderList.removeAllElements();
    }

    public boolean checkCurKey(String key) {
        return this._curKey.size() > 0 && this._curKey.firstElement().equals(key);
    }

    public boolean checkUpKey(String key) {
        return this._curKey.size() > 0 && this._curKey.lastElement().equals(key);
    }

    public boolean isContain(String key) {
        return this._curKey.size() > 0 && this._curKey.contains(key);
    }

    public CWAUIControl getControl(String key) {
        return (CWAUIControl)this._elements.get(key);
    }

    public String curKey() {
        if (this._curKey.size() > 0) {
            return (String)this._curKey.lastElement();
        }
        return null;
    }

    public boolean getSprFrame(CWAUIControl control, int id, int frame) {
        return ((CWAUIItem)control.GetRefFromId((int)id)).GetUiFrontData().UnSelectedIFrame.getSprite().isCheckFrame(frame);
    }

    public int getSprFrame(CWAUIControl control, int id) {
        return ((CWAUIItem)control.GetRefFromId((int)id)).GetUiFrontData().UnSelectedIFrame.getSprite().getCurFrame();
    }

    public boolean isEndFrame(int id) {
        return ((CWAUIItem)this.curControl.GetRefFromId((int)id)).GetUiFrontData().UnSelectedIFrame.getSprite().isEndFrame() && ((CWAUIItem)this.curControl.GetRefFromId((int)id)).GetUiFrontData().UnSelectedIFrame.getSprite().isEnddelay();
    }

    public int getDelay(int id) {
        return ((CWAUIItem)this.curControl.GetRefFromId((int)id)).GetUiFrontData().UnSelectedIFrame.getSprite().delay();
    }
}

