/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ui;

import com.zy.ui.Panel;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Label
extends Panel {
    private String text = null;
    private int textColor = 0;
    private Font font = null;
    private int textWidth = 0;

    public Label(String text, int textColor, int backColor, boolean viewBackColor) {
        super(text == null ? 0 : Font.getDefaultFont().stringWidth(text), Font.getDefaultFont().getHeight(), backColor, viewBackColor);
        this.text = text;
        this.textColor = textColor;
        this.font = Font.getDefaultFont();
        this.resetTextWidth();
    }

    private void resetTextWidth() {
        this.textWidth = this.text == null ? 0 : this.font.stringWidth(this.text);
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetTextWidth();
    }

    public void draw(Graphics g) {
        super.draw(g);
        if (this.text == null) {
            return;
        }
        Label.saveOldColor(g);
        g.setColor(this.textColor);
        int tempX = this.xAbstractScreen + (this.getWidth() - this.getTextWidth() >> 1);
        g.drawString(this.text, tempX, this.yAbstractScreen + 1, 20);
        Label.loadOldColor(g);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = null;
        this.text = text;
        if (text == null) {
            return;
        }
        this.resetTextWidth();
        this.setSize(this.getTextWidth() + 2, this.font.getHeight() + 2);
    }

    public int getTextWidth() {
        return this.textWidth;
    }
}

