/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ui;

import com.zy.ui.Label;
import javax.microedition.lcdui.Graphics;

public class PageNumberBar
extends Label {
    private int curIndex = 1;
    private int maxNumber = 1;
    private boolean pageChange = false;

    public PageNumberBar(int maxNumber, int textColor, int backColor, boolean ViewBackColor) {
        super("<1/" + maxNumber + ">", textColor, backColor, ViewBackColor);
        this.maxNumber = maxNumber;
    }

    public PageNumberBar(int textColor, int backColor, boolean ViewBackColor) {
        super("<1/1>", textColor, backColor, ViewBackColor);
    }

    public void setMaxPageNumber(int maxPageNumber) {
        if (maxPageNumber < 1) {
            maxPageNumber = 1;
        }
        this.maxNumber = maxPageNumber;
        if (this.curIndex > this.maxNumber) {
            this.curIndex = this.maxNumber;
        }
        this.setValue(this.curIndex);
    }

    public boolean pageNext() {
        int tempCurIndex = this.curIndex;
        if (tempCurIndex < this.maxNumber) {
            this.curIndex = ++tempCurIndex;
            this.pageChange = true;
        } else {
            this.pageChange = false;
        }
        this.setValue(this.curIndex);
        return this.pageChange;
    }

    private void setValue(int curIndex) {
        String str = "<" + curIndex + "/" + this.maxNumber + ">";
        this.setText(str);
    }

    public boolean pagePre() {
        int tempCurIndex = this.curIndex;
        if (tempCurIndex > 1) {
            this.curIndex = --tempCurIndex;
            this.pageChange = true;
        } else {
            this.pageChange = false;
        }
        this.setValue(this.curIndex);
        return this.pageChange;
    }

    public void draw(Graphics g) {
        super.draw(g);
    }

    public String getPageString() {
        return this.getText();
    }

    public boolean pageMin() {
        int tempCurIndex = this.curIndex;
        this.curIndex = 1;
        this.setValue(this.curIndex);
        return tempCurIndex != this.curIndex;
    }

    public boolean pageMax() {
        int tempCurIndex = this.curIndex;
        this.curIndex = this.maxNumber;
        this.setValue(this.curIndex);
        return tempCurIndex != this.curIndex;
    }

    public int getCurrentPage() {
        return this.curIndex;
    }

    public int getMaxPage() {
        return this.maxNumber;
    }

    public boolean isMaxPage() {
        return this.curIndex == this.maxNumber;
    }

    public boolean isFirstPage() {
        return this.curIndex == 1;
    }
}

