/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ui;

import com.zy.ui.ActionListener;
import com.zy.ui.BackgroundInterface;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Panel {
    public static final int KEY_NONE = 0;
    public static final int KEY_NUM0 = 1;
    public static final int KEY_NUM1 = 2;
    public static final int KEY_NUM2 = 4;
    public static final int KEY_NUM3 = 8;
    public static final int KEY_NUM4 = 16;
    public static final int KEY_NUM5 = 32;
    public static final int KEY_NUM6 = 64;
    public static final int KEY_NUM7 = 128;
    public static final int KEY_NUM8 = 256;
    public static final int KEY_NUM9 = 512;
    public static final int KEY_STAR = 1024;
    public static final int KEY_POUND = 2048;
    public static final int KEY_UP = 4096;
    public static final int KEY_DOWN = 8192;
    public static final int KEY_LEFT = 16384;
    public static final int KEY_RIGHT = 32768;
    public static final int KEY_OK = 65536;
    public static final int KEY_SOFT_LEFT = 131072;
    public static final int KEY_SOFT_RIGHT = 262144;
    private Panel parent = null;
    private ActionListener pl = null;
    private BackgroundInterface bi = null;
    protected int xRelativeParent = 0;
    protected int yRelativeParent = 0;
    protected int xAbstractScreen = 0;
    protected int yAbstractScreen = 0;
    protected int key = 0;
    private Vector childPanels = null;
    private int width = 0;
    private int height = 0;
    private int backColor = 0;
    private static int oldColor = 0;
    private static int oldClipX = 0;
    private static int oldClipY = 0;
    private static int oldClipW = 0;
    private static int oldClipH = 0;
    private boolean viewBackColor = false;
    private boolean isFocus = false;
    private boolean canGetFocus = true;

    public Panel(int width, int height, int backColor, boolean viewBackColor) {
        this.width = width;
        this.height = height;
        this.backColor = backColor;
        this.viewBackColor = viewBackColor;
    }

    public void setXYRelativeParent(int xRelativeParent, int yRelativeParent) {
        this.setXRelativeParent(xRelativeParent);
        this.setYRelativeParent(yRelativeParent);
    }

    public int getXRelativeParent() {
        return this.xRelativeParent;
    }

    public void setXRelativeParent(int xRelativeParent) {
        this.xRelativeParent = xRelativeParent;
        this.updataXAbstractScreen(xRelativeParent);
    }

    public int getYRelativeParent() {
        return this.yRelativeParent;
    }

    public void setYRelativeParent(int yRelativeParent) {
        this.yRelativeParent = yRelativeParent;
        this.updataYAbstractScreen(yRelativeParent);
    }

    public int getXAbstractScreen() {
        return this.xAbstractScreen;
    }

    public synchronized void updataXAbstractScreen(int xRelativeParent) {
        this.xAbstractScreen = this.parent == null ? xRelativeParent : this.parent.getXAbstractScreen() + xRelativeParent;
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                Panel child = (Panel)this.childPanels.elementAt(i);
                child.updataXAbstractScreen(child.getXRelativeParent());
            }
        }
    }

    public int getYAbstractScreen() {
        return this.yAbstractScreen;
    }

    public void updataYAbstractScreen(int yRelativeParent) {
        this.yAbstractScreen = this.parent == null ? yRelativeParent : this.parent.getYAbstractScreen() + yRelativeParent;
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                Panel child = (Panel)this.childPanels.elementAt(i);
                child.updataYAbstractScreen(child.getYRelativeParent());
            }
        }
    }

    public synchronized void updataXYAbstractScreen(int xRelativeParent, int yRelativeParent) {
        if (this.parent == null) {
            this.xAbstractScreen = xRelativeParent;
            this.yAbstractScreen = yRelativeParent;
        } else {
            this.xAbstractScreen = this.parent.getXAbstractScreen() + xRelativeParent;
            this.yAbstractScreen = this.parent.getYAbstractScreen() + yRelativeParent;
        }
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                Panel child = (Panel)this.childPanels.elementAt(i);
                child.updataXYAbstractScreen(child.getXRelativeParent(), child.getYRelativeParent());
            }
        }
    }

    protected void setParent(Panel parent) {
        this.parent = null;
        this.parent = parent;
    }

    public synchronized Panel getParent() {
        return this.parent;
    }

    protected synchronized void removeParent() {
        this.parent = null;
        this.updataXYAbstractScreen(this.xRelativeParent, this.yRelativeParent);
    }

    public final int getBackColor() {
        return this.backColor;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public synchronized void draw(Graphics g) {
        if (this.viewBackColor) {
            if (this.bi == null) {
                Panel.saveOldColor(g);
                g.setColor(this.backColor);
                g.fillRect(this.xAbstractScreen, this.yAbstractScreen, this.width, this.height);
                Panel.loadOldColor(g);
            } else {
                Panel.saveOldClipXYWH(g);
                Panel.saveOldColor(g);
                this.bi.drawOutBackGround(g);
                Panel.loadOldClipXYWH(g);
                Panel.loadOldColor(g);
            }
        }
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                ((Panel)this.childPanels.elementAt(i)).draw(g);
            }
        }
    }

    public void setFocus(boolean isFocus) {
        this.isFocus = this.canGetFocus ? isFocus : false;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public synchronized void setMeAndMyChildsFocusFalse() {
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                Panel oneChild = (Panel)this.childPanels.elementAt(i);
                oneChild.setMeAndMyChildsFocusFalse();
            }
        }
        this.setFocus(false);
    }

    public void canGetFocus(boolean canGetFocus) {
        this.canGetFocus = canGetFocus;
        if (!canGetFocus) {
            this.isFocus = false;
        }
    }

    public final synchronized void append(Panel childPanel) {
        if (this.childPanels == null) {
            this.childPanels = new Vector();
        }
        if (this.childPanels.indexOf(childPanel) == -1) {
            this.childPanels.addElement(childPanel);
            childPanel.setParent(this);
            childPanel.updataXYAbstractScreen(childPanel.getXRelativeParent(), childPanel.getYRelativeParent());
        }
    }

    public final synchronized void remove(Panel childPanel) {
        if (this.childPanels != null && childPanel != null) {
            childPanel.removeParent();
            this.childPanels.removeElement(childPanel);
        }
    }

    public final synchronized void removeAll() {
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                ((Panel)this.childPanels.elementAt(i)).removeParent();
            }
            this.childPanels.removeAllElements();
        }
    }

    public synchronized void upData() {
        if (this.childPanels != null) {
            for (int i = 0; i < this.childPanels.size(); ++i) {
                ((Panel)this.childPanels.elementAt(i)).upData();
            }
        }
    }

    public synchronized boolean keyPressed(int key) {
        boolean childPanelPointerValue = false;
        if (this.childPanels != null) {
            int i;
            Panel[] tempArray = new Panel[this.childPanels.size()];
            for (i = 0; i < tempArray.length; ++i) {
                tempArray[i] = (Panel)this.childPanels.elementAt(i);
            }
            for (i = tempArray.length - 1; i > -1; --i) {
                Panel oneChild = tempArray[i];
                if (childPanelPointerValue) {
                    oneChild.setMeAndMyChildsFocusFalse();
                    continue;
                }
                childPanelPointerValue = oneChild.keyPressed(key);
            }
        }
        if (childPanelPointerValue) {
            this.setFocus(false);
            return true;
        }
        if (this.checkKeyInMine(key)) {
            this.setFocus(true);
            if (this.pl != null) {
                final Panel mine = this;
                final ActionListener tempPl = this.pl;
                if (mine != null && tempPl != null) {
                    new Thread(new Runnable(){

                        public synchronized void run() {
                            tempPl.doAction(mine);
                        }
                    }).start();
                }
            }
            return true;
        }
        this.setFocus(false);
        return false;
    }

    public synchronized boolean keyReleased(int key) {
        return false;
    }

    public synchronized boolean pointerPressed(int x, int y) {
        boolean childPanelPointerValue = false;
        if (this.childPanels != null) {
            int i;
            Panel[] tempArray = new Panel[this.childPanels.size()];
            for (i = 0; i < tempArray.length; ++i) {
                tempArray[i] = (Panel)this.childPanels.elementAt(i);
            }
            for (i = tempArray.length - 1; i > -1; --i) {
                Panel oneChild = tempArray[i];
                if (childPanelPointerValue) {
                    oneChild.setMeAndMyChildsFocusFalse();
                    continue;
                }
                childPanelPointerValue = oneChild.pointerPressed(x, y);
            }
        }
        if (childPanelPointerValue) {
            return true;
        }
        if (this.checkPointerInMine(x, y)) {
            this.setFocus(true);
            System.out.println("pointerPressed setFocus=true;");
            System.out.println("isFocus= " + this.isFocus());
            if (this.pl != null) {
                final Panel mine = this;
                final ActionListener tempPl = this.pl;
                if (this != null && tempPl != null) {
                    new Thread(new Runnable(){

                        public synchronized void run() {
                            tempPl.doAction(mine);
                        }
                    }).start();
                }
            }
            return true;
        }
        this.setFocus(false);
        return false;
    }

    public static int getKeyValue(int key) {
        switch (key) {
            case 48: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 42: {
                return 1024;
            }
            case 35: {
                return 2048;
            }
            case -1: {
                return 4096;
            }
            case -2: {
                return 8192;
            }
            case -3: {
                return 16384;
            }
            case -4: {
                return 32768;
            }
            case -5: {
                return 65536;
            }
            case -21: 
            case -6: {
                return 131072;
            }
            case -22: 
            case -7: {
                return 262144;
            }
        }
        return 0;
    }

    public void clearKey() {
    }

    public void addActionListener(ActionListener pl) {
        this.pl = null;
        this.pl = pl;
    }

    public void addBackgroundInterface(BackgroundInterface background) {
        this.bi = null;
        this.bi = background;
    }

    public boolean checkPointerInMine(int x, int y) {
        return x > this.getXAbstractScreen() && x < this.getXAbstractScreen() + this.getWidth() && y > this.getYAbstractScreen() && y < this.getYAbstractScreen() + this.getHeight();
    }

    public boolean checkKeyInMine(int key) {
        return this.key != 0 && this.key == key;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    protected static void saveOldClipXYWH(Graphics g) {
        oldClipX = g.getClipX();
        oldClipY = g.getClipY();
        oldClipW = g.getClipWidth();
        oldClipH = g.getClipHeight();
    }

    protected static void loadOldClipXYWH(Graphics g) {
        g.setClip(oldClipX, oldClipY, oldClipW, oldClipH);
    }

    protected static void saveOldColor(Graphics g) {
        oldColor = g.getColor();
    }

    protected static void loadOldColor(Graphics g) {
        g.setColor(oldColor);
    }

    public void setKey(int key) {
        this.key = key;
    }
}

