/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAScreenChange;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwabase2d.CWACamera;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAMap;
import CWAEvent.CWAEvent;
import CWAEvent.CWAEventStruct;
import game.GameBattle;
import game.GameDialog;
import game.GameManager;
import game.GameNpc;
import game.GamePet;
import game.GamePlayer;
import game.GameWorld;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameEvent
extends CWACommon
implements CWAGlobal {
    public static byte isReCall;
    private static GameEvent gameEvent;
    private GameWorld gameWorld;
    private GamePlayer gamePlayer;
    private CWACommon _game;
    public CWAEvent[] roomEvent;
    public Vector curEvent;
    private byte curEventId = (byte)-1;
    public byte[][] eventState;
    public int count = 0;
    public int curState = -1;
    public static Vector bqVector;
    public static Vector taskVector;
    private GameDialog gameDialog = GameDialog.getInstance();
    public static boolean isUiClose;
    public static boolean isfrash;
    public static boolean eventTalk;
    public static boolean begainTalk;
    public boolean eventSms = true;
    public static boolean eventEscape;
    public static boolean battleKey;
    public boolean ride = true;
    public boolean smscheck = false;
    public byte eventBattleResult = 0;
    public static byte eventBuyEgg;
    private short[] mulNpc;
    private byte[] step;
    private short[] stepX;
    private short[] stepY;
    private short[][] posX;
    private short[][] posY;
    private short[] spX;
    private short[] spY;
    public byte countDown = 0;
    public static Image img;
    private String[] imgStr = new String[]{"ikon_1", "ikon_2", "ikon_3", "ikon_4", "ikon_5"};
    private int imgX;
    private int imgY;
    private int speed;
    private int optionNum = 0;
    private int optionType = 0;
    private byte[] optionSkip;
    private String[] optionStr;
    private int[] taskType;
    private int[] taskTypeId;
    private String[] taskStr = null;
    private CWASprActor arrowSpr = null;
    private int arrowId = -1;
    private Calendar calendar = null;
    private int[] date;
    public byte gameTimes = 0;
    private final byte GAMETIMES = (byte)5;
    public static String[] branchQuestStr;
    public static String[] mainQuestStr;
    public static short[][] taskNum;
    public static byte mainQuestIndex;
    public static byte branchQuestIndex;
    public static final short[] branchParam;
    public static byte[][] mapAccept;
    public static byte[][] mapHand;

    public GameEvent() {
        if (this.gameWorld == null) {
            this.gameWorld = GameWorld.getInstance();
        }
        if (this.gamePlayer == null) {
            this.gamePlayer = GamePlayer.getInstance();
        }
        if (this.eventState == null) {
            this.eventState = new byte[127][];
        }
        if (taskNum == null) {
            taskNum = new short[200][2];
        }
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(TimeZone.getDefault());
        }
        try {
            int i;
            InputStream is = CWATools.getInputStream("/data/script/bTask.mid");
            String[][] tempStr = CWATools.get2DStrings(is);
            branchQuestStr = new String[tempStr.length];
            for (i = 0; i < tempStr.length; ++i) {
                System.arraycopy(tempStr[i], 0, branchQuestStr, i, tempStr[i].length);
            }
            is = CWATools.getInputStream("/data/script/mTask.mid");
            tempStr = CWATools.get2DStrings(is);
            mainQuestStr = new String[tempStr.length];
            for (i = 0; i < tempStr.length; ++i) {
                System.arraycopy(tempStr[i], 0, mainQuestStr, i, tempStr[i].length);
            }
            is = CWATools.getInputStream("/data/script/bqTask.mid");
            mapAccept = CWATools.getByte2DArray(is);
            mapHand = CWATools.getByte2DArray(is);
            is.close();
            is = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static GameEvent getInstance() {
        if (gameEvent == null) {
            gameEvent = new GameEvent();
        }
        return gameEvent;
    }

    public void setGame(CWACommon game) {
        if (this._game != null) {
            this._game = null;
        }
        this._game = game;
    }

    public void update() {
        if (this.roomEvent == null) {
            return;
        }
        CWAScreenChange.getInstance().update();
        this.gameDialog.update();
        this.checkQuest();
        this.executeQuest();
    }

    public void drawBq(Graphics g) {
        CWASprActor spActor;
        int i;
        if (bqVector != null) {
            for (i = 0; i < bqVector.size(); ++i) {
                spActor = (CWASprActor)bqVector.elementAt(i);
                spActor.setPosition(spActor.target.getActorX(), spActor.target.getActorY() - 40);
                spActor.drawSprite(g, CWAMap.getInstance().leftTopX, CWAMap.getInstance().leftTopY);
            }
        }
        if (taskVector != null) {
            for (i = 0; i < taskVector.size(); ++i) {
                spActor = (CWASprActor)taskVector.elementAt(i);
                spActor.drawSprite(g, CWAMap.getInstance().leftTopX, CWAMap.getInstance().leftTopY);
            }
        }
    }

    public void drawCt(Graphics g) {
        if (img != null) {
            g.setColor(0);
            g.fillRect(0, 0, (int)GameEvent.getWidth(), (int)GameEvent.getHeight());
            g.drawImage(img, this.imgX, this.imgY, 20);
        }
        if (this.arrowSpr != null && this.arrowId == GameWorld.getMapId(this.gameWorld.sceneId, this.gameWorld.roomId)) {
            this.arrowSpr.drawSprite(g, CWAMap.getInstance().leftTopX, CWAMap.getInstance().leftTopY);
        }
    }

    public void updateBq() {
        CWASprActor spActor;
        int i;
        if (bqVector != null) {
            for (i = 0; i < bqVector.size(); ++i) {
                spActor = (CWASprActor)bqVector.elementAt(i);
                spActor.updateAction();
                if (!spActor.sprite.isEndFrame()) continue;
                spActor.stop();
                bqVector.removeElementAt(i);
                --i;
            }
        }
        if (taskVector != null) {
            for (i = 0; i < taskVector.size(); ++i) {
                spActor = (CWASprActor)taskVector.elementAt(i);
                spActor.updateAction();
            }
        }
        if (this.arrowSpr != null) {
            this.arrowSpr.updateAction();
        }
    }

    public void render(Graphics g) {
        CWAScreenChange.getInstance().render(g);
        this.drawCt(g);
        this.gameDialog.render(g);
    }

    public boolean init() {
        return true;
    }

    public boolean init(DataInputStream dis, int scId, int roomId, int evtCount, String[] roomStr) {
        try {
            this.roomEvent = new CWAEvent[evtCount];
            this.curEvent = new Vector();
            bqVector = new Vector();
            int srId = scId << 8 | roomId;
            if (this.eventState[GameWorld.mapIndex[scId] + roomId] == null) {
                this.eventState[GameWorld.mapIndex[scId] + roomId] = new byte[evtCount];
            }
            for (byte i = 0; i < evtCount; i = (byte)(i + 1)) {
                this.roomEvent[i] = new CWAEvent();
                this.roomEvent[i].init(dis, i, srId, roomStr);
                this.roomEvent[i].setState(this.eventState[GameWorld.mapIndex[scId] + roomId][i]);
            }
        }
        catch (IOException ex) {
            System.out.println(" ex = " + ex.toString() + " event init ");
        }
        this.canAccept();
        return false;
    }

    public void delete() {
        this.gamePlayer = null;
        this.gameWorld = null;
        this.eventState = null;
        taskNum = null;
        this.calendar = null;
        gameEvent = null;
    }

    public void release() {
        if (bqVector != null) {
            bqVector.removeAllElements();
            bqVector = null;
        }
        if (taskVector != null) {
            taskVector.removeAllElements();
            taskVector = null;
        }
        this.roomEvent = null;
        this.mulNpc = null;
        this.step = null;
        this.stepX = null;
        this.stepY = null;
        this.posX = null;
        this.posY = null;
        this.spX = null;
        this.spY = null;
        img = null;
        this.optionSkip = null;
        this.optionStr = null;
    }

    public void setState(byte state) {
    }

    public byte siftHandQuest(int j) {
        for (int i = 0; i < this.roomEvent.length; ++i) {
            CWAEventStruct evt;
            if (this.roomEvent[i].getState() == 3 || j == i || (evt = this.roomEvent[i].firstEvent()).getType() != 44 || GameWorld.getMapId(evt.getPara()[2], evt.getPara()[3]) != GameWorld.getMapId(this.gameWorld.sceneId, this.gameWorld.roomId) || evt.getPara()[4] != GameWorld.collNpc || !this.canAchieve(evt)) continue;
            return (byte)i;
        }
        return -1;
    }

    public byte siftAcceptQuest(int j) {
        for (int i = 0; i < this.roomEvent.length; ++i) {
            CWAEventStruct evt;
            if (this.roomEvent[i].getState() == 3 || j == i || (evt = this.roomEvent[i].firstEvent()).getType() != 43 || GameWorld.getMapId(evt.getPara()[2], evt.getPara()[3]) != GameWorld.getMapId(this.gameWorld.sceneId, this.gameWorld.roomId) || evt.getPara()[4] != GameWorld.collNpc || !this.canAccept(evt)) continue;
            return (byte)i;
        }
        return -1;
    }

    public void checkQuest() {
        for (int i = 0; i < this.roomEvent.length; ++i) {
            if (this.roomEvent[i].getState() != 0 && this.roomEvent[i].getState() != 4) continue;
            CWAEventStruct cWAEventStruct = this.roomEvent[i].firstEvent();
            boolean bl = false;
            switch (cWAEventStruct.getType()) {
                case 44: {
                    if (GameWorld.getMapId(cWAEventStruct.getPara()[2], cWAEventStruct.getPara()[3]) != GameWorld.getMapId(this.gameWorld.sceneId, this.gameWorld.roomId) || cWAEventStruct.getPara()[4] != GameWorld.collNpc || !this.canAchieve(cWAEventStruct)) break;
                    eventTalk = true;
                    if (!begainTalk) break;
                    bl = true;
                    eventTalk = false;
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    if (cWAEventStruct.getPara()[1] != 1) break;
                    GameEvent.taskNum[GameEvent.branchQuestIndex][0] = cWAEventStruct.getPara()[0];
                    break;
                }
                case 43: {
                    if (GameWorld.getMapId(cWAEventStruct.getPara()[2], cWAEventStruct.getPara()[3]) != GameWorld.getMapId(this.gameWorld.sceneId, this.gameWorld.roomId) || cWAEventStruct.getPara()[4] != GameWorld.collNpc || !this.canAccept(cWAEventStruct)) break;
                    eventTalk = true;
                    if (!begainTalk || this.siftHandQuest(-1) != -1 || i < this.siftAcceptQuest(i)) break;
                    bl = true;
                    eventTalk = false;
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    if (cWAEventStruct.getPara()[1] != 1) break;
                    GameEvent.taskNum[GameEvent.branchQuestIndex][0] = cWAEventStruct.getPara()[0];
                    break;
                }
                case 13: {
                    if (!CWATools.isCollides(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1], cWAEventStruct.getPara()[2], cWAEventStruct.getPara()[3], this.gamePlayer.actorX, this.gamePlayer.actorY, this.gamePlayer.sprite.getbeattData())) break;
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    bl = true;
                    break;
                }
                case 15: {
                    if (this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])] == null || this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])][cWAEventStruct.getPara()[2]] != 3 && this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])][cWAEventStruct.getPara()[2]] != 4) break;
                    bl = true;
                    break;
                }
                case 16: {
                    if (cWAEventStruct.getPara()[0] != GameWorld.collNpc) break;
                    eventTalk = true;
                    if (!begainTalk) break;
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    begainTalk = false;
                    bl = true;
                    break;
                }
                case 69: {
                    if (cWAEventStruct.getPara()[0] != GameWorld.collNpc) break;
                    bl = true;
                    break;
                }
                case 57: {
                    if (this.gamePlayer.target == null || ((GameNpc)this.gamePlayer.target).actorType != 0 || ((GameNpc)this.gamePlayer.target).npcType != 11 || ((GameNpc)this.gamePlayer.target).npcId != cWAEventStruct.getPara()[3] || !begainTalk) break;
                    if (this.gameWorld.npc[cWAEventStruct.getPara()[0]].getActorX() == cWAEventStruct.getPara()[1] && this.gameWorld.npc[cWAEventStruct.getPara()[0]].getActorY() == cWAEventStruct.getPara()[2]) {
                        ((GameNpc)this.gamePlayer.target).setState((byte)0);
                    } else {
                        bl = true;
                    }
                    begainTalk = false;
                    break;
                }
                case 59: {
                    Object[] objectArray = new int[CWATools.split(cWAEventStruct.getWords()[0], ',').length];
                    int n = 0;
                    for (n = 0; n < objectArray.length; ++n) {
                        objectArray[n] = CWATools.getInteger(CWATools.split(cWAEventStruct.getWords()[0], ',')[n]);
                        if (this.gameWorld.npc[objectArray[n]].getRoleState() == 0) break;
                    }
                    if (n < objectArray.length) break;
                    bl = true;
                    break;
                }
                case 61: {
                    Object[] objectArray = new int[CWATools.split(cWAEventStruct.getWords()[0], ',').length];
                    int n = 0;
                    for (n = 0; n < objectArray.length; ++n) {
                        objectArray[n] = CWATools.getInteger(CWATools.split(cWAEventStruct.getWords()[0], ',')[n]);
                        if (this.gameWorld.npc[objectArray[n]].getRoleState() == 0) break;
                    }
                    if (n < objectArray.length) break;
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    bl = true;
                    break;
                }
                case 73: {
                    Object[] objectArray = CWATools.split(cWAEventStruct.getWords()[1], ',');
                    String[] stringArray = CWATools.split(cWAEventStruct.getWords()[0], ',');
                    int n = 0;
                    for (n = 0; n < objectArray.length && this.gamePlayer.getPokPetMapValue(CWATools.getByte(stringArray[n]), CWATools.getByte((String)objectArray[n])) >= 2; ++n) {
                    }
                    if (n < objectArray.length) break;
                    bl = true;
                    break;
                }
                case 75: {
                    if (this.gamePlayer.pokAmulet.size() < 1) break;
                    bl = true;
                    break;
                }
                case 78: {
                    Object[] objectArray = CWATools.getByteArray(cWAEventStruct.getWords()[0]);
                    byte[] byArray = CWATools.getByteArray(cWAEventStruct.getWords()[1]);
                    byte[] byArray2 = CWATools.getByteArray(cWAEventStruct.getWords()[2]);
                    int n = 0;
                    for (n = 0; n < byArray2.length && this.eventState[GameWorld.getMapId(objectArray[n], byArray[n])] != null && (this.eventState[GameWorld.getMapId(objectArray[n], byArray[n])][byArray2[n]] == 3 || this.eventState[GameWorld.getMapId(objectArray[n], byArray[n])][byArray2[n]] == 4); ++n) {
                    }
                    if (n < byArray2.length) break;
                    bl = true;
                    break;
                }
                case 79: {
                    if (this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])] == null || this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])][cWAEventStruct.getPara()[2]] != 3 || this.gamePlayer.isUserPokSpecial(0) || GameWorld.collNpc != cWAEventStruct.getPara()[3]) break;
                    eventTalk = true;
                    if (!begainTalk) break;
                    begainTalk = false;
                    bl = true;
                    break;
                }
                case 86: {
                    if (this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])] == null || this.eventState[GameWorld.getMapId(cWAEventStruct.getPara()[0], cWAEventStruct.getPara()[1])][cWAEventStruct.getPara()[2]] != 3) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl) continue;
            System.out.println(" i = " + i + " map = " + this.gameWorld.mapName);
            this.curEventId = (byte)i;
            this.roomEvent[i].setCurPtr((byte)0);
            this.curEvent.addElement(this.roomEvent[i]);
            this.roomEvent[i].setState((byte)1);
        }
    }

    public void completeTask(int taskId) {
        for (int i = 0; i < branchQuestIndex; ++i) {
            if (taskNum[i][0] != taskId) continue;
            GameEvent.taskNum[i][1] = 3;
            break;
        }
    }

    public int finkTask(int taskId) {
        for (int i = 0; i < branchQuestIndex; ++i) {
            if (taskNum[i][0] != taskId) continue;
            return i;
        }
        return -1;
    }

    public void executeQuest() {
        int i = 0;
        while (i < this.curEvent.size()) {
            CWAEvent e = (CWAEvent)this.curEvent.elementAt(i);
            CWAEventStruct ev = e.getCurEvent();
            switch (ev.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (e.getState() != 5) {
                        CWAScreenChange.getInstance().init(0, 9);
                        this.gameDialog.setPos(ev.getPara()[1], ev.getPara()[2]);
                        this.gameDialog.initDialog((byte)(ev.getPara()[0] / 10 - 1), ev.getWords()[0], ev.getPara()[0] % 10);
                        this.gameDialog.setDrawNum(true);
                        e.setState((byte)5);
                        break;
                    }
                    if (!GameDialog.isEnd || !this._game.isKeyDown(1)) break;
                    this.gameDialog.keyDialog();
                    if (GameDialog.isDrawDialog) break;
                    CWAScreenChange.getInstance().screenType = -1;
                    this.gameDialog.release();
                    e.setState((byte)1);
                    break;
                }
                case 2: {
                    if (ev.getPara()[0] == -1) {
                        this.gamePlayer.start();
                        this.gamePlayer.setState((byte)0, CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[0]));
                        break;
                    }
                    for (int j = 0; j < ev.getPara()[0]; ++j) {
                        this.gameWorld.npc[CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j])].setActorDir(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]));
                        if (this.gameWorld.npc[CWATools.getShort((String)CWATools.split((String)ev.getWords()[0], (char)',')[j])].npcType == 1) {
                            this.gameWorld.npc[CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j])].setState((byte)0);
                        }
                        this.gameWorld.npc[CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j])].start();
                    }
                    break;
                }
                case 3: {
                    if (ev.getPara()[0] == -1) {
                        this.gamePlayer.stop();
                        break;
                    }
                    short id = 0;
                    for (int j = 0; j < ev.getPara()[0]; ++j) {
                        id = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                        this.gameWorld.npc[id].stop();
                    }
                    break;
                }
                case 4: {
                    if (e.getState() != 5) {
                        this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                        this.gameWorld._gui.initDialog(ev.getWords()[0], ev.getWords()[1], ev.getPara()[1], -1);
                        e.setState((byte)5);
                        break;
                    }
                    boolean canClose = this.gameWorld._gui.updateDialog(ev.getPara()[1], -1);
                    if (!canClose || !this._game.isKeyDown(196640)) break;
                    GameWorld.getInstance().removeBq(4);
                    if (CWATools.curPage < CWATools.maxPage()) {
                        CWATools.addPage();
                        this.gameWorld._gui.setDialog(CWATools.curPage);
                        break;
                    }
                    if (GameWorld.collNpc != -1 && this.gameWorld.npc[GameWorld.collNpc].sprite.sprIndex <= 85 && this.gameWorld.npc[GameWorld.collNpc].getBqType() == 0) {
                        GameWorld.getInstance().setBq((byte)13, GameWorld.getInstance().npc[GameWorld.collNpc].actorX, GameWorld.getInstance().npc[GameWorld.collNpc].actorY - 40, GameWorld.getInstance().npc[GameWorld.collNpc]);
                    }
                    eventTalk = false;
                    begainTalk = false;
                    this.gameWorld._gui.closeDialog();
                    e.setState((byte)1);
                    break;
                }
                case 5: {
                    CWASprActor spActor = new CWASprActor();
                    spActor.initSprite(259, false);
                    spActor.reCallImage();
                    spActor.setAction((byte)ev.getPara()[2], (byte)-1, true);
                    if (ev.getPara()[0] == 0) {
                        spActor.setPosition(this.gamePlayer.getActorX(), this.gamePlayer.getActorY() - this.gamePlayer.sprite.getFrameImgWH(this.gamePlayer.getRoleState(), this.gamePlayer.faceDir)[3]);
                        spActor.setTarget(this.gamePlayer);
                    } else if (ev.getPara()[0] == 1) {
                        if (ev.getPara()[3] != 0 || ev.getPara()[4] != 0) {
                            spActor.setPosition(ev.getPara()[3], ev.getPara()[4]);
                        } else {
                            spActor.setPosition(this.gameWorld.npc[ev.getPara()[1]].getActorX(), this.gameWorld.npc[ev.getPara()[1]].getActorY());
                            spActor.setTarget(this.gameWorld.npc[ev.getPara()[1]]);
                        }
                    }
                    spActor.start();
                    bqVector.addElement(spActor);
                    break;
                }
                case 6: {
                    this.eventState[GameWorld.mapIndex[this.gameWorld.sceneId] + this.gameWorld.roomId][e.getEventId()] = 3;
                    GameWorld.getInstance().sceneId = ev.getPara()[0];
                    GameWorld.getInstance().roomId = ev.getPara()[1];
                    this.gameWorld.doorId = ev.getPara()[3] == 1 ? ev.getPara()[2] : -1;
                    GameManager.getInstance().setState((byte)22);
                    break;
                }
                case 7: {
                    if (e.getState() != 5) {
                        this.mulNpc = new short[ev.getPara()[0]];
                        for (int j = 0; j < this.mulNpc.length; ++j) {
                            this.mulNpc[j] = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                            byte dir = CWATools.getByte(CWATools.split(ev.getWords()[2], ',')[j]);
                            if (this.mulNpc[j] == -1) {
                                this.gamePlayer.setState(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[0]), dir);
                                continue;
                            }
                            this.gameWorld.npc[this.mulNpc[j]].setActorDir(dir);
                            this.gameWorld.npc[this.mulNpc[j]].setState(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]));
                        }
                        this.count = 0;
                        e.setState((byte)5);
                        break;
                    }
                    for (int j = 0; j < this.mulNpc.length; ++j) {
                        if (this.mulNpc[j] == -1) {
                            if (!this.gamePlayer.isEndFrame()) continue;
                            this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                            ++this.count;
                            continue;
                        }
                        if (!this.gameWorld.npc[this.mulNpc[j]].isEndFrame()) continue;
                        this.gameWorld.npc[this.mulNpc[j]].setState((byte)0);
                        ++this.count;
                    }
                    if (this.count < this.mulNpc.length) break;
                    this.count = 0;
                    e.setState((byte)1);
                    break;
                }
                case 8: {
                    this.gamePlayer.start();
                    GameWorld.collNpc = (short)-1;
                    this.gamePlayer.setPosition(ev.getPara()[0], ev.getPara()[1]);
                    this.gamePlayer.shadowActor.setPosition(ev.getPara()[0], ev.getPara()[1]);
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    break;
                }
                case 9: {
                    if (e.getState() != 5) {
                        boolean isSkip = false;
                        if (ev.getPara()[0] == 12 || ev.getPara()[0] == 13) {
                            CWAScreenChange.getInstance().init(0, ev.getPara()[0]);
                            CWAScreenChange.getInstance().setBlackScreen(ev.getPara()[1], ev.getPara()[2], ev.getPara()[3], ev.getPara()[4], ev.getPara()[5]);
                        } else if (ev.getPara()[0] == 10) {
                            CWAScreenChange.getInstance().init(0, ev.getPara()[0]);
                            CWAScreenChange.getInstance().setFlashScreen(ev.getPara()[1], ev.getPara()[2]);
                        } else if (ev.getPara()[0] == 15 || ev.getPara()[0] == 14) {
                            CWAScreenChange.getInstance().init(0, ev.getPara()[0]);
                            CWAScreenChange.getInstance().setImage(this.imgStr[ev.getPara()[1]], ev.getPara()[2], ev.getPara()[3], ev.getPara()[4]);
                        } else if (ev.getPara()[0] == 16) {
                            String[] imgStr1 = null;
                            if (ev.getPara()[1] == 0) {
                                imgStr1 = new String[]{"star0", "star1", "star2", "star3"};
                                CWAScreenChange.getInstance().init(16, 0, (byte)ev.getPara()[2], (byte)7, GameWorld.backImg, imgStr1);
                            } else if (ev.getPara()[1] == 1) {
                                imgStr1 = new String[]{"fire0", "fire1", "fire2"};
                                CWAScreenChange.getInstance().init(16, 0, (byte)ev.getPara()[2], (byte)0, null, imgStr1);
                            } else if (ev.getPara()[1] == 2) {
                                imgStr1 = new String[]{"fire0", "fire1", "fire2"};
                                CWAScreenChange.getInstance().init(17, 0, (byte)ev.getPara()[2], (byte)0, null, imgStr1);
                            } else {
                                isSkip = true;
                                CWAScreenChange.getInstance().init(-1, 0, (byte)ev.getPara()[2], (byte)0, null, imgStr1);
                                e.setState((byte)1);
                            }
                        } else if (ev.getPara()[0] == 17) {
                            CWAScreenChange.getInstance().init(ev.getPara()[1], ev.getPara()[0]);
                            CWAScreenChange.getInstance().setArc(ev.getPara()[2], ev.getPara()[3], ev.getPara()[4], ev.getPara()[5]);
                        } else {
                            int color = ev.getPara()[1] << 24 | ev.getPara()[2] << 16 | ev.getPara()[3] << 8 | ev.getPara()[4];
                            CWAScreenChange.getInstance().init(color, ev.getPara()[0]);
                        }
                        if (isSkip) break;
                        e.setState((byte)5);
                        break;
                    }
                    if (CWAScreenChange.getInstance().isScreenOpen && (ev.getPara()[0] == 12 || ev.getPara()[0] == 13)) {
                        e.setState((byte)1);
                        break;
                    }
                    if (ev.getPara()[0] == 16) {
                        e.setState((byte)1);
                        break;
                    }
                    if (!CWAScreenChange.getInstance().isScreenOver) break;
                    e.setState((byte)1);
                    break;
                }
                case 10: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == -1) {
                            this.step = new byte[1];
                            this.gamePlayer.setActorDir(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[0]));
                            this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                            this.gamePlayer.setCurProp((byte)0, CWATools.getByte(CWATools.split(ev.getWords()[2], ',')[0]));
                            this.step[0] = CWATools.getByte(CWATools.split(ev.getWords()[3], ',')[0]);
                        } else {
                            this.mulNpc = new short[ev.getPara()[0]];
                            this.step = new byte[ev.getPara()[0]];
                            for (int j = 0; j < this.mulNpc.length; ++j) {
                                this.mulNpc[j] = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                                if (this.mulNpc[j] != -1) {
                                    this.gameWorld.npc[this.mulNpc[j]].setActorDir(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]));
                                    this.gameWorld.npc[this.mulNpc[j]].setCurProp((byte)0, CWATools.getByte(CWATools.split(ev.getWords()[2], ',')[j]));
                                    this.gameWorld.npc[this.mulNpc[j]].setState((byte)0);
                                } else {
                                    this.gamePlayer.setActorDir(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]));
                                    this.gamePlayer.setCurProp((byte)0, CWATools.getByte(CWATools.split(ev.getWords()[2], ',')[j]));
                                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                                }
                                this.step[j] = CWATools.getByte(CWATools.split(ev.getWords()[3], ',')[j]);
                            }
                        }
                        this.count = 0;
                        e.setState((byte)5);
                        break;
                    }
                    if (ev.getPara()[0] == -1) {
                        if (this.gamePlayer.getRoleState() == 0) {
                            this.gamePlayer.setState((byte)1, this.gamePlayer.faceDir);
                            break;
                        }
                        this.step[0] = (byte)(this.step[0] - 1);
                        if (this.step[0] > 0) break;
                        this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                        if (this.gamePlayer.pokRidePet[0] == 2 || this.gamePlayer.pokRidePet[1] == 2) {
                            this.gamePlayer.setCurProp((byte)0, (short)8);
                        } else {
                            this.gamePlayer.setCurProp((byte)0, (short)4);
                        }
                        e.setState((byte)1);
                        break;
                    }
                    for (int j = 0; j < this.mulNpc.length; ++j) {
                        if (this.mulNpc[j] != -1 && this.gameWorld.npc[this.mulNpc[j]].getRoleState() == 0 || this.mulNpc[j] == -1 && this.gamePlayer.getRoleState() == 0) {
                            if (this.step[j] <= 0) continue;
                            if (this.mulNpc[j] != -1) {
                                this.gameWorld.npc[this.mulNpc[j]].setState((byte)3);
                                continue;
                            }
                            this.gamePlayer.setState((byte)1, this.gamePlayer.faceDir);
                            continue;
                        }
                        int n = j;
                        this.step[n] = (byte)(this.step[n] - 1);
                        if (this.step[j] > 0) continue;
                        ++this.count;
                        this.step[j] = 0;
                        if (this.mulNpc[j] != -1) {
                            this.gameWorld.npc[this.mulNpc[j]].setState((byte)0);
                            this.gameWorld.npc[this.mulNpc[j]].setCurProp((byte)0, (short)4);
                            continue;
                        }
                        this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                        if (this.gamePlayer.pokRidePet[0] == 2 || this.gamePlayer.pokRidePet[1] == 2) {
                            this.gamePlayer.setCurProp((byte)0, (short)8);
                            continue;
                        }
                        this.gamePlayer.setCurProp((byte)0, (short)4);
                    }
                    if (this.count < this.mulNpc.length) break;
                    e.setState((byte)1);
                    break;
                }
                case 11: {
                    if (e.getState() != 5) {
                        boolean isArrive = false;
                        if (ev.getPara()[6] == 0) {
                            isArrive = true;
                        }
                        CWACamera.getInstance().setSpeed(ev.getPara()[7]);
                        if (ev.getPara()[2] == 1) {
                            CWACamera.getInstance().setCommonCamera(ev.getPara()[4], ev.getPara()[5], ev.getPara()[0], ev.getPara()[1], isArrive);
                        } else if (ev.getPara()[2] == 0) {
                            if (ev.getPara()[3] == -1) {
                                CWACamera.getInstance().setTargetCamera(this.gamePlayer, ev.getPara()[0], ev.getPara()[1], isArrive);
                            } else {
                                CWACamera.getInstance().setTargetCamera(this.gameWorld.npc[ev.getPara()[3]], ev.getPara()[0], ev.getPara()[1], isArrive);
                            }
                        }
                        this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                        e.setState((byte)5);
                        break;
                    }
                    if (!CWACamera.getInstance().isArrive()) break;
                    e.setState((byte)1);
                    break;
                }
                case 12: {
                    ++this.count;
                    if (e.getState() != 5) {
                        e.setState((byte)5);
                        break;
                    }
                    if (this.count < ev.getPara()[0]) break;
                    this.count = 0;
                    e.setState((byte)1);
                    break;
                }
                case 13: {
                    if (CWATools.isCollides(ev.getPara()[0], ev.getPara()[1], ev.getPara()[2], ev.getPara()[3], this.gamePlayer.actorX, this.gamePlayer.actorY, this.gamePlayer.sprite.getbeattData())) {
                        e.setState((byte)1);
                        this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                        break;
                    }
                    e.setState((byte)6);
                    break;
                }
                case 14: {
                    e.setState((byte)3);
                    break;
                }
                case 16: {
                    if (ev.getPara()[0] == GameWorld.collNpc) {
                        eventTalk = true;
                        if (!begainTalk) break;
                        begainTalk = false;
                        e.setState((byte)2);
                        break;
                    }
                    e.setState((byte)6);
                    break;
                }
                case 17: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == 0) {
                            if (this.gamePlayer.canAddItem(ev.getPara()[1], ev.getPara()[2], (byte)0)) {
                                short nameId = CWADataManager.DataBase[4][ev.getPara()[1]][0];
                                this._game._gui.boxItemTips("\u83b7\u5f97: " + CWACommon.STR(nameId), ev.getPara()[2]);
                                this.gamePlayer.addItem(ev.getPara()[1], ev.getPara()[2], (byte)0);
                            } else {
                                this._game._gui.boxItemTips("\u6b64\u9053\u5177\u80cc\u5305\u5df2\u6ee1");
                            }
                        } else if (this.gamePlayer.canRemoveItem(ev.getPara()[1], ev.getPara()[2], (byte)0)) {
                            short nameId = CWADataManager.DataBase[4][ev.getPara()[1]][0];
                            this._game._gui.boxItemTips("\u5931\u53bb: " + CWACommon.STR(nameId), ev.getPara()[2]);
                            this.gamePlayer.removeItem(ev.getPara()[1], ev.getPara()[2], (byte)0);
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 18: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == 0) {
                            if (this.gamePlayer.canAddItem(ev.getPara()[1], ev.getPara()[2], (byte)2)) {
                                short nameId = CWADataManager.DataBase[3][ev.getPara()[1]][0];
                                this._game._gui.boxItemTips("\u83b7\u5f97: " + CWACommon.STR(nameId), ev.getPara()[2]);
                                this.gamePlayer.addItem(ev.getPara()[1], ev.getPara()[2], (byte)2);
                            } else {
                                this._game._gui.boxItemTips("\u6b64\u9053\u5177\u80cc\u5305\u5df2\u6ee1");
                            }
                        } else if (ev.getPara()[0] == 1) {
                            short nameId = CWADataManager.DataBase[3][ev.getPara()[1]][0];
                            this._game._gui.boxItemTips("\u5931\u53bb: " + CWACommon.STR(nameId), ev.getPara()[2]);
                            this.gamePlayer.removeItem(ev.getPara()[1], ev.getPara()[2], (byte)2);
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 19: {
                    if (e.getState() != 5) {
                        short nameId = CWADataManager.DataBase[5][ev.getPara()[0]][0];
                        this._game._gui.boxItemTips("\u83b7\u5f97: " + CWACommon.STR(nameId), ev.getPara()[1]);
                        int returnValue = this.gamePlayer.canAddPokSpecial(ev.getPara()[0], ev.getPara()[1]);
                        if (returnValue != -1) {
                            if (returnValue == 1) {
                                this._game._gui.boxItemTips("\u6b64\u7c7b\u9053\u5177\u80cc\u5305\u5df2\u6ee1");
                            } else {
                                this.gamePlayer.addPokSpecial(ev.getPara()[0], ev.getPara()[1]);
                            }
                        } else if (ev.getPara()[0] == 0) {
                            this.gamePlayer.openPokSpecial(ev.getPara()[0], -1);
                        } else {
                            this.gamePlayer.addPokSpecial(ev.getPara()[0]);
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 20: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == 1) {
                            this._game._gui.boxItemTips("\u5931\u53bb: " + ev.getWords()[0]);
                            this.gamePlayer.taskItem[ev.getPara()[1]] = false;
                        } else {
                            this._game._gui.boxItemTips("\u83b7\u5f97: " + ev.getWords()[0]);
                            this.gamePlayer.taskItem[ev.getPara()[1]] = true;
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 21: {
                    GameWorld.isPlayer = false;
                    GameWorld.npcId = ev.getPara()[2];
                    if (ev.getPara()[1] != 1) break;
                    GameWorld.cameraX = ev.getPara()[3];
                    GameWorld.cameraY = ev.getPara()[4];
                    GameWorld.cameraW = ev.getPara()[5];
                    GameWorld.cameraH = ev.getPara()[6];
                    break;
                }
                case 22: {
                    GameWorld.isPlayer = true;
                    GameWorld.faceDir = (byte)ev.getPara()[1];
                    GameWorld.getInstance().playerX = ev.getPara()[2];
                    GameWorld.getInstance().playerY = ev.getPara()[3];
                    GameWorld.cameraW = ev.getPara()[4];
                    GameWorld.cameraH = ev.getPara()[5];
                    GameWorld.getInstance().doorId = -1;
                    break;
                }
                case 23: {
                    this.eventState[GameWorld.getMapId((int)ev.getPara()[0], (int)ev.getPara()[1])][ev.getPara()[2]] = 3;
                    if (ev.getPara()[0] != this.gameWorld.sceneId || ev.getPara()[1] != this.gameWorld.roomId) break;
                    this.roomEvent[ev.getPara()[2]].setState((byte)3);
                    if (this.curEvent.size() <= 0) break;
                    this.curEvent.removeElement(this.roomEvent[ev.getPara()[2]]);
                    --i;
                    break;
                }
                case 24: {
                    if (e.getState() != 5) {
                        CWAScreenChange.getInstance().init(0, 11);
                        CWAScreenChange.getInstance().setShakeParam(ev.getPara()[0], ev.getPara()[1], ev.getPara()[2]);
                        e.setState((byte)5);
                        break;
                    }
                    if (!CWAScreenChange.getInstance().isScreenOver) break;
                    e.setState((byte)1);
                    break;
                }
                case 25: {
                    isfrash = ev.getPara()[0] == 0;
                    break;
                }
                case 29: {
                    if (e.getState() != 5) {
                        short num = 0;
                        num = ev.getPara()[0];
                        if (ev.getPara()[0] == -1) {
                            num = 1;
                        }
                        this.mulNpc = new short[num];
                        this.spX = new short[num];
                        this.spY = new short[num];
                        this.stepX = new short[num];
                        this.stepY = new short[num];
                        for (int j = 0; j < this.mulNpc.length; ++j) {
                            this.mulNpc[j] = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                            this.spX[j] = CWATools.getShort(CWATools.split(ev.getWords()[1], ',')[j]);
                            this.spY[j] = CWATools.getShort(CWATools.split(ev.getWords()[2], ',')[j]);
                            this.stepX[j] = CWATools.getShort(CWATools.split(ev.getWords()[3], ',')[j]);
                            this.stepY[j] = CWATools.getShort(CWATools.split(ev.getWords()[4], ',')[j]);
                        }
                        e.setState((byte)5);
                        break;
                    }
                    boolean stop = true;
                    for (int j = 0; j < this.mulNpc.length; ++j) {
                        int y;
                        int x;
                        if (this.stepX[j] <= 0 && this.stepY[j] <= 0) continue;
                        stop = false;
                        int n = j;
                        this.stepX[n] = (short)(this.stepX[n] - 1);
                        int n2 = j;
                        this.stepY[n2] = (short)(this.stepY[n2] - 1);
                        if (ev.getPara()[0] == -1) {
                            x = this.gamePlayer.getActorX() + this.spX[j];
                            y = this.gamePlayer.getActorY() + this.spY[j];
                            this.gamePlayer.setPosition(x, y);
                            if (this.gamePlayer.shadowActor == null) continue;
                            this.gamePlayer.shadowActor.setPosition(x, y);
                            continue;
                        }
                        x = this.gameWorld.npc[this.mulNpc[j]].getActorX() + this.spX[j];
                        y = this.gameWorld.npc[this.mulNpc[j]].getActorY() + this.spY[j];
                        this.gameWorld.npc[this.mulNpc[j]].setPosition(x, y);
                        if (this.gameWorld.npc[this.mulNpc[j]].shadowActor == null) continue;
                        this.gameWorld.npc[this.mulNpc[j]].shadowActor.setPosition(x, y);
                    }
                    if (!stop) break;
                    e.setState((byte)1);
                    break;
                }
                case 30: {
                    if (e.getState() != 5) {
                        int j;
                        this.mulNpc = new short[ev.getPara()[0]];
                        String[] tempMulNpc = CWATools.split(ev.getWords()[2], ',');
                        for (int j2 = 0; j2 < this.mulNpc.length; ++j2) {
                            this.mulNpc[j2] = CWATools.getShort(tempMulNpc[j2]);
                        }
                        String[][] tempX = new String[this.mulNpc.length][];
                        String[][] tempY = new String[this.mulNpc.length][];
                        for (j = 0; j < tempY.length; ++j) {
                            tempX[j] = CWATools.split(CWATools.split(ev.getWords()[0], '#')[j], ',');
                            tempY[j] = CWATools.split(CWATools.split(ev.getWords()[1], '#')[j], ',');
                        }
                        this.posX = new short[this.mulNpc.length][];
                        this.posY = new short[this.mulNpc.length][];
                        for (j = 0; j < this.mulNpc.length; ++j) {
                            this.posX[j] = new short[tempX[j].length];
                            this.posY[j] = new short[tempY[j].length];
                            for (int k = 0; k < this.posX[j].length; ++k) {
                                this.posX[j][k] = CWATools.getShort(tempX[j][k]);
                                this.posY[j][k] = CWATools.getShort(tempY[j][k]);
                            }
                        }
                        this.count = 0;
                        e.setState((byte)5);
                        break;
                    }
                    for (int j = 0; j < this.mulNpc.length; ++j) {
                        this.gameWorld.npc[this.mulNpc[j]].setPosition(this.posX[j][this.count], this.posY[j][this.count]);
                    }
                    ++this.count;
                    if (this.count < this.posX[0].length) break;
                    e.setState((byte)1);
                    break;
                }
                case 31: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == 0) {
                            if (ev.getPara()[1] == 0) {
                                this.gamePlayer.addGold(ev.getPara()[2]);
                                this._game._gui.boxItemTips("\u83b7\u5f97: " + ev.getPara()[2] + "\u91d1\u5e01");
                            } else if (ev.getPara()[1] == 1) {
                                this.gamePlayer.addBadge(ev.getPara()[2]);
                                this._game._gui.boxItemTips("\u83b7\u5f97: " + ev.getPara()[2] + "\u5fbd\u7ae0");
                            }
                        } else if (ev.getPara()[0] == 1) {
                            if (ev.getPara()[1] == 0) {
                                this.gamePlayer.addGold(-ev.getPara()[2]);
                                this._game._gui.boxItemTips("\u5931\u53bb: " + ev.getPara()[2] + "\u91d1\u5e01");
                            } else if (ev.getPara()[1] == 1) {
                                this.gamePlayer.addBadge(-ev.getPara()[2]);
                                this._game._gui.boxItemTips("\u5931\u53bb: " + ev.getPara()[2] + "\u4e2a\u5fbd\u7ae0");
                            }
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this.gameWorld._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 32: {
                    this.gameWorld.removeBq(5);
                    GameBattle.getInstance().playMode = ev.getPara()[0];
                    GameBattle.getInstance().battleType = (byte)ev.getPara()[1];
                    GameBattle.getInstance().battleBackGround = Image.createImage((int)CWACommon.getWidth(), (int)CWACommon.getHeight());
                    Graphics g = GameBattle.getInstance().battleBackGround.getGraphics();
                    this.gameWorld.world.renderMap(g);
                    this.gamePlayer.setState((byte)0, this.gamePlayer.faceDir);
                    e.setState((byte)1);
                    GameManager.getInstance().setState((byte)12);
                    break;
                }
                case 33: {
                    if (isReCall == 2 || isReCall != 3) break;
                    break;
                }
                case 34: {
                    if (e.getState() != 5) {
                        this.imgX = ev.getPara()[1];
                        this.imgY = ev.getPara()[2];
                        this.speed = ev.getPara()[3];
                        this.count = ev.getPara()[4];
                        e.setState((byte)5);
                        break;
                    }
                    --this.count;
                    this.imgY -= this.speed;
                    if (this.count > 0) break;
                    this.count = 0;
                    e.setState((byte)1);
                    break;
                }
                case 35: {
                    if (e.getState() != 5) {
                        this.optionNum = ev.getPara()[0];
                        this.optionType = ev.getPara()[1];
                        this.optionStr = CWATools.split(ev.getWords()[0], ',');
                        this.optionSkip = new byte[CWATools.split(ev.getWords()[1], ',').length];
                        String answerStr = ev.getWords()[2];
                        for (int j = 0; j < this.optionSkip.length; ++j) {
                            this.optionSkip[j] = CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]);
                        }
                        this._game._gui.initOption(this.optionType, this.optionNum, this.optionStr, answerStr);
                        e.setState((byte)5);
                        break;
                    }
                    int optionIndex = this._game._gui.updateOption(this.optionNum, this.optionType);
                    if (optionIndex == -1) break;
                    e.setCurPtr((byte)(this.optionSkip[optionIndex] - 2));
                    e.setState((byte)1);
                    break;
                }
                case 36: {
                    if (e.getState() != 5) {
                        byte tempPet = this.gamePlayer.canAddPet();
                        if (ev.getPara()[0] == 0) {
                            if (tempPet == 0) {
                                this.gamePlayer.addPokPet(ev.getPara()[1], ev.getPara()[2], (short)-1, (byte)ev.getPara()[4], (byte)ev.getPara()[3], (byte)-1, new int[]{1, ev.getPara()[5], ev.getPara()[6]});
                            } else if (tempPet == 1) {
                                this._game._gui.boxItemTips("\u80cc\u5305\u5df2\u6ee1\uff0c\u5df2\u653e\u5165\u94f6\u884c");
                                short petHp = GamePet.getHpProp(ev.getPara()[1], ev.getPara()[2]);
                                this.gamePlayer.addBankPet(ev.getPara()[1], ev.getPara()[2], (short)-1, (byte)ev.getPara()[4], (byte)ev.getPara()[3], (byte)-1, petHp, 0, 0, new int[]{1, ev.getPara()[5], ev.getPara()[6]});
                            } else {
                                this._game._gui.boxItemTips("\u6ca1\u6709\u7a7a\u95f4\uff0c\u5df2\u653e\u751f");
                            }
                        } else if (ev.getPara()[0] == 1) {
                            this.gamePlayer.removePok(ev.getPara()[1]);
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 37: {
                    GameBattle.getInstance().setEnemy(new int[][]{{ev.getPara()[0], ev.getPara()[1], ev.getPara()[2]}});
                    break;
                }
                case 38: {
                    byte skipIndex = 0;
                    eventTalk = false;
                    for (int j = 0; j < CWATools.split(ev.getWords()[0], ',').length; ++j) {
                        if (CWATools.getByte(CWATools.split(ev.getWords()[0], ',')[j]) != GameWorld.collNpc) continue;
                        eventTalk = true;
                        if (!begainTalk) break;
                        GameWorld.collNpc = (short)-1;
                        skipIndex = CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]);
                        e.setCurPtr((byte)(skipIndex - 1));
                        GameWorld.getInstance().removeBq(6);
                        eventTalk = false;
                        begainTalk = false;
                        break;
                    }
                    e.setState((byte)6);
                    break;
                }
                case 39: {
                    for (int j = 0; j < this.gamePlayer.pokPetSize; ++j) {
                        this.gamePlayer.pokPet[j].resetPet();
                    }
                    break;
                }
                case 40: {
                    if (e.getState() != 5) {
                        this._game._gui.taskTips(ev.getWords()[0]);
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseTaskTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 41: {
                    e.setCurPtr((byte)(ev.getPara()[0] - 2));
                    break;
                }
                case 42: {
                    e.setState((byte)4);
                    break;
                }
                case 45: {
                    if (e.getState() != 5) {
                        this._game._gui.taskTips(ev.getWords()[0]);
                        mainQuestIndex = (byte)ev.getPara()[0];
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseTaskTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 46: {
                    if (e.getState() != 5) {
                        this._game._gui.initMsgTip();
                        this._game._gui.setMsgTip(ev.getWords()[0]);
                        e.setState((byte)5);
                        break;
                    }
                    if (this._game._gui._ui_layer == 0) {
                        if (this._game.isKeyDown(196640)) {
                            this._game._gui._ui_layer = 1;
                            this._game._gui.setMsgTip("\u4fdd\u5b58\u4e2d..\u8bf7\u52ff\u5173\u7535\u6e90");
                            this._game._gui.hideMsgTip();
                            break;
                        }
                        if (!this._game.isKeyDown(262144)) break;
                        e.setState((byte)1);
                        this._game._gui.closeMsgTip();
                        this._game._gui._ui_layer = 0;
                        break;
                    }
                    if (this._game._gui._ui_layer == 1) {
                        this.eventState[GameWorld.getMapId((int)this.gameWorld.sceneId, (int)this.gameWorld.roomId)][e.getEventId()] = 3;
                        if (!((GameWorld)this._game).save()) break;
                        this._game._gui.setMsgTip("\u4fdd\u5b58\u6210\u529f");
                        this._game._gui._ui_layer = 2;
                        break;
                    }
                    if (this._game._gui._ui_layer != 2) break;
                    this._game._gui.closeMsgTip();
                    this._game._gui._ui_layer = 0;
                    e.setState((byte)1);
                    break;
                }
                case 47: {
                    if (this.eventBattleResult == -1) break;
                    e.setCurPtr((byte)(ev.getPara()[this.eventBattleResult] - 2));
                    break;
                }
                case 48: {
                    if (e.getState() != 5) {
                        this.gameDialog.setPos(ev.getPara()[1], ev.getPara()[2]);
                        this.gameDialog.initDialog((byte)(ev.getPara()[0] / 10 - 1), ev.getWords()[0], ev.getPara()[0] % 10);
                        if (ev.getPara()[5] == 1) {
                            this.gameDialog.setDrawNum(true);
                        }
                        this.gameDialog.setWidthCount(ev.getPara()[3], ev.getPara()[4]);
                        e.setState((byte)5);
                        break;
                    }
                    if (this.gameDialog.isDrawNum()) {
                        if (!GameDialog.isEnd || !this._game.isKeyDown(1)) break;
                        this.gameDialog.keyDialog();
                        if (GameDialog.isDrawDialog) break;
                        CWAScreenChange.getInstance().screenType = -1;
                        this.gameDialog.release();
                        e.setState((byte)1);
                        break;
                    }
                    e.setState((byte)1);
                    break;
                }
                case 49: {
                    if (e.getState() != 5) {
                        int j;
                        this.taskType = new int[2];
                        this.taskTypeId = new int[2];
                        this.taskStr = new String[2];
                        this.optionStr = new String[2];
                        for (j = 0; j < 2; ++j) {
                            this.taskType[j] = ev.getPara()[j * 2];
                            this.taskTypeId[j] = ev.getPara()[j * 2 + 1];
                            this.taskStr[j] = ev.getWords()[j];
                        }
                        this.optionSkip = new byte[CWATools.split(ev.getWords()[2], ',').length];
                        for (j = 0; j < this.optionSkip.length; ++j) {
                            this.optionSkip[j] = CWATools.getByte(CWATools.split(ev.getWords()[2], ',')[j]);
                            this.optionStr[j] = CWATools.split(ev.getWords()[3], ',')[j];
                        }
                        this._game._gui.initTaskOption(this.taskType, this.taskTypeId, this.taskStr, this.optionStr);
                        e.setState((byte)5);
                        break;
                    }
                    int optionIndex = this._game._gui.updateTaskOption();
                    if (optionIndex == -1) break;
                    if (optionIndex == 0 && e.firstEvent().getPara()[1] == 1) {
                        GameEvent.taskNum[GameEvent.branchQuestIndex][1] = 1;
                        branchQuestIndex = (byte)(branchQuestIndex + 1);
                    }
                    e.setCurPtr((byte)(this.optionSkip[optionIndex] - 2));
                    e.setState((byte)1);
                    break;
                }
                case 50: {
                    if (ev.getPara()[0] == 0) {
                        this.gamePlayer.strip();
                        break;
                    }
                    this.gamePlayer.reloading();
                    break;
                }
                case 51: {
                    this.gameWorld._gui.initDialog();
                    this.gameDialog.setPos(ev.getPara()[1], ev.getPara()[2]);
                    this.gameDialog.initDialog((byte)(ev.getPara()[0] / 10 - 1), ev.getWords()[0], ev.getPara()[0] % 10);
                    this.gameDialog.setWidthCount(ev.getPara()[3], ev.getPara()[4]);
                    break;
                }
                case 52: {
                    this.eventSms = ev.getPara()[0] == 0;
                    if (ev.getPara()[1] == 0) {
                        eventEscape = true;
                        break;
                    }
                    eventEscape = false;
                    break;
                }
                case 53: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[1] == 0) {
                            this.gamePlayer.setPokBadgeValue((byte)ev.getPara()[0], (byte)ev.getPara()[1], (byte)2);
                            for (int j = 0; j < GameWorld.getInstance().npc.length; ++j) {
                                if (GameWorld.getInstance().npc[j].actorType != 0 || GameWorld.getInstance().npc[j].npcType != 1) continue;
                                GameWorld.getInstance().npc[j].bossBq();
                            }
                        } else if (ev.getPara()[1] == 1) {
                            this.gamePlayer.setPokBadgeValue((byte)ev.getPara()[0], (byte)ev.getPara()[1], (byte)1);
                        }
                        this._game._gui.initGetBadge(ev.getPara()[0]);
                        e.setState((byte)5);
                        break;
                    }
                    if (!this.gameWorld.isKeyDown(1)) break;
                    this._game._gui.closeGetBadge();
                    e.setState((byte)1);
                    break;
                }
                case 54: {
                    int num = ev.getPara()[0];
                    int[][] enemy = new int[num][3];
                    for (int j = 0; j < num; ++j) {
                        enemy[j][0] = CWATools.getInteger(CWATools.split(ev.getWords()[0], ',')[j]);
                        enemy[j][1] = CWATools.getInteger(CWATools.split(ev.getWords()[1], ',')[j]);
                        enemy[j][2] = CWATools.getInteger(CWATools.split(ev.getWords()[2], ',')[j]);
                    }
                    GameBattle.getInstance().setEnemy(enemy);
                    break;
                }
                case 55: {
                    if (ev.getPara()[0] == 0) {
                        if (this.arrowSpr == null) {
                            this.arrowSpr = new CWASprActor();
                            this.arrowSpr.initSprite(340, false);
                            this.arrowSpr.start();
                            this.arrowId = GameWorld.getMapId(ev.getPara()[3], ev.getPara()[4]);
                        }
                        this.arrowSpr.setPosition(ev.getPara()[1], ev.getPara()[2]);
                        break;
                    }
                    if (ev.getPara()[0] != 1 || this.arrowSpr == null) break;
                    this.arrowSpr.stop();
                    this.arrowSpr = null;
                    this.arrowId = -1;
                    break;
                }
                case 56: {
                    int num = ev.getPara()[1];
                    if (ev.getPara()[0] == 0) {
                        for (int j = 0; j < num; ++j) {
                            short npcId = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                            byte dir = CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]);
                            this.gameWorld.npc[npcId].setActorDir(dir);
                            if (this.gameWorld.npc[npcId].npcType == 1) {
                                this.gameWorld.npc[npcId].setState((byte)0);
                            }
                            this.gameWorld.npc[npcId].start();
                            this.gameWorld.setNpcObject(npcId, 1, (byte)1, true);
                            this.gameWorld.setNpcObject(npcId, 2, dir, true);
                            this.gameWorld.npc[npcId].saveNpcXY();
                        }
                    } else {
                        if (ev.getPara()[0] != 1) break;
                        for (int j = 0; j < num; ++j) {
                            short npcId = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                            if (this.gameWorld.npc[npcId].npcType == 1) {
                                this.gameWorld.npc[npcId].setState((byte)0);
                            }
                            this.gameWorld.npc[npcId].stop();
                            this.gameWorld.setNpcObject(npcId, 1, (byte)0, true);
                            this.gameWorld.npc[npcId].saveNpcXY();
                        }
                    }
                    break;
                }
                case 58: {
                    if (((GameNpc)this.gamePlayer.target).getRoleState() != 1 || !((GameNpc)this.gamePlayer.target).sprite.isEndFrame()) break;
                    ((GameNpc)this.gamePlayer.target).setState((byte)0);
                    this.gameWorld.npc[ev.getPara()[0]].setPosition(ev.getPara()[1], ev.getPara()[2]);
                    if ((GameNpc)this.gameWorld.npc[ev.getPara()[0]].target == null) break;
                    ((GameNpc)this.gameWorld.npc[ev.getPara()[0]].target).countLaserArea();
                    this.gameWorld.npc[ev.getPara()[0]].setTarget(null);
                    break;
                }
                case 60: {
                    if (e.getState() != 5) {
                        this.mulNpc = new short[ev.getPara()[0]];
                        for (int j = 0; j < this.mulNpc.length; ++j) {
                            this.mulNpc[j] = CWATools.getShort(CWATools.split(ev.getWords()[0], ',')[j]);
                            this.gameWorld.npc[this.mulNpc[j]].setState(CWATools.getByte(CWATools.split(ev.getWords()[1], ',')[j]));
                            if (this.gameWorld.npc[this.mulNpc[j]].actorType != 0 || this.gameWorld.npc[this.mulNpc[j]].npcType != 6 || this.gameWorld.npc[this.mulNpc[j]].getRoleState() != 2) continue;
                            GameWorld.getInstance().world.changeActorLayer(GameWorld.getInstance().npc[this.mulNpc[j]], 2);
                        }
                        this.count = 0;
                        e.setState((byte)5);
                        break;
                    }
                    for (int j = 0; j < this.mulNpc.length; ++j) {
                        if (!this.gameWorld.npc[this.mulNpc[j]].isEndFrame()) continue;
                        ++this.count;
                    }
                    if (this.count < this.mulNpc.length) break;
                    this.count = 0;
                    e.setState((byte)1);
                    break;
                }
                case 62: {
                    int[] npc = new int[CWATools.split(ev.getWords()[0], ',').length];
                    int j = 0;
                    int result = -1;
                    e.setState((byte)6);
                    for (j = 0; j < npc.length; ++j) {
                        npc[j] = CWATools.getInteger(CWATools.split(ev.getWords()[0], ',')[j]);
                        if (this.gameWorld.npc[npc[j]].getRoleState() != 2) continue;
                        result = npc[j];
                        break;
                    }
                    if (result < 0) break;
                    if (result != ev.getPara()[0]) {
                        e.setCurPtr((byte)(ev.getPara()[2] - 2));
                        e.setState((byte)1);
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[1] - 2));
                    e.setState((byte)1);
                    break;
                }
                case 63: {
                    if (ev.getPara()[0] == 0) {
                        this.gamePlayer.ridePet(ev.getPara()[1]);
                    } else {
                        this.gamePlayer.downPet();
                    }
                    this.ride = ev.getPara()[2] != 0;
                    break;
                }
                case 64: {
                    if (ev.getPara()[0] == 0) {
                        this.gameWorld.initFollow(ev.getPara()[1]);
                        if (ev.getPara()[2] == -1) {
                            this.gameWorld.addFollow(this.gamePlayer);
                            break;
                        }
                        this.gameWorld.addFollow(this.gameWorld.npc[ev.getPara()[2]]);
                        break;
                    }
                    this.gameWorld.removeFollow();
                    break;
                }
                case 65: {
                    if (e.getState() != 5 && !isSMSCheck) {
                        this._game.setState((byte)100);
                        e.setState((byte)5);
                        break;
                    }
                    if (isSMSCheck) {
                        e.setCurPtr((byte)(ev.getPara()[0] - 2));
                        e.setState((byte)1);
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[1] - 2));
                    e.setState((byte)1);
                    break;
                }
                case 66: {
                    CWACommon.teachId = (byte)ev.getPara()[0];
                    CWACommon.setTeachKey(0, 3);
                    break;
                }
                case 67: {
                    GameWorld.collBattleNpc = ev.getPara()[0];
                    break;
                }
                case 70: {
                    if (e.getState() != 5) {
                        isUiClose = false;
                        this.curState = ev.getPara()[0];
                        switch (ev.getPara()[0]) {
                            case 0: 
                            case 1: {
                                this.gameWorld.setState((byte)1);
                                break;
                            }
                            case 2: {
                                this.gameWorld.setState((byte)16);
                            }
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!isUiClose) break;
                    this.curState = -1;
                    e.setState((byte)1);
                    break;
                }
                case 71: {
                    if (this.gamePlayer.pokPetTypeNum >= ev.getPara()[0]) {
                        e.setCurPtr((byte)(ev.getPara()[1] - 2));
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[2] - 2));
                    break;
                }
                case 72: {
                    String[] npcId = CWATools.split(ev.getWords()[0], ',');
                    String[] bqId = CWATools.split(ev.getWords()[1], ',');
                    CWASprActor[] spActor = new CWASprActor[npcId.length];
                    for (int j = 0; j < npcId.length; ++j) {
                        spActor[j] = new CWASprActor();
                        spActor[j].initSprite(259, false);
                        spActor[j].reCallImage();
                        if (CWATools.getInteger(npcId[j]) == -1) {
                            spActor[j].setAction(CWATools.getByte(bqId[j]), (byte)-1, true);
                            spActor[j].start();
                            spActor[j].setPosition(this.gamePlayer.getActorX(), this.gamePlayer.getActorY() - 40);
                            spActor[j].setTarget(this.gamePlayer);
                        } else {
                            spActor[j].setAction(CWATools.getByte(bqId[j]), (byte)-1, true);
                            spActor[j].start();
                            spActor[j].setPosition(this.gameWorld.npc[CWATools.getInteger(npcId[j])].getActorX(), this.gameWorld.npc[CWATools.getInteger(npcId[j])].getActorY() - 40);
                            spActor[j].setTarget(this.gameWorld.npc[CWATools.getInteger(npcId[j])]);
                        }
                        bqVector.addElement(spActor[j]);
                    }
                    break;
                }
                case 74: {
                    int[] temp = (int[])this.gamePlayer.pokBall.elementAt(0);
                    if (temp[1] >= 1) {
                        e.setCurPtr((byte)(ev.getPara()[0] - 2));
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[1] - 2));
                    break;
                }
                case 76: {
                    this.eventState[GameWorld.mapIndex[this.gameWorld.sceneId] + this.gameWorld.roomId][e.getEventId()] = 3;
                    GameWorld.getInstance().sceneId = ev.getPara()[0];
                    GameWorld.getInstance().roomId = ev.getPara()[1];
                    GameWorld.getInstance().doorId = -1;
                    this.gameWorld.setState((byte)29);
                    break;
                }
                case 77: {
                    this.eventState[GameWorld.getMapId((int)ev.getPara()[0], (int)ev.getPara()[1])][ev.getPara()[2]] = 4;
                    if (ev.getPara()[0] != this.gameWorld.sceneId || ev.getPara()[1] != this.gameWorld.roomId) break;
                    this.roomEvent[ev.getPara()[2]].setState((byte)4);
                    break;
                }
                case 80: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == 0) {
                            this.count = 0;
                            this.countDown = (byte)4;
                        } else if (ev.getPara()[0] == 1) {
                            GameManager.getInstance().endTime = GameManager.getInstance().curTime;
                            long time = GameManager.getInstance().endTime - GameManager.getInstance().begainTime;
                            if (CWATools.getTime(time)[2] <= 110L) {
                                byte tempPet = this.gamePlayer.canAddPet();
                                if (tempPet == 0) {
                                    this._game._gui.boxItemTips("\u83b7\u5f97#2\u9646\u884c\u9e1f");
                                    this.gamePlayer.addPokPet(54, 5, (short)-1, (byte)2, (short)-1, (byte)-1, new int[]{1, 30, 45});
                                } else if (tempPet == 1) {
                                    this._game._gui.boxItemTips("\u83b7\u5f97#2\u9646\u884c\u9e1f#0\u80cc\u5305\u5df2\u6ee1\uff0c\u5df2\u653e\u5165\u94f6\u884c");
                                    this.gamePlayer.addBankPet(54, 5, (short)-1, (byte)2, (short)-1, (byte)-1, 0, 0, 0, new int[]{1, 30, 45});
                                } else {
                                    this._game._gui.boxItemTips("\u6ca1\u6709\u7a7a\u95f4\uff0c\u5df2\u653e\u751f");
                                }
                            } else if (CWATools.getTime(time)[2] <= 120L) {
                                this.gamePlayer.addGold(1000);
                                this._game._gui.boxItemTips("\u5956\u52b11000\u91d1");
                            } else if (CWATools.getTime(time)[2] <= 130L) {
                                this.gamePlayer.addGold(750);
                                this._game._gui.boxItemTips("\u5956\u52b1750\u91d1");
                            } else if (CWATools.getTime(time)[2] <= 200L) {
                                this.gamePlayer.addGold(600);
                                this._game._gui.boxItemTips("\u5956\u52b1600\u91d1");
                            }
                            GameManager.getInstance().curTime = 0L;
                            GameManager.getInstance().begainTime = 0L;
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (ev.getPara()[0] == 0) {
                        ++this.count;
                        if (this.countDown > 0) {
                            if (this.count / 10 == 0 || this.count % 10 != 0) break;
                            this.countDown = (byte)(this.countDown - 1);
                            break;
                        }
                        this.countDown = 0;
                        GameManager.getInstance().curTime = GameManager.getInstance().begainTime = System.currentTimeMillis();
                        GameManager.getInstance().endTime = 0L;
                        e.setState((byte)1);
                        break;
                    }
                    if (ev.getPara()[0] != 1 || !this._game._gui.isCloseItemTips()) break;
                    if (this.gameTimes == 0) {
                        this.date = this.getDate();
                    }
                    this.gameTimes = (byte)(this.gameTimes + 1);
                    e.setState((byte)1);
                    break;
                }
                case 81: {
                    if (ev.getPara()[0] == 0) {
                        if (this.gamePlayer.canSubGold(ev.getPara()[1])) {
                            e.setCurPtr((byte)(ev.getPara()[2] - 2));
                            break;
                        }
                        e.setCurPtr((byte)(ev.getPara()[3] - 2));
                        break;
                    }
                    if (ev.getPara()[0] != 1) break;
                    if (this.gamePlayer.canSubBadge(ev.getPara()[1])) {
                        e.setCurPtr((byte)(ev.getPara()[2] - 2));
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[3] - 2));
                    break;
                }
                case 82: {
                    int num = ev.getPara()[0];
                    byte[] npcId = CWATools.getByteArray(ev.getWords()[0]);
                    for (int j = 0; j < num; ++j) {
                        this.gameWorld.npc[npcId[j]].saveNpcXY();
                        this.gameWorld.npc[npcId[j]].saveNpcObject();
                    }
                    break;
                }
                case 83: {
                    if (e.getState() != 5) {
                        this._game.setState((byte)30);
                        e.setState((byte)5);
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[eventBuyEgg] - 2));
                    e.setState((byte)1);
                    break;
                }
                case 84: {
                    if (e.getState() != 5) {
                        int[] args = null;
                        if (ev.getPara()[2] == 1) {
                            args = new int[]{this.gameTimes, 5 - this.gameTimes};
                        } else if (ev.getPara()[2] == 0) {
                            args = new int[]{this.gamePlayer.hatchPetNum, this.gamePlayer.hatchPet.length - this.gamePlayer.hatchPetNum};
                        }
                        String str = GameEvent.STR(ev.getWords()[1], args);
                        this.gameWorld._gui.initDialog(ev.getWords()[0], str, ev.getPara()[1], -1);
                        e.setState((byte)5);
                        break;
                    }
                    boolean canClose = this.gameWorld._gui.updateDialog(ev.getPara()[1], -1);
                    if (!canClose || !this._game.isKeyDown(196640)) break;
                    GameWorld.getInstance().removeBq(4);
                    if (CWATools.curPage < CWATools.maxPage()) {
                        CWATools.addPage();
                        this.gameWorld._gui.setDialog(CWATools.curPage);
                        break;
                    }
                    if (GameWorld.collNpc != -1 && this.gameWorld.npc[GameWorld.collNpc].sprite.sprIndex <= 85 && this.gameWorld.npc[GameWorld.collNpc].getBqType() == 0) {
                        GameWorld.getInstance().setBq((byte)13, GameWorld.getInstance().npc[GameWorld.collNpc].actorX, GameWorld.getInstance().npc[GameWorld.collNpc].actorY - 40, GameWorld.getInstance().npc[GameWorld.collNpc]);
                    }
                    eventTalk = false;
                    begainTalk = false;
                    this.gameWorld._gui.closeDialog();
                    e.setState((byte)1);
                    break;
                }
                case 85: {
                    if (this.gameTimes >= 0 && this.gameTimes < 5) {
                        e.setCurPtr((byte)(ev.getPara()[0] - 2));
                        break;
                    }
                    e.setCurPtr((byte)(ev.getPara()[1] - 2));
                    break;
                }
                case 87: {
                    if (e.getState() != 5) {
                        if (ev.getPara()[0] == 0) {
                            this.gamePlayer.addPokPet(ev.getPara()[7], ev.getPara()[1], ev.getPara()[2], (short)-1, (byte)ev.getPara()[4], (byte)ev.getPara()[3], (byte)-1, new int[]{1, ev.getPara()[5], ev.getPara()[6]});
                        } else if (ev.getPara()[0] == 1) {
                            this.gamePlayer.removePok(ev.getPara()[1]);
                        }
                        e.setState((byte)5);
                        break;
                    }
                    if (!this._game._gui.isCloseItemTips()) break;
                    e.setState((byte)1);
                    break;
                }
                case 88: {
                    if (this.gamePlayer.canAddPet() == 2) {
                        e.setCurPtr((byte)(ev.getPara()[0] - 2));
                    } else {
                        e.setCurPtr((byte)(ev.getPara()[1] - 2));
                    }
                    e.setState((byte)1);
                }
            }
            if (e.getState() != 5 && e.getState() != 6) {
                e.next();
            }
            if (e.getState() == 3 || e.getState() == 4) {
                begainTalk = false;
                this.curEvent.removeElement(e);
                int srId = GameWorld.getMapId(e.getSrId()[0], e.getSrId()[1]);
                if (this.eventState[srId] != null) {
                    this.eventState[srId][e.getEventId()] = e.getState();
                }
                if (e.getState() == 3 && e.firstEvent().getType() == 44 && e.firstEvent().getPara()[1] == 1) {
                    this.completeTask(e.firstEvent().getPara()[0]);
                }
                this.canAccept();
                continue;
            }
            ++i;
        }
    }

    public byte getCurEventId() {
        return this.curEventId;
    }

    public boolean isEventRun() {
        if (this.roomEvent == null) {
            return false;
        }
        for (int i = 0; i < this.curEvent.size(); ++i) {
            CWAEvent e = (CWAEvent)this.curEvent.elementAt(i);
            if (e.getState() == 2 || e.getState() == 6) continue;
            return true;
        }
        return false;
    }

    public boolean canAccept(CWAEventStruct evt) {
        boolean canAccept;
        block14: {
            block13: {
                canAccept = false;
                if (evt.getPara()[7] == -1) break block13;
                if (evt.getPara()[7] == -1) break block14;
                if (this.eventState[GameWorld.getMapId(evt.getPara()[5], evt.getPara()[6])] == null) break block14;
                if (this.eventState[GameWorld.getMapId(evt.getPara()[5], evt.getPara()[6])][evt.getPara()[7]] != 3) break block14;
            }
            block0 : switch (evt.getPara()[8]) {
                case 0: {
                    if (!this.gamePlayer.taskItem[evt.getPara()[9]]) break;
                    canAccept = true;
                    break;
                }
                case 1: {
                    canAccept = true;
                    break;
                }
                case 2: {
                    int j;
                    if (this.gamePlayer.pokPetBank.size() + this.gamePlayer.pokPetSize < evt.getPara()[9]) break;
                    int[] temp = null;
                    for (j = 0; j < this.gamePlayer.pokPetSize; ++j) {
                        if (this.gamePlayer.pokPet[j].getLevel() != evt.getPara()[10]) continue;
                        canAccept = true;
                        break;
                    }
                    if (canAccept) break;
                    for (j = 0; j < this.gamePlayer.pokPetBank.size(); ++j) {
                        temp = (int[])this.gamePlayer.pokPetBank.elementAt(j);
                        if (temp[1] != evt.getPara()[10]) continue;
                        canAccept = true;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    if (this.gamePlayer.pokPetTypeNum < evt.getPara()[9]) break;
                    canAccept = true;
                    break;
                }
                case 4: {
                    if (this.gamePlayer.getPokPetMapValue((byte)evt.getPara()[9], evt.getPara()[10]) != 2) break;
                    canAccept = true;
                    break;
                }
                case 5: {
                    if (mainQuestIndex <= evt.getPara()[9]) break;
                    canAccept = true;
                    break;
                }
                case 6: {
                    if (mainQuestIndex != evt.getPara()[9]) break;
                    canAccept = true;
                    break;
                }
                default: {
                    canAccept = true;
                }
            }
        }
        return canAccept;
    }

    public boolean canAchieve(CWAEventStruct evt) {
        boolean canAchieve = false;
        if (evt.getPara()[7] == -1 || evt.getPara()[7] != -1 && this.eventState[GameWorld.getMapId(evt.getPara()[5], evt.getPara()[6])] != null && this.eventState[GameWorld.getMapId(evt.getPara()[5], evt.getPara()[6])][evt.getPara()[7]] == 3) {
            switch (evt.getPara()[8]) {
                case 0: {
                    if (this.gamePlayer.getPokPetMapValue((byte)evt.getPara()[9], evt.getPara()[10]) != 2) break;
                    canAchieve = true;
                    break;
                }
                case 1: {
                    if (!this.gamePlayer.taskItem[evt.getPara()[9]]) break;
                    canAchieve = true;
                    break;
                }
                case 2: 
                case 4: {
                    if (this.eventState[GameWorld.getMapId(evt.getPara()[5], evt.getPara()[6])] == null || this.eventState[GameWorld.getMapId(evt.getPara()[5], evt.getPara()[6])][evt.getPara()[7]] != 3) break;
                    canAchieve = true;
                    break;
                }
                case 3: {
                    if (!this.gamePlayer.canRemoveItem(evt.getPara()[9], evt.getPara()[10], (byte)0)) break;
                    canAchieve = true;
                    break;
                }
                case 5: {
                    if (this.gamePlayer.pokPetTypeNum < evt.getPara()[9]) break;
                    canAchieve = true;
                    break;
                }
                case 6: {
                    int i;
                    byte[] petdep = new byte[]{0, 1, 2, 3};
                    block8: for (i = 0; i < this.gamePlayer.pokPetSize; ++i) {
                        int j = 0;
                        for (j = 0; j < petdep.length; ++j) {
                            if (petdep[j] == -1 || petdep[j] != CWADataManager.getDataBase((byte)0, (short)this.gamePlayer.pokPet[i].getPetId(), (byte)1)) continue;
                            petdep[j] = -1;
                            continue block8;
                        }
                    }
                    i = 0;
                    for (i = 0; i < petdep.length && petdep[i] == -1; ++i) {
                    }
                    if (i < petdep.length) break;
                    canAchieve = true;
                }
            }
        }
        return canAchieve;
    }

    public void canAccept() {
        CWASprActor spra;
        int i;
        if (taskVector == null) {
            taskVector = new Vector();
        }
        taskVector.removeAllElements();
        CWAEventStruct ev = null;
        Vector<String> vectorNpc = new Vector<String>();
        for (i = 0; i < mapHand.length; ++i) {
            if (GameWorld.getMapId(mapHand[i][0], mapHand[i][1]) != GameWorld.getMapId(GameWorld.getInstance().sceneId, GameWorld.getInstance().roomId) || this.roomEvent[mapHand[i][2]].getState() != 0 && this.roomEvent[mapHand[i][2]].getState() != 4) continue;
            ev = this.roomEvent[mapHand[i][2]].firstEvent();
            if (vectorNpc.contains("" + ev.getPara()[4])) continue;
            if (this.canAchieve(ev)) {
                spra = new CWASprActor();
                spra.initSprite(259, false);
                spra.setAction((byte)1, (byte)-1, true);
                spra.setPosition(this.gameWorld.npc[ev.getPara()[4]].getActorX(), this.gameWorld.npc[ev.getPara()[4]].getActorY() - 40);
                this.gameWorld.npc[ev.getPara()[4]].setBqType((byte)1);
                spra.setTarget(this.gameWorld.npc[ev.getPara()[4]]);
                spra.start();
                taskVector.addElement(spra);
                vectorNpc.addElement("" + ev.getPara()[4]);
                continue;
            }
            int taskId = this.finkTask(ev.getPara()[0]);
            if ((ev.getPara()[1] != 0 || this.eventState[GameWorld.getMapId(mapAccept[i][0], mapAccept[i][1])][mapAccept[i][2]] != 3 || this.eventState[GameWorld.getMapId(mapHand[i][0], mapHand[i][1])][mapHand[i][2]] == 3) && (ev.getPara()[1] != 1 || taskId == -1 || taskNum[taskId][1] != 1)) continue;
            CWASprActor spra2 = new CWASprActor();
            spra2.initSprite(259, false);
            spra2.setAction((byte)15, (byte)-1, true);
            spra2.setPosition(this.gameWorld.npc[ev.getPara()[4]].getActorX(), this.gameWorld.npc[ev.getPara()[4]].getActorY() - 40);
            this.gameWorld.npc[ev.getPara()[4]].setBqType((byte)1);
            spra2.setTarget(this.gameWorld.npc[ev.getPara()[4]]);
            spra2.start();
            taskVector.addElement(spra2);
            vectorNpc.addElement("" + ev.getPara()[4]);
        }
        for (i = 0; i < mapAccept.length; ++i) {
            if (GameWorld.getMapId(mapAccept[i][0], mapAccept[i][1]) != GameWorld.getMapId(GameWorld.getInstance().sceneId, GameWorld.getInstance().roomId) || this.roomEvent[mapAccept[i][2]].getState() != 0 && this.roomEvent[mapAccept[i][2]].getState() != 4) continue;
            ev = this.roomEvent[mapAccept[i][2]].firstEvent();
            if (vectorNpc.contains("" + ev.getPara()[4]) || !this.canAccept(ev)) continue;
            spra = new CWASprActor();
            spra.initSprite(259, false);
            spra.setAction((byte)7, (byte)-1, true);
            spra.setPosition(this.gameWorld.npc[ev.getPara()[4]].getActorX(), this.gameWorld.npc[ev.getPara()[4]].getActorY() - 40);
            this.gameWorld.npc[ev.getPara()[4]].setBqType((byte)1);
            spra.setTarget(this.gameWorld.npc[ev.getPara()[4]]);
            spra.start();
            taskVector.addElement(spra);
        }
    }

    public int[] getDate() {
        int[] tdate = new int[]{this.calendar.get(1), this.calendar.get(2), this.calendar.get(5), this.calendar.get(11)};
        return this.date;
    }

    public int[] getRecordDate() {
        return this.date;
    }

    public void setRecordDate(int[] date) {
        this.date = date;
    }

    static {
        gameEvent = null;
        isUiClose = false;
        isfrash = true;
        eventTalk = false;
        begainTalk = false;
        eventEscape = true;
        battleKey = false;
        eventBuyEgg = (byte)-1;
        taskNum = null;
        mainQuestIndex = 0;
        branchQuestIndex = 0;
        branchParam = null;
    }
}

