/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwabase2d.CWAMap;
import game.GameEvent;
import game.GameManager;
import game.GamePlayer;
import game.GameWorld;
import javax.microedition.lcdui.Graphics;

public class GameNpc
extends CWASprActor
implements CWAGlobal {
    public byte actorType;
    public boolean isColl;
    public byte npcType;
    public byte smilies;
    public short startFrame;
    public short autoSpeak;
    public short speakName;
    private int _moveCount;
    private int _aiFrame;
    private int _aiCheckTime;
    private int _count;
    public byte isStandPlayer;
    public int laserArea;
    public int templaserArea;
    public byte playerDirection;
    public short nextScene;
    public short nextRoom;
    public short nextDoor;
    public short itemNum;
    public short itemType;
    public short itemId;
    public boolean isAI;
    public short Level;
    public short RegionX;
    public short RegionY;
    public short SpeedX;
    public short SpeedY;
    public byte[] doorDir = new byte[]{2, 3, 0, 1};
    private byte bqType = 0;
    public CWASprActor bqSprite;
    public CWASprActor tipSprite;
    public short npcId = (short)-1;
    public short[] actorPos = new short[]{8, 9, 2, 96, 320, 0};
    protected int fireCount = 0;
    protected int fireArea = 52;
    protected int fireCatchArea = 48;

    public void init(short[] data, int npcId) {
        this.npcId = (short)npcId;
        this.actorType = (byte)data[0];
        this.sprite.initSprite(data[1], false);
        this.sprite.reCallImage();
        this.npcType = (byte)data[6];
        if (this.actorType == 0 && (this.npcType == 1 || this.npcType == 18)) {
            this.setActorDir((byte)(data[2] % 3));
        }
        this.setState((byte)data[2]);
        this.actorX = data[3];
        this.actorY = data[4];
        if (data[5] == 1) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        switch (this.actorType) {
            case 0: {
                this.layer = (byte)data[7];
                this.smilies = (byte)data[8];
                this.initSpbq();
                this.bossBq();
                this.isColl = data[9] != 0;
                this.startFrame = data[10];
                this.autoSpeak = data[11];
                this.speakName = data[12];
                this._moveCount = 0;
                this._aiCheckTime = CWATools.getRandom(20, 40);
                this.isStandPlayer = 0;
                if (this.npcType == 12) {
                    this.faceDir = 0;
                } else if (this.npcType == 13) {
                    this.faceDir = 1;
                }
                if (this.npcType == 3) {
                    if (this.roleState == 4) {
                        this.faceDir = 1;
                    }
                } else if (this.npcType == 2) {
                    if (this.roleState == 5) {
                        this.faceDir = (byte)2;
                    } else if (this.roleState == 3) {
                        this.faceDir = 0;
                    }
                }
                if ((this.npcType != 1 || this.sprite.sprIndex == 226) && this.npcType != 2 && this.npcType != 3 && this.npcType != 17) break;
                if (this.shadowActor == null) {
                    this.shadowActor = new CWASprActor();
                    this.shadowActor.initSprite(337, false);
                }
                this.shadowActor.setPosition(this.actorX, this.actorY);
                if (this.sprite.sprIndex == 4) {
                    this.shadowActor.setAction((byte)0, (byte)0, this.isAI);
                } else {
                    this.shadowActor.setAction((byte)1, (byte)0, this.isAI);
                }
                this.shadowActor.start();
                break;
            }
            case 1: {
                this.layer = data[1] == 320 ? 2 : 1;
                if (this.isVisible() && data[0] >= 1 && data[0] <= 3) {
                    GameWorld.getInstance().doorNpc.addElement(this);
                }
                if (this.npcType == 3) {
                    this.isColl = true;
                }
                this.playerDirection = (byte)data[7];
                this.nextScene = data[8];
                this.nextRoom = data[9];
                this.nextDoor = data[10];
                break;
            }
            case 2: {
                if (data[7] == 0) {
                    this.isAI = false;
                    break;
                }
                this.isAI = true;
                this.Level = data[7];
                this.RegionX = data[8];
                this.RegionY = data[9];
                this.SpeedX = data[10];
                this.SpeedY = data[11];
                break;
            }
            case 3: {
                this.layer = 1;
                this.itemNum = data[7];
                this.itemType = data[8];
                switch (this.itemType) {
                    case 9: {
                        this.itemType = 1;
                        break;
                    }
                    case 10: {
                        this.itemType = 0;
                        break;
                    }
                    case 11: {
                        this.itemType = (short)2;
                        break;
                    }
                    case 12: {
                        this.itemType = (short)3;
                    }
                }
                this.itemId = data[9];
                this.isColl = true;
            }
        }
        this.baseProp = new short[3];
        this.curProp = new short[3];
    }

    public void recallImg() {
        if (this.sprite != null) {
            this.sprite.reCallImg();
        }
    }

    public void release() {
        this.shadowStop();
        if (this.shadowActor != null) {
            this.shadowActor.sprite.removeSprite(5);
            this.shadowActor = null;
        }
        if (this.npcId != -1 && this.sprite.sprIndex != 0 && this.sprite.sprIndex != 8) {
            this.sprite.releaseSprite(6);
            this.sprite = null;
        }
        if (this.bqSprite != null) {
            this.bqSprite.sprite.releaseSprite(7);
            this.bqSprite = null;
        }
        if (this.tipSprite != null) {
            this.tipSprite.sprite.releaseSprite(8);
            this.tipSprite = null;
        }
        this.npcId = (short)-1;
    }

    public void setState(byte state) {
        switch (this.actorType) {
            case 0: {
                if (this.npcType == 8) {
                    this.setAction((byte)0, (byte)-1, false);
                    this._moveCount = 0;
                    this.roleState = state;
                    break;
                }
                if (this.npcType == 1 || this.npcType == 18) {
                    this.roleState = (byte)(state / 3);
                    if (this.roleState == 0) {
                        if (this.faceDir == 3) {
                            this.setAction((byte)1, (byte)-1, false);
                            break;
                        }
                        this.setAction(this.faceDir, (byte)-1, false);
                        break;
                    }
                    if (this.roleState != 1) break;
                    if (this.faceDir == 3) {
                        this.setAction((byte)(this.roleState * 3 + 1), (byte)-1, false);
                        break;
                    }
                    this.setAction((byte)(this.roleState * 3 + this.faceDir), (byte)-1, false);
                    break;
                }
                this.setAction(state, (byte)-1, false);
                this.roleState = state;
                GameWorld.getInstance().setNpcObject(this.npcId, 0, this.roleState, true);
                break;
            }
            case 1: {
                if (this.npcType == 0) {
                    switch (state) {
                        case 0: {
                            this.setAction(state, (byte)-1, false);
                            break;
                        }
                        case 1: {
                            this.setAction(state, (byte)-2, false);
                            break;
                        }
                        case 2: {
                            this.setAction(state, (byte)-1, false);
                            break;
                        }
                        case 3: {
                            this.setAction(state, (byte)-2, false);
                        }
                    }
                } else {
                    this.setAction(state, (byte)-1, false);
                    if (this.npcType == 3) {
                        GameWorld.getInstance().setNpcObject(this.npcId, 0, state, true);
                    }
                }
                this.roleState = state;
                break;
            }
            case 2: {
                this.roleState = state;
                break;
            }
            case 3: {
                this.setAction(state, (byte)-2, false);
                this.roleState = state;
                GameWorld.getInstance().setNpcObject(this.npcId, 0, this.roleState, true);
            }
        }
    }

    public void update() {
        switch (this.actorType) {
            case 0: {
                this.updateNpc();
                break;
            }
            case 1: {
                if (this.npcType == 0) {
                    if (this.roleState == 0 && CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData())) {
                        this.setState((byte)1);
                    } else if (this.roleState == 2 && !CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData())) {
                        this.setState((byte)3);
                    } else if (this.roleState == 1 && this.sprite.isEndFrame()) {
                        this.setState((byte)2);
                    } else if (this.roleState == 3 && this.sprite.isEndFrame()) {
                        this.setState((byte)0);
                    }
                }
                if (this.npcType == 0 && this.sprite.isEndFrame() || this.npcType == 1 || this.npcType == 3 && this.getRoleState() == 2) {
                    if (this.sprite.sprIndex == 320 && !this.isVisible()) {
                        return;
                    }
                    if ((GamePlayer.getInstance().afterDir != this.doorDir[this.playerDirection] || this.sprite.sprIndex == 320 || this.sprite.sprIndex == 310) && this.sprite.sprIndex != 320 && this.sprite.sprIndex != 310 || !CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getAttData())) break;
                    GameWorld.getInstance().sceneId = this.nextScene;
                    GameWorld.getInstance().roomId = this.nextRoom;
                    GameWorld.getInstance().doorId = this.nextDoor;
                    GameManager.getInstance().setState((byte)9);
                    break;
                }
                if (this.npcType == 2) {
                    if ((GamePlayer.getInstance().afterDir != this.doorDir[this.playerDirection] || this.sprite.sprIndex == 320) && this.sprite.sprIndex != 320 || !CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getAttData())) break;
                    for (int i = 0; i < this.actorPos.length / 6; ++i) {
                        if (this.actorPos[i * 6] != this.npcId || this.actorPos[i * 6 + 1] != GameWorld.getInstance().sceneId || this.actorPos[i * 6 + 2] != GameWorld.getInstance().roomId) continue;
                        GameWorld.getInstance().playerX = this.actorPos[i * 6 + 3];
                        GameWorld.getInstance().playerY = this.actorPos[i * 6 + 4];
                        GameWorld.faceDir = (byte)this.actorPos[i * 6 + 5];
                        break;
                    }
                    GameWorld.getInstance().sceneId = this.nextScene;
                    GameWorld.getInstance().roomId = this.nextRoom;
                    GameWorld.getInstance().doorId = -1;
                    GameManager.getInstance().setState((byte)9);
                    break;
                }
                if (this.npcType != 4 || GamePlayer.getInstance().getRoleState() == 9 || GamePlayer.getInstance().getRoleState() == 10 || !CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getAttData())) break;
                GamePlayer.getInstance().setPosition(this.actorX, this.actorY);
                GamePlayer.getInstance().shadowActor.setPosition(this.actorX, this.actorY);
                GamePlayer.getInstance().setState((byte)9, this.faceDir);
                GameWorld.getInstance().doorId = this.nextDoor;
                break;
            }
            case 2: {
                break;
            }
        }
        this.checkIsScreen();
    }

    public void updateNpc() {
        block0 : switch (this.npcType) {
            case 2: {
                if (this.checkAi()) {
                    byte[] tempState = new byte[]{0, 1, 2, 3, 5};
                    this.setState(tempState[CWATools.getRandom(5)]);
                    if (this.roleState == 3 || this.roleState == 0) {
                        this.setActorDir((byte)0);
                    } else if (this.roleState == 5 || this.roleState == 2) {
                        this.setActorDir((byte)2);
                    } else if (CWATools.getRandom(2) == 0) {
                        this.setActorDir((byte)3);
                    } else {
                        this.setActorDir((byte)1);
                    }
                }
                if (this.roleState == 3) {
                    if (this._moveCount >= 64) {
                        this.setState((byte)0);
                        break;
                    }
                    this.move(4);
                    this._moveCount += 4;
                    break;
                }
                if (this.roleState != 5) break;
                if (this._moveCount <= 0) {
                    this.setState((byte)2);
                    break;
                }
                this.move(4);
                this._moveCount -= 4;
                break;
            }
            case 3: {
                if (this.checkAi()) {
                    byte[] tempstate = new byte[]{0, 1, 2, 4};
                    this.setState(tempstate[CWATools.getRandom(4)]);
                    if (this.roleState == 0) {
                        this.setActorDir((byte)0);
                    } else if (this.roleState == 2) {
                        this.setActorDir((byte)2);
                    } else if (CWATools.getRandom(2) == 0) {
                        this.setActorDir((byte)3);
                    } else {
                        this.setActorDir((byte)1);
                    }
                }
                if (this.roleState != 4) break;
                if (this.faceDir == 1) {
                    if (this._moveCount >= 64) {
                        this.setState((byte)0);
                        break;
                    }
                    this.move(4);
                    this._moveCount += 4;
                    break;
                }
                if (this.faceDir != 3) break;
                if (this._moveCount <= 0) {
                    this.setState((byte)2);
                    break;
                }
                this.move(4);
                this._moveCount -= 4;
                break;
            }
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                int addGold;
                if (this.tipSprite != null && this.isVisible() && this.tipSprite.target.equals(this) && (this.roleState != 0 || !GamePlayer.getInstance().canCollNpc(this, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData()))) {
                    this.tipStop();
                }
                if (this.roleState != 1 || !this.sprite.isEndFrame()) break;
                this.setState((byte)2);
                if (this.npcType == 6 && this.npcType == 7) {
                    GameWorld.getInstance().setNpcObject(this.npcId, 0, this.roleState, false);
                } else {
                    GameWorld.getInstance().setNpcObject(this.npcId, 0, this.roleState, true);
                }
                if ((this.npcType == 7 || this.npcType == 6) && (addGold = CWATools.getRandom(2)) > 0) {
                    GamePlayer.getInstance().addGold(addGold);
                    int[] temp = new int[]{addGold, this.getActorX(), this.getActorY() - 20, 0};
                    GamePlayer.getInstance().getGold.addElement(temp);
                }
                GameEvent.begainTalk = false;
                break;
            }
            case 8: {
                if (this.roleState != 1) break;
                if (this._moveCount < 2 && this.canMove(this.faceDir, 8, (byte)0)) {
                    ++this._moveCount;
                    this.move(8);
                    this.saveNpcXY();
                    break;
                }
                this.setState((byte)0);
                break;
            }
            case 9: 
            case 10: {
                if (this.isStandPlayer != 1) break;
                if ((this.sprite.sprIndex == 302 || this.sprite.sprIndex == 298) && this.canMove(this.faceDir, 4, (byte)1)) {
                    this.move(4);
                    ((CWASprActor)this.target).move(4);
                    break;
                }
                if (this.canMove(this.faceDir, 4, (byte)2)) {
                    this.move(4);
                    ((CWASprActor)this.target).move(4);
                    break;
                }
                this.saveNpcXY();
                this.isStandPlayer = (byte)2;
                this.setState((byte)0);
                break;
            }
            case 12: {
                if (!this.isVisible()) break;
                if (CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, this.sprite.getbeattData())) {
                    if (GamePlayer.getInstance().getRoleState() == 8) break;
                    GamePlayer.getInstance().setState((byte)8, this.faceDir);
                    break;
                }
                if (this.canMove(this.faceDir, 4, (byte)0)) {
                    this.move(4);
                    break;
                }
                if (this.faceDir == 2) {
                    this.faceDir = 0;
                    break;
                }
                this.faceDir = (byte)2;
                break;
            }
            case 13: {
                if (!this.isVisible()) break;
                if (CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, this.sprite.getbeattData())) {
                    if (GamePlayer.getInstance().getRoleState() == 8) break;
                    GamePlayer.getInstance().setState((byte)8, this.faceDir);
                    break;
                }
                if (this.canMove(this.faceDir, 4, (byte)0)) {
                    this.move(4);
                    break;
                }
                if (this.faceDir == 3) {
                    this.faceDir = 1;
                    break;
                }
                this.faceDir = (byte)3;
                break;
            }
            case 16: {
                if (!CWATools.isCollides(GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY, this.actorX, this.actorY, this.sprite.getbeattData()) || GamePlayer.getInstance().getRoleState() == 5) break;
                GamePlayer.getInstance().setState((byte)5, GamePlayer.getInstance().faceDir);
                break;
            }
            case 14: {
                this.countLaserArea();
                if (this._count < 4) {
                    ++this._count;
                    break;
                }
                this._count = 0;
                break;
            }
            case 1: {
                if (this.roleState == 1) {
                    this.move(this.getCurProp((byte)0));
                    if (GameWorld.getInstance().bqSprActor != null && GameWorld.getInstance().bqSprActor.target != null && GameWorld.getInstance().bqSprActor.target.equals(this) && GamePlayer.getInstance().sprite != null && !GamePlayer.getInstance().canCollNpc(this, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData())) {
                        GameWorld.getInstance().removeBq(2);
                    }
                }
                if (!(GameWorld.getInstance().bqSprActor == null || GameWorld.getInstance().bqSprActor.target == null || !GameWorld.getInstance().bqSprActor.target.equals(this) || GamePlayer.getInstance().sprite == null || this.isVisible() && GamePlayer.getInstance().canCollNpc(this, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData()))) {
                    GameWorld.collNpc = (short)-1;
                    GameWorld.getInstance().removeBq(3);
                }
                if (this.bqSprite != null && this.isVisible() && this.bqSprite.target.equals(this) && GamePlayer.getInstance().sprite != null && !GamePlayer.getInstance().canCollNpc(this, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData())) {
                    this.bqStart();
                }
                if (GameEvent.taskVector == null || GameEvent.taskVector.size() <= 0 || this.getBqType() != 1 || GamePlayer.getInstance().sprite == null || GamePlayer.getInstance().canCollNpc(this, GamePlayer.getInstance().sprite.getbeattData(), this.sprite.getbeattData())) break;
                for (int j = 0; j < GameEvent.taskVector.size(); ++j) {
                    if (!((CWASprActor)GameEvent.taskVector.elementAt((int)j)).target.equals(this)) continue;
                    ((CWASprActor)GameEvent.taskVector.elementAt(j)).start();
                    break block0;
                }
                break;
            }
        }
    }

    public void updateEnemy(int playerX, int playerY, boolean b) {
        if (!b) {
            switch (this.roleState) {
                case 0: {
                    if (this.fireCount >= 0) {
                        if (CWATools.stance(this.actorX, this.actorY, this.RegionX, this.RegionY) > this.fireArea) {
                            this.setState((byte)2);
                        } else {
                            this.fireCount = 0;
                            this.setState((byte)1);
                        }
                    }
                    ++this.fireCount;
                    break;
                }
                case 1: {
                    if (CWATools.stance(this.actorX, this.actorY, playerX, playerY) < this.fireCatchArea) {
                        this.setState((byte)3);
                    }
                    if (this.fireCount > CWATools.getRandom(20) && this.fireCount > 10) {
                        this.fireCount = 0;
                    }
                    if (CWATools.stance(this.actorX, this.actorY, this.RegionX, this.RegionY) > this.fireArea) {
                        this.setState((byte)2);
                    }
                    ++this.fireCount;
                    break;
                }
                case 2: {
                    if (CWATools.stance(this.actorX, this.actorY, this.RegionX, this.RegionY) > this.fireArea / 2) {
                        this.fireCount = 0;
                        break;
                    }
                    this.setState((byte)0);
                    break;
                }
                case 3: {
                    this.movePoint(this.SpeedX + 2, playerX, playerY);
                    if (CWATools.stance(this.actorX, this.actorY, this.RegionX, this.RegionY) <= this.fireArea + this.fireCatchArea / 2) break;
                    this.setState((byte)2);
                }
            }
        }
    }

    public void standNpcOn() {
        if (this.npcType == 9) {
            this.setState((byte)1);
            if ((this.sprite.sprIndex == 302 || this.sprite.sprIndex == 298) && this.canMove((byte)1, 4, (byte)1)) {
                this.setActorDir((byte)1);
            } else if (this.canMove((byte)1, 4, (byte)2)) {
                this.setActorDir((byte)1);
            } else {
                this.setActorDir((byte)3);
            }
        } else if ((this.sprite.sprIndex == 302 || this.sprite.sprIndex == 298) && this.canMove((byte)2, 4, (byte)1)) {
            this.setState((byte)2);
            this.setActorDir((byte)2);
        } else if (this.canMove((byte)2, 4, (byte)2)) {
            this.setState((byte)2);
            this.setActorDir((byte)2);
        } else {
            this.setState((byte)1);
            this.setActorDir((byte)0);
        }
        this.isStandPlayer = 1;
    }

    public void recordCountLaserArea() {
        this.laserArea = 0;
        while (this.initMoveLaser(this.getAction(), 16 * (this.laserArea + 1), (byte)0)) {
            ++this.laserArea;
        }
        this.templaserArea = this.laserArea;
        this.laserArea = 0;
    }

    public void countLaserArea() {
        this.laserArea = 0;
        while (this.canMoveLaser(this.getAction(), 16 * (this.laserArea + 1), (byte)0)) {
            ++this.laserArea;
        }
    }

    public boolean checkAi() {
        ++this._aiFrame;
        if (this._aiFrame >= this._aiCheckTime) {
            this._aiFrame = 0;
            this._aiCheckTime = CWATools.getRandom(20, 40);
            return true;
        }
        return false;
    }

    public boolean canMove(byte face, int move, byte canTile) {
        byte tile = 0;
        switch (face) {
            case 2: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - this.sprite.getbeattData()[3] - move);
                break;
            }
            case 0: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + move);
                break;
            }
            case 3: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX - move - this.sprite.getbeattData()[2] / 2, this.actorY);
                break;
            }
            case 1: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX + move + this.sprite.getbeattData()[2] / 2, this.actorY);
            }
        }
        return tile == canTile;
    }

    public boolean initMoveLaser(byte face, int move, byte canTile) {
        byte tile = 0;
        switch (face) {
            case 2: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - move);
                break;
            }
            case 0: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + move);
                break;
            }
            case 3: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX - move, this.actorY);
                break;
            }
            case 1: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX + move, this.actorY);
            }
        }
        return tile == canTile;
    }

    public boolean canMoveLaser(byte face, int move, byte canTile) {
        byte tile = 0;
        switch (face) {
            case 2: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY - move);
                for (int i = 0; i < GameWorld.getInstance().npc.length; ++i) {
                    if (GameWorld.getInstance().npc[i].npcType == this.npcType || GameWorld.getInstance().npc[i].sprite.getbeattData() == null || !CWATools.isCollides(this.actorX, this.actorY - move, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY, GameWorld.getInstance().npc[i].sprite.getbeattData())) continue;
                    GameWorld.getInstance().npc[i].setTarget(this);
                    return false;
                }
                break;
            }
            case 0: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX, this.actorY + move);
                for (int i = 0; i < GameWorld.getInstance().npc.length; ++i) {
                    if (GameWorld.getInstance().npc[i].npcType == this.npcType || GameWorld.getInstance().npc[i].sprite.getbeattData() == null || !CWATools.isCollides(this.actorX, this.actorY + move, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY, GameWorld.getInstance().npc[i].sprite.getbeattData())) continue;
                    GameWorld.getInstance().npc[i].setTarget(this);
                    return false;
                }
                break;
            }
            case 3: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX - move, this.actorY);
                for (int i = 0; i < GameWorld.getInstance().npc.length; ++i) {
                    if (GameWorld.getInstance().npc[i].npcType == this.npcType || GameWorld.getInstance().npc[i].sprite.getbeattData() == null || !CWATools.isCollides(this.actorX - move, this.actorY, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY, GameWorld.getInstance().npc[i].sprite.getbeattData())) continue;
                    GameWorld.getInstance().npc[i].setTarget(this);
                    return false;
                }
                break;
            }
            case 1: {
                tile = CWAMap.getInstance().getMapTile(0, this.actorX + move, this.actorY);
                for (int i = 0; i < GameWorld.getInstance().npc.length; ++i) {
                    if (GameWorld.getInstance().npc[i].npcType == this.npcType || GameWorld.getInstance().npc[i].sprite.getbeattData() == null || !CWATools.isCollides(this.actorX + move, this.actorY, GameWorld.getInstance().npc[i].actorX, GameWorld.getInstance().npc[i].actorY, GameWorld.getInstance().npc[i].sprite.getbeattData())) continue;
                    GameWorld.getInstance().npc[i].setTarget(this);
                    return false;
                }
                break;
            }
        }
        return tile == canTile;
    }

    public void renderLaser(Graphics g, int x, int y) {
        switch (this.getAction()) {
            case 2: {
                g.setColor(65280);
                g.fillRect(this.actorX - x - (this._count + 5) / 2, this.actorY - this.sprite.getAttData()[3] - y - this.laserArea * 16 + 8, this._count + 5, this.laserArea * 16);
                g.setColor(0xFFFFFF);
                g.fillRect(this.actorX - x - (this._count + 3) / 2, this.actorY - this.sprite.getAttData()[3] - y - this.laserArea * 16 + 8, this._count + 3, this.laserArea * 16);
                break;
            }
            case 0: {
                g.setColor(65280);
                g.fillRect(this.actorX - x - (this._count + 5) / 2, this.actorY - this.sprite.getAttData()[3] - y + 20, this._count + 5, (this.laserArea + 1) * 16);
                g.setColor(0xFFFFFF);
                g.fillRect(this.actorX - x - (this._count + 3) / 2, this.actorY - this.sprite.getAttData()[3] - y + 20, this._count + 3, (this.laserArea + 1) * 16);
                break;
            }
            case 3: {
                g.setColor(65280);
                g.fillRect(this.actorX - x - 8 - this.laserArea * 16, this.actorY - this.sprite.getAttData()[3] - y - (this._count + 5) / 2 + 13, this.laserArea * 16, this._count + 5);
                g.setColor(0xFFFFFF);
                g.fillRect(this.actorX - x - 8 - this.laserArea * 16, this.actorY - this.sprite.getAttData()[3] - y - (this._count + 3) / 2 + 13, this.laserArea * 16, this._count + 3);
                break;
            }
            case 1: {
                g.setColor(65280);
                g.fillRect(this.actorX - x + 7, this.actorY - this.sprite.getAttData()[3] - y - (this._count + 5) / 2 + 13, this.laserArea * 16, this._count + 5);
                g.setColor(0xFFFFFF);
                g.fillRect(this.actorX - x + 7, this.actorY - this.sprite.getAttData()[3] - y - (this._count + 3) / 2 + 13, this.laserArea * 16, this._count + 3);
            }
        }
    }

    public void saveNpcXY() {
        GameWorld.getInstance().setNpcPos(this.npcId, 0, this.actorX);
        GameWorld.getInstance().setNpcPos(this.npcId, 1, this.actorY);
    }

    public void saveNpcObject() {
        byte isVis = 0;
        if (this.isVisible()) {
            isVis = 1;
        }
        GameWorld.getInstance().setNpcObject(this.npcId, 1, isVis, true);
        GameWorld.getInstance().setNpcObject(this.npcId, 0, this.roleState, true);
        GameWorld.getInstance().setNpcObject(this.npcId, 2, this.faceDir, true);
    }

    public void move(int speed) {
        this.RegionX = (short)this.actorX;
        this.RegionY = (short)this.actorY;
        super.move(speed);
    }

    public void setBqType(byte bqType) {
        this.bqType = bqType;
    }

    public byte getBqType() {
        return this.bqType;
    }

    public void initSpbq() {
        if (this.smilies != 0 && this.bqSprite == null && this.isVisible()) {
            this.bqSprite = new CWASprActor();
            this.bqSprite.initSprite(259, false);
            this.bqSprite.reCallImage();
            this.bqSprite.setAction(this.smilies, (byte)-1, true);
            this.bqSprite.setPosition(this.actorX, this.actorY - 40);
            this.bqSprite.setTarget(this);
        }
        this.bqStart();
    }

    public void initTip(int posY) {
        if (this.tipSprite == null && this.isVisible()) {
            this.tipSprite = new CWASprActor();
            this.tipSprite.initSprite(259, false);
            this.tipSprite.reCallImage();
            this.tipSprite.setAction((byte)7, (byte)-1, true);
            this.tipSprite.setPosition(this.actorX, this.actorY - posY);
            this.tipSprite.setTarget(this);
        }
        this.tipStart();
    }

    public void bossBq() {
        if (GameWorld.getInstance().removeSpBq(this.npcId)) {
            this.bqStop();
        }
    }

    public void bqStart() {
        if (this.bqSprite != null) {
            this.bqSprite.start();
        }
    }

    public void tipStart() {
        if (this.tipSprite != null) {
            this.tipSprite.start();
        }
    }

    public void stop() {
        super.stop();
        this.bqStop();
        this.shadowStop();
        this.tipStop();
    }

    public void bqStop() {
        if (this.bqSprite != null) {
            this.bqSprite.stop();
        }
    }

    public void tipStop() {
        if (this.tipSprite != null) {
            this.tipSprite.stop();
        }
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        if (this.shadowActor != null && this.shadowActor.isVisible()) {
            this.shadowActor.setPosition(x, y);
        }
    }

    public void setPosition(int x, int y, int h) {
        super.setPosition(x, y, h);
    }
}

